/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.txc.client.springcloud;

import com.taobao.txc.common.LoggerInit;
import com.taobao.txc.common.LoggerWrap;
import com.taobao.txc.common.TxcContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

@Configuration
public class TxcInboundHandler
extends WebMvcConfigurerAdapter
implements HandlerInterceptor {
    private static final LoggerWrap LOGGER = LoggerInit.logger;

    public void addInterceptors(InterceptorRegistry registry) {
        LOGGER.info("Registry TxcHandlerInterceptor ... ");
        registry.addInterceptor((HandlerInterceptor)new TxcInboundHandler()).addPathPatterns(new String[]{"/**"});
    }

    private static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        String xid = TxcContext.getCurrentXid();
        String rpcXid = request.getHeader("TXC_XID");
        String beginCountStr = request.getHeader("BEGIN_COUNT");
        String commitCountStr = request.getHeader("COMMIT_COUNT");
        int beginCount = 0;
        int commitCount = 0;
        if (!TxcInboundHandler.isEmpty(beginCountStr)) {
            beginCount = Integer.parseInt(beginCountStr);
        }
        if (!TxcInboundHandler.isEmpty(commitCountStr)) {
            commitCount = Integer.parseInt(commitCountStr);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("xid in TxcContext {} xid in TxcContext {}", new Object[]{xid, rpcXid});
        }
        if (xid == null && rpcXid != null) {
            TxcContext.bind((String)rpcXid, null);
            TxcContext.setBegin((int)beginCount);
            TxcContext.setCommitCount((int)commitCount);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("bind {} to TxcContext", new Object[]{rpcXid});
            }
        }
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception e) {
        String unbindXid = TxcContext.getCurrentXid();
        String rpcXid = request.getHeader("TXC_XID");
        if (!TxcInboundHandler.isEmpty(unbindXid)) {
            if (!unbindXid.equals(rpcXid)) {
                LOGGER.error("Unknown", "xid has changed, please check!");
                return;
            }
            TxcContext.unbind();
            TxcContext.clearReenterCounter();
        }
    }
}

