/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.txc.client.springcloud.hystrix;

import com.netflix.hystrix.HystrixThreadPoolKey;
import com.netflix.hystrix.HystrixThreadPoolProperties;
import com.netflix.hystrix.strategy.HystrixPlugins;
import com.netflix.hystrix.strategy.concurrency.HystrixConcurrencyStrategy;
import com.netflix.hystrix.strategy.concurrency.HystrixRequestVariable;
import com.netflix.hystrix.strategy.concurrency.HystrixRequestVariableLifecycle;
import com.netflix.hystrix.strategy.eventnotifier.HystrixEventNotifier;
import com.netflix.hystrix.strategy.executionhook.HystrixCommandExecutionHook;
import com.netflix.hystrix.strategy.metrics.HystrixMetricsPublisher;
import com.netflix.hystrix.strategy.properties.HystrixPropertiesStrategy;
import com.netflix.hystrix.strategy.properties.HystrixProperty;
import com.taobao.txc.common.TxcContext;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

public class TxcHystrixConcurrencyStrategy
extends HystrixConcurrencyStrategy {
    private final Logger logger = LoggerFactory.getLogger(TxcHystrixConcurrencyStrategy.class);
    private HystrixConcurrencyStrategy delegate;

    public TxcHystrixConcurrencyStrategy() {
        try {
            this.delegate = HystrixPlugins.getInstance().getConcurrencyStrategy();
            if (this.delegate instanceof TxcHystrixConcurrencyStrategy) {
                return;
            }
            HystrixCommandExecutionHook commandExecutionHook = HystrixPlugins.getInstance().getCommandExecutionHook();
            HystrixEventNotifier eventNotifier = HystrixPlugins.getInstance().getEventNotifier();
            HystrixMetricsPublisher metricsPublisher = HystrixPlugins.getInstance().getMetricsPublisher();
            HystrixPropertiesStrategy propertiesStrategy = HystrixPlugins.getInstance().getPropertiesStrategy();
            this.logCurrentStateOfHystrixPlugins(eventNotifier, metricsPublisher, propertiesStrategy);
            HystrixPlugins.reset();
            HystrixPlugins.getInstance().registerConcurrencyStrategy((HystrixConcurrencyStrategy)this);
            HystrixPlugins.getInstance().registerCommandExecutionHook(commandExecutionHook);
            HystrixPlugins.getInstance().registerEventNotifier(eventNotifier);
            HystrixPlugins.getInstance().registerMetricsPublisher(metricsPublisher);
            HystrixPlugins.getInstance().registerPropertiesStrategy(propertiesStrategy);
        }
        catch (Exception ex) {
            this.logger.error("Failed to register Seata Hystrix Concurrency Strategy", (Throwable)ex);
        }
    }

    private void logCurrentStateOfHystrixPlugins(HystrixEventNotifier eventNotifier, HystrixMetricsPublisher metricsPublisher, HystrixPropertiesStrategy propertiesStrategy) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Current Hystrix plugins configuration is [concurrencyStrategy [" + this.delegate + "],eventNotifier [" + eventNotifier + "],metricPublisher [" + metricsPublisher + "],propertiesStrategy [" + propertiesStrategy + "],]");
            this.logger.debug("Registering Seata Hystrix Concurrency Strategy.");
        }
    }

    public ThreadPoolExecutor getThreadPool(HystrixThreadPoolKey threadPoolKey, HystrixProperty<Integer> corePoolSize, HystrixProperty<Integer> maximumPoolSize, HystrixProperty<Integer> keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue) {
        return this.delegate.getThreadPool(threadPoolKey, corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue);
    }

    public ThreadPoolExecutor getThreadPool(HystrixThreadPoolKey threadPoolKey, HystrixThreadPoolProperties threadPoolProperties) {
        return this.delegate.getThreadPool(threadPoolKey, threadPoolProperties);
    }

    public BlockingQueue<Runnable> getBlockingQueue(int maxQueueSize) {
        return this.delegate.getBlockingQueue(maxQueueSize);
    }

    public <T> HystrixRequestVariable<T> getRequestVariable(HystrixRequestVariableLifecycle<T> rv) {
        return this.delegate.getRequestVariable(rv);
    }

    public <K> Callable<K> wrapCallable(Callable<K> c) {
        if (c instanceof TxcContextCallable) {
            return c;
        }
        Callable wrappedCallable = this.delegate != null ? this.delegate.wrapCallable(c) : c;
        if (wrappedCallable instanceof TxcContextCallable) {
            return wrappedCallable;
        }
        return new TxcContextCallable(wrappedCallable, RequestContextHolder.getRequestAttributes());
    }

    private static class TxcContextCallable<K>
    implements Callable<K> {
        private final Callable<K> actual;
        private final String xid;
        private final int beginCount;
        private final int commitCount;
        private final RequestAttributes requestAttributes;

        TxcContextCallable(Callable<K> actual, RequestAttributes requestAttribute) {
            this.actual = actual;
            this.requestAttributes = requestAttribute;
            this.xid = TxcContext.getCurrentXid();
            this.beginCount = TxcContext.getBeginCount();
            this.commitCount = TxcContext.getCommitCount();
        }

        @Override
        public K call() throws Exception {
            try {
                RequestContextHolder.setRequestAttributes((RequestAttributes)this.requestAttributes);
                TxcContext.bind((String)this.xid, null);
                TxcContext.setBegin((int)this.beginCount);
                TxcContext.setCommitCount((int)this.commitCount);
                K k = this.actual.call();
                return k;
            }
            finally {
                TxcContext.unbind();
                TxcContext.clearReenterCounter();
                RequestContextHolder.resetRequestAttributes();
            }
        }
    }
}

