/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.txc.parser.ast.expression;

import com.alibaba.txc.parser.ast.expression.AbstractExpression;
import com.alibaba.txc.parser.ast.expression.Expression;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class PolyadicOperatorExpression
extends AbstractExpression {
    protected List<Expression> operands;
    protected final int precedence;

    public PolyadicOperatorExpression(int precedence) {
        this(precedence, true);
    }

    public PolyadicOperatorExpression(int precedence, boolean leftCombine) {
        this(precedence, 4);
    }

    public PolyadicOperatorExpression(int precedence, int initArity) {
        this.precedence = precedence;
        this.operands = new ArrayList<Expression>(initArity);
    }

    public PolyadicOperatorExpression appendOperand(Expression operand) {
        if (operand == null) {
            return this;
        }
        if (this.getClass().isAssignableFrom(operand.getClass())) {
            PolyadicOperatorExpression sub = (PolyadicOperatorExpression)operand;
            this.operands.addAll(sub.operands);
        } else {
            this.operands.add(operand);
        }
        return this;
    }

    public Expression getOperand(int index) {
        if (index >= this.operands.size()) {
            throw new IllegalArgumentException("only contains " + this.operands.size() + " operands," + index + " is out of bound");
        }
        return this.operands.get(index);
    }

    public int getArity() {
        return this.operands.size();
    }

    @Override
    public int getPrecedence() {
        return this.precedence;
    }

    public abstract String getOperator();

    @Override
    protected Object evaluationInternal(Map<? extends Object, ? extends Object> parameters) {
        return UNEVALUATABLE;
    }
}

