/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.txc.parser.ast.expression.arithmeic;

import com.alibaba.txc.parser.ast.expression.Expression;
import com.alibaba.txc.parser.ast.expression.arithmeic.ArithmeticBinaryOperatorExpression;
import com.taobao.txc.parser.visitor.api.SQLASTVisitor;
import java.math.BigDecimal;
import java.math.BigInteger;

public class ArithmeticSubtractExpression
extends ArithmeticBinaryOperatorExpression {
    public ArithmeticSubtractExpression(Expression leftOprand, Expression rightOprand) {
        super(leftOprand, rightOprand, 12);
    }

    @Override
    public String getOperator() {
        return "-";
    }

    @Override
    public Number calculate(Integer integer1, Integer integer2) {
        if (integer1 == null || integer2 == null) {
            return null;
        }
        int i1 = integer1;
        int i2 = integer2;
        if (i2 == 0) {
            return integer1;
        }
        if (i1 == 0) {
            if (i2 == Integer.MIN_VALUE) {
                return new Long(-((long)i2));
            }
            return new Integer(-i2);
        }
        if (i1 >= 0 && i2 >= 0 || i1 <= 0 && i2 <= 0) {
            return new Integer(i1 - i2);
        }
        int rst = i1 - i2;
        if (i1 > 0 && rst < i1 || i1 < 0 && rst > i1) {
            return new Long((long)i1 - (long)i2);
        }
        return new Integer(rst);
    }

    @Override
    public Number calculate(Long long1, Long long2) {
        if (long1 == null || long1 == null) {
            return null;
        }
        long l1 = long1;
        long l2 = long1;
        if (l2 == 0L) {
            return long1;
        }
        if (l1 == 0L) {
            if (l2 == Long.MIN_VALUE) {
                return BigInteger.valueOf(l2).negate();
            }
            return new Long(-l2);
        }
        if (l1 >= 0L && l2 >= 0L || l1 <= 0L && l2 <= 0L) {
            return new Long(l1 - l2);
        }
        long rst = l1 - l2;
        if (l1 > 0L && rst < l1 || l1 < 0L && rst > l1) {
            BigInteger bi1 = BigInteger.valueOf(l1);
            BigInteger bi2 = BigInteger.valueOf(l2);
            return bi1.subtract(bi2);
        }
        return new Long(rst);
    }

    @Override
    public Number calculate(BigInteger bigint1, BigInteger bigint2) {
        if (bigint1 == null || bigint2 == null) {
            return null;
        }
        return bigint1.subtract(bigint2);
    }

    @Override
    public Number calculate(BigDecimal bigDecimal1, BigDecimal bigDecimal2) {
        if (bigDecimal1 == null || bigDecimal2 == null) {
            return null;
        }
        return bigDecimal1.subtract(bigDecimal2);
    }

    @Override
    public void accept(SQLASTVisitor visitor) {
        visitor.visit(this);
    }
}

