/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.txc.parser.ast.expression.arithmeic;

import com.alibaba.txc.parser.ast.expression.Expression;
import com.alibaba.txc.parser.ast.expression.UnaryOperatorExpression;
import com.alibaba.txc.parser.util.ExprEvalUtils;
import com.alibaba.txc.parser.util.UnaryOperandCalculator;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Map;

public class MinusExpression
extends UnaryOperatorExpression
implements UnaryOperandCalculator {
    public MinusExpression(Expression operand) {
        super(operand, 15);
    }

    @Override
    public String getOperator() {
        return "-";
    }

    @Override
    public Object evaluationInternal(Map<? extends Object, ? extends Object> parameters) {
        Object operand = this.getOperand().evaluation(parameters);
        if (operand == null) {
            return null;
        }
        if (operand == UNEVALUATABLE) {
            return UNEVALUATABLE;
        }
        Number num = null;
        num = operand instanceof String ? (Number)ExprEvalUtils.string2Number((String)operand) : (Number)((Number)operand);
        return ExprEvalUtils.calculate(this, num);
    }

    @Override
    public Number calculate(Integer num) {
        if (num == null) {
            return null;
        }
        int n = num;
        if (n == Integer.MIN_VALUE) {
            return new Long(-((long)n));
        }
        return new Integer(-n);
    }

    @Override
    public Number calculate(Long num) {
        if (num == null) {
            return null;
        }
        long n = num;
        if (n == Long.MIN_VALUE) {
            return new Long(-n);
        }
        return new Long(-n);
    }

    @Override
    public Number calculate(BigInteger num) {
        if (num == null) {
            return null;
        }
        return num.negate();
    }

    @Override
    public Number calculate(BigDecimal num) {
        if (num == null) {
            return null;
        }
        return num.negate();
    }
}

