/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.txc.parser.ast.expression.comparison;

import com.alibaba.txc.parser.ast.expression.BinaryOperatorExpression;
import com.alibaba.txc.parser.ast.expression.Expression;
import com.alibaba.txc.parser.ast.expression.ReplacableExpression;
import com.alibaba.txc.parser.ast.expression.primary.literal.LiteralBoolean;
import com.alibaba.txc.parser.util.ExprEvalUtils;
import com.alibaba.txc.parser.util.Pair;
import com.taobao.txc.parser.visitor.api.SQLASTVisitor;
import java.util.Map;

public class ComparisionEqualsExpression
extends BinaryOperatorExpression
implements ReplacableExpression {
    private Expression replaceExpr;

    public ComparisionEqualsExpression(Expression leftOprand, Expression rightOprand) {
        super(leftOprand, rightOprand, 7);
    }

    @Override
    public String getOperator() {
        return "=";
    }

    @Override
    public Object evaluationInternal(Map<? extends Object, ? extends Object> parameters) {
        Object left = this.leftOprand.evaluation(parameters);
        Object right = this.rightOprand.evaluation(parameters);
        if (left == null || right == null) {
            return null;
        }
        if (left == UNEVALUATABLE || right == UNEVALUATABLE) {
            return UNEVALUATABLE;
        }
        if (left instanceof Number || right instanceof Number) {
            Pair<Number, Number> pair = ExprEvalUtils.convertNum2SameLevel(left, right);
            left = pair.getKey();
            right = pair.getValue();
        }
        return left.equals(right) ? LiteralBoolean.TRUE : LiteralBoolean.FALSE;
    }

    @Override
    public void setReplaceExpr(Expression replaceExpr) {
        this.replaceExpr = replaceExpr;
    }

    @Override
    public void clearReplaceExpr() {
        this.replaceExpr = null;
    }

    @Override
    public void accept(SQLASTVisitor visitor) {
        if (this.replaceExpr == null) {
            visitor.visit(this);
        } else {
            this.replaceExpr.accept(visitor);
        }
    }
}

