/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.txc.parser.ast.expression.primary;

import com.alibaba.txc.parser.ast.expression.primary.PrimaryExpression;
import com.taobao.txc.parser.visitor.api.SQLASTVisitor;

public class Identifier
extends PrimaryExpression {
    protected Identifier parent;
    protected final String idText;
    protected final String idTextUnescape;
    protected final String idTextUpUnescape;
    public static final int PARENT_ABSENT = 0;
    public static final int PARENT_TRIMED = 1;
    public static final int PARENT_IGNORED = 2;

    public static String unescapeName(String name) {
        return Identifier.unescapeName(name, false);
    }

    public static String unescapeName(String name, boolean toUppercase) {
        if (name == null || name.length() <= 0) {
            return name;
        }
        if (name.charAt(0) != '`') {
            return toUppercase ? name.toUpperCase() : name;
        }
        if (name.charAt(name.length() - 1) != '`') {
            throw new IllegalArgumentException("id start with a '`' must end with a '`', id: " + name);
        }
        StringBuilder sb = new StringBuilder(name.length() - 2);
        int endIndex = name.length() - 1;
        boolean hold = false;
        for (int i = 1; i < endIndex; ++i) {
            char c = name.charAt(i);
            if (c == '`' && !hold) {
                hold = true;
                continue;
            }
            hold = false;
            if (toUppercase && c >= 'a' && c <= 'z') {
                c = (char)(c - 32);
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public Identifier(Identifier parent, String idText) {
        this(parent, idText, idText.toUpperCase());
    }

    public Identifier(Identifier parent, String idText, String idTextUp) {
        this.parent = parent;
        this.idText = idText;
        this.idTextUpUnescape = Identifier.unescapeName(idTextUp);
        this.idTextUnescape = Identifier.unescapeName(idText, false);
    }

    public String getLevelUnescapeUpName(int level) {
        Identifier id = this;
        for (int i = level; i > 1 && id != null; --i) {
            id = id.parent;
        }
        if (id != null) {
            return id.idTextUpUnescape;
        }
        return null;
    }

    public boolean isSequenceNextval() {
        return this.idTextUpUnescape.equals("NEXTVAL") && this.parent != null;
    }

    public int trimParent(int level, String trimSchema) {
        Identifier id = this;
        for (int i = 1; i < level; ++i) {
            if (id.parent == null) {
                return 0;
            }
            id = id.parent;
        }
        if (id.parent == null) {
            return 0;
        }
        if (trimSchema != null && !trimSchema.equalsIgnoreCase(id.parent.idTextUnescape)) {
            return 2;
        }
        return 1;
    }

    public void setParent(Identifier parent) {
        this.parent = parent;
    }

    public Identifier getParent() {
        return this.parent;
    }

    public String getIdText() {
        return this.idText;
    }

    public String getIdTextUpUnescape() {
        return this.idTextUpUnescape;
    }

    public String getIdTextUnescape() {
        return this.idTextUnescape;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ID:");
        if (this.parent != null) {
            sb.append(this.parent).append('.');
        }
        return sb.append(this.idText).toString();
    }

    public int hashCode() {
        int constant = 37;
        int hash = 17;
        hash = this.parent == null ? (hash += 37) : hash * 37 + this.parent.hashCode();
        hash = this.idText == null ? (hash += 37) : hash * 37 + this.idText.hashCode();
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Identifier) {
            Identifier that = (Identifier)obj;
            return Identifier.objEquals(this.parent, that.parent) && Identifier.objEquals(this.idText, that.idText);
        }
        return false;
    }

    private static boolean objEquals(Object obj, Object obj2) {
        if (obj == obj2) {
            return true;
        }
        if (obj == null) {
            return obj2 == null;
        }
        return obj.equals(obj2);
    }

    @Override
    public void accept(SQLASTVisitor visitor) {
        visitor.visit(this);
    }
}

