/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.txc.parser.ast.expression.primary.literal;

import com.alibaba.txc.parser.ast.expression.Expression;
import com.alibaba.txc.parser.ast.expression.primary.literal.Literal;
import com.taobao.txc.parser.visitor.api.SQLASTVisitor;
import java.util.HashMap;
import java.util.Map;

public class IntervalPrimary
extends Literal {
    private static final Map<String, Unit> unitMap = IntervalPrimary.initUnitMap();
    private final Unit unit;
    private final Expression quantity;

    private static Map<String, Unit> initUnitMap() {
        Unit[] units = (Unit[])Unit.class.getEnumConstants();
        HashMap<String, Unit> map = new HashMap<String, Unit>(units.length);
        for (Unit unit : units) {
            map.put(unit.name(), unit);
        }
        return map;
    }

    public static Unit getIntervalUnit(String unitString) {
        return unitMap.get(unitString);
    }

    public IntervalPrimary(Expression quantity, Unit unit) {
        if (quantity == null) {
            throw new IllegalArgumentException("quantity expression is null");
        }
        if (unit == null) {
            throw new IllegalArgumentException("unit of time is null");
        }
        this.quantity = quantity;
        this.unit = unit;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public Expression getQuantity() {
        return this.quantity;
    }

    @Override
    public void accept(SQLASTVisitor visitor) {
        visitor.visit(this);
    }

    public static enum Unit {
        MICROSECOND,
        SECOND,
        MINUTE,
        HOUR,
        DAY,
        WEEK,
        MONTH,
        QUARTER,
        YEAR,
        SECOND_MICROSECOND,
        MINUTE_MICROSECOND,
        MINUTE_SECOND,
        HOUR_MICROSECOND,
        HOUR_SECOND,
        HOUR_MINUTE,
        DAY_MICROSECOND,
        DAY_SECOND,
        DAY_MINUTE,
        DAY_HOUR,
        YEAR_MONTH;

    }
}

