/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.txc.parser.ast.expression.primary.literal;

import com.alibaba.txc.parser.ast.expression.primary.literal.Literal;
import com.alibaba.txc.parser.util.ParseString;
import com.taobao.txc.parser.visitor.api.SQLASTVisitor;
import java.util.Map;

public class LiteralHexadecimal
extends Literal {
    private byte[] bytes;
    private final String introducer;
    private final String charset;
    private final char[] string;
    private final int offset;
    private final int size;

    public LiteralHexadecimal(String introducer, char[] string, int offset, int size, String charset) {
        if (string == null || offset + size > string.length) {
            throw new IllegalArgumentException("hex text is invalid");
        }
        if (charset == null) {
            throw new IllegalArgumentException("charset is null");
        }
        this.introducer = introducer;
        this.charset = charset;
        this.string = string;
        this.offset = offset;
        this.size = size;
    }

    public String getText() {
        return new String(this.string, this.offset, this.size);
    }

    public String getIntroducer() {
        return this.introducer;
    }

    public void appendTo(StringBuilder sb) {
        sb.append(this.string, this.offset, this.size);
    }

    @Override
    public Object evaluationInternal(Map<? extends Object, ? extends Object> parameters) {
        this.bytes = ParseString.hexString2Bytes(this.string, this.offset, this.size);
        return this.bytes;
    }

    @Override
    public void accept(SQLASTVisitor visitor) {
        visitor.visit(this);
    }
}

