/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.txc.parser.ast.expression.primary.literal;

import com.alibaba.txc.parser.ast.expression.primary.literal.Literal;
import com.taobao.txc.parser.visitor.api.SQLASTVisitor;
import java.util.Map;

public class LiteralString
extends Literal {
    private final String introducer;
    private final String string;
    private final boolean nchars;

    public LiteralString(String introducer, String string, boolean nchars) {
        this.introducer = introducer;
        if (string == null) {
            throw new IllegalArgumentException("argument string is null!");
        }
        this.string = string;
        this.nchars = nchars;
    }

    public String getIntroducer() {
        return this.introducer;
    }

    public String getString() {
        return this.string;
    }

    public boolean isNchars() {
        return this.nchars;
    }

    public String getUnescapedString() {
        return LiteralString.getUnescapedString(this.string, false);
    }

    public String getLikeUnescapedString() {
        return LiteralString.getLikeUnescapedString(this.string);
    }

    public String getUnescapedString(boolean toUppercase) {
        return LiteralString.getUnescapedString(this.string, toUppercase);
    }

    public static String getUnescapedString(String string) {
        return LiteralString.getUnescapedString(string, false);
    }

    public static String getUnescapedString(String string, boolean toUppercase) {
        StringBuilder sb = new StringBuilder();
        char[] chars = string.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (c == '\\') {
                c = chars[++i];
                switch (c) {
                    case '0': {
                        sb.append('\u0000');
                        break;
                    }
                    case 'b': {
                        sb.append('\b');
                        break;
                    }
                    case 'n': {
                        sb.append('\n');
                        break;
                    }
                    case 'r': {
                        sb.append('\r');
                        break;
                    }
                    case 't': {
                        sb.append('\t');
                        break;
                    }
                    case 'Z': {
                        sb.append('\u001a');
                        break;
                    }
                    default: {
                        sb.append(c);
                        break;
                    }
                }
                continue;
            }
            if (c == '\'') {
                ++i;
                sb.append('\'');
                continue;
            }
            if (toUppercase && c >= 'a' && c <= 'z') {
                c = (char)(c - 32);
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String getLikeUnescapedString(String string) {
        StringBuilder sb = new StringBuilder();
        char[] chars = string.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (c == '\\') {
                c = chars[++i];
                switch (c) {
                    case '0': {
                        sb.append('\u0000');
                        break;
                    }
                    case 'b': {
                        sb.append('\b');
                        break;
                    }
                    case 'n': {
                        sb.append('\n');
                        break;
                    }
                    case 'r': {
                        sb.append('\r');
                        break;
                    }
                    case 't': {
                        sb.append('\t');
                        break;
                    }
                    case 'Z': {
                        sb.append('\u001a');
                        break;
                    }
                    default: {
                        sb.append('\\').append(c);
                        break;
                    }
                }
                continue;
            }
            if (c == '\'') {
                ++i;
                sb.append('\'');
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    @Override
    public Object evaluationInternal(Map<? extends Object, ? extends Object> parameters) {
        if (this.string == null) {
            return null;
        }
        return this.getUnescapedString();
    }

    @Override
    public void accept(SQLASTVisitor visitor) {
        visitor.visit(this);
    }
}

