/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.txc.parser.ast.fragment.tableref;

import com.alibaba.txc.parser.ast.expression.primary.Identifier;
import com.alibaba.txc.parser.ast.expression.primary.literal.LiteralString;
import com.alibaba.txc.parser.ast.fragment.tableref.TableReference;

public abstract class AliasableTableReference
implements TableReference {
    protected String alias;
    protected String aliasUnEscape;
    protected String aliasUpUnEscape;

    public AliasableTableReference(String alias) {
        this.alias = alias;
        this.aliasUnEscape = this.aliasUnescapeUppercase(alias, false);
        this.aliasUpUnEscape = this.aliasUnescapeUppercase(alias, false);
    }

    public String aliasUnescapeUppercase(String alias, boolean toUppercase) {
        if (alias == null || alias.length() <= 0) {
            return alias;
        }
        switch (alias.charAt(0)) {
            case '`': {
                return Identifier.unescapeName(alias, toUppercase);
            }
            case '\'': {
                return LiteralString.getUnescapedString(alias.substring(1, alias.length() - 1), toUppercase);
            }
            case '_': {
                int ind = -1;
                for (int i = 1; i < alias.length(); ++i) {
                    if (alias.charAt(i) != '\'') continue;
                    ind = i;
                    break;
                }
                if (ind < 0) break;
                LiteralString st = new LiteralString(alias.substring(0, ind), alias.substring(ind + 1, alias.length() - 1), false);
                this.aliasUpUnEscape = st.getUnescapedString(toUppercase);
                return this.aliasUpUnEscape;
            }
        }
        if (toUppercase) {
            return alias.toUpperCase();
        }
        return alias;
    }

    public String getAlias() {
        return this.alias;
    }

    public AliasableTableReference setAlias(String alias) {
        this.alias = alias;
        this.aliasUnEscape = this.aliasUnescapeUppercase(alias, false);
        this.aliasUpUnEscape = this.aliasUnescapeUppercase(alias, false);
        return this;
    }

    public String getAliasUnEscape() {
        return this.aliasUnEscape;
    }

    public String getAliasUpUnEscape() {
        return this.aliasUpUnEscape;
    }
}

