/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.txc.parser.ast.fragment.tableref;

import com.alibaba.txc.parser.ast.ASTNode;
import com.taobao.txc.parser.visitor.api.SQLASTVisitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class IndexHint
implements ASTNode {
    private final IndexAction action;
    private final IndexType type;
    private final IndexScope scope;
    private final List<String> indexList;

    public IndexHint(IndexAction action, IndexType type, IndexScope scope, List<String> indexList) {
        if (action == null) {
            throw new IllegalArgumentException("index hint action is null");
        }
        if (type == null) {
            throw new IllegalArgumentException("index hint type is null");
        }
        if (scope == null) {
            throw new IllegalArgumentException("index hint scope is null");
        }
        this.action = action;
        this.type = type;
        this.scope = scope;
        this.indexList = indexList == null || indexList.isEmpty() ? Collections.emptyList() : (indexList instanceof ArrayList ? indexList : new ArrayList<String>(indexList));
    }

    public IndexAction getAction() {
        return this.action;
    }

    public IndexType getType() {
        return this.type;
    }

    public IndexScope getScope() {
        return this.scope;
    }

    public List<String> getIndexList() {
        return this.indexList;
    }

    @Override
    public void accept(SQLASTVisitor visitor) {
        visitor.visit(this);
    }

    public static enum IndexScope {
        ALL,
        JOIN,
        GROUP_BY,
        ORDER_BY;

    }

    public static enum IndexType {
        INDEX,
        KEY;

    }

    public static enum IndexAction {
        USE,
        IGNORE,
        FORCE;

    }
}

