/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.txc.parser.ast.fragment.tableref;

import com.alibaba.txc.parser.ast.expression.Expression;
import com.alibaba.txc.parser.ast.fragment.tableref.TableReference;
import com.taobao.txc.parser.visitor.api.SQLASTVisitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class InnerJoin
implements TableReference {
    private final TableReference leftTableRef;
    private final TableReference rightTableRef;
    private Expression onCond;
    private List<String> using;

    private static List<String> ensureListType(List<String> list) {
        if (list == null) {
            return null;
        }
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        if (list instanceof ArrayList) {
            return list;
        }
        return new ArrayList<String>(list);
    }

    private InnerJoin(TableReference leftTableRef, TableReference rightTableRef, Expression onCond, List<String> using) {
        this.leftTableRef = leftTableRef;
        this.rightTableRef = rightTableRef;
        this.onCond = onCond;
        this.using = InnerJoin.ensureListType(using);
    }

    public InnerJoin(TableReference leftTableRef, TableReference rightTableRef) {
        this(leftTableRef, rightTableRef, null, null);
    }

    public InnerJoin(TableReference leftTableRef, TableReference rightTableRef, Expression onCond) {
        this(leftTableRef, rightTableRef, onCond, null);
    }

    public InnerJoin(TableReference leftTableRef, TableReference rightTableRef, List<String> using) {
        this(leftTableRef, rightTableRef, null, using);
    }

    public TableReference getLeftTableRef() {
        return this.leftTableRef;
    }

    public TableReference getRightTableRef() {
        return this.rightTableRef;
    }

    public Expression getOnCond() {
        return this.onCond;
    }

    public List<String> getUsing() {
        return this.using;
    }

    @Override
    public Object removeLastConditionElement() {
        Object obj;
        if (this.onCond != null) {
            obj = this.onCond;
            this.onCond = null;
        } else if (this.using != null) {
            obj = this.using;
            this.using = null;
        } else {
            return null;
        }
        return obj;
    }

    @Override
    public boolean isSingleTable() {
        return false;
    }

    @Override
    public int getPrecedence() {
        return 1;
    }

    @Override
    public void accept(SQLASTVisitor visitor) {
        visitor.visit(this);
    }
}

