/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.txc.parser.ast.fragment.tableref;

import com.alibaba.txc.parser.ast.fragment.tableref.TableReference;
import com.taobao.txc.parser.visitor.api.SQLASTVisitor;
import java.sql.SQLSyntaxErrorException;
import java.util.ArrayList;
import java.util.List;

public class TableReferences
implements TableReference {
    private final List<TableReference> list;

    protected static List<TableReference> ensureListType(List<TableReference> list) {
        if (list instanceof ArrayList) {
            return list;
        }
        return new ArrayList<TableReference>(list);
    }

    public List<TableReference> getTableReferenceList() {
        return this.list;
    }

    public TableReferences(List<TableReference> list) throws SQLSyntaxErrorException {
        if (list == null || list.isEmpty()) {
            throw new SQLSyntaxErrorException("at least one table reference");
        }
        this.list = TableReferences.ensureListType(list);
    }

    @Override
    public Object removeLastConditionElement() {
        if (this.list != null && !this.list.isEmpty()) {
            return this.list.get(this.list.size() - 1).removeLastConditionElement();
        }
        return null;
    }

    @Override
    public boolean isSingleTable() {
        if (this.list == null) {
            return false;
        }
        int count = 0;
        TableReference first = null;
        for (TableReference ref : this.list) {
            if (ref == null || 1 != ++count) continue;
            first = ref;
        }
        return count == 1 && first.isSingleTable();
    }

    @Override
    public int getPrecedence() {
        return 0;
    }

    @Override
    public void accept(SQLASTVisitor visitor) {
        visitor.visit(this);
    }
}

