/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.txc.parser.ast.stmt.ddl;

import com.alibaba.txc.parser.ast.expression.Expression;
import com.alibaba.txc.parser.ast.expression.primary.Identifier;
import com.alibaba.txc.parser.ast.expression.primary.ddl.DBPartitionOptions;
import com.alibaba.txc.parser.ast.expression.primary.ddl.PartitionOptions;
import com.alibaba.txc.parser.ast.fragment.ddl.ColumnDefinition;
import com.alibaba.txc.parser.ast.fragment.ddl.TableOptions;
import com.alibaba.txc.parser.ast.fragment.ddl.index.IndexDefinition;
import com.alibaba.txc.parser.ast.stmt.ddl.DDLStatement;
import com.alibaba.txc.parser.ast.stmt.dml.DMLSelectStatement;
import com.alibaba.txc.parser.util.Pair;
import com.taobao.txc.parser.visitor.api.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class DDLCreateTableStatement
implements DDLStatement {
    private final boolean temporary;
    private final boolean ifNotExists;
    private final Identifier table;
    private final List<Pair<Identifier, ColumnDefinition>> colDefs;
    private IndexDefinition primaryKey;
    private final List<Pair<Identifier, IndexDefinition>> uniqueKeys;
    private final List<Pair<Identifier, IndexDefinition>> keys;
    private final List<Pair<Identifier, IndexDefinition>> fullTextKeys;
    private final List<Pair<Identifier, IndexDefinition>> spatialKeys;
    private final List<Pair<Identifier, IndexDefinition>> foreignKeys;
    private final List<Expression> checks;
    private Identifier paimaryKeyConstraint = null;
    private boolean hasPrimaryKeyConstraint = false;
    private TableOptions tableOptions;
    private PartitionOptions partitionOptions;
    private DBPartitionOptions DBPartitionOptions;
    private Pair<SelectOption, DMLSelectStatement> select;
    private Identifier oldTblName;

    public List<Pair<Identifier, IndexDefinition>> getForeignKeys() {
        return this.foreignKeys;
    }

    public boolean isHasPrimaryKeyConstraint() {
        return this.hasPrimaryKeyConstraint;
    }

    public void setHasPrimaryKeyConstraint(boolean hasPrimaryKeyConstraint) {
        this.hasPrimaryKeyConstraint = hasPrimaryKeyConstraint;
    }

    public PartitionOptions getPartitionOptions() {
        return this.partitionOptions;
    }

    public void setPartitionOptions(PartitionOptions partitionOptions) {
        this.partitionOptions = partitionOptions;
    }

    public DDLCreateTableStatement(boolean temporary, boolean ifNotExists, Identifier table) {
        this.table = table;
        this.temporary = temporary;
        this.ifNotExists = ifNotExists;
        this.colDefs = new ArrayList<Pair<Identifier, ColumnDefinition>>(4);
        this.uniqueKeys = new ArrayList<Pair<Identifier, IndexDefinition>>(1);
        this.keys = new ArrayList<Pair<Identifier, IndexDefinition>>(2);
        this.fullTextKeys = new ArrayList<Pair<Identifier, IndexDefinition>>(1);
        this.spatialKeys = new ArrayList<Pair<Identifier, IndexDefinition>>(1);
        this.checks = new ArrayList<Expression>(1);
        this.foreignKeys = new ArrayList<Pair<Identifier, IndexDefinition>>(1);
    }

    public DDLCreateTableStatement setTableOptions(TableOptions tableOptions) {
        this.tableOptions = tableOptions;
        return this;
    }

    public DDLCreateTableStatement addColumnDefinition(Identifier colname, ColumnDefinition def) {
        this.colDefs.add(new Pair<Identifier, ColumnDefinition>(colname, def));
        return this;
    }

    public DDLCreateTableStatement setPrimaryKey(IndexDefinition def) {
        this.primaryKey = def;
        return this;
    }

    public DDLCreateTableStatement addUniqueIndex(Identifier colname, IndexDefinition def) {
        this.uniqueKeys.add(new Pair<Identifier, IndexDefinition>(colname, def));
        return this;
    }

    public DDLCreateTableStatement addForeignKey(Identifier colname, IndexDefinition def) {
        this.foreignKeys.add(new Pair<Identifier, IndexDefinition>(colname, def));
        return this;
    }

    public DDLCreateTableStatement addIndex(Identifier colname, IndexDefinition def) {
        this.keys.add(new Pair<Identifier, IndexDefinition>(colname, def));
        return this;
    }

    public DDLCreateTableStatement addFullTextIndex(Identifier colname, IndexDefinition def) {
        this.fullTextKeys.add(new Pair<Identifier, IndexDefinition>(colname, def));
        return this;
    }

    public DDLCreateTableStatement addSpatialIndex(Identifier colname, IndexDefinition def) {
        this.spatialKeys.add(new Pair<Identifier, IndexDefinition>(colname, def));
        return this;
    }

    public DDLCreateTableStatement addCheck(Expression check) {
        this.checks.add(check);
        return this;
    }

    public TableOptions getTableOptions() {
        return this.tableOptions;
    }

    public Pair<SelectOption, DMLSelectStatement> getSelect() {
        return this.select;
    }

    public void setSelect(SelectOption option, DMLSelectStatement select) {
        this.select = new Pair<SelectOption, DMLSelectStatement>(option, select);
    }

    public boolean isTemporary() {
        return this.temporary;
    }

    public boolean isIfNotExists() {
        return this.ifNotExists;
    }

    public Identifier getTable() {
        return this.table;
    }

    public List<Pair<Identifier, ColumnDefinition>> getColDefs() {
        return this.colDefs;
    }

    public IndexDefinition getPrimaryKey() {
        return this.primaryKey;
    }

    public List<Pair<Identifier, IndexDefinition>> getUniqueKeys() {
        return this.uniqueKeys;
    }

    public List<Pair<Identifier, IndexDefinition>> getKeys() {
        return this.keys;
    }

    public List<Pair<Identifier, IndexDefinition>> getFullTextKeys() {
        return this.fullTextKeys;
    }

    public List<Pair<Identifier, IndexDefinition>> getSpatialKeys() {
        return this.spatialKeys;
    }

    public List<Expression> getChecks() {
        return this.checks;
    }

    public DBPartitionOptions getDBPartitionOptions() {
        return this.DBPartitionOptions;
    }

    public DDLCreateTableStatement setDBPartitionOptions(DBPartitionOptions DBPartitionOptions2) {
        this.DBPartitionOptions = DBPartitionOptions2;
        return this;
    }

    public Identifier getPrimaryKeyConstraint() {
        return this.paimaryKeyConstraint;
    }

    public void setPaimaryKeyConstraint(Identifier paimaryKeyConstraint) {
        this.paimaryKeyConstraint = paimaryKeyConstraint;
    }

    public Identifier getOldTblName() {
        return this.oldTblName;
    }

    public void setOldTblName(Identifier oldTblName) {
        this.oldTblName = oldTblName;
    }

    @Override
    public void accept(SQLASTVisitor visitor) {
        visitor.visit(this);
    }

    public static enum SelectOption {
        IGNORED,
        REPLACE;

    }
}

