/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.txc.parser.ast.stmt.dml;

import com.alibaba.txc.parser.ast.expression.Expression;
import com.alibaba.txc.parser.ast.expression.primary.Identifier;
import com.alibaba.txc.parser.ast.expression.primary.ParamMarker;
import com.alibaba.txc.parser.ast.fragment.Limit;
import com.alibaba.txc.parser.ast.fragment.OrderBy;
import com.alibaba.txc.parser.ast.fragment.tableref.TableReferences;
import com.alibaba.txc.parser.ast.stmt.dml.DMLSelectStatement;
import com.alibaba.txc.parser.util.Pair;
import com.taobao.txc.parser.visitor.api.SQLASTVisitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DMLSelectFromUpdateStatement
extends DMLSelectStatement {
    private final SelectFromUpdateOption option;
    private final List<Pair<Expression, String>> selectExprList;
    private final TableReferences tables;
    private final Expression where;
    private final OrderBy order;
    private final Limit limit;
    private List<Pair<Identifier, Expression>> values;
    private Identifier table;
    private String originStr;

    public DMLSelectFromUpdateStatement(SelectFromUpdateOption option, List<Pair<Expression, String>> selectExprList, Identifier table, List<Pair<Identifier, Expression>> values, Expression where, OrderBy order, Limit limit) {
        super(new DMLSelectStatement.SelectOption(), selectExprList, null, null, null, null, order, limit);
        if (option == null) {
            throw new IllegalArgumentException("argument 'option' is null");
        }
        this.option = option;
        this.selectExprList = selectExprList == null || selectExprList.isEmpty() ? Collections.emptyList() : DMLSelectFromUpdateStatement.ensureListType(selectExprList);
        this.tables = null;
        this.table = table;
        this.where = where;
        this.order = order;
        this.limit = limit;
        this.values = values;
    }

    public SelectFromUpdateOption getSelectFromUpdateOption() {
        return this.option;
    }

    @Override
    public List<Pair<Expression, String>> getSelectExprList() {
        return this.selectExprList;
    }

    @Override
    public List<Expression> getSelectExprListWithoutAlias() {
        if (this.selectExprList == null || this.selectExprList.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Expression> list = new ArrayList<Expression>(this.selectExprList.size());
        for (Pair<Expression, String> p : this.selectExprList) {
            if (p == null || p.getKey() == null) continue;
            list.add(p.getKey());
        }
        return list;
    }

    @Override
    public TableReferences getTables() {
        return this.tables;
    }

    @Override
    public Expression getWhere() {
        return this.where;
    }

    @Override
    public OrderBy getOrder() {
        return this.order;
    }

    @Override
    public Limit getLimit() {
        return this.limit;
    }

    @Override
    public void accept(SQLASTVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public String getOriginStr() {
        return this.originStr;
    }

    @Override
    public Expression setOriginStr(String str) {
        this.originStr = str;
        return this;
    }

    public List<Pair<Identifier, Expression>> getValues() {
        return this.values;
    }

    public Identifier getTable() {
        return this.table;
    }

    public static final class SelectFromUpdateOption {
        public boolean lowPriority = false;
        public boolean ignore = false;
        public boolean commitOnSuccess = false;
        public boolean rollbackOnFail = false;
        public boolean queueOnPk = false;
        public boolean targetAffectRow = false;
        public Number num = null;
        public ParamMarker numP = null;
        public Number queueOnPkNum = null;
        public ParamMarker queueOnPkNumP = null;

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getClass().getSimpleName()).append('{');
            sb.append(", ").append("lowPriority").append('=').append(this.lowPriority);
            sb.append(", ").append("ignore").append('=').append(this.ignore);
            sb.append(", ").append("commitOnSuccess").append('=').append(this.commitOnSuccess);
            sb.append(", ").append("rollbackOnFail").append('=').append(this.rollbackOnFail);
            sb.append(", ").append("queueOnPk").append('=').append(this.queueOnPk);
            sb.append(", ").append("targetAffectRow").append('=').append(this.targetAffectRow);
            sb.append(", ").append("queueOnPkNum").append('=').append(this.queueOnPkNum);
            sb.append(", ").append("queueOnPkNumP").append('=').append(this.queueOnPkNumP);
            sb.append(", ").append("num").append('=').append(this.num);
            sb.append(", ").append("numP").append('=').append(this.numP);
            sb.append('}');
            return sb.toString();
        }
    }

    public static enum LockMode {
        UNDEF,
        FOR_UPDATE,
        LOCK_IN_SHARE_MODE;

    }

    public static enum SmallOrBigResult {
        UNDEF,
        SQL_SMALL_RESULT,
        SQL_BIG_RESULT;

    }

    public static enum QueryCacheStrategy {
        UNDEF,
        SQL_CACHE,
        SQL_NO_CACHE;

    }

    public static enum SelectDuplicationStrategy {
        ALL,
        DISTINCT,
        DISTINCTROW;

    }
}

