/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.txc.parser.ast.stmt.dml;

import com.alibaba.txc.parser.ast.expression.Expression;
import com.alibaba.txc.parser.ast.fragment.GroupBy;
import com.alibaba.txc.parser.ast.fragment.Limit;
import com.alibaba.txc.parser.ast.fragment.OrderBy;
import com.alibaba.txc.parser.ast.fragment.tableref.TableReferences;
import com.alibaba.txc.parser.ast.stmt.dml.DMLQueryStatement;
import com.alibaba.txc.parser.util.Pair;
import com.taobao.txc.parser.visitor.api.SQLASTVisitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DMLSelectStatement
extends DMLQueryStatement {
    private final SelectOption option;
    private final List<Pair<Expression, String>> selectExprList;
    private final TableReferences tables;
    private final Expression where;
    private final GroupBy group;
    private final Expression having;
    private final OrderBy order;
    private final Limit limit;
    private String originStr;

    public DMLSelectStatement(SelectOption option, List<Pair<Expression, String>> selectExprList, TableReferences tables, Expression where, GroupBy group, Expression having, OrderBy order, Limit limit) {
        if (option == null) {
            throw new IllegalArgumentException("argument 'option' is null");
        }
        this.option = option;
        this.selectExprList = selectExprList == null || selectExprList.isEmpty() ? Collections.emptyList() : DMLSelectStatement.ensureListType(selectExprList);
        this.tables = tables;
        this.where = where;
        this.group = group;
        this.having = having;
        this.order = order;
        this.limit = limit;
    }

    public SelectOption getOption() {
        return this.option;
    }

    public List<Pair<Expression, String>> getSelectExprList() {
        return this.selectExprList;
    }

    public List<Expression> getSelectExprListWithoutAlias() {
        if (this.selectExprList == null || this.selectExprList.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Expression> list = new ArrayList<Expression>(this.selectExprList.size());
        for (Pair<Expression, String> p : this.selectExprList) {
            if (p == null || p.getKey() == null) continue;
            list.add(p.getKey());
        }
        return list;
    }

    public TableReferences getTables() {
        return this.tables;
    }

    public Expression getWhere() {
        return this.where;
    }

    public GroupBy getGroup() {
        return this.group;
    }

    public Expression getHaving() {
        return this.having;
    }

    public OrderBy getOrder() {
        return this.order;
    }

    public Limit getLimit() {
        return this.limit;
    }

    @Override
    public void accept(SQLASTVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public String getOriginStr() {
        return this.originStr;
    }

    @Override
    public Expression setOriginStr(String str) {
        this.originStr = str;
        return this;
    }

    public static final class SelectOption {
        public SelectDuplicationStrategy resultDup = SelectDuplicationStrategy.ALL;
        public boolean highPriority = false;
        public boolean straightJoin = false;
        public SmallOrBigResult resultSize = SmallOrBigResult.UNDEF;
        public boolean sqlBufferResult = false;
        public QueryCacheStrategy queryCache = QueryCacheStrategy.UNDEF;
        public boolean sqlCalcFoundRows = false;
        public LockMode lockMode = LockMode.UNDEF;

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getClass().getSimpleName()).append('{');
            sb.append("resultDup").append('=').append(this.resultDup.name());
            sb.append(", ").append("highPriority").append('=').append(this.highPriority);
            sb.append(", ").append("straightJoin").append('=').append(this.straightJoin);
            sb.append(", ").append("resultSize").append('=').append(this.resultSize.name());
            sb.append(", ").append("sqlBufferResult").append('=').append(this.sqlBufferResult);
            sb.append(", ").append("queryCache").append('=').append(this.queryCache.name());
            sb.append(", ").append("sqlCalcFoundRows").append('=').append(this.sqlCalcFoundRows);
            sb.append(", ").append("lockMode").append('=').append(this.lockMode.name());
            sb.append('}');
            return sb.toString();
        }
    }

    public static enum LockMode {
        UNDEF,
        FOR_UPDATE,
        LOCK_IN_SHARE_MODE;

    }

    public static enum SmallOrBigResult {
        UNDEF,
        SQL_SMALL_RESULT,
        SQL_BIG_RESULT;

    }

    public static enum QueryCacheStrategy {
        UNDEF,
        SQL_CACHE,
        SQL_NO_CACHE;

    }

    public static enum SelectDuplicationStrategy {
        ALL,
        DISTINCT,
        DISTINCTROW;

    }
}

