/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.txc.parser.recognizer;

import com.alibaba.txc.parser.ast.stmt.SQLStatement;
import com.alibaba.txc.parser.ast.stmt.dml.DMLQueryStatement;
import com.alibaba.txc.parser.recognizer.mysql.MySQLToken;
import com.alibaba.txc.parser.recognizer.mysql.lexer.MySQLLexer;
import com.alibaba.txc.parser.recognizer.mysql.syntax.KillParser;
import com.alibaba.txc.parser.recognizer.mysql.syntax.MySQLDALParser;
import com.alibaba.txc.parser.recognizer.mysql.syntax.MySQLDDLParser;
import com.alibaba.txc.parser.recognizer.mysql.syntax.MySQLDMLCallParser;
import com.alibaba.txc.parser.recognizer.mysql.syntax.MySQLDMLDeleteParser;
import com.alibaba.txc.parser.recognizer.mysql.syntax.MySQLDMLInsertParser;
import com.alibaba.txc.parser.recognizer.mysql.syntax.MySQLDMLLoadParser;
import com.alibaba.txc.parser.recognizer.mysql.syntax.MySQLDMLReplaceParser;
import com.alibaba.txc.parser.recognizer.mysql.syntax.MySQLDMLSelectParser;
import com.alibaba.txc.parser.recognizer.mysql.syntax.MySQLDMLUpdateParser;
import com.alibaba.txc.parser.recognizer.mysql.syntax.MySQLExprParser;
import com.alibaba.txc.parser.recognizer.mysql.syntax.MySQLMTSParser;
import com.alibaba.txc.parser.recognizer.mysql.syntax.ReloadParser;
import java.sql.SQLSyntaxErrorException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class SQLParserDelegate {
    private static final Map<String, SpecialIdentifier> specialIdentifiers = new HashMap<String, SpecialIdentifier>();

    private static boolean isEOFedDDL(SQLStatement stmt) {
        return true;
    }

    public static String buildErrorMsg(Exception e, MySQLLexer lexer, String sql) {
        int to;
        StringBuilder sb = new StringBuilder("You have an error in your SQL syntax; Error occurs around this fragment: ");
        int ch = lexer.getCurrentIndex();
        int from = ch - 16;
        if (from < 0) {
            from = 0;
        }
        if ((to = ch + 9) >= sql.length()) {
            to = sql.length() - 1;
        }
        String fragment = sql.substring(from, to + 1);
        sb.append('{').append(fragment).append('}');
        if (e != null) {
            sb.append(". Error cause: " + e.getMessage());
        }
        return sb.toString();
    }

    public static SQLStatement parse(String sql, MySQLLexer lexer, String charset) throws SQLSyntaxErrorException {
        try {
            SQLStatement stmt = null;
            boolean isEOF = true;
            MySQLExprParser exprParser = new MySQLExprParser(lexer, charset);
            boolean explain = false;
            switch (lexer.token()) {
                case KW_EXPLAIN: {
                    lexer.nextToken();
                    explain = true;
                    break;
                }
            }
            block4 : switch (lexer.token()) {
                case KW_DESC: 
                case KW_DESCRIBE: {
                    stmt = new MySQLDALParser(lexer, exprParser).desc();
                    break;
                }
                case KW_SELECT: 
                case PUNC_LEFT_PAREN: {
                    stmt = new MySQLDMLSelectParser(lexer, exprParser).selectUnion();
                    break;
                }
                case KW_DELETE: {
                    stmt = new MySQLDMLDeleteParser(lexer, exprParser).delete();
                    break;
                }
                case KW_INSERT: {
                    stmt = new MySQLDMLInsertParser(lexer, exprParser).insert();
                    break;
                }
                case KW_REPLACE: {
                    stmt = new MySQLDMLReplaceParser(lexer, exprParser).replace();
                    break;
                }
                case KW_UPDATE: {
                    stmt = new MySQLDMLUpdateParser(lexer, exprParser).update();
                    break;
                }
                case KW_CALL: {
                    stmt = new MySQLDMLCallParser(lexer, exprParser).call();
                    break;
                }
                case KW_SET: {
                    stmt = new MySQLDALParser(lexer, exprParser).set();
                    break;
                }
                case KW_SHOW: {
                    stmt = new MySQLDALParser(lexer, exprParser).show();
                    break;
                }
                case KW_CHECK: {
                    stmt = new MySQLDALParser(lexer, exprParser).check();
                    break;
                }
                case KW_LOCK: {
                    stmt = new MySQLDALParser(lexer, exprParser).lock();
                    break;
                }
                case KW_UNLOCK: {
                    stmt = new MySQLDALParser(lexer, exprParser).unlock();
                    break;
                }
                case KW_LOAD: {
                    stmt = new MySQLDMLLoadParser(lexer, exprParser).load();
                    break;
                }
                case KW_ALTER: 
                case KW_CREATE: 
                case KW_DROP: 
                case KW_RENAME: {
                    stmt = new MySQLDDLParser(lexer, exprParser).ddlStmt();
                    isEOF = SQLParserDelegate.isEOFedDDL(stmt);
                    break;
                }
                case KW_RELEASE: {
                    stmt = new MySQLMTSParser(lexer).release();
                    break;
                }
                case IDENTIFIER: {
                    SpecialIdentifier si = null;
                    si = specialIdentifiers.get(lexer.stringValueUppercase());
                    if (si != null) {
                        switch (si) {
                            case TRUNCATE: {
                                stmt = new MySQLDDLParser(lexer, exprParser).truncate();
                                break block4;
                            }
                            case SAVEPOINT: {
                                stmt = new MySQLMTSParser(lexer).savepoint();
                                break block4;
                            }
                            case ROLLBACK: {
                                stmt = new MySQLMTSParser(lexer).rollback();
                                break block4;
                            }
                            case RELOAD: {
                                stmt = new ReloadParser(lexer).reload();
                                break block4;
                            }
                        }
                    }
                }
                default: {
                    throw new SQLSyntaxErrorException("sql is not a supported statement");
                }
            }
            if (isEOF) {
                while (lexer.token() == MySQLToken.PUNC_SEMICOLON) {
                    lexer.nextToken();
                }
                if (lexer.token() != MySQLToken.EOF) {
                    throw new SQLSyntaxErrorException(SQLParserDelegate.buildErrorMsg(null, lexer, sql));
                }
            }
            if (stmt instanceof DMLQueryStatement) {
                ((DMLQueryStatement)stmt).setExplain(explain);
            }
            return stmt;
        }
        catch (Exception e) {
            throw new SQLSyntaxErrorException(SQLParserDelegate.buildErrorMsg(e, lexer, sql), e);
        }
    }

    public static SQLStatement parse(String sql, String charset) throws SQLSyntaxErrorException {
        return SQLParserDelegate.parse(sql, new MySQLLexer(sql), charset);
    }

    public static SQLStatement parse(String sql) throws SQLSyntaxErrorException {
        return SQLParserDelegate.parse(sql, "utf-8");
    }

    public static List<SQLStatement> parseMultiStatements(String sql) throws SQLSyntaxErrorException {
        return SQLParserDelegate.parseMultiStatements(sql, "utf-8");
    }

    public static List<SQLStatement> parseMultiStatements(String sql, String charset) throws SQLSyntaxErrorException {
        return SQLParserDelegate.parseMultiStatements(sql, new MySQLLexer(sql), charset);
    }

    public static List<SQLStatement> parseMultiStatements(String sql, MySQLLexer lexer, String charset) throws SQLSyntaxErrorException {
        ArrayList<SQLStatement> stmtList = new ArrayList<SQLStatement>();
        try {
            boolean explain;
            SQLStatement stmt;
            while (true) {
                stmt = null;
                boolean isEOF = true;
                MySQLExprParser exprParser = new MySQLExprParser(lexer, charset);
                explain = false;
                switch (lexer.token()) {
                    case KW_EXPLAIN: {
                        lexer.nextToken();
                        explain = true;
                        break;
                    }
                }
                block4 : switch (lexer.token()) {
                    case KW_DESC: 
                    case KW_DESCRIBE: {
                        stmt = new MySQLDALParser(lexer, exprParser).desc();
                        break;
                    }
                    case KW_SELECT: 
                    case PUNC_LEFT_PAREN: {
                        stmt = new MySQLDMLSelectParser(lexer, exprParser).selectUnion();
                        break;
                    }
                    case KW_DELETE: {
                        stmt = new MySQLDMLDeleteParser(lexer, exprParser).delete();
                        break;
                    }
                    case KW_INSERT: {
                        stmt = new MySQLDMLInsertParser(lexer, exprParser).insert();
                        break;
                    }
                    case KW_REPLACE: {
                        stmt = new MySQLDMLReplaceParser(lexer, exprParser).replace();
                        break;
                    }
                    case KW_UPDATE: {
                        stmt = new MySQLDMLUpdateParser(lexer, exprParser).update();
                        break;
                    }
                    case KW_CALL: {
                        stmt = new MySQLDMLCallParser(lexer, exprParser).call();
                        break;
                    }
                    case KW_SET: {
                        stmt = new MySQLDALParser(lexer, exprParser).set();
                        break;
                    }
                    case KW_SHOW: {
                        stmt = new MySQLDALParser(lexer, exprParser).show();
                        break;
                    }
                    case KW_CHECK: {
                        stmt = new MySQLDALParser(lexer, exprParser).check();
                        break;
                    }
                    case KW_LOCK: {
                        stmt = new MySQLDALParser(lexer, exprParser).lock();
                        break;
                    }
                    case KW_UNLOCK: {
                        stmt = new MySQLDALParser(lexer, exprParser).unlock();
                        break;
                    }
                    case KW_LOAD: {
                        stmt = new MySQLDMLLoadParser(lexer, exprParser).load();
                        break;
                    }
                    case KW_KILL: {
                        stmt = new KillParser(lexer).kill();
                        break;
                    }
                    case KW_ALTER: 
                    case KW_CREATE: 
                    case KW_DROP: 
                    case KW_RENAME: {
                        stmt = new MySQLDDLParser(lexer, exprParser).ddlStmt();
                        isEOF = SQLParserDelegate.isEOFedDDL(stmt);
                        break;
                    }
                    case KW_RELEASE: {
                        stmt = new MySQLMTSParser(lexer).release();
                        break;
                    }
                    case IDENTIFIER: {
                        SpecialIdentifier si = null;
                        si = specialIdentifiers.get(lexer.stringValueUppercase());
                        if (si != null) {
                            switch (si) {
                                case TRUNCATE: {
                                    stmt = new MySQLDDLParser(lexer, exprParser).truncate();
                                    break block4;
                                }
                                case SAVEPOINT: {
                                    stmt = new MySQLMTSParser(lexer).savepoint();
                                    break block4;
                                }
                                case ROLLBACK: {
                                    stmt = new MySQLMTSParser(lexer).rollback();
                                    break block4;
                                }
                                case RELOAD: {
                                    stmt = new ReloadParser(lexer).reload();
                                    break block4;
                                }
                            }
                        }
                    }
                    default: {
                        throw new SQLSyntaxErrorException("sql is not a supported statement");
                    }
                }
                if (!isEOF) continue;
                while (lexer.token() == MySQLToken.PUNC_SEMICOLON) {
                    lexer.nextToken();
                }
                if (lexer.token() == MySQLToken.EOF) break;
                stmtList.add(stmt);
            }
            if (stmt instanceof DMLQueryStatement) {
                ((DMLQueryStatement)stmt).setExplain(explain);
            }
            stmtList.add(stmt);
        }
        catch (Exception e) {
            throw new SQLSyntaxErrorException(SQLParserDelegate.buildErrorMsg(e, lexer, sql), e);
        }
        return stmtList;
    }

    static {
        specialIdentifiers.put("TRUNCATE", SpecialIdentifier.TRUNCATE);
        specialIdentifiers.put("SAVEPOINT", SpecialIdentifier.SAVEPOINT);
        specialIdentifiers.put("ROLLBACK", SpecialIdentifier.ROLLBACK);
        specialIdentifiers.put("RELOAD", SpecialIdentifier.RELOAD);
    }

    private static enum SpecialIdentifier {
        ROLLBACK,
        SAVEPOINT,
        TRUNCATE,
        RELOAD;

    }
}

