/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.txc.parser.recognizer.mysql.lexer;

import com.alibaba.txc.parser.recognizer.mysql.MySQLToken;
import java.util.Map;
import java.util.TreeMap;

public class MySQLKeywords {
    public static final MySQLKeywords DEFAULT_KEYWORDS = new MySQLKeywords();
    private final Map<String, MySQLToken> keywords = new TreeMap<String, MySQLToken>(String.CASE_INSENSITIVE_ORDER);

    private MySQLKeywords() {
        for (MySQLToken type : (MySQLToken[])MySQLToken.class.getEnumConstants()) {
            String name = type.name();
            if (!name.startsWith("KW_")) continue;
            String kw = name.substring("KW_".length());
            this.keywords.put(kw, type);
        }
        this.keywords.put("NULL", MySQLToken.LITERAL_NULL);
        this.keywords.put("FALSE", MySQLToken.LITERAL_BOOL_FALSE);
        this.keywords.put("TRUE", MySQLToken.LITERAL_BOOL_TRUE);
    }

    public MySQLToken getKeyword(String keyUpperCase) {
        return this.keywords.get(keyUpperCase);
    }

    public boolean isKeyword(String keyUpperCase) {
        return this.keywords.containsKey(keyUpperCase);
    }
}

