/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.txc.parser.recognizer.mysql.lexer;

import com.alibaba.txc.parser.recognizer.mysql.MySQLToken;
import com.alibaba.txc.parser.recognizer.mysql.lexer.MySQLKeywords;
import com.alibaba.txc.parser.util.CharTypes;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.SQLSyntaxErrorException;

public class SQLLexer {
    private static int C_STYLE_COMMENT_VERSION = 50599;
    private static final byte EOI = 26;
    protected final char[] sql;
    protected final int eofIndex;
    protected int curIndex = -1;
    protected char ch;
    private MySQLToken token;
    private MySQLToken tokenCache;
    private int paramIndex = 0;
    protected static final ThreadLocal<char[]> sbufRef = new ThreadLocal();
    protected char[] sbuf;
    private String stringValue;
    private String stringValueUppercase;
    protected MySQLKeywords keywods = MySQLKeywords.DEFAULT_KEYWORDS;
    protected boolean inCStyleComment;
    protected boolean inCStyleCommentIgnore;
    protected int offsetCache;
    protected int sizeCache;

    public static int setCStyleCommentVersion(int version) {
        int v = C_STYLE_COMMENT_VERSION;
        C_STYLE_COMMENT_VERSION = version;
        return v;
    }

    protected void updateStringValue(char[] src, int srcOffset, int len) {
        int srcIndex;
        this.stringValue = new String(src, srcOffset, len);
        int end = srcOffset + len;
        boolean lowerCase = false;
        int hash = 0;
        for (srcIndex = srcOffset; srcIndex < end; ++srcIndex) {
            char c = src[srcIndex];
            if (c >= 'a' && c <= 'z') {
                lowerCase = true;
                if (srcIndex <= srcOffset) break;
                System.arraycopy(src, srcOffset, this.sbuf, 0, srcIndex - srcOffset);
                break;
            }
            hash = 31 * hash + c;
        }
        if (lowerCase) {
            for (int destIndex = srcIndex - srcOffset; destIndex < len; ++destIndex) {
                char c = src[srcIndex++];
                hash = 31 * hash + c;
                if (c >= 'a' && c <= 'z') {
                    this.sbuf[destIndex] = (char)(c - 32);
                    hash -= 32;
                    continue;
                }
                this.sbuf[destIndex] = c;
            }
            this.stringValueUppercase = new String(this.sbuf, 0, len);
        } else {
            this.stringValueUppercase = new String(src, srcOffset, len);
        }
    }

    public SQLLexer(char[] sql) throws SQLSyntaxErrorException {
        this.sbuf = sbufRef.get();
        if (this.sbuf == null) {
            this.sbuf = new char[1024];
            sbufRef.set(this.sbuf);
        }
        if (CharTypes.isWhitespace(sql[sql.length - 1])) {
            this.sql = sql;
        } else {
            this.sql = new char[sql.length + 1];
            System.arraycopy(sql, 0, this.sql, 0, sql.length);
        }
        this.eofIndex = this.sql.length - 1;
        this.sql[this.eofIndex] = 26;
        this.scanChar();
        this.nextToken();
    }

    public SQLLexer(String sql) throws SQLSyntaxErrorException {
        this(SQLLexer.fromSQL2Chars(sql));
    }

    private static char[] fromSQL2Chars(String sql) {
        if (CharTypes.isWhitespace(sql.charAt(sql.length() - 1))) {
            return sql.toCharArray();
        }
        char[] chars = new char[sql.length() + 1];
        sql.getChars(0, sql.length(), chars, 0);
        chars[chars.length - 1] = 32;
        return chars;
    }

    public final void addCacheToke(MySQLToken token) {
        this.tokenCache = token;
    }

    public final MySQLToken token() {
        if (this.tokenCache != null) {
            return this.tokenCache;
        }
        return this.token;
    }

    public final char[] getSQL() {
        return this.sql;
    }

    public int getOffsetCache() {
        return this.offsetCache;
    }

    public int getSizeCache() {
        return this.sizeCache;
    }

    public int paramIndex() {
        return this.paramIndex;
    }

    protected final char scanChar() {
        this.ch = this.sql[++this.curIndex];
        return this.ch;
    }

    protected final char scanChar(int skip) {
        this.ch = this.sql[this.curIndex += skip];
        return this.ch;
    }

    protected final boolean hasChars(int howMany) {
        return this.curIndex + howMany <= this.eofIndex;
    }

    protected final boolean eof() {
        return this.curIndex >= this.eofIndex;
    }

    private MySQLToken nextTokenInternal() throws SQLSyntaxErrorException {
        switch (this.ch) {
            case '0': {
                switch (this.sql[this.curIndex + 1]) {
                    case 'x': {
                        this.scanChar(2);
                        this.scanHexaDecimal(false);
                        return this.token;
                    }
                    case 'b': {
                        this.scanChar(2);
                        this.scanBitField(false);
                        return this.token;
                    }
                }
            }
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                this.scanNumber();
                return this.token;
            }
            case '.': {
                if (CharTypes.isDigit(this.sql[this.curIndex + 1])) {
                    this.scanNumber();
                } else {
                    this.scanChar();
                    this.token = MySQLToken.PUNC_DOT;
                }
                return this.token;
            }
            case '\"': 
            case '\'': {
                this.scanString();
                return this.token;
            }
            case 'N': 
            case 'n': {
                if (this.sql[this.curIndex + 1] == '\'') {
                    this.scanChar();
                    this.scanString();
                    this.token = MySQLToken.LITERAL_NCHARS;
                    return this.token;
                }
                this.scanIdentifier();
                return this.token;
            }
            case 'X': 
            case 'x': {
                if (this.sql[this.curIndex + 1] == '\'') {
                    this.scanChar(2);
                    this.scanHexaDecimal(true);
                    return this.token;
                }
                this.scanIdentifier();
                return this.token;
            }
            case 'B': 
            case 'b': {
                if (this.sql[this.curIndex + 1] == '\'') {
                    this.scanChar(2);
                    this.scanBitField(true);
                    return this.token;
                }
                this.scanIdentifier();
                return this.token;
            }
            case '@': {
                if (this.sql[this.curIndex + 1] == '@') {
                    this.scanSystemVariable();
                    return this.token;
                }
                this.scanUserVariable();
                return this.token;
            }
            case '?': {
                this.scanChar();
                this.token = MySQLToken.QUESTION_MARK;
                ++this.paramIndex;
                return this.token;
            }
            case '(': {
                this.scanChar();
                this.token = MySQLToken.PUNC_LEFT_PAREN;
                return this.token;
            }
            case ')': {
                this.scanChar();
                this.token = MySQLToken.PUNC_RIGHT_PAREN;
                return this.token;
            }
            case '[': {
                this.scanChar();
                this.token = MySQLToken.PUNC_LEFT_BRACKET;
                return this.token;
            }
            case ']': {
                this.scanChar();
                this.token = MySQLToken.PUNC_RIGHT_BRACKET;
                return this.token;
            }
            case '{': {
                this.scanChar();
                this.token = MySQLToken.PUNC_LEFT_BRACE;
                return this.token;
            }
            case '}': {
                this.scanChar();
                this.token = MySQLToken.PUNC_RIGHT_BRACE;
                return this.token;
            }
            case ',': {
                this.scanChar();
                this.token = MySQLToken.PUNC_COMMA;
                return this.token;
            }
            case ';': {
                this.scanChar();
                this.token = MySQLToken.PUNC_SEMICOLON;
                return this.token;
            }
            case ':': {
                if (this.sql[this.curIndex + 1] == '=') {
                    this.scanChar(2);
                    this.token = MySQLToken.OP_ASSIGN;
                    return this.token;
                }
                this.scanChar();
                this.token = MySQLToken.PUNC_COLON;
                return this.token;
            }
            case '=': {
                this.scanChar();
                this.token = MySQLToken.OP_EQUALS;
                return this.token;
            }
            case '~': {
                this.scanChar();
                this.token = MySQLToken.OP_TILDE;
                return this.token;
            }
            case '*': {
                if (this.inCStyleComment && this.sql[this.curIndex + 1] == '/') {
                    this.inCStyleComment = false;
                    this.inCStyleCommentIgnore = false;
                    this.scanChar(2);
                    this.token = MySQLToken.PUNC_C_STYLE_COMMENT_END;
                    return this.token;
                }
                this.scanChar();
                this.token = MySQLToken.OP_ASTERISK;
                return this.token;
            }
            case '-': {
                this.scanChar();
                this.token = MySQLToken.OP_MINUS;
                return this.token;
            }
            case '+': {
                this.scanChar();
                this.token = MySQLToken.OP_PLUS;
                return this.token;
            }
            case '^': {
                this.scanChar();
                this.token = MySQLToken.OP_CARET;
                return this.token;
            }
            case '/': {
                this.scanChar();
                this.token = MySQLToken.OP_SLASH;
                return this.token;
            }
            case '%': {
                this.scanChar();
                this.token = MySQLToken.OP_PERCENT;
                return this.token;
            }
            case '&': {
                if (this.sql[this.curIndex + 1] == '&') {
                    this.scanChar(2);
                    this.token = MySQLToken.OP_LOGICAL_AND;
                    return this.token;
                }
                this.scanChar();
                this.token = MySQLToken.OP_AMPERSAND;
                return this.token;
            }
            case '|': {
                if (this.sql[this.curIndex + 1] == '|') {
                    this.scanChar(2);
                    this.token = MySQLToken.OP_LOGICAL_OR;
                    return this.token;
                }
                this.scanChar();
                this.token = MySQLToken.OP_VERTICAL_BAR;
                return this.token;
            }
            case '!': {
                if (this.sql[this.curIndex + 1] == '=') {
                    this.scanChar(2);
                    this.token = MySQLToken.OP_NOT_EQUALS;
                    return this.token;
                }
                this.scanChar();
                this.token = MySQLToken.OP_EXCLAMATION;
                return this.token;
            }
            case '>': {
                switch (this.sql[this.curIndex + 1]) {
                    case '=': {
                        this.scanChar(2);
                        this.token = MySQLToken.OP_GREATER_OR_EQUALS;
                        return this.token;
                    }
                    case '>': {
                        this.scanChar(2);
                        this.token = MySQLToken.OP_RIGHT_SHIFT;
                        return this.token;
                    }
                }
                this.scanChar();
                this.token = MySQLToken.OP_GREATER_THAN;
                return this.token;
            }
            case '<': {
                switch (this.sql[this.curIndex + 1]) {
                    case '=': {
                        if (this.sql[this.curIndex + 2] == '>') {
                            this.scanChar(3);
                            this.token = MySQLToken.OP_NULL_SAFE_EQUALS;
                            return this.token;
                        }
                        this.scanChar(2);
                        this.token = MySQLToken.OP_LESS_OR_EQUALS;
                        return this.token;
                    }
                    case '>': {
                        this.scanChar(2);
                        this.token = MySQLToken.OP_LESS_OR_GREATER;
                        return this.token;
                    }
                    case '<': {
                        this.scanChar(2);
                        this.token = MySQLToken.OP_LEFT_SHIFT;
                        return this.token;
                    }
                }
                this.scanChar();
                this.token = MySQLToken.OP_LESS_THAN;
                return this.token;
            }
            case '`': {
                this.scanIdentifierWithAccent();
                return this.token;
            }
            case '\u0000': {
                if (this.curIndex + 1 >= this.eofIndex) {
                    this.token = MySQLToken.EOF;
                    this.curIndex = this.eofIndex;
                    return this.token;
                }
                throw this.err("unsupported character: " + this.ch);
            }
        }
        if (CharTypes.isIdentifierChar(this.ch)) {
            this.scanIdentifier();
        } else if (this.eof()) {
            this.token = MySQLToken.EOF;
            this.curIndex = this.eofIndex;
        } else {
            throw this.err("unsupported character: " + this.ch);
        }
        return this.token;
    }

    public MySQLToken nextToken() throws SQLSyntaxErrorException {
        MySQLToken t;
        if (this.tokenCache != null) {
            this.tokenCache = null;
            return this.token;
        }
        do {
            this.skipSeparator();
            t = this.nextTokenInternal();
        } while (this.inCStyleComment && this.inCStyleCommentIgnore || MySQLToken.PUNC_C_STYLE_COMMENT_END == t);
        return t;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void scanUserVariable() throws SQLSyntaxErrorException {
        if (this.ch != '@') {
            throw this.err("first char must be @");
        }
        this.offsetCache = this.curIndex;
        this.sizeCache = 1;
        boolean dq = false;
        block0 : switch (this.scanChar()) {
            case '\"': {
                dq = true;
            }
            case '\'': {
                ++this.sizeCache;
                while (true) {
                    switch (this.scanChar()) {
                        case '\\': {
                            ++this.sizeCache;
                            this.scanChar();
                            break;
                        }
                        case '\"': {
                            if (!dq) break;
                            ++this.sizeCache;
                            if (this.scanChar() != '\"') break block0;
                            break;
                        }
                        case '\'': {
                            if (dq) break;
                            ++this.sizeCache;
                            if (this.scanChar() != '\'') break block0;
                        }
                    }
                    ++this.sizeCache;
                }
            }
            case '`': {
                ++this.sizeCache;
                while (true) {
                    switch (this.scanChar()) {
                        case '`': {
                            ++this.sizeCache;
                            if (this.scanChar() != '`') break block0;
                        }
                        default: {
                            ++this.sizeCache;
                            break;
                        }
                    }
                }
            }
            default: {
                while (CharTypes.isIdentifierChar(this.ch) || this.ch == '.') {
                    this.scanChar();
                    ++this.sizeCache;
                }
                break block0;
            }
        }
        this.stringValue = new String(this.sql, this.offsetCache, this.sizeCache);
        this.token = MySQLToken.USR_VAR;
    }

    protected void scanSystemVariable() throws SQLSyntaxErrorException {
        block6: {
            if (this.ch != '@' || this.sql[this.curIndex + 1] != '@') {
                throw this.err("first char must be @@");
            }
            this.offsetCache = this.curIndex + 2;
            this.sizeCache = 0;
            this.scanChar(2);
            if (this.ch == '`') {
                ++this.sizeCache;
                while (true) {
                    if (this.scanChar() == '`') {
                        ++this.sizeCache;
                        if (this.scanChar() != '`') break block6;
                    }
                    ++this.sizeCache;
                }
            }
            while (CharTypes.isIdentifierChar(this.ch)) {
                this.scanChar();
                ++this.sizeCache;
            }
        }
        this.updateStringValue(this.sql, this.offsetCache, this.sizeCache);
        this.token = MySQLToken.SYS_VAR;
    }

    protected void scanString() throws SQLSyntaxErrorException {
        int size;
        block19: {
            boolean dq = false;
            if (this.ch != '\'') {
                if (this.ch == '\"') {
                    dq = true;
                } else {
                    throw this.err("first char must be \" or '");
                }
            }
            this.offsetCache = this.curIndex;
            size = 1;
            this.sbuf[0] = 39;
            if (dq) {
                while (true) {
                    switch (this.scanChar()) {
                        case '\'': {
                            this.putChar('\\', size++);
                            this.putChar('\'', size++);
                            break;
                        }
                        case '\\': {
                            this.putChar('\\', size++);
                            this.putChar(this.scanChar(), size++);
                            break;
                        }
                        case '\"': {
                            if (this.sql[this.curIndex + 1] == '\"') {
                                this.putChar('\"', size++);
                                this.scanChar();
                                break;
                            }
                            this.putChar('\'', size++);
                            this.scanChar();
                            break block19;
                        }
                        default: {
                            if (this.eof()) {
                                throw this.err("unclosed string");
                            }
                            this.putChar(this.ch, size++);
                            break;
                        }
                    }
                }
            }
            block10: while (true) {
                switch (this.scanChar()) {
                    case '\\': {
                        this.putChar('\\', size++);
                        this.putChar(this.scanChar(), size++);
                        continue block10;
                    }
                    case '\'': {
                        if (this.sql[this.curIndex + 1] == '\'') {
                            this.putChar('\\', size++);
                            this.putChar(this.scanChar(), size++);
                            continue block10;
                        }
                        this.putChar('\'', size++);
                        this.scanChar();
                        break block10;
                    }
                    default: {
                        if (this.eof()) {
                            throw this.err("unclosed string");
                        }
                        this.putChar(this.ch, size++);
                        continue block10;
                    }
                }
                break;
            }
        }
        this.sizeCache = size;
        this.stringValue = new String(this.sbuf, 0, size);
        this.token = MySQLToken.LITERAL_CHARS;
    }

    protected final void putChar(char ch, int index) {
        if (index >= this.sbuf.length) {
            char[] newsbuf = new char[this.sbuf.length * 2];
            System.arraycopy(this.sbuf, 0, newsbuf, 0, this.sbuf.length);
            this.sbuf = newsbuf;
        }
        this.sbuf[index] = ch;
    }

    protected void scanHexaDecimal(boolean quoteMode) throws SQLSyntaxErrorException {
        this.offsetCache = this.curIndex;
        while (CharTypes.isHex(this.ch)) {
            this.scanChar();
        }
        this.sizeCache = this.curIndex - this.offsetCache;
        if (this.sizeCache <= 0) {
            throw this.err("expect at least one hexdigit");
        }
        if (quoteMode) {
            if (this.ch != '\'') {
                throw this.err("invalid char for hex: " + this.ch);
            }
            this.scanChar();
        } else if (CharTypes.isIdentifierChar(this.ch)) {
            this.scanIdentifierFromNumber(this.offsetCache - 2, this.sizeCache + 2);
            return;
        }
        this.token = MySQLToken.LITERAL_HEX;
    }

    protected void scanBitField(boolean quoteMode) throws SQLSyntaxErrorException {
        this.offsetCache = this.curIndex;
        while (this.ch == '0' || this.ch == '1') {
            this.scanChar();
        }
        this.sizeCache = this.curIndex - this.offsetCache;
        if (this.sizeCache <= 0) {
            throw this.err("expect at least one bit");
        }
        if (quoteMode) {
            if (this.ch != '\'') {
                throw this.err("invalid char for bit: " + this.ch);
            }
            this.scanChar();
        } else if (CharTypes.isIdentifierChar(this.ch)) {
            this.scanIdentifierFromNumber(this.offsetCache - 2, this.sizeCache + 2);
            return;
        }
        this.token = MySQLToken.LITERAL_BIT;
        this.stringValue = new String(this.sql, this.offsetCache, this.sizeCache);
    }

    protected void scanNumber() throws SQLSyntaxErrorException {
        int state;
        boolean fstDot;
        this.offsetCache = this.curIndex;
        this.sizeCache = 1;
        boolean dot = fstDot = this.ch == '.';
        boolean sign = false;
        int n = state = fstDot ? 1 : 0;
        while (this.scanChar() != '\u001a') {
            switch (state) {
                case 0: {
                    if (CharTypes.isDigit(this.ch)) break;
                    if (this.ch == '.') {
                        dot = true;
                        state = 1;
                        break;
                    }
                    if (this.ch == 'e' || this.ch == 'E') {
                        state = 3;
                        break;
                    }
                    if (CharTypes.isIdentifierChar(this.ch)) {
                        this.scanIdentifierFromNumber(this.offsetCache, this.sizeCache);
                        return;
                    }
                    this.token = MySQLToken.LITERAL_NUM_PURE_DIGIT;
                    return;
                }
                case 1: {
                    if (CharTypes.isDigit(this.ch)) {
                        state = 2;
                        break;
                    }
                    if (this.ch == 'e' || this.ch == 'E') {
                        state = 3;
                        break;
                    }
                    if (CharTypes.isIdentifierChar(this.ch) && fstDot) {
                        this.sizeCache = 1;
                        this.curIndex = this.offsetCache + 1;
                        this.ch = this.sql[this.curIndex];
                        this.token = MySQLToken.PUNC_DOT;
                        return;
                    }
                    this.token = MySQLToken.LITERAL_NUM_MIX_DIGIT;
                    return;
                }
                case 2: {
                    if (CharTypes.isDigit(this.ch)) break;
                    if (this.ch == 'e' || this.ch == 'E') {
                        state = 3;
                        break;
                    }
                    if (CharTypes.isIdentifierChar(this.ch) && fstDot) {
                        this.sizeCache = 1;
                        this.curIndex = this.offsetCache + 1;
                        this.ch = this.sql[this.curIndex];
                        this.token = MySQLToken.PUNC_DOT;
                        return;
                    }
                    this.token = MySQLToken.LITERAL_NUM_MIX_DIGIT;
                    return;
                }
                case 3: {
                    if (CharTypes.isDigit(this.ch)) {
                        state = 5;
                        break;
                    }
                    if (this.ch == '+' || this.ch == '-') {
                        sign = true;
                        state = 4;
                        break;
                    }
                    if (fstDot) {
                        this.sizeCache = 1;
                        this.curIndex = this.offsetCache + 1;
                        this.ch = this.sql[this.curIndex];
                        this.token = MySQLToken.PUNC_DOT;
                        return;
                    }
                    if (!dot) {
                        if (CharTypes.isIdentifierChar(this.ch)) {
                            this.scanIdentifierFromNumber(this.offsetCache, this.sizeCache);
                        } else {
                            this.updateStringValue(this.sql, this.offsetCache, this.sizeCache);
                            MySQLToken tok = this.keywods.getKeyword(this.stringValueUppercase);
                            this.token = tok == null ? MySQLToken.IDENTIFIER : tok;
                        }
                        return;
                    }
                    throw this.err("invalid char after '.' and 'e' for as part of number: " + this.ch);
                }
                case 4: {
                    if (CharTypes.isDigit(this.ch)) {
                        state = 5;
                        break;
                    }
                    if (fstDot) {
                        this.sizeCache = 1;
                        this.curIndex = this.offsetCache + 1;
                        this.ch = this.sql[this.curIndex];
                        this.token = MySQLToken.PUNC_DOT;
                    } else if (!dot) {
                        this.ch = this.sql[--this.curIndex];
                        --this.sizeCache;
                        this.updateStringValue(this.sql, this.offsetCache, this.sizeCache);
                        MySQLToken tok = this.keywods.getKeyword(this.stringValueUppercase);
                        this.token = tok == null ? MySQLToken.IDENTIFIER : tok;
                    } else {
                        throw this.err("expect digit char after SIGN for 'e': " + this.ch);
                    }
                    return;
                }
                case 5: {
                    if (CharTypes.isDigit(this.ch)) break;
                    if (CharTypes.isIdentifierChar(this.ch)) {
                        if (fstDot) {
                            this.sizeCache = 1;
                            this.curIndex = this.offsetCache + 1;
                            this.ch = this.sql[this.curIndex];
                            this.token = MySQLToken.PUNC_DOT;
                        } else if (!dot) {
                            if (sign) {
                                this.curIndex = this.offsetCache;
                                this.ch = this.sql[this.curIndex];
                                this.scanIdentifierFromNumber(this.curIndex, 0);
                            } else {
                                this.scanIdentifierFromNumber(this.offsetCache, this.sizeCache);
                            }
                        } else {
                            this.token = MySQLToken.LITERAL_NUM_MIX_DIGIT;
                        }
                    } else {
                        this.token = MySQLToken.LITERAL_NUM_MIX_DIGIT;
                    }
                    return;
                }
            }
            ++this.sizeCache;
        }
        switch (state) {
            case 0: {
                this.token = MySQLToken.LITERAL_NUM_PURE_DIGIT;
                return;
            }
            case 1: {
                if (fstDot) {
                    this.token = MySQLToken.PUNC_DOT;
                    return;
                }
            }
            case 2: 
            case 5: {
                this.token = MySQLToken.LITERAL_NUM_MIX_DIGIT;
                return;
            }
            case 3: {
                if (fstDot) {
                    this.sizeCache = 1;
                    this.curIndex = this.offsetCache + 1;
                    this.ch = this.sql[this.curIndex];
                    this.token = MySQLToken.PUNC_DOT;
                } else if (!dot) {
                    this.updateStringValue(this.sql, this.offsetCache, this.sizeCache);
                    MySQLToken tok = this.keywods.getKeyword(this.stringValueUppercase);
                    this.token = tok == null ? MySQLToken.IDENTIFIER : tok;
                } else {
                    throw this.err("expect digit char after SIGN for 'e': " + this.ch);
                }
                return;
            }
            case 4: {
                if (fstDot) {
                    this.sizeCache = 1;
                    this.curIndex = this.offsetCache + 1;
                    this.ch = this.sql[this.curIndex];
                    this.token = MySQLToken.PUNC_DOT;
                } else if (!dot) {
                    this.ch = this.sql[--this.curIndex];
                    --this.sizeCache;
                    this.updateStringValue(this.sql, this.offsetCache, this.sizeCache);
                    MySQLToken tok = this.keywods.getKeyword(this.stringValueUppercase);
                    this.token = tok == null ? MySQLToken.IDENTIFIER : tok;
                } else {
                    throw this.err("expect digit char after SIGN for 'e': " + this.ch);
                }
                return;
            }
        }
    }

    private void scanIdentifierFromNumber(int initOffset, int initSize) throws SQLSyntaxErrorException {
        this.offsetCache = initOffset;
        this.sizeCache = initSize;
        while (CharTypes.isIdentifierChar(this.ch)) {
            this.scanChar();
            ++this.sizeCache;
        }
        this.updateStringValue(this.sql, this.offsetCache, this.sizeCache);
        MySQLToken tok = this.keywods.getKeyword(this.stringValueUppercase);
        this.token = tok == null ? MySQLToken.IDENTIFIER : tok;
    }

    protected void scanIdentifier() throws SQLSyntaxErrorException {
        if (this.ch == '$') {
            if (this.scanChar() == '{') {
                this.scanPlaceHolder();
            } else {
                this.scanIdentifierFromNumber(this.curIndex - 1, 1);
            }
        } else {
            this.scanIdentifierFromNumber(this.curIndex, 0);
        }
    }

    protected void scanPlaceHolder() throws SQLSyntaxErrorException {
        this.offsetCache = this.curIndex + 1;
        this.sizeCache = 0;
        this.scanChar();
        while (this.ch != '}' && !this.eof()) {
            this.scanChar();
            ++this.sizeCache;
        }
        if (this.ch == '}') {
            this.scanChar();
        }
        this.updateStringValue(this.sql, this.offsetCache, this.sizeCache);
        this.token = MySQLToken.PLACE_HOLDER;
    }

    protected void scanIdentifierWithAccent() throws SQLSyntaxErrorException {
        this.offsetCache = this.curIndex;
        while (this.scanChar() != '\u001a' && (this.ch != '`' || this.scanChar() == '`')) {
        }
        this.sizeCache = this.curIndex - this.offsetCache;
        this.updateStringValue(this.sql, this.offsetCache, this.sizeCache);
        this.token = MySQLToken.IDENTIFIER;
    }

    protected void skipSeparator() {
        block5: while (!this.eof()) {
            while (CharTypes.isWhitespace(this.ch)) {
                this.scanChar();
            }
            switch (this.ch) {
                case '#': {
                    while (this.scanChar() != '\n') {
                        if (!this.eof()) continue;
                        return;
                    }
                    this.scanChar();
                    continue block5;
                }
                case '/': {
                    if (this.hasChars(2) && '*' == this.sql[this.curIndex + 1]) {
                        boolean commentSkip;
                        if ('!' == this.sql[this.curIndex + 2]) {
                            this.scanChar(3);
                            this.inCStyleComment = true;
                            this.inCStyleCommentIgnore = false;
                            commentSkip = false;
                            if (this.hasChars(5) && CharTypes.isDigit(this.ch) && CharTypes.isDigit(this.sql[this.curIndex + 1]) && CharTypes.isDigit(this.sql[this.curIndex + 2]) && CharTypes.isDigit(this.sql[this.curIndex + 3]) && CharTypes.isDigit(this.sql[this.curIndex + 4])) {
                                int version = this.ch - 48;
                                version *= 10;
                                version += this.sql[this.curIndex + 1] - 48;
                                version *= 10;
                                version += this.sql[this.curIndex + 2] - 48;
                                version *= 10;
                                version += this.sql[this.curIndex + 3] - 48;
                                version *= 10;
                                this.scanChar(5);
                                if ((version += this.sql[this.curIndex + 4] - 48) > C_STYLE_COMMENT_VERSION) {
                                    this.inCStyleCommentIgnore = true;
                                }
                            }
                            this.skipSeparator();
                        } else {
                            this.scanChar(2);
                            commentSkip = true;
                        }
                        if (commentSkip) {
                            boolean state = false;
                            while (!this.eof()) {
                                if (!state) {
                                    if ('*' == this.ch) {
                                        state = true;
                                    }
                                } else {
                                    if ('/' == this.ch) {
                                        this.scanChar();
                                        continue block5;
                                    }
                                    if ('*' != this.ch) {
                                        state = false;
                                    }
                                }
                                this.scanChar();
                            }
                            continue block5;
                        }
                    }
                    return;
                }
                case '-': {
                    if (!this.hasChars(3) || '-' != this.sql[this.curIndex + 1] || !CharTypes.isWhitespace(this.sql[this.curIndex + 2])) break;
                    this.scanChar(3);
                    while (!this.eof()) {
                        if ('\n' == this.ch) {
                            this.scanChar();
                            continue block5;
                        }
                        this.scanChar();
                    }
                    continue block5;
                }
            }
            return;
        }
    }

    protected SQLSyntaxErrorException err(String msg) throws SQLSyntaxErrorException {
        String errMsg = msg + ". " + this.toString();
        throw new SQLSyntaxErrorException(errMsg);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append('@').append(this.hashCode()).append('{');
        String sqlLeft = new String(this.sql, this.curIndex, this.sql.length - this.curIndex);
        sb.append("curIndex=").append(this.curIndex).append(", ch=").append(this.ch).append(", token=").append((Object)this.token).append(", sqlLeft=").append(sqlLeft).append(", sql=").append(this.sql);
        sb.append('}');
        return sb.toString();
    }

    public Number integerValue() {
        if (this.sizeCache < 10 || this.sizeCache == 10 && (this.sql[this.offsetCache] < '2' || this.sql[this.offsetCache] == '2' && this.sql[this.offsetCache + 1] == '0')) {
            int rst = 0;
            int end = this.offsetCache + this.sizeCache;
            for (int i = this.offsetCache; i < end; ++i) {
                rst = (rst << 3) + (rst << 1);
                rst += this.sql[i] - 48;
            }
            return rst;
        }
        if (this.sizeCache < 19 || this.sizeCache == 19 && this.sql[this.offsetCache] < '9') {
            long rst = 0L;
            int end = this.offsetCache + this.sizeCache;
            for (int i = this.offsetCache; i < end; ++i) {
                rst = (rst << 3) + (rst << 1);
                rst += (long)(this.sql[i] - 48);
            }
            return rst;
        }
        return new BigInteger(new String(this.sql, this.offsetCache, this.sizeCache), 10);
    }

    public BigDecimal decimalValue() {
        return new BigDecimal(this.sql, this.offsetCache, this.sizeCache);
    }

    public void appendStringContent(StringBuilder sb) {
        sb.append(this.sbuf, 1, this.sizeCache - 2);
    }

    public final String stringValue() {
        return this.stringValue;
    }

    public final String stringValueUppercase() {
        return this.stringValueUppercase;
    }
}

