/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.txc.parser.recognizer.mysql.syntax;

import com.alibaba.txc.parser.ast.expression.primary.Identifier;
import com.alibaba.txc.parser.ast.expression.primary.ddl.AlterSpecification;
import com.alibaba.txc.parser.ast.expression.primary.ddl.ChangeColumn;
import com.alibaba.txc.parser.ast.expression.primary.ddl.DBPartitionBy;
import com.alibaba.txc.parser.ast.expression.primary.ddl.PartitionByType;
import com.alibaba.txc.parser.ast.expression.primary.ddl.TBPartitionBy;
import com.alibaba.txc.parser.ast.expression.primary.literal.LiteralString;
import com.alibaba.txc.parser.ast.stmt.ddl.DDLAlterTableStatement;
import com.alibaba.txc.parser.ast.stmt.ddl.DDLCreateTableStatement;
import com.alibaba.txc.parser.ast.stmt.ddl.DDLDropTableStatement;
import com.alibaba.txc.parser.recognizer.mysql.syntax.EmptySQLASTVisitor;
import java.util.List;

public class MyDBPartitionCharsetVisitor
extends EmptySQLASTVisitor {
    private RuleTopology ruleTopology;

    public MyDBPartitionCharsetVisitor() {
    }

    public MyDBPartitionCharsetVisitor(RuleTopology ruleTopology) {
        this.ruleTopology = ruleTopology;
    }

    @Override
    public void visit(DBPartitionBy DBPartitionBy2) {
        LiteralString str;
        if (DBPartitionBy2.getType() == PartitionByType.HASH && DBPartitionBy2.getColExpr() instanceof LiteralString && !this.isAscii((str = (LiteralString)DBPartitionBy2.getColExpr()).getString())) {
            throw new IllegalArgumentException("DDL cannot take non-ASCII db shard column");
        }
    }

    @Override
    public void visit(TBPartitionBy TBPartitionBy2) {
        LiteralString str;
        if (TBPartitionBy2.getType() == PartitionByType.HASH && TBPartitionBy2.getColExpr() instanceof LiteralString && !this.isAscii((str = (LiteralString)TBPartitionBy2.getColExpr()).getString())) {
            throw new IllegalArgumentException("DDL cannot take non-ASCII table shard column");
        }
    }

    @Override
    public void visit(DDLCreateTableStatement stmt) {
        if (stmt.getDBPartitionOptions() == null) {
            return;
        }
        if (stmt.getDBPartitionOptions().getDbpartitionBy() == null && stmt.getDBPartitionOptions().getDbpartitions() != null && stmt.getDBPartitionOptions().getDbpartitions() != 1) {
            throw new IllegalArgumentException("Dbpartition without dbpartition key is not allowed");
        }
        DBPartitionBy DBPartitionBy2 = stmt.getDBPartitionOptions().getDbpartitionBy();
        TBPartitionBy TBPartitionBy2 = stmt.getDBPartitionOptions().getTbpartitionBy();
        if (DBPartitionBy2 == null && TBPartitionBy2 == null) {
            return;
        }
        if (!this.isAscii(stmt.getTable().getIdText())) {
            throw new IllegalArgumentException("partition CREATE DDL cannot take non-ASCII table name");
        }
        if (DBPartitionBy2 != null) {
            DBPartitionBy2.accept(this);
        }
        if (TBPartitionBy2 != null) {
            TBPartitionBy2.accept(this);
        }
    }

    @Override
    public void visit(DDLDropTableStatement node) {
        if (this.ruleTopology == null) {
            return;
        }
        for (Identifier identifier : node.getTableNames()) {
            String tableName = identifier.getIdTextUnescape();
            if (!this.ruleTopology.isRuleExist(tableName) || this.isAscii(tableName)) continue;
            throw new IllegalArgumentException("partition DROP DDL cannot take non-ASCII table name");
        }
    }

    @Override
    public void visit(DDLAlterTableStatement node) {
        if (this.ruleTopology == null) {
            return;
        }
        String tableName = node.getTable().getIdTextUnescape();
        if (!this.ruleTopology.isRuleExist(tableName)) {
            return;
        }
        List<String> shardColumns = this.ruleTopology.getShardColumns(tableName);
        if (shardColumns == null || shardColumns.isEmpty()) {
            return;
        }
        for (AlterSpecification alterSpecification : node.getAlters()) {
            if (!(alterSpecification instanceof ChangeColumn)) continue;
            ChangeColumn changeColumn = (ChangeColumn)alterSpecification;
            if (changeColumn.getNewName() == null || changeColumn.getOldName() == null) {
                throw new IllegalArgumentException("partition ALTER DDL cannot take null new and old column Name");
            }
            String columnNewName = changeColumn.getNewName().getIdText();
            String columnOldName = changeColumn.getOldName().getIdText();
            if (!this.containsIgnoreCase(shardColumns, columnOldName) || this.isAscii(columnNewName)) continue;
            throw new IllegalArgumentException("partition ALTER DDL cannot take non-ASCII CHANGE column name");
        }
    }

    private boolean containsIgnoreCase(List<String> names, String str) {
        for (String name : names) {
            if (!name.equalsIgnoreCase(str)) continue;
            return true;
        }
        return false;
    }

    private boolean isAscii(String str) {
        char[] chars = str.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            byte[] bytes = ("" + chars[i]).getBytes();
            if (bytes.length <= 1) continue;
            return false;
        }
        return true;
    }

    public static interface RuleTopology {
        public List<String> getShardColumns(String var1);

        public boolean isRuleExist(String var1);
    }
}

