/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.txc.parser.recognizer.mysql.syntax;

import com.alibaba.txc.parser.ast.expression.Expression;
import com.alibaba.txc.parser.ast.expression.primary.Identifier;
import com.alibaba.txc.parser.ast.expression.primary.SysVarPrimary;
import com.alibaba.txc.parser.ast.expression.primary.UsrDefVarPrimary;
import com.alibaba.txc.parser.ast.expression.primary.VariableExpression;
import com.alibaba.txc.parser.ast.expression.primary.literal.LiteralBoolean;
import com.alibaba.txc.parser.ast.expression.primary.literal.LiteralNumber;
import com.alibaba.txc.parser.ast.expression.primary.literal.LiteralString;
import com.alibaba.txc.parser.ast.fragment.Limit;
import com.alibaba.txc.parser.ast.fragment.LockReference;
import com.alibaba.txc.parser.ast.fragment.OrderBy;
import com.alibaba.txc.parser.ast.fragment.SortOrder;
import com.alibaba.txc.parser.ast.fragment.VariableScope;
import com.alibaba.txc.parser.ast.stmt.SQLStatement;
import com.alibaba.txc.parser.ast.stmt.dal.CheckTableStatement;
import com.alibaba.txc.parser.ast.stmt.dal.DALDeallocateStatement;
import com.alibaba.txc.parser.ast.stmt.dal.DALExecuteStatement;
import com.alibaba.txc.parser.ast.stmt.dal.DALPrepareStatement;
import com.alibaba.txc.parser.ast.stmt.dal.DALSetCharacterSetStatement;
import com.alibaba.txc.parser.ast.stmt.dal.DALSetSimpleStatement;
import com.alibaba.txc.parser.ast.stmt.dal.DALSetStatement;
import com.alibaba.txc.parser.ast.stmt.dal.DALShowStatement;
import com.alibaba.txc.parser.ast.stmt.dal.ShowAuthors;
import com.alibaba.txc.parser.ast.stmt.dal.ShowBinLogEvent;
import com.alibaba.txc.parser.ast.stmt.dal.ShowBinaryLog;
import com.alibaba.txc.parser.ast.stmt.dal.ShowBroadcasts;
import com.alibaba.txc.parser.ast.stmt.dal.ShowCharaterSet;
import com.alibaba.txc.parser.ast.stmt.dal.ShowCollation;
import com.alibaba.txc.parser.ast.stmt.dal.ShowColumns;
import com.alibaba.txc.parser.ast.stmt.dal.ShowContributors;
import com.alibaba.txc.parser.ast.stmt.dal.ShowCreate;
import com.alibaba.txc.parser.ast.stmt.dal.ShowDataSources;
import com.alibaba.txc.parser.ast.stmt.dal.ShowDatabases;
import com.alibaba.txc.parser.ast.stmt.dal.ShowDbLock;
import com.alibaba.txc.parser.ast.stmt.dal.ShowEngine;
import com.alibaba.txc.parser.ast.stmt.dal.ShowEngines;
import com.alibaba.txc.parser.ast.stmt.dal.ShowErrors;
import com.alibaba.txc.parser.ast.stmt.dal.ShowEvents;
import com.alibaba.txc.parser.ast.stmt.dal.ShowFunctionCode;
import com.alibaba.txc.parser.ast.stmt.dal.ShowFunctionStatus;
import com.alibaba.txc.parser.ast.stmt.dal.ShowGrants;
import com.alibaba.txc.parser.ast.stmt.dal.ShowIndex;
import com.alibaba.txc.parser.ast.stmt.dal.ShowMasterStatus;
import com.alibaba.txc.parser.ast.stmt.dal.ShowOpenTables;
import com.alibaba.txc.parser.ast.stmt.dal.ShowPartitions;
import com.alibaba.txc.parser.ast.stmt.dal.ShowPlugins;
import com.alibaba.txc.parser.ast.stmt.dal.ShowPrivileges;
import com.alibaba.txc.parser.ast.stmt.dal.ShowProcedureCode;
import com.alibaba.txc.parser.ast.stmt.dal.ShowProcedureStatus;
import com.alibaba.txc.parser.ast.stmt.dal.ShowProcesslist;
import com.alibaba.txc.parser.ast.stmt.dal.ShowProfile;
import com.alibaba.txc.parser.ast.stmt.dal.ShowProfiles;
import com.alibaba.txc.parser.ast.stmt.dal.ShowRule;
import com.alibaba.txc.parser.ast.stmt.dal.ShowSequences;
import com.alibaba.txc.parser.ast.stmt.dal.ShowSlaveHosts;
import com.alibaba.txc.parser.ast.stmt.dal.ShowSlaveStatus;
import com.alibaba.txc.parser.ast.stmt.dal.ShowSlow;
import com.alibaba.txc.parser.ast.stmt.dal.ShowStats;
import com.alibaba.txc.parser.ast.stmt.dal.ShowStatus;
import com.alibaba.txc.parser.ast.stmt.dal.ShowTableStatus;
import com.alibaba.txc.parser.ast.stmt.dal.ShowTables;
import com.alibaba.txc.parser.ast.stmt.dal.ShowTopology;
import com.alibaba.txc.parser.ast.stmt.dal.ShowTrace;
import com.alibaba.txc.parser.ast.stmt.dal.ShowTriggers;
import com.alibaba.txc.parser.ast.stmt.dal.ShowVariables;
import com.alibaba.txc.parser.ast.stmt.dal.ShowWarnings;
import com.alibaba.txc.parser.ast.stmt.ddl.DescTableStatement;
import com.alibaba.txc.parser.ast.stmt.ddl.LockTablesStatement;
import com.alibaba.txc.parser.ast.stmt.ddl.UnLockTablesStatement;
import com.alibaba.txc.parser.ast.stmt.mts.MTSSetTransactionStatement;
import com.alibaba.txc.parser.recognizer.mysql.MySQLToken;
import com.alibaba.txc.parser.recognizer.mysql.lexer.MySQLLexer;
import com.alibaba.txc.parser.recognizer.mysql.syntax.MySQLExprParser;
import com.alibaba.txc.parser.recognizer.mysql.syntax.MySQLParser;
import com.alibaba.txc.parser.util.Pair;
import java.sql.SQLSyntaxErrorException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class MySQLDALParser
extends MySQLParser {
    protected MySQLExprParser exprParser;
    private static final Map<String, SpecialIdentifier> specialIdentifiers = new HashMap<String, SpecialIdentifier>();

    public MySQLDALParser(MySQLLexer lexer, MySQLExprParser exprParser) {
        super(lexer);
        this.exprParser = exprParser;
    }

    public DescTableStatement desc() throws SQLSyntaxErrorException {
        this.match(MySQLToken.KW_DESC, MySQLToken.KW_DESCRIBE);
        Identifier table = this.identifier();
        return new DescTableStatement(table);
    }

    public LockTablesStatement lock() throws SQLSyntaxErrorException {
        this.match(MySQLToken.KW_LOCK);
        switch (this.lexer.token()) {
            case IDENTIFIER: {
                String tempStrUp = this.lexer.stringValueUppercase();
                SpecialIdentifier tempSi = specialIdentifiers.get(tempStrUp);
                if (tempSi == null) break;
                switch (tempSi) {
                    case TABLES: {
                        AbstractList locks;
                        this.lexer.nextToken();
                        LockReference lock = this.lockReference();
                        if (this.lexer.token() == MySQLToken.PUNC_COMMA) {
                            locks = new LinkedList<LockReference>();
                            locks.add(lock);
                            while (this.lexer.token() == MySQLToken.PUNC_COMMA) {
                                this.lexer.nextToken();
                                lock = this.lockReference();
                                locks.add(lock);
                            }
                        } else {
                            locks = new ArrayList(1);
                            locks.add(lock);
                        }
                        return new LockTablesStatement(locks);
                    }
                }
            }
        }
        throw this.err("unexpect token for LOCK");
    }

    private LockReference lockReference() throws SQLSyntaxErrorException {
        Identifier table = this.identifier();
        Identifier alias = null;
        switch (this.lexer.token()) {
            case KW_AS: {
                this.match(MySQLToken.KW_AS);
                alias = this.identifier();
                break;
            }
            case IDENTIFIER: {
                alias = this.identifier();
                break;
            }
        }
        switch (this.lexer.token()) {
            case KW_READ: {
                this.match(MySQLToken.KW_READ);
                switch (this.lexer.token()) {
                    case IDENTIFIER: {
                        String tempStrUp = this.lexer.stringValueUppercase();
                        SpecialIdentifier tempSi = specialIdentifiers.get(tempStrUp);
                        if (tempSi == null) break;
                        switch (tempSi) {
                            case LOCAL: {
                                this.lexer.nextToken();
                                return new LockReference(table, alias, LockTablesStatement.LockType.READ_LOCAL);
                            }
                        }
                    }
                }
                return new LockReference(table, alias, LockTablesStatement.LockType.READ);
            }
            case KW_WRITE: {
                this.match(MySQLToken.KW_WRITE);
                return new LockReference(table, alias, LockTablesStatement.LockType.WRITE);
            }
            case KW_LOW_PRIORITY: {
                this.match(MySQLToken.KW_LOW_PRIORITY);
                this.match(MySQLToken.KW_WRITE);
                return new LockReference(table, alias, LockTablesStatement.LockType.LOW_PRIORITY_WRITE);
            }
        }
        throw this.err("unexpect token for LOCK");
    }

    public UnLockTablesStatement unlock() throws SQLSyntaxErrorException {
        this.match(MySQLToken.KW_UNLOCK);
        switch (this.lexer.token()) {
            case IDENTIFIER: {
                String tempStrUp = this.lexer.stringValueUppercase();
                SpecialIdentifier tempSi = specialIdentifiers.get(tempStrUp);
                if (tempSi == null) break;
                switch (tempSi) {
                    case TABLES: {
                        this.lexer.nextToken();
                        return new UnLockTablesStatement();
                    }
                }
            }
        }
        throw this.err("unexpect token for UNLOCK");
    }

    public CheckTableStatement check() throws SQLSyntaxErrorException {
        this.match(MySQLToken.KW_CHECK);
        this.match(MySQLToken.KW_TABLE);
        ArrayList<Identifier> talbleNameList = new ArrayList<Identifier>();
        Identifier tempId = this.identifier();
        talbleNameList.add(tempId);
        if (this.lexer.token() == MySQLToken.PUNC_COMMA) {
            while (this.lexer.token() == MySQLToken.PUNC_COMMA) {
                this.lexer.nextToken();
                tempId = this.identifier();
                talbleNameList.add(tempId);
            }
        }
        return new CheckTableStatement(talbleNameList);
    }

    public DALShowStatement show() throws SQLSyntaxErrorException {
        this.match(MySQLToken.KW_SHOW);
        switch (this.lexer.token()) {
            case KW_BINARY: {
                this.lexer.nextToken();
                this.matchIdentifier("LOGS");
                return new ShowBinaryLog();
            }
            case KW_CHARACTER: {
                this.lexer.nextToken();
                this.match(MySQLToken.KW_SET);
                switch (this.lexer.token()) {
                    case KW_LIKE: {
                        String tempStr = this.like();
                        return new ShowCharaterSet(tempStr);
                    }
                    case KW_WHERE: {
                        Expression tempExpr = this.where();
                        return new ShowCharaterSet(tempExpr);
                    }
                }
                return new ShowCharaterSet();
            }
            case KW_CREATE: {
                ShowCreate.Type showCreateType;
                block16 : switch (this.lexer.nextToken()) {
                    case KW_DATABASE: {
                        showCreateType = ShowCreate.Type.DATABASE;
                        break;
                    }
                    case KW_PROCEDURE: {
                        showCreateType = ShowCreate.Type.PROCEDURE;
                        break;
                    }
                    case KW_TABLE: {
                        showCreateType = ShowCreate.Type.TABLE;
                        break;
                    }
                    case KW_TRIGGER: {
                        showCreateType = ShowCreate.Type.TRIGGER;
                        break;
                    }
                    case IDENTIFIER: {
                        SpecialIdentifier tempSi = specialIdentifiers.get(this.lexer.stringValueUppercase());
                        if (tempSi != null) {
                            switch (tempSi) {
                                case EVENT: {
                                    showCreateType = ShowCreate.Type.EVENT;
                                    break block16;
                                }
                                case FUNCTION: {
                                    showCreateType = ShowCreate.Type.FUNCTION;
                                    break block16;
                                }
                                case VIEW: {
                                    showCreateType = ShowCreate.Type.VIEW;
                                    break block16;
                                }
                            }
                        }
                    }
                    default: {
                        throw this.err("unexpect token for SHOW CREATE");
                    }
                }
                this.lexer.nextToken();
                Identifier tempId = this.identifier();
                return new ShowCreate(showCreateType, tempId);
            }
            case KW_SCHEMAS: 
            case KW_DATABASES: {
                this.lexer.nextToken();
                switch (this.lexer.token()) {
                    case KW_LIKE: {
                        String tempStr = this.like();
                        return new ShowDatabases(tempStr);
                    }
                    case KW_WHERE: {
                        Expression tempExpr = this.where();
                        return new ShowDatabases(tempExpr);
                    }
                }
                return new ShowDatabases();
            }
            case KW_KEYS: {
                return this.showIndex(ShowIndex.Type.KEYS);
            }
            case KW_INDEX: {
                return this.showIndex(ShowIndex.Type.INDEX);
            }
            case KW_PROCEDURE: {
                this.lexer.nextToken();
                String tempStrUp = this.lexer.stringValueUppercase();
                SpecialIdentifier tempSi = specialIdentifiers.get(tempStrUp);
                if (tempSi != null) {
                    switch (tempSi) {
                        case CODE: {
                            this.lexer.nextToken();
                            Identifier tempId = this.identifier();
                            return new ShowProcedureCode(tempId);
                        }
                        case STATUS: {
                            switch (this.lexer.nextToken()) {
                                case KW_LIKE: {
                                    String tempStr = this.like();
                                    return new ShowProcedureStatus(tempStr);
                                }
                                case KW_WHERE: {
                                    Expression tempExpr = this.where();
                                    return new ShowProcedureStatus(tempExpr);
                                }
                            }
                            return new ShowProcedureStatus();
                        }
                    }
                }
                throw this.err("unexpect token for SHOW PROCEDURE");
            }
            case KW_SLOW: {
                Expression tempExpr = null;
                Limit tempLimit = null;
                OrderBy tempOrderBy = null;
                this.lexer.nextToken();
                if (this.lexer.token() == MySQLToken.KW_WHERE) {
                    tempExpr = this.where();
                }
                if (this.lexer.token() == MySQLToken.KW_ORDER) {
                    tempOrderBy = this.orderBy();
                }
                if (this.lexer.token() == MySQLToken.KW_LIMIT) {
                    tempLimit = this.limit();
                }
                return new ShowSlow(false, false, tempExpr, tempOrderBy, tempLimit);
            }
            case KW_TABLE: {
                this.lexer.nextToken();
                this.matchIdentifier("STATUS");
                Identifier tempId = null;
                if (this.lexer.token() == MySQLToken.KW_FROM || this.lexer.token() == MySQLToken.KW_IN) {
                    this.lexer.nextToken();
                    tempId = this.identifier();
                }
                switch (this.lexer.token()) {
                    case KW_LIKE: {
                        String tempStr = this.like();
                        return new ShowTableStatus(tempId, tempStr);
                    }
                    case KW_WHERE: {
                        Expression tempExpr = this.where();
                        return new ShowTableStatus(tempId, tempExpr);
                    }
                }
                return new ShowTableStatus(tempId);
            }
            case IDENTIFIER: {
                String tempStrUp = this.lexer.stringValueUppercase();
                SpecialIdentifier tempSi = specialIdentifiers.get(tempStrUp);
                if (tempSi == null) break;
                switch (tempSi) {
                    case PHYSICAL_SLOW: {
                        Expression tempExpr = null;
                        Limit tempLimit = null;
                        OrderBy tempOrderBy = null;
                        this.lexer.nextToken();
                        if (this.lexer.token() == MySQLToken.KW_WHERE) {
                            tempExpr = this.where();
                        }
                        if (this.lexer.token() == MySQLToken.KW_ORDER) {
                            tempOrderBy = this.orderBy();
                        }
                        if (this.lexer.token() == MySQLToken.KW_LIMIT) {
                            tempLimit = this.limit();
                        }
                        return new ShowSlow(true, false, tempExpr, tempOrderBy, tempLimit);
                    }
                    case PARTITIONS: {
                        Identifier tempId = null;
                        switch (this.lexer.nextToken()) {
                            case KW_FROM: {
                                this.lexer.nextToken();
                                tempId = this.identifier();
                                break;
                            }
                            default: {
                                tempId = this.identifier();
                            }
                        }
                        return new ShowPartitions(tempId);
                    }
                    case TOPOLOGY: {
                        Identifier tempId = null;
                        switch (this.lexer.nextToken()) {
                            case KW_FROM: {
                                this.lexer.nextToken();
                                tempId = this.identifier();
                                break;
                            }
                            default: {
                                tempId = this.identifier();
                            }
                        }
                        return new ShowTopology(tempId);
                    }
                    case BROADCASTS: {
                        this.lexer.nextToken();
                        return new ShowBroadcasts();
                    }
                    case DBLOCK: {
                        this.lexer.nextToken();
                        return new ShowDbLock();
                    }
                    case DATASOURCES: {
                        this.lexer.nextToken();
                        return new ShowDataSources();
                    }
                    case TRACE: {
                        this.lexer.nextToken();
                        return new ShowTrace();
                    }
                    case SEQUENCES: {
                        this.lexer.nextToken();
                        return new ShowSequences();
                    }
                    case RULE: {
                        this.lexer.nextToken();
                        switch (this.lexer.token()) {
                            case KW_FROM: {
                                this.lexer.nextToken();
                                Identifier tempId = this.identifier();
                                return new ShowRule(false, tempId);
                            }
                        }
                        return new ShowRule(false, null);
                    }
                    case PARITIONS: {
                        Identifier tempId = null;
                        switch (this.lexer.nextToken()) {
                            case KW_FROM: {
                                this.lexer.nextToken();
                                tempId = this.identifier();
                                break;
                            }
                            default: {
                                tempId = this.identifier();
                            }
                        }
                        return new ShowPartitions(tempId);
                    }
                    case INDEXES: {
                        return this.showIndex(ShowIndex.Type.INDEXES);
                    }
                    case GRANTS: {
                        if (this.lexer.nextToken() == MySQLToken.KW_FOR) {
                            this.lexer.nextToken();
                            Expression tempExpr = this.exprParser.expression();
                            return new ShowGrants(tempExpr);
                        }
                        return new ShowGrants();
                    }
                    case AUTHORS: {
                        this.lexer.nextToken();
                        return new ShowAuthors();
                    }
                    case BINLOG: {
                        this.lexer.nextToken();
                        this.matchIdentifier("EVENTS");
                        String tempStr = null;
                        Expression tempExpr = null;
                        Limit tempLimit = null;
                        if (this.lexer.token() == MySQLToken.KW_IN) {
                            this.lexer.nextToken();
                            tempStr = this.lexer.stringValue();
                            this.lexer.nextToken();
                        }
                        if (this.lexer.token() == MySQLToken.KW_FROM) {
                            this.lexer.nextToken();
                            tempExpr = this.exprParser.expression();
                        }
                        if (this.lexer.token() == MySQLToken.KW_LIMIT) {
                            tempLimit = this.limit();
                        }
                        return new ShowBinLogEvent(tempStr, tempExpr, tempLimit);
                    }
                    case COLLATION: {
                        switch (this.lexer.nextToken()) {
                            case KW_LIKE: {
                                String tempStr = this.like();
                                return new ShowCollation(tempStr);
                            }
                            case KW_WHERE: {
                                Expression tempExpr = this.where();
                                return new ShowCollation(tempExpr);
                            }
                        }
                        return new ShowCollation();
                    }
                    case COLUMNS: 
                    case FIELDS: {
                        return this.showColumns(false);
                    }
                    case CONTRIBUTORS: {
                        this.lexer.nextToken();
                        return new ShowContributors();
                    }
                    case ENGINE: {
                        switch (this.lexer.nextToken()) {
                            case IDENTIFIER: {
                                tempStrUp = this.lexer.stringValueUppercase();
                                tempSi = specialIdentifiers.get(tempStrUp);
                                if (tempSi == null) break;
                                switch (tempSi) {
                                    case INNODB: {
                                        this.lexer.nextToken();
                                        tempStrUp = this.lexer.stringValueUppercase();
                                        tempSi = specialIdentifiers.get(tempStrUp);
                                        if (tempSi != null) {
                                            switch (tempSi) {
                                                case STATUS: {
                                                    this.lexer.nextToken();
                                                    return new ShowEngine(ShowEngine.Type.INNODB_STATUS);
                                                }
                                                case MUTEX: {
                                                    this.lexer.nextToken();
                                                    return new ShowEngine(ShowEngine.Type.INNODB_MUTEX);
                                                }
                                            }
                                        }
                                    }
                                    case PERFORMANCE_SCHEMA: {
                                        this.lexer.nextToken();
                                        this.matchIdentifier("STATUS");
                                        return new ShowEngine(ShowEngine.Type.PERFORMANCE_SCHEMA_STATUS);
                                    }
                                }
                            }
                        }
                        throw this.err("unexpect token for SHOW ENGINE");
                    }
                    case ENGINES: {
                        this.lexer.nextToken();
                        return new ShowEngines();
                    }
                    case ERRORS: {
                        this.lexer.nextToken();
                        Limit tempLimit = this.limit();
                        return new ShowErrors(false, tempLimit);
                    }
                    case COUNT: {
                        this.lexer.nextToken();
                        this.match(MySQLToken.PUNC_LEFT_PAREN);
                        this.match(MySQLToken.OP_ASTERISK);
                        this.match(MySQLToken.PUNC_RIGHT_PAREN);
                        switch (this.matchIdentifier("ERRORS", "WARNINGS")) {
                            case 0: {
                                return new ShowErrors(true, null);
                            }
                            case 1: {
                                return new ShowWarnings(true, null);
                            }
                        }
                    }
                    case EVENTS: {
                        Identifier tempId = null;
                        switch (this.lexer.nextToken()) {
                            case KW_FROM: 
                            case KW_IN: {
                                this.lexer.nextToken();
                                tempId = this.identifier();
                            }
                        }
                        switch (this.lexer.token()) {
                            case KW_LIKE: {
                                String tempStr = this.like();
                                return new ShowEvents(tempId, tempStr);
                            }
                            case KW_WHERE: {
                                Expression tempExpr = this.where();
                                return new ShowEvents(tempId, tempExpr);
                            }
                        }
                        return new ShowEvents(tempId);
                    }
                    case FULL: {
                        this.lexer.nextToken();
                        switch (this.lexer.token()) {
                            case IDENTIFIER: {
                                tempStrUp = this.lexer.stringValueUppercase();
                                tempSi = specialIdentifiers.get(tempStrUp);
                                if (tempSi != null) {
                                    switch (tempSi) {
                                        case COLUMNS: 
                                        case FIELDS: {
                                            return this.showColumns(true);
                                        }
                                        case STATS: {
                                            this.lexer.nextToken();
                                            return new ShowStats(true);
                                        }
                                        case RULE: {
                                            this.lexer.nextToken();
                                            switch (this.lexer.token()) {
                                                case KW_FROM: {
                                                    this.lexer.nextToken();
                                                    Identifier tempId = this.identifier();
                                                    return new ShowRule(true, tempId);
                                                }
                                            }
                                            return new ShowRule(true, null);
                                        }
                                        case PROCESSLIST: {
                                            this.lexer.nextToken();
                                            return new ShowProcesslist(true);
                                        }
                                        case TABLES: {
                                            Identifier tempId = null;
                                            switch (this.lexer.nextToken()) {
                                                case KW_FROM: 
                                                case KW_IN: {
                                                    this.lexer.nextToken();
                                                    tempId = this.identifier();
                                                }
                                            }
                                            switch (this.lexer.token()) {
                                                case KW_LIKE: {
                                                    String tempStr = this.like();
                                                    return new ShowTables(true, tempId, tempStr);
                                                }
                                                case KW_WHERE: {
                                                    Expression tempExpr = this.where();
                                                    return new ShowTables(true, tempId, tempExpr);
                                                }
                                            }
                                            return new ShowTables(true, tempId);
                                        }
                                        case PHYSICAL_SLOW: {
                                            Expression tempExpr = null;
                                            Limit tempLimit = null;
                                            OrderBy tempOrderBy = null;
                                            this.lexer.nextToken();
                                            if (this.lexer.token() == MySQLToken.KW_WHERE) {
                                                tempExpr = this.where();
                                            }
                                            if (this.lexer.token() == MySQLToken.KW_ORDER) {
                                                tempOrderBy = this.orderBy();
                                            }
                                            if (this.lexer.token() == MySQLToken.KW_LIMIT) {
                                                tempLimit = this.limit();
                                            }
                                            return new ShowSlow(true, true, tempExpr, tempOrderBy, tempLimit);
                                        }
                                        case TRIGGERS: {
                                            Identifier tempId = null;
                                            switch (this.lexer.nextToken()) {
                                                case KW_FROM: 
                                                case KW_IN: {
                                                    this.lexer.nextToken();
                                                    tempId = this.identifier();
                                                }
                                            }
                                            switch (this.lexer.token()) {
                                                case KW_LIKE: {
                                                    String tempStr = this.like();
                                                    return new ShowTriggers(true, tempId, tempStr);
                                                }
                                                case KW_WHERE: {
                                                    Expression tempExpr = this.where();
                                                    return new ShowTriggers(true, tempId, tempExpr);
                                                }
                                            }
                                            return new ShowTriggers(true, tempId);
                                        }
                                    }
                                }
                                throw this.err("unexpected token for SHOW FULL");
                            }
                            case KW_SLOW: {
                                Expression tempExpr = null;
                                Limit tempLimit = null;
                                OrderBy tempOrderBy = null;
                                this.lexer.nextToken();
                                if (this.lexer.token() == MySQLToken.KW_WHERE) {
                                    tempExpr = this.where();
                                }
                                if (this.lexer.token() == MySQLToken.KW_ORDER) {
                                    tempOrderBy = this.orderBy();
                                }
                                if (this.lexer.token() == MySQLToken.KW_LIMIT) {
                                    tempLimit = this.limit();
                                }
                                return new ShowSlow(false, true, tempExpr, tempOrderBy, tempLimit);
                            }
                        }
                        throw this.err("unexpected token for SHOW FULL");
                    }
                    case FUNCTION: {
                        this.lexer.nextToken();
                        tempStrUp = this.lexer.stringValueUppercase();
                        tempSi = specialIdentifiers.get(tempStrUp);
                        if (tempSi != null) {
                            switch (tempSi) {
                                case CODE: {
                                    this.lexer.nextToken();
                                    Identifier tempId = this.identifier();
                                    return new ShowFunctionCode(tempId);
                                }
                                case STATUS: {
                                    switch (this.lexer.nextToken()) {
                                        case KW_LIKE: {
                                            String tempStr = this.like();
                                            return new ShowFunctionStatus(tempStr);
                                        }
                                        case KW_WHERE: {
                                            Expression tempExpr = this.where();
                                            return new ShowFunctionStatus(tempExpr);
                                        }
                                    }
                                    return new ShowFunctionStatus();
                                }
                            }
                        }
                        throw this.err("unexpected token for SHOW FUNCTION");
                    }
                    case GLOBAL: {
                        this.lexer.nextToken();
                        tempStrUp = this.lexer.stringValueUppercase();
                        tempSi = specialIdentifiers.get(tempStrUp);
                        if (tempSi != null) {
                            switch (tempSi) {
                                case STATUS: {
                                    switch (this.lexer.nextToken()) {
                                        case KW_LIKE: {
                                            String tempStr = this.like();
                                            return new ShowStatus(VariableScope.GLOBAL, tempStr);
                                        }
                                        case KW_WHERE: {
                                            Expression tempExpr = this.where();
                                            return new ShowStatus(VariableScope.GLOBAL, tempExpr);
                                        }
                                    }
                                    return new ShowStatus(VariableScope.GLOBAL);
                                }
                                case VARIABLES: {
                                    switch (this.lexer.nextToken()) {
                                        case KW_LIKE: {
                                            String tempStr = this.like();
                                            return new ShowVariables(VariableScope.GLOBAL, tempStr);
                                        }
                                        case KW_WHERE: {
                                            Expression tempExpr = this.where();
                                            return new ShowVariables(VariableScope.GLOBAL, tempExpr);
                                        }
                                    }
                                    return new ShowVariables(VariableScope.GLOBAL);
                                }
                            }
                        }
                        throw this.err("unexpected token for SHOW GLOBAL");
                    }
                    case MASTER: {
                        this.lexer.nextToken();
                        tempStrUp = this.lexer.stringValueUppercase();
                        tempSi = specialIdentifiers.get(tempStrUp);
                        if (tempSi != null && tempSi == SpecialIdentifier.STATUS) {
                            this.lexer.nextToken();
                            return new ShowMasterStatus();
                        }
                        this.matchIdentifier("LOGS");
                        return new ShowBinaryLog();
                    }
                    case OPEN: {
                        this.lexer.nextToken();
                        this.matchIdentifier("TABLES");
                        Identifier tempId = null;
                        switch (this.lexer.token()) {
                            case KW_FROM: 
                            case KW_IN: {
                                this.lexer.nextToken();
                                tempId = this.identifier();
                            }
                        }
                        switch (this.lexer.token()) {
                            case KW_LIKE: {
                                String tempStr = this.like();
                                return new ShowOpenTables(tempId, tempStr);
                            }
                            case KW_WHERE: {
                                Expression tempExpr = this.where();
                                return new ShowOpenTables(tempId, tempExpr);
                            }
                        }
                        return new ShowOpenTables(tempId);
                    }
                    case PLUGINS: {
                        this.lexer.nextToken();
                        return new ShowPlugins();
                    }
                    case PRIVILEGES: {
                        this.lexer.nextToken();
                        return new ShowPrivileges();
                    }
                    case PROCESSLIST: {
                        this.lexer.nextToken();
                        return new ShowProcesslist(false);
                    }
                    case PROFILE: {
                        return this.showProfile();
                    }
                    case PROFILES: {
                        this.lexer.nextToken();
                        return new ShowProfiles();
                    }
                    case LOCAL: 
                    case SESSION: {
                        this.lexer.nextToken();
                        tempStrUp = this.lexer.stringValueUppercase();
                        tempSi = specialIdentifiers.get(tempStrUp);
                        if (tempSi != null) {
                            switch (tempSi) {
                                case STATUS: {
                                    switch (this.lexer.nextToken()) {
                                        case KW_LIKE: {
                                            String tempStr = this.like();
                                            return new ShowStatus(VariableScope.SESSION, tempStr);
                                        }
                                        case KW_WHERE: {
                                            Expression tempExpr = this.where();
                                            return new ShowStatus(VariableScope.SESSION, tempExpr);
                                        }
                                    }
                                    return new ShowStatus(VariableScope.SESSION);
                                }
                                case VARIABLES: {
                                    switch (this.lexer.nextToken()) {
                                        case KW_LIKE: {
                                            String tempStr = this.like();
                                            return new ShowVariables(VariableScope.SESSION, tempStr);
                                        }
                                        case KW_WHERE: {
                                            Expression tempExpr = this.where();
                                            return new ShowVariables(VariableScope.SESSION, tempExpr);
                                        }
                                    }
                                    return new ShowVariables(VariableScope.SESSION);
                                }
                            }
                        }
                        throw this.err("unexpected token for SHOW SESSION");
                    }
                    case SLAVE: {
                        this.lexer.nextToken();
                        tempStrUp = this.lexer.stringValueUppercase();
                        tempSi = specialIdentifiers.get(tempStrUp);
                        if (tempSi != null) {
                            switch (tempSi) {
                                case HOSTS: {
                                    this.lexer.nextToken();
                                    return new ShowSlaveHosts();
                                }
                                case STATUS: {
                                    this.lexer.nextToken();
                                    return new ShowSlaveStatus();
                                }
                            }
                        }
                        throw this.err("unexpected token for SHOW SLAVE");
                    }
                    case STATUS: {
                        switch (this.lexer.nextToken()) {
                            case KW_LIKE: {
                                String tempStr = this.like();
                                return new ShowStatus(VariableScope.SESSION, tempStr);
                            }
                            case KW_WHERE: {
                                Expression tempExpr = this.where();
                                return new ShowStatus(VariableScope.SESSION, tempExpr);
                            }
                        }
                        return new ShowStatus(VariableScope.SESSION);
                    }
                    case STATS: {
                        this.lexer.nextToken();
                        return new ShowStats(false);
                    }
                    case STORAGE: {
                        this.lexer.nextToken();
                        this.matchIdentifier("ENGINES");
                        return new ShowEngines();
                    }
                    case TABLES: {
                        Identifier tempId = null;
                        switch (this.lexer.nextToken()) {
                            case KW_FROM: 
                            case KW_IN: {
                                this.lexer.nextToken();
                                tempId = this.identifier();
                            }
                        }
                        switch (this.lexer.token()) {
                            case KW_LIKE: {
                                String tempStr = this.like();
                                return new ShowTables(false, tempId, tempStr);
                            }
                            case KW_WHERE: {
                                Expression tempExpr = this.where();
                                return new ShowTables(false, tempId, tempExpr);
                            }
                        }
                        return new ShowTables(false, tempId);
                    }
                    case TRIGGERS: {
                        Identifier tempId = null;
                        switch (this.lexer.nextToken()) {
                            case KW_FROM: 
                            case KW_IN: {
                                this.lexer.nextToken();
                                tempId = this.identifier();
                            }
                        }
                        switch (this.lexer.token()) {
                            case KW_LIKE: {
                                String tempStr = this.like();
                                return new ShowTriggers(false, tempId, tempStr);
                            }
                            case KW_WHERE: {
                                Expression tempExpr = this.where();
                                return new ShowTriggers(false, tempId, tempExpr);
                            }
                        }
                        return new ShowTriggers(false, tempId);
                    }
                    case VARIABLES: {
                        switch (this.lexer.nextToken()) {
                            case KW_LIKE: {
                                String tempStr = this.like();
                                return new ShowVariables(VariableScope.SESSION, tempStr);
                            }
                            case KW_WHERE: {
                                Expression tempExpr = this.where();
                                return new ShowVariables(VariableScope.SESSION, tempExpr);
                            }
                        }
                        return new ShowVariables(VariableScope.SESSION);
                    }
                    case WARNINGS: {
                        this.lexer.nextToken();
                        Limit tempLimit = this.limit();
                        return new ShowWarnings(false, tempLimit);
                    }
                    case CHARSET: {
                        this.lexer.nextToken();
                        return new ShowCharaterSet();
                    }
                }
                break;
            }
        }
        throw this.err("unexpect token for SHOW");
    }

    private ShowIndex showIndex(ShowIndex.Type type) throws SQLSyntaxErrorException {
        this.lexer.nextToken();
        this.match(MySQLToken.KW_FROM, MySQLToken.KW_IN);
        Identifier tempId = this.identifier();
        if (this.lexer.token() == MySQLToken.KW_FROM || this.lexer.token() == MySQLToken.KW_IN) {
            this.lexer.nextToken();
            Identifier tempId2 = this.identifier();
            return new ShowIndex(type, tempId, tempId2);
        }
        return new ShowIndex(type, tempId);
    }

    private ShowProfile showProfile() throws SQLSyntaxErrorException {
        this.lexer.nextToken();
        List<Object> types = new LinkedList();
        ShowProfile.Type type = this.showPrifileType();
        if (type == null) {
            types = Collections.emptyList();
        } else if (this.lexer.token() == MySQLToken.PUNC_COMMA) {
            types = new LinkedList();
            types.add((Object)type);
            while (this.lexer.token() == MySQLToken.PUNC_COMMA) {
                this.lexer.nextToken();
                type = this.showPrifileType();
                types.add((Object)type);
            }
        } else {
            types = new ArrayList();
            types.add((Object)type);
        }
        Expression forQuery = null;
        if (this.lexer.token() == MySQLToken.KW_FOR) {
            this.lexer.nextToken();
            this.matchIdentifier("QUERY");
            forQuery = this.exprParser.expression();
        }
        Limit limit = this.limit();
        return new ShowProfile(types, forQuery, limit);
    }

    private ShowProfile.Type showPrifileType() throws SQLSyntaxErrorException {
        switch (this.lexer.token()) {
            case KW_ALL: {
                this.lexer.nextToken();
                return ShowProfile.Type.ALL;
            }
            case IDENTIFIER: {
                String strUp = this.lexer.stringValueUppercase();
                SpecialIdentifier si = specialIdentifiers.get(strUp);
                if (si == null) break;
                switch (si) {
                    case BLOCK: {
                        this.lexer.nextToken();
                        this.matchIdentifier("IO");
                        return ShowProfile.Type.BLOCK_IO;
                    }
                    case CONTEXT: {
                        this.lexer.nextToken();
                        this.matchIdentifier("SWITCHES");
                        return ShowProfile.Type.CONTEXT_SWITCHES;
                    }
                    case CPU: {
                        this.lexer.nextToken();
                        return ShowProfile.Type.CPU;
                    }
                    case IPC: {
                        this.lexer.nextToken();
                        return ShowProfile.Type.IPC;
                    }
                    case MEMORY: {
                        this.lexer.nextToken();
                        return ShowProfile.Type.MEMORY;
                    }
                    case PAGE: {
                        this.lexer.nextToken();
                        this.matchIdentifier("FAULTS");
                        return ShowProfile.Type.PAGE_FAULTS;
                    }
                    case SOURCE: {
                        this.lexer.nextToken();
                        return ShowProfile.Type.SOURCE;
                    }
                    case SWAPS: {
                        this.lexer.nextToken();
                        return ShowProfile.Type.SWAPS;
                    }
                }
            }
        }
        return null;
    }

    private ShowColumns showColumns(boolean full) throws SQLSyntaxErrorException {
        this.lexer.nextToken();
        this.match(MySQLToken.KW_FROM, MySQLToken.KW_IN);
        Identifier table = this.identifier();
        Identifier database = null;
        switch (this.lexer.token()) {
            case KW_FROM: 
            case KW_IN: {
                this.lexer.nextToken();
                database = this.identifier();
            }
        }
        switch (this.lexer.token()) {
            case KW_LIKE: {
                String like = this.like();
                return new ShowColumns(full, table, database, like);
            }
            case KW_WHERE: {
                Expression where = this.where();
                return new ShowColumns(full, table, database, where);
            }
        }
        return new ShowColumns(full, table, database);
    }

    private String like() throws SQLSyntaxErrorException {
        this.match(MySQLToken.KW_LIKE);
        String pattern = this.lexer.stringValue();
        this.lexer.nextToken();
        return pattern;
    }

    private Expression where() throws SQLSyntaxErrorException {
        this.match(MySQLToken.KW_WHERE);
        Expression where = this.exprParser.expression();
        return where;
    }

    private String getStringValue() throws SQLSyntaxErrorException {
        switch (this.lexer.token()) {
            case IDENTIFIER: {
                String name = Identifier.unescapeName(this.lexer.stringValue());
                this.lexer.nextToken();
                return name;
            }
            case LITERAL_CHARS: {
                String name = this.lexer.stringValue();
                name = LiteralString.getUnescapedString(name.substring(1, name.length() - 1));
                this.lexer.nextToken();
                return name;
            }
        }
        throw this.err("unexpected token: " + (Object)((Object)this.lexer.token()));
    }

    public SQLStatement set() throws SQLSyntaxErrorException {
        Pair pair;
        this.match(MySQLToken.KW_SET);
        if (this.lexer.token() == MySQLToken.KW_OPTION) {
            this.lexer.nextToken();
        }
        AbstractList assignmentList = new ArrayList();
        if (this.lexer.token() == MySQLToken.KW_CHARACTER) {
            this.lexer.nextToken();
            this.match(MySQLToken.KW_SET);
            if (this.lexer.token() == MySQLToken.KW_DEFAULT) {
                this.lexer.nextToken();
                return new DALSetCharacterSetStatement();
            }
            String charsetName = this.getStringValue();
            return new DALSetCharacterSetStatement(charsetName);
        }
        Object obj = this.varAssign();
        if (obj instanceof MTSSetTransactionStatement) {
            return (MTSSetTransactionStatement)obj;
        }
        assignmentList = new LinkedList();
        if (obj instanceof Pair) {
            pair = (Pair)obj;
            assignmentList.add(pair);
        } else {
            assignmentList.addAll((List)obj);
        }
        while (this.lexer.token() == MySQLToken.PUNC_COMMA) {
            this.lexer.nextToken();
            obj = this.varAssign();
            if (obj instanceof Pair) {
                pair = (Pair)obj;
                assignmentList.add(pair);
                continue;
            }
            assignmentList.addAll((List)obj);
        }
        return new DALSetStatement(assignmentList);
    }

    private Object setMTSSetTransactionStatement(VariableScope scope) throws SQLSyntaxErrorException {
        this.lexer.nextToken();
        SpecialIdentifier si = null;
        switch (this.lexer.token()) {
            case KW_READ: {
                SysVarPrimary read = new SysVarPrimary(VariableScope.SESSION, this.lexer.stringValue(), StringUtils.upperCase((String)this.lexer.stringValue()));
                this.lexer.nextToken();
                switch (this.lexer.token()) {
                    case KW_WRITE: {
                        LiteralString write = new LiteralString(null, this.lexer.stringValue(), false);
                        this.lexer.nextToken();
                        return new Pair<SysVarPrimary, LiteralString>(read, write);
                    }
                    case IDENTIFIER: {
                        si = specialIdentifiers.get(this.lexer.stringValueUppercase());
                        switch (si) {
                            case ONLY: {
                                LiteralString only = new LiteralString(null, this.lexer.stringValue(), false);
                                this.lexer.nextToken();
                                return new Pair<SysVarPrimary, LiteralString>(read, only);
                            }
                        }
                    }
                    case EOF: {
                        break;
                    }
                    case KW_ACCESSIBLE: {
                        break;
                    }
                    case KW_ADD: {
                        break;
                    }
                    case KW_ALL: {
                        break;
                    }
                    case KW_ALTER: {
                        break;
                    }
                    case KW_ANALYZE: {
                        break;
                    }
                    case KW_AND: {
                        break;
                    }
                    case KW_AS: {
                        break;
                    }
                    case KW_ASC: {
                        break;
                    }
                    case KW_ASENSITIVE: {
                        break;
                    }
                    case KW_BEFORE: {
                        break;
                    }
                    case KW_BETWEEN: {
                        break;
                    }
                    case KW_BIGINT: {
                        break;
                    }
                    case KW_BINARY: {
                        break;
                    }
                    case KW_BLOB: {
                        break;
                    }
                    case KW_BOTH: {
                        break;
                    }
                    case KW_BY: {
                        break;
                    }
                    case KW_CALL: {
                        break;
                    }
                    case KW_CASCADE: {
                        break;
                    }
                    case KW_CASE: {
                        break;
                    }
                    case KW_CHANGE: {
                        break;
                    }
                    case KW_CHAR: {
                        break;
                    }
                    case KW_CHARACTER: {
                        break;
                    }
                    case KW_CHECK: {
                        break;
                    }
                    case KW_COLLATE: {
                        break;
                    }
                    case KW_COLUMN: {
                        break;
                    }
                    case KW_CONDITION: {
                        break;
                    }
                    case KW_CONSTRAINT: {
                        break;
                    }
                    case KW_CONTINUE: {
                        break;
                    }
                    case KW_CONVERT: {
                        break;
                    }
                    case KW_CREATE: {
                        break;
                    }
                    case KW_CROSS: {
                        break;
                    }
                    case KW_CURRENT_DATE: {
                        break;
                    }
                    case KW_CURRENT_TIME: {
                        break;
                    }
                    case KW_CURRENT_TIMESTAMP: {
                        break;
                    }
                    case KW_CURRENT_USER: {
                        break;
                    }
                    case KW_CURSOR: {
                        break;
                    }
                    case KW_DATABASE: {
                        break;
                    }
                    case KW_DATABASES: {
                        break;
                    }
                    case KW_DAY_HOUR: {
                        break;
                    }
                    case KW_DAY_MICROSECOND: {
                        break;
                    }
                    case KW_DAY_MINUTE: {
                        break;
                    }
                    case KW_DAY_SECOND: {
                        break;
                    }
                    case KW_DEC: {
                        break;
                    }
                    case KW_DECIMAL: {
                        break;
                    }
                    case KW_DECLARE: {
                        break;
                    }
                    case KW_DEFAULT: {
                        break;
                    }
                    case KW_DELAYED: {
                        break;
                    }
                    case KW_DELETE: {
                        break;
                    }
                    case KW_DESC: {
                        break;
                    }
                    case KW_DESCRIBE: {
                        break;
                    }
                    case KW_DETERMINISTIC: {
                        break;
                    }
                    case KW_DISTINCT: {
                        break;
                    }
                    case KW_DISTINCTROW: {
                        break;
                    }
                    case KW_DIV: {
                        break;
                    }
                    case KW_DOUBLE: {
                        break;
                    }
                    case KW_DROP: {
                        break;
                    }
                    case KW_DUAL: {
                        break;
                    }
                    case KW_EACH: {
                        break;
                    }
                    case KW_ELSE: {
                        break;
                    }
                    case KW_ELSEIF: {
                        break;
                    }
                    case KW_ENCLOSED: {
                        break;
                    }
                    case KW_ESCAPED: {
                        break;
                    }
                    case KW_EXISTS: {
                        break;
                    }
                    case KW_EXIT: {
                        break;
                    }
                    case KW_EXPLAIN: {
                        break;
                    }
                    case KW_FETCH: {
                        break;
                    }
                    case KW_FLOAT: {
                        break;
                    }
                    case KW_FLOAT4: {
                        break;
                    }
                    case KW_FLOAT8: {
                        break;
                    }
                    case KW_FOR: {
                        break;
                    }
                    case KW_FORCE: {
                        break;
                    }
                    case KW_FOREIGN: {
                        break;
                    }
                    case KW_FROM: {
                        break;
                    }
                    case KW_FULLTEXT: {
                        break;
                    }
                    case KW_GENERAL: {
                        break;
                    }
                    case KW_GET: {
                        break;
                    }
                    case KW_GRANT: {
                        break;
                    }
                    case KW_GROUP: {
                        break;
                    }
                    case KW_HAVING: {
                        break;
                    }
                    case KW_HIGH_PRIORITY: {
                        break;
                    }
                    case KW_HOUR_MICROSECOND: {
                        break;
                    }
                    case KW_HOUR_MINUTE: {
                        break;
                    }
                    case KW_HOUR_SECOND: {
                        break;
                    }
                    case KW_IF: {
                        break;
                    }
                    case KW_IGNORE: {
                        break;
                    }
                    case KW_IGNORE_SERVER_IDS: {
                        break;
                    }
                    case KW_IN: {
                        break;
                    }
                    case KW_INDEX: {
                        break;
                    }
                    case KW_INFILE: {
                        break;
                    }
                    case KW_INNER: {
                        break;
                    }
                    case KW_INOUT: {
                        break;
                    }
                    case KW_INSENSITIVE: {
                        break;
                    }
                    case KW_INSERT: {
                        break;
                    }
                    case KW_INT: {
                        break;
                    }
                    case KW_INT1: {
                        break;
                    }
                    case KW_INT2: {
                        break;
                    }
                    case KW_INT3: {
                        break;
                    }
                    case KW_INT4: {
                        break;
                    }
                    case KW_INT8: {
                        break;
                    }
                    case KW_INTEGER: {
                        break;
                    }
                    case KW_INTERVAL: {
                        break;
                    }
                    case KW_INTO: {
                        break;
                    }
                    case KW_IS: {
                        break;
                    }
                    case KW_ITERATE: {
                        break;
                    }
                    case KW_JOIN: {
                        break;
                    }
                    case KW_KEY: {
                        break;
                    }
                    case KW_KEYS: {
                        break;
                    }
                    case KW_KILL: {
                        break;
                    }
                    case KW_LEADING: {
                        break;
                    }
                    case KW_LEAVE: {
                        break;
                    }
                    case KW_LEFT: {
                        break;
                    }
                    case KW_LIKE: {
                        break;
                    }
                    case KW_LIMIT: {
                        break;
                    }
                    case KW_LINEAR: {
                        break;
                    }
                    case KW_LINES: {
                        break;
                    }
                    case KW_LOAD: {
                        break;
                    }
                    case KW_LOCALTIME: {
                        break;
                    }
                    case KW_LOCALTIMESTAMP: {
                        break;
                    }
                    case KW_LOCK: {
                        break;
                    }
                    case KW_LONG: {
                        break;
                    }
                    case KW_LONGBLOB: {
                        break;
                    }
                    case KW_LONGTEXT: {
                        break;
                    }
                    case KW_LOOP: {
                        break;
                    }
                    case KW_LOW_PRIORITY: {
                        break;
                    }
                    case KW_MASTER_HEARTBEAT_PERIOD: {
                        break;
                    }
                    case KW_MASTER_SSL_VERIFY_SERVER_CERT: {
                        break;
                    }
                    case KW_MATCH: {
                        break;
                    }
                    case KW_MAXVALUE: {
                        break;
                    }
                    case KW_MEDIUMBLOB: {
                        break;
                    }
                    case KW_MEDIUMINT: {
                        break;
                    }
                    case KW_MEDIUMTEXT: {
                        break;
                    }
                    case KW_MIDDLEINT: {
                        break;
                    }
                    case KW_MINUTE_MICROSECOND: {
                        break;
                    }
                    case KW_MINUTE_SECOND: {
                        break;
                    }
                    case KW_MOD: {
                        break;
                    }
                    case KW_MODIFIES: {
                        break;
                    }
                    case KW_NATURAL: {
                        break;
                    }
                    case KW_NCHAR: {
                        break;
                    }
                    case KW_NOT: {
                        break;
                    }
                    case KW_NO_WRITE_TO_BINLOG: {
                        break;
                    }
                    case KW_NULL: {
                        break;
                    }
                    case KW_NUMERIC: {
                        break;
                    }
                    case KW_NVARCHAR: {
                        break;
                    }
                    case KW_ON: {
                        break;
                    }
                    case KW_OPTIMIZE: {
                        break;
                    }
                    case KW_OPTION: {
                        break;
                    }
                    case KW_OPTIONALLY: {
                        break;
                    }
                    case KW_OR: {
                        break;
                    }
                    case KW_ORDER: {
                        break;
                    }
                    case KW_OUT: {
                        break;
                    }
                    case KW_OUTER: {
                        break;
                    }
                    case KW_OUTFILE: {
                        break;
                    }
                    case KW_PRECISION: {
                        break;
                    }
                    case KW_PRIMARY: {
                        break;
                    }
                    case KW_PROCEDURE: {
                        break;
                    }
                    case KW_PURGE: {
                        break;
                    }
                    case KW_RANGE: {
                        break;
                    }
                    case KW_READ: {
                        break;
                    }
                    case KW_READS: {
                        break;
                    }
                    case KW_READ_WRITE: {
                        break;
                    }
                    case KW_REAL: {
                        break;
                    }
                    case KW_REFERENCES: {
                        break;
                    }
                    case KW_REGEXP: {
                        break;
                    }
                    case KW_RELEASE: {
                        break;
                    }
                    case KW_RENAME: {
                        break;
                    }
                    case KW_REPEAT: {
                        break;
                    }
                    case KW_REPLACE: {
                        break;
                    }
                    case KW_REQUIRE: {
                        break;
                    }
                    case KW_RESIGNAL: {
                        break;
                    }
                    case KW_RESTRICT: {
                        break;
                    }
                    case KW_RETURN: {
                        break;
                    }
                    case KW_REVOKE: {
                        break;
                    }
                    case KW_RIGHT: {
                        break;
                    }
                    case KW_RLIKE: {
                        break;
                    }
                    case KW_SCHEMA: {
                        break;
                    }
                    case KW_SCHEMAS: {
                        break;
                    }
                    case KW_SECOND_MICROSECOND: {
                        break;
                    }
                    case KW_SELECT: {
                        break;
                    }
                    case KW_SENSITIVE: {
                        break;
                    }
                    case KW_SEPARATOR: {
                        break;
                    }
                    case KW_SET: {
                        break;
                    }
                    case KW_SHOW: {
                        break;
                    }
                    case KW_SIGNAL: {
                        break;
                    }
                    case KW_SLOW: {
                        break;
                    }
                    case KW_SMALLINT: {
                        break;
                    }
                    case KW_SPATIAL: {
                        break;
                    }
                    case KW_SPECIFIC: {
                        break;
                    }
                    case KW_SQL: {
                        break;
                    }
                    case KW_SQLEXCEPTION: {
                        break;
                    }
                    case KW_SQLSTATE: {
                        break;
                    }
                    case KW_SQLWARNING: {
                        break;
                    }
                    case KW_SQL_BIG_RESULT: {
                        break;
                    }
                    case KW_SQL_CALC_FOUND_ROWS: {
                        break;
                    }
                    case KW_SQL_SMALL_RESULT: {
                        break;
                    }
                    case KW_SSL: {
                        break;
                    }
                    case KW_STARTING: {
                        break;
                    }
                    case KW_STRAIGHT_JOIN: {
                        break;
                    }
                    case KW_TABLE: {
                        break;
                    }
                    case KW_TERMINATED: {
                        break;
                    }
                    case KW_THEN: {
                        break;
                    }
                    case KW_TINYBLOB: {
                        break;
                    }
                    case KW_TINYINT: {
                        break;
                    }
                    case KW_TINYTEXT: {
                        break;
                    }
                    case KW_TO: {
                        break;
                    }
                    case KW_TRAILING: {
                        break;
                    }
                    case KW_TRIGGER: {
                        break;
                    }
                    case KW_UNDO: {
                        break;
                    }
                    case KW_UNION: {
                        break;
                    }
                    case KW_UNIQUE: {
                        break;
                    }
                    case KW_UNLOCK: {
                        break;
                    }
                    case KW_UNSIGNED: {
                        break;
                    }
                    case KW_UPDATE: {
                        break;
                    }
                    case KW_USAGE: {
                        break;
                    }
                    case KW_USE: {
                        break;
                    }
                    case KW_USING: {
                        break;
                    }
                    case KW_UTC_DATE: {
                        break;
                    }
                    case KW_UTC_TIME: {
                        break;
                    }
                    case KW_UTC_TIMESTAMP: {
                        break;
                    }
                    case KW_VALUES: {
                        break;
                    }
                    case KW_VARBINARY: {
                        break;
                    }
                    case KW_VARCHAR: {
                        break;
                    }
                    case KW_VARCHARACTER: {
                        break;
                    }
                    case KW_VARYING: {
                        break;
                    }
                    case KW_WHEN: {
                        break;
                    }
                    case KW_WHERE: {
                        break;
                    }
                    case KW_WHILE: {
                        break;
                    }
                    case KW_WITH: {
                        break;
                    }
                    case KW_XOR: {
                        break;
                    }
                    case KW_YEAR_MONTH: {
                        break;
                    }
                    case KW_ZEROFILL: {
                        break;
                    }
                    case LITERAL_BIT: {
                        break;
                    }
                    case LITERAL_BOOL_FALSE: {
                        break;
                    }
                    case LITERAL_BOOL_TRUE: {
                        break;
                    }
                    case LITERAL_CHARS: {
                        break;
                    }
                    case LITERAL_HEX: {
                        break;
                    }
                    case LITERAL_NCHARS: {
                        break;
                    }
                    case LITERAL_NULL: {
                        break;
                    }
                    case LITERAL_NUM_MIX_DIGIT: {
                        break;
                    }
                    case LITERAL_NUM_PURE_DIGIT: {
                        break;
                    }
                    case OP_AMPERSAND: {
                        break;
                    }
                    case OP_ASSIGN: {
                        break;
                    }
                    case OP_ASTERISK: {
                        break;
                    }
                    case OP_CARET: {
                        break;
                    }
                    case OP_EQUALS: {
                        break;
                    }
                    case OP_EXCLAMATION: {
                        break;
                    }
                    case OP_GREATER_OR_EQUALS: {
                        break;
                    }
                    case OP_GREATER_THAN: {
                        break;
                    }
                    case OP_LEFT_SHIFT: {
                        break;
                    }
                    case OP_LESS_OR_EQUALS: {
                        break;
                    }
                    case OP_LESS_OR_GREATER: {
                        break;
                    }
                    case OP_LESS_THAN: {
                        break;
                    }
                    case OP_LOGICAL_AND: {
                        break;
                    }
                    case OP_LOGICAL_OR: {
                        break;
                    }
                    case OP_MINUS: {
                        break;
                    }
                    case OP_NOT_EQUALS: {
                        break;
                    }
                    case OP_NULL_SAFE_EQUALS: {
                        break;
                    }
                    case OP_PERCENT: {
                        break;
                    }
                    case OP_PLUS: {
                        break;
                    }
                    case OP_RIGHT_SHIFT: {
                        break;
                    }
                    case OP_SLASH: {
                        break;
                    }
                    case OP_TILDE: {
                        break;
                    }
                    case OP_VERTICAL_BAR: {
                        break;
                    }
                    case PLACE_HOLDER: {
                        break;
                    }
                    case PUNC_COLON: {
                        break;
                    }
                    case PUNC_COMMA: {
                        break;
                    }
                    case PUNC_C_STYLE_COMMENT_END: {
                        break;
                    }
                    case PUNC_DOT: {
                        break;
                    }
                    case PUNC_LEFT_BRACE: {
                        break;
                    }
                    case PUNC_LEFT_BRACKET: {
                        break;
                    }
                    case PUNC_LEFT_PAREN: {
                        break;
                    }
                    case PUNC_RIGHT_BRACE: {
                        break;
                    }
                    case PUNC_RIGHT_BRACKET: {
                        break;
                    }
                    case PUNC_RIGHT_PAREN: {
                        break;
                    }
                    case PUNC_SEMICOLON: {
                        break;
                    }
                    case QUESTION_MARK: {
                        break;
                    }
                    case SYS_VAR: {
                        break;
                    }
                    case USR_VAR: {
                        break;
                    }
                }
                throw this.err("unexpected token for SET TRANSACTION statement");
            }
            case IDENTIFIER: {
                si = specialIdentifiers.get(this.lexer.stringValueUppercase());
                this.lexer.nextToken();
                switch (si) {
                    case ISOLATION: {
                        this.matchIdentifier("LEVEL");
                        switch (this.lexer.token()) {
                            case KW_READ: {
                                this.lexer.nextToken();
                                si = specialIdentifiers.get(this.lexer.stringValueUppercase());
                                if (si != null) {
                                    switch (si) {
                                        case COMMITTED: {
                                            this.lexer.nextToken();
                                            return new MTSSetTransactionStatement(scope, MTSSetTransactionStatement.IsolationLevel.READ_COMMITTED);
                                        }
                                        case UNCOMMITTED: {
                                            this.lexer.nextToken();
                                            return new MTSSetTransactionStatement(scope, MTSSetTransactionStatement.IsolationLevel.READ_UNCOMMITTED);
                                        }
                                    }
                                }
                                throw this.err("unknown isolation read level: " + this.lexer.stringValue());
                            }
                            case IDENTIFIER: {
                                si = specialIdentifiers.get(this.lexer.stringValueUppercase());
                                if (si == null) break;
                                switch (si) {
                                    case REPEATABLE: {
                                        this.lexer.nextToken();
                                        this.match(MySQLToken.KW_READ);
                                        return new MTSSetTransactionStatement(scope, MTSSetTransactionStatement.IsolationLevel.REPEATABLE_READ);
                                    }
                                    case SERIALIZABLE: {
                                        this.lexer.nextToken();
                                        return new MTSSetTransactionStatement(scope, MTSSetTransactionStatement.IsolationLevel.SERIALIZABLE);
                                    }
                                }
                            }
                        }
                        throw this.err("unknown isolation level: " + this.lexer.stringValue());
                    }
                    case POLICY: {
                        SysVarPrimary transactionPolicy = new SysVarPrimary(VariableScope.SESSION, "transaction policy", "TRANSACTION POLICY");
                        LiteralNumber policy = new LiteralNumber(this.lexer.integerValue());
                        this.lexer.nextToken();
                        return new Pair<SysVarPrimary, LiteralNumber>(transactionPolicy, policy);
                    }
                }
                throw this.err("unexpected token for SET TRANSACTION statement");
            }
        }
        throw this.err("unexpected token for SET TRANSACTION statement");
    }

    private Object varAssign() throws SQLSyntaxErrorException {
        Expression expr;
        VariableExpression var;
        VariableScope scope = VariableScope.SESSION;
        switch (this.lexer.token()) {
            case IDENTIFIER: {
                boolean explictScope = false;
                SpecialIdentifier si = specialIdentifiers.get(this.lexer.stringValueUppercase());
                if (si != null) {
                    switch (si) {
                        case NAMES: {
                            ArrayList<Pair<SysVarPrimary, LiteralString>> assignmentList = new ArrayList<Pair<SysVarPrimary, LiteralString>>();
                            String charsetName = null;
                            String collationName = null;
                            this.lexer.nextToken();
                            if (this.lexer.token() == MySQLToken.KW_DEFAULT) {
                                this.lexer.nextToken();
                                charsetName = "default";
                            } else if (this.lexer.token() == MySQLToken.KW_BINARY) {
                                this.lexer.nextToken();
                                charsetName = "binary";
                            } else {
                                charsetName = this.getStringValue();
                                collationName = null;
                                if (this.lexer.token() == MySQLToken.KW_COLLATE) {
                                    this.lexer.nextToken();
                                    collationName = this.getStringValue();
                                }
                            }
                            SysVarPrimary charset = new SysVarPrimary(VariableScope.SESSION, "names", "NAMES");
                            LiteralString charsetValue = new LiteralString(null, charsetName, false);
                            assignmentList.add(new Pair<SysVarPrimary, LiteralString>(charset, charsetValue));
                            if (collationName != null) {
                                SysVarPrimary collate = new SysVarPrimary(VariableScope.SESSION, "collate", "COLLATE");
                                LiteralString collateValue = new LiteralString(null, collationName, false);
                                assignmentList.add(new Pair<SysVarPrimary, LiteralString>(collate, collateValue));
                            }
                            return assignmentList;
                        }
                        case TRANSACTION: {
                            return this.setMTSSetTransactionStatement(null);
                        }
                        case GLOBAL: {
                            scope = VariableScope.GLOBAL;
                        }
                        case LOCAL: 
                        case SESSION: {
                            explictScope = true;
                            this.lexer.nextToken();
                        }
                    }
                }
                if (explictScope && specialIdentifiers.get(this.lexer.stringValueUppercase()) == SpecialIdentifier.TRANSACTION) {
                    return this.setMTSSetTransactionStatement(scope);
                }
                Identifier key = this.identifier();
                var = new SysVarPrimary(scope, key.getIdTextUnescape(), key.getIdTextUpUnescape());
                break;
            }
            case SYS_VAR: {
                var = this.systemVariale();
                break;
            }
            case USR_VAR: {
                var = new UsrDefVarPrimary(this.lexer.stringValue());
                this.lexer.nextToken();
                break;
            }
            default: {
                throw this.err("unexpected token for SET statement");
            }
        }
        this.match(MySQLToken.OP_EQUALS, MySQLToken.OP_ASSIGN);
        block11 : switch (this.lexer.token()) {
            case KW_BINARY: {
                expr = new LiteralString(null, "binary", false);
                this.lexer.nextToken();
                break;
            }
            case KW_ON: {
                expr = new LiteralBoolean(true);
                this.lexer.nextToken();
                break;
            }
            default: {
                SpecialIdentifier si;
                expr = this.exprParser.expression();
                if (!(expr instanceof Identifier) || (si = specialIdentifiers.get(((Identifier)expr).getIdTextUpUnescape())) == null) break;
                switch (si) {
                    case OFF: {
                        expr = new LiteralBoolean(false);
                        break block11;
                    }
                }
            }
        }
        return new Pair<SysVarPrimary, Expression>((SysVarPrimary)var, expr);
    }

    public SQLStatement prepare() throws SQLSyntaxErrorException {
        SpecialIdentifier tempSi = specialIdentifiers.get(this.lexer.stringValueUppercase());
        if (tempSi != SpecialIdentifier.PREPARE) {
            this.err("expect 'PREPARE'");
        }
        this.lexer.nextToken();
        if (this.lexer.token() != MySQLToken.IDENTIFIER) {
            return new DALPrepareStatement(null);
        }
        DALPrepareStatement stmt = new DALPrepareStatement(this.lexer.stringValue());
        this.lexer.nextToken();
        if (this.lexer.token() != MySQLToken.KW_FROM) {
            return new DALPrepareStatement(null);
        }
        this.lexer.nextToken();
        if (this.lexer.token() == MySQLToken.LITERAL_CHARS) {
            stmt.setStmt_define(this.lexer.stringValue());
            stmt.setStmt_token(this.lexer.token());
        } else if (this.lexer.token() == MySQLToken.USR_VAR) {
            stmt.setStmt_define(this.lexer.stringValue());
            stmt.setStmt_token(this.lexer.token());
        }
        return stmt;
    }

    public SQLStatement execute() throws SQLSyntaxErrorException {
        SpecialIdentifier tempSi = specialIdentifiers.get(this.lexer.stringValueUppercase());
        if (tempSi != SpecialIdentifier.EXECUTE) {
            this.err("expect 'EXECUTE'");
        }
        this.lexer.nextToken();
        if (this.lexer.token() != MySQLToken.IDENTIFIER) {
            return new DALExecuteStatement(null);
        }
        DALExecuteStatement stmt = new DALExecuteStatement(this.lexer.stringValue());
        this.lexer.nextToken();
        if (this.lexer.token() != MySQLToken.KW_USING) {
            return stmt;
        }
        this.lexer.nextToken();
        String param = this.readParam();
        if (this.lexer.token() != MySQLToken.PUNC_COMMA) {
            stmt.setParams(new ArrayList<String>(1));
            stmt.getParams().add(param);
            return stmt;
        }
        stmt.setParams(new ArrayList<String>());
        stmt.getParams().add(param);
        while (this.lexer.token() == MySQLToken.PUNC_COMMA) {
            this.lexer.nextToken();
            param = this.readParam();
            if (param == null) continue;
            stmt.getParams().add(param);
        }
        return stmt;
    }

    public SQLStatement deallocate() throws SQLSyntaxErrorException {
        SpecialIdentifier tempSi = specialIdentifiers.get(this.lexer.stringValueUppercase());
        if (tempSi != SpecialIdentifier.DEALLOCATE) {
            this.err("expect 'DEALLOCATE'");
        }
        this.lexer.nextToken();
        if (this.lexer.token() != MySQLToken.IDENTIFIER) {
            return new DALDeallocateStatement(null);
        }
        return new DALDeallocateStatement(this.lexer.stringValue());
    }

    private String readParam() throws SQLSyntaxErrorException {
        String param = this.lexer.stringValue();
        this.lexer.nextToken();
        return param;
    }

    public SQLStatement setSimple() throws SQLSyntaxErrorException {
        this.match(MySQLToken.KW_SET);
        if (this.lexer.token() == MySQLToken.KW_OPTION) {
            return new DALSetSimpleStatement(null);
        }
        if (this.lexer.token() == MySQLToken.IDENTIFIER && SpecialIdentifier.NAMES == specialIdentifiers.get(this.lexer.stringValueUppercase())) {
            return new DALSetSimpleStatement(null);
        }
        if (this.lexer.token() == MySQLToken.KW_CHARACTER) {
            return new DALSetSimpleStatement(null);
        }
        Pair<String, String> obj = this.varAssignSimple();
        if (obj == null) {
            return new DALSetSimpleStatement(null);
        }
        if (this.lexer.token() != MySQLToken.PUNC_COMMA) {
            ArrayList<Pair<String, String>> vals = new ArrayList<Pair<String, String>>(1);
            vals.add(obj);
            return new DALSetSimpleStatement(vals);
        }
        ArrayList<Pair<String, String>> vals = new ArrayList<Pair<String, String>>();
        vals.add(obj);
        while (this.lexer.token() == MySQLToken.PUNC_COMMA) {
            this.lexer.nextToken();
            obj = this.varAssignSimple();
            if (obj == null) continue;
            vals.add(obj);
        }
        return new DALSetSimpleStatement(vals);
    }

    private Pair<String, String> varAssignSimple() throws SQLSyntaxErrorException {
        String expr;
        String var;
        switch (this.lexer.token()) {
            case IDENTIFIER: {
                return null;
            }
            case SYS_VAR: {
                return null;
            }
            case USR_VAR: {
                var = this.lexer.stringValue();
                this.lexer.nextToken();
                break;
            }
            default: {
                throw this.err("unexpected token for SET statement");
            }
        }
        this.match(MySQLToken.OP_EQUALS, MySQLToken.OP_ASSIGN);
        if (this.lexer.token() == MySQLToken.LITERAL_NUM_PURE_DIGIT) {
            expr = "" + this.lexer.integerValue();
            this.lexer.nextToken();
        } else if (this.lexer.token() == MySQLToken.LITERAL_NUM_MIX_DIGIT) {
            expr = "" + this.lexer.decimalValue();
            this.lexer.nextToken();
        } else if (this.lexer.token() == MySQLToken.IDENTIFIER) {
            expr = this.findFullIdentifierAndNextToken(this.lexer);
        } else {
            expr = this.lexer.stringValue();
            this.lexer.nextToken();
        }
        return new Pair<String, String>(var, expr);
    }

    private String findFullIdentifierAndNextToken(MySQLLexer lexer) throws SQLSyntaxErrorException {
        StringBuffer sb = new StringBuffer();
        sb.append(lexer.stringValue());
        lexer.nextToken();
        if (lexer.token() == MySQLToken.PUNC_LEFT_PAREN) {
            sb.append('(');
            int nested = 1;
            do {
                lexer.nextToken();
                if (lexer.token() == MySQLToken.PUNC_LEFT_PAREN) {
                    ++nested;
                    sb.append('(');
                    continue;
                }
                if (lexer.token() == MySQLToken.PUNC_RIGHT_PAREN) {
                    --nested;
                    sb.append(')');
                    continue;
                }
                if (lexer.token() == MySQLToken.LITERAL_NUM_PURE_DIGIT) {
                    sb.append(lexer.integerValue());
                    continue;
                }
                if (lexer.token() == MySQLToken.LITERAL_NUM_MIX_DIGIT) {
                    sb.append(lexer.decimalValue());
                    continue;
                }
                if (lexer.token() == MySQLToken.PUNC_COMMA) {
                    sb.append(',');
                    continue;
                }
                sb.append(lexer.stringValue());
            } while (nested > 0 && lexer.token() != MySQLToken.EOF);
            lexer.nextToken();
        }
        return sb.toString();
    }

    protected OrderBy orderBy() throws SQLSyntaxErrorException {
        OrderBy orderBy;
        if (this.lexer.token() != MySQLToken.KW_ORDER) {
            return null;
        }
        this.lexer.nextToken();
        this.match(MySQLToken.KW_BY);
        Expression expr = this.exprParser.expression();
        SortOrder order = SortOrder.ASC;
        switch (this.lexer.token()) {
            case KW_DESC: {
                order = SortOrder.DESC;
            }
            case KW_ASC: {
                if (this.lexer.nextToken() != MySQLToken.PUNC_COMMA) {
                    return new OrderBy(expr, order);
                }
            }
            case PUNC_COMMA: {
                orderBy = new OrderBy();
                orderBy.addOrderByItem(expr, order);
                break;
            }
            default: {
                return new OrderBy(expr, order);
            }
        }
        while (this.lexer.token() == MySQLToken.PUNC_COMMA) {
            this.lexer.nextToken();
            order = SortOrder.ASC;
            expr = this.exprParser.expression();
            switch (this.lexer.token()) {
                case KW_DESC: {
                    order = SortOrder.DESC;
                }
                case KW_ASC: {
                    this.lexer.nextToken();
                }
            }
            orderBy.addOrderByItem(expr, order);
        }
        return orderBy;
    }

    static {
        specialIdentifiers.put("PHYSICAL_SLOW", SpecialIdentifier.PHYSICAL_SLOW);
        specialIdentifiers.put("AUTHORS", SpecialIdentifier.AUTHORS);
        specialIdentifiers.put("BINLOG", SpecialIdentifier.BINLOG);
        specialIdentifiers.put("COLLATION", SpecialIdentifier.COLLATION);
        specialIdentifiers.put("COLUMNS", SpecialIdentifier.COLUMNS);
        specialIdentifiers.put("PARTITIONS", SpecialIdentifier.PARTITIONS);
        specialIdentifiers.put("FIELDS", SpecialIdentifier.FIELDS);
        specialIdentifiers.put("CONTRIBUTORS", SpecialIdentifier.CONTRIBUTORS);
        specialIdentifiers.put("EVENT", SpecialIdentifier.EVENT);
        specialIdentifiers.put("FUNCTION", SpecialIdentifier.FUNCTION);
        specialIdentifiers.put("VIEW", SpecialIdentifier.VIEW);
        specialIdentifiers.put("ENGINE", SpecialIdentifier.ENGINE);
        specialIdentifiers.put("ENGINES", SpecialIdentifier.ENGINES);
        specialIdentifiers.put("ERRORS", SpecialIdentifier.ERRORS);
        specialIdentifiers.put("EVENTS", SpecialIdentifier.EVENTS);
        specialIdentifiers.put("FULL", SpecialIdentifier.FULL);
        specialIdentifiers.put("GLOBAL", SpecialIdentifier.GLOBAL);
        specialIdentifiers.put("GRANTS", SpecialIdentifier.GRANTS);
        specialIdentifiers.put("MASTER", SpecialIdentifier.MASTER);
        specialIdentifiers.put("OPEN", SpecialIdentifier.OPEN);
        specialIdentifiers.put("PLUGINS", SpecialIdentifier.PLUGINS);
        specialIdentifiers.put("CODE", SpecialIdentifier.CODE);
        specialIdentifiers.put("STATUS", SpecialIdentifier.STATUS);
        specialIdentifiers.put("PRIVILEGES", SpecialIdentifier.PRIVILEGES);
        specialIdentifiers.put("PROCESSLIST", SpecialIdentifier.PROCESSLIST);
        specialIdentifiers.put("DBLOCK", SpecialIdentifier.DBLOCK);
        specialIdentifiers.put("PROFILE", SpecialIdentifier.PROFILE);
        specialIdentifiers.put("PROFILES", SpecialIdentifier.PROFILES);
        specialIdentifiers.put("SESSION", SpecialIdentifier.SESSION);
        specialIdentifiers.put("SLAVE", SpecialIdentifier.SLAVE);
        specialIdentifiers.put("STORAGE", SpecialIdentifier.STORAGE);
        specialIdentifiers.put("TABLES", SpecialIdentifier.TABLES);
        specialIdentifiers.put("TRIGGERS", SpecialIdentifier.TRIGGERS);
        specialIdentifiers.put("VARIABLES", SpecialIdentifier.VARIABLES);
        specialIdentifiers.put("WARNINGS", SpecialIdentifier.WARNINGS);
        specialIdentifiers.put("INNODB", SpecialIdentifier.INNODB);
        specialIdentifiers.put("PERFORMANCE_SCHEMA", SpecialIdentifier.PERFORMANCE_SCHEMA);
        specialIdentifiers.put("MUTEX", SpecialIdentifier.MUTEX);
        specialIdentifiers.put("COUNT", SpecialIdentifier.COUNT);
        specialIdentifiers.put("BLOCK", SpecialIdentifier.BLOCK);
        specialIdentifiers.put("CONTEXT", SpecialIdentifier.CONTEXT);
        specialIdentifiers.put("CPU", SpecialIdentifier.CPU);
        specialIdentifiers.put("MEMORY", SpecialIdentifier.MEMORY);
        specialIdentifiers.put("PAGE", SpecialIdentifier.PAGE);
        specialIdentifiers.put("SOURCE", SpecialIdentifier.SOURCE);
        specialIdentifiers.put("SWAPS", SpecialIdentifier.SWAPS);
        specialIdentifiers.put("IPC", SpecialIdentifier.IPC);
        specialIdentifiers.put("LOCAL", SpecialIdentifier.LOCAL);
        specialIdentifiers.put("HOSTS", SpecialIdentifier.HOSTS);
        specialIdentifiers.put("INDEXES", SpecialIdentifier.INDEXES);
        specialIdentifiers.put("TRANSACTION", SpecialIdentifier.TRANSACTION);
        specialIdentifiers.put("UNCOMMITTED", SpecialIdentifier.UNCOMMITTED);
        specialIdentifiers.put("COMMITTED", SpecialIdentifier.COMMITTED);
        specialIdentifiers.put("REPEATABLE", SpecialIdentifier.REPEATABLE);
        specialIdentifiers.put("SERIALIZABLE", SpecialIdentifier.SERIALIZABLE);
        specialIdentifiers.put("NAMES", SpecialIdentifier.NAMES);
        specialIdentifiers.put("SEQUENCES", SpecialIdentifier.SEQUENCES);
        specialIdentifiers.put("TOPOLOGY", SpecialIdentifier.TOPOLOGY);
        specialIdentifiers.put("BROADCASTS", SpecialIdentifier.BROADCASTS);
        specialIdentifiers.put("RULE", SpecialIdentifier.RULE);
        specialIdentifiers.put("TRACE", SpecialIdentifier.TRACE);
        specialIdentifiers.put("DATASOURCES", SpecialIdentifier.DATASOURCES);
        specialIdentifiers.put("CHARSET", SpecialIdentifier.CHARSET);
        specialIdentifiers.put("ISOLATION", SpecialIdentifier.ISOLATION);
        specialIdentifiers.put("POLICY", SpecialIdentifier.POLICY);
        specialIdentifiers.put("PREPARE", SpecialIdentifier.PREPARE);
        specialIdentifiers.put("EXECUTE", SpecialIdentifier.EXECUTE);
        specialIdentifiers.put("DEALLOCATE", SpecialIdentifier.DEALLOCATE);
        specialIdentifiers.put("OFF", SpecialIdentifier.OFF);
        specialIdentifiers.put("STATS", SpecialIdentifier.STATS);
        specialIdentifiers.put("ONLY", SpecialIdentifier.ONLY);
    }

    private static enum SpecialIdentifier {
        AUTHORS,
        BINLOG,
        BLOCK,
        CODE,
        COLLATION,
        COLUMNS,
        FIELDS,
        COMMITTED,
        CONTEXT,
        CONTRIBUTORS,
        COUNT,
        CPU,
        ENGINE,
        ENGINES,
        ERRORS,
        EVENT,
        EVENTS,
        FULL,
        FUNCTION,
        GLOBAL,
        GRANTS,
        HOSTS,
        INDEXES,
        INNODB,
        IPC,
        ISOLATION,
        LOCAL,
        MASTER,
        MEMORY,
        MUTEX,
        NAMES,
        OPEN,
        PAGE,
        PERFORMANCE_SCHEMA,
        PLUGINS,
        POLICY,
        PRIVILEGES,
        PROCESSLIST,
        PROFILE,
        PROFILES,
        REPEATABLE,
        SERIALIZABLE,
        SESSION,
        SLAVE,
        SOURCE,
        STATUS,
        STORAGE,
        SWAPS,
        TABLES,
        TRANSACTION,
        TRIGGERS,
        UNCOMMITTED,
        VARIABLES,
        VIEW,
        WARNINGS,
        SEQUENCES,
        TOPOLOGY,
        PARITIONS,
        BROADCASTS,
        RULE,
        TRACE,
        DATASOURCES,
        CHARSET,
        PARTITIONS,
        PREPARE,
        EXECUTE,
        DEALLOCATE,
        DBLOCK,
        OFF,
        PHYSICAL_SLOW,
        STATS,
        ONLY;

    }
}

