/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.txc.parser.recognizer.mysql.syntax;

import com.alibaba.txc.parser.ast.expression.Expression;
import com.alibaba.txc.parser.ast.expression.UnaryOperatorExpression;
import com.alibaba.txc.parser.ast.expression.primary.Identifier;
import com.alibaba.txc.parser.ast.expression.primary.ddl.AddColumn;
import com.alibaba.txc.parser.ast.expression.primary.ddl.AddColumns;
import com.alibaba.txc.parser.ast.expression.primary.ddl.AddForeignKey;
import com.alibaba.txc.parser.ast.expression.primary.ddl.AddFullTextIndex;
import com.alibaba.txc.parser.ast.expression.primary.ddl.AddIndex;
import com.alibaba.txc.parser.ast.expression.primary.ddl.AddPartitition;
import com.alibaba.txc.parser.ast.expression.primary.ddl.AddPrimaryKey;
import com.alibaba.txc.parser.ast.expression.primary.ddl.AddSpatialIndex;
import com.alibaba.txc.parser.ast.expression.primary.ddl.AddUniqueKey;
import com.alibaba.txc.parser.ast.expression.primary.ddl.Algorithm;
import com.alibaba.txc.parser.ast.expression.primary.ddl.AlterColumnDefaultVal;
import com.alibaba.txc.parser.ast.expression.primary.ddl.AnalyzePartition;
import com.alibaba.txc.parser.ast.expression.primary.ddl.ChangeColumn;
import com.alibaba.txc.parser.ast.expression.primary.ddl.CharacterSet;
import com.alibaba.txc.parser.ast.expression.primary.ddl.CheckPartition;
import com.alibaba.txc.parser.ast.expression.primary.ddl.CoalescePartition;
import com.alibaba.txc.parser.ast.expression.primary.ddl.ConvertCharset;
import com.alibaba.txc.parser.ast.expression.primary.ddl.DBPartitionBy;
import com.alibaba.txc.parser.ast.expression.primary.ddl.DBPartitionDefinition;
import com.alibaba.txc.parser.ast.expression.primary.ddl.DBPartitionDefinitionType;
import com.alibaba.txc.parser.ast.expression.primary.ddl.DBPartitionOptions;
import com.alibaba.txc.parser.ast.expression.primary.ddl.DropColumn;
import com.alibaba.txc.parser.ast.expression.primary.ddl.DropForeignKey;
import com.alibaba.txc.parser.ast.expression.primary.ddl.DropIndex;
import com.alibaba.txc.parser.ast.expression.primary.ddl.DropPartitition;
import com.alibaba.txc.parser.ast.expression.primary.ddl.DropPrimaryKey;
import com.alibaba.txc.parser.ast.expression.primary.ddl.EnableKeys;
import com.alibaba.txc.parser.ast.expression.primary.ddl.ExchangePartition;
import com.alibaba.txc.parser.ast.expression.primary.ddl.ForceOperation;
import com.alibaba.txc.parser.ast.expression.primary.ddl.ImportTablespace;
import com.alibaba.txc.parser.ast.expression.primary.ddl.LockOperation;
import com.alibaba.txc.parser.ast.expression.primary.ddl.ModifyColumn;
import com.alibaba.txc.parser.ast.expression.primary.ddl.OptimizePartition;
import com.alibaba.txc.parser.ast.expression.primary.ddl.Orderby;
import com.alibaba.txc.parser.ast.expression.primary.ddl.PartitionBy;
import com.alibaba.txc.parser.ast.expression.primary.ddl.PartitionByType;
import com.alibaba.txc.parser.ast.expression.primary.ddl.PartitionDefinition;
import com.alibaba.txc.parser.ast.expression.primary.ddl.PartitionOptions;
import com.alibaba.txc.parser.ast.expression.primary.ddl.RebuildPartition;
import com.alibaba.txc.parser.ast.expression.primary.ddl.RemovePartitioning;
import com.alibaba.txc.parser.ast.expression.primary.ddl.RenameOperation;
import com.alibaba.txc.parser.ast.expression.primary.ddl.ReorganizePartition;
import com.alibaba.txc.parser.ast.expression.primary.ddl.RepairPartition;
import com.alibaba.txc.parser.ast.expression.primary.ddl.SubPartitionBy;
import com.alibaba.txc.parser.ast.expression.primary.ddl.SubpartitionDefinition;
import com.alibaba.txc.parser.ast.expression.primary.ddl.TBPartitionBy;
import com.alibaba.txc.parser.ast.expression.primary.ddl.TBPartitionDefinition;
import com.alibaba.txc.parser.ast.expression.primary.ddl.TruncatePartitition;
import com.alibaba.txc.parser.ast.expression.primary.literal.Literal;
import com.alibaba.txc.parser.ast.expression.primary.literal.LiteralNumber;
import com.alibaba.txc.parser.ast.expression.primary.literal.LiteralString;
import com.alibaba.txc.parser.ast.fragment.ddl.ColumnDefinition;
import com.alibaba.txc.parser.ast.fragment.ddl.TableOptions;
import com.alibaba.txc.parser.ast.fragment.ddl.datatype.DataType;
import com.alibaba.txc.parser.ast.fragment.ddl.index.IndexColumnName;
import com.alibaba.txc.parser.ast.fragment.ddl.index.IndexDefinition;
import com.alibaba.txc.parser.ast.fragment.ddl.index.IndexOption;
import com.alibaba.txc.parser.ast.fragment.ddl.index.ReferenceDefinition;
import com.alibaba.txc.parser.ast.fragment.ddl.index.ReferenceOption;
import com.alibaba.txc.parser.ast.stmt.ddl.AlterSequence;
import com.alibaba.txc.parser.ast.stmt.ddl.CreateSequence;
import com.alibaba.txc.parser.ast.stmt.ddl.DDLAlterTableStatement;
import com.alibaba.txc.parser.ast.stmt.ddl.DDLCreateIndexStatement;
import com.alibaba.txc.parser.ast.stmt.ddl.DDLCreateTableStatement;
import com.alibaba.txc.parser.ast.stmt.ddl.DDLDropIndexStatement;
import com.alibaba.txc.parser.ast.stmt.ddl.DDLDropTableStatement;
import com.alibaba.txc.parser.ast.stmt.ddl.DDLRenameTableStatement;
import com.alibaba.txc.parser.ast.stmt.ddl.DDLStatement;
import com.alibaba.txc.parser.ast.stmt.ddl.DDLTruncateStatement;
import com.alibaba.txc.parser.ast.stmt.ddl.DropSequence;
import com.alibaba.txc.parser.ast.stmt.dml.DMLSelectStatement;
import com.alibaba.txc.parser.ast.stmt.extension.ExtDDLCreatePolicy;
import com.alibaba.txc.parser.ast.stmt.extension.ExtDDLDropPolicy;
import com.alibaba.txc.parser.recognizer.mysql.MySQLToken;
import com.alibaba.txc.parser.recognizer.mysql.lexer.MySQLLexer;
import com.alibaba.txc.parser.recognizer.mysql.syntax.MyDBPartitionCharsetVisitor;
import com.alibaba.txc.parser.recognizer.mysql.syntax.MySQLDMLSelectParser;
import com.alibaba.txc.parser.recognizer.mysql.syntax.MySQLExprParser;
import com.alibaba.txc.parser.recognizer.mysql.syntax.MySQLParser;
import com.alibaba.txc.parser.util.Pair;
import java.sql.SQLSyntaxErrorException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class MySQLDDLParser
extends MySQLParser {
    protected MySQLExprParser exprParser;
    private static final Map<String, SpecialIdentifier> specialIdentifiers = new HashMap<String, SpecialIdentifier>(1, 1.0f);

    public MySQLDDLParser(MySQLLexer lexer, MySQLExprParser exprParser) {
        super(lexer);
        this.exprParser = exprParser;
    }

    public DDLTruncateStatement truncate() throws SQLSyntaxErrorException {
        this.matchIdentifier("TRUNCATE");
        if (this.lexer.token() == MySQLToken.KW_TABLE) {
            this.lexer.nextToken();
        }
        Identifier tb = this.identifier();
        return new DDLTruncateStatement(tb);
    }

    public DDLStatement ddlStmt() throws SQLSyntaxErrorException {
        switch (this.lexer.token()) {
            case KW_ALTER: {
                boolean ignore = false;
                if (this.lexer.nextToken() == MySQLToken.KW_IGNORE) {
                    ignore = true;
                    this.lexer.nextToken();
                }
                switch (this.lexer.token()) {
                    case KW_TABLE: {
                        this.lexer.nextToken();
                        Identifier idTemp1 = this.identifier();
                        DDLAlterTableStatement alterTableStatement = new DDLAlterTableStatement(ignore, idTemp1);
                        return this.alterTable(alterTableStatement);
                    }
                    case IDENTIFIER: {
                        SpecialIdentifier siTemp = specialIdentifiers.get(this.lexer.stringValueUppercase());
                        if (siTemp == null) break;
                        switch (siTemp) {
                            case SEQUENCE: {
                                this.lexer.nextToken();
                                Identifier name = this.identifier();
                                Number batch = null;
                                Number increment = null;
                                Number start = null;
                                block14 : switch (this.lexer.token()) {
                                    case LITERAL_NUM_PURE_DIGIT: {
                                        start = this.lexer.integerValue();
                                        break;
                                    }
                                    case IDENTIFIER: {
                                        if (!"START".equals(this.lexer.stringValueUppercase())) break;
                                        this.lexer.nextToken();
                                        this.match(MySQLToken.KW_WITH);
                                        switch (this.lexer.token()) {
                                            case LITERAL_NUM_PURE_DIGIT: {
                                                start = this.lexer.integerValue();
                                                break block14;
                                            }
                                        }
                                        throw this.err("expect digit after start with");
                                    }
                                    case EOF: {
                                        if (start == null) {
                                            throw this.err("expect digit after start with after alter sequence");
                                        }
                                    }
                                    default: {
                                        throw this.err("expect digit after start with after alter sequence");
                                    }
                                }
                                if (this.lexer.token() != MySQLToken.EOF) {
                                    this.lexer.nextToken();
                                }
                                return new AlterSequence(name, batch, increment, start);
                            }
                        }
                        throw this.err("Only ALTER SEQUENCE is supported");
                    }
                }
                throw this.err("Only ALTER TABLE is supported");
            }
            case KW_CREATE: {
                DDLCreateIndexStatement.IndexConstraintType constraintType = null;
                switch (this.lexer.nextToken()) {
                    case KW_UNIQUE: 
                    case KW_FULLTEXT: 
                    case KW_SPATIAL: {
                        if (this.lexer.token() == MySQLToken.KW_UNIQUE) {
                            constraintType = DDLCreateIndexStatement.IndexConstraintType.UNIQUE;
                        } else if (this.lexer.token() == MySQLToken.KW_FULLTEXT) {
                            constraintType = DDLCreateIndexStatement.IndexConstraintType.FULLTEXT;
                        } else if (this.lexer.token() == MySQLToken.KW_SPATIAL) {
                            constraintType = DDLCreateIndexStatement.IndexConstraintType.SPATIAL;
                        }
                        this.lexer.nextToken();
                    }
                    case KW_INDEX: {
                        ArrayList<IndexColumnName> columns = new ArrayList<IndexColumnName>(1);
                        Algorithm.AlgorithmType algorithmType = null;
                        LockOperation.LockType lockType = null;
                        IndexDefinition.IndexType indexType = null;
                        this.match(MySQLToken.KW_INDEX);
                        Identifier idTemp1 = this.identifier();
                        if (this.lexer.token() == MySQLToken.KW_USING) {
                            this.lexer.nextToken();
                            int tp = this.matchIdentifier("BTREE", "HASH");
                            indexType = tp == 0 ? IndexDefinition.IndexType.BTREE : IndexDefinition.IndexType.HASH;
                        }
                        this.match(MySQLToken.KW_ON);
                        Identifier idTemp2 = this.identifier();
                        this.match(MySQLToken.PUNC_LEFT_PAREN);
                        int i = 0;
                        while (this.lexer.token() != MySQLToken.PUNC_RIGHT_PAREN) {
                            if (i > 0) {
                                this.match(MySQLToken.PUNC_COMMA);
                            }
                            IndexColumnName indexColumnName = this.indexColumnName();
                            columns.add(indexColumnName);
                            ++i;
                        }
                        this.match(MySQLToken.PUNC_RIGHT_PAREN);
                        List<IndexOption> options = this.indexOptions();
                        block28 : switch (this.lexer.token()) {
                            case IDENTIFIER: {
                                SpecialIdentifier si = specialIdentifiers.get(this.lexer.stringValueUppercase());
                                if (si != null) {
                                    block32 : switch (si) {
                                        case ALGORITHM: {
                                            this.lexer.nextToken();
                                            if (this.lexer.token() == MySQLToken.OP_EQUALS) {
                                                this.lexer.nextToken();
                                            }
                                            if (this.lexer.token() == MySQLToken.KW_DEFAULT) {
                                                algorithmType = Algorithm.AlgorithmType.DEFAULT;
                                                this.lexer.nextToken();
                                                break;
                                            }
                                            si = specialIdentifiers.get(this.lexer.stringValueUppercase());
                                            if (si == null) break;
                                            switch (si) {
                                                case INPLACE: {
                                                    algorithmType = Algorithm.AlgorithmType.INPLACE;
                                                    this.lexer.nextToken();
                                                    break block32;
                                                }
                                                case COPY: {
                                                    algorithmType = Algorithm.AlgorithmType.COPY;
                                                    this.lexer.nextToken();
                                                    break block32;
                                                }
                                            }
                                            break;
                                        }
                                    }
                                }
                            }
                            case KW_LOCK: {
                                this.lexer.nextToken();
                                if (this.lexer.token() == MySQLToken.OP_EQUALS) {
                                    this.lexer.nextToken();
                                }
                                if (this.lexer.token() == MySQLToken.KW_DEFAULT) {
                                    lockType = LockOperation.LockType.DEFAULT;
                                    this.lexer.nextToken();
                                    break;
                                }
                                SpecialIdentifier si = specialIdentifiers.get(this.lexer.stringValueUppercase());
                                if (si == null) break;
                                switch (si) {
                                    case NONE: {
                                        lockType = LockOperation.LockType.NONE;
                                        this.lexer.nextToken();
                                        break block28;
                                    }
                                    case SHARED: {
                                        lockType = LockOperation.LockType.SHARED;
                                        this.lexer.nextToken();
                                        break block28;
                                    }
                                    case EXCLUSIVE: {
                                        lockType = LockOperation.LockType.EXCLUSIVE;
                                        this.lexer.nextToken();
                                        break block28;
                                    }
                                }
                                break;
                            }
                        }
                        return new DDLCreateIndexStatement(idTemp1, idTemp2, constraintType, columns, indexType, options, algorithmType, lockType);
                    }
                    case KW_TABLE: {
                        this.lexer.nextToken();
                        return this.createTable(false);
                    }
                    case IDENTIFIER: {
                        SpecialIdentifier siTemp = specialIdentifiers.get(this.lexer.stringValueUppercase());
                        if (siTemp == null) break;
                        switch (siTemp) {
                            case TEMPORARY: {
                                this.lexer.nextToken();
                                this.match(MySQLToken.KW_TABLE);
                                return this.createTable(true);
                            }
                            case POLICY: {
                                this.lexer.nextToken();
                                Identifier policyName = this.identifier();
                                this.match(MySQLToken.PUNC_LEFT_PAREN);
                                ExtDDLCreatePolicy policy = new ExtDDLCreatePolicy(policyName);
                                int j = 0;
                                while (this.lexer.token() != MySQLToken.PUNC_RIGHT_PAREN) {
                                    if (j > 0) {
                                        this.match(MySQLToken.PUNC_COMMA);
                                    }
                                    Integer id = this.lexer.integerValue().intValue();
                                    this.match(MySQLToken.LITERAL_NUM_PURE_DIGIT);
                                    Expression val = this.exprParser.valueExpression();
                                    policy.addProportion(id, val);
                                    ++j;
                                }
                                this.match(MySQLToken.PUNC_RIGHT_PAREN);
                                return policy;
                            }
                            case SEQUENCE: {
                                this.lexer.nextToken();
                                Identifier name = this.identifier();
                                Number batch = null;
                                Number increment = null;
                                Number start = null;
                                block49 : switch (this.lexer.token()) {
                                    case LITERAL_NUM_PURE_DIGIT: {
                                        start = this.lexer.integerValue();
                                        break;
                                    }
                                    case IDENTIFIER: {
                                        if (!"START".equals(this.lexer.stringValueUppercase())) break;
                                        this.lexer.nextToken();
                                        this.match(MySQLToken.KW_WITH);
                                        switch (this.lexer.token()) {
                                            case LITERAL_NUM_PURE_DIGIT: {
                                                start = this.lexer.integerValue();
                                                break block49;
                                            }
                                        }
                                        throw this.err("expect digit after start with");
                                    }
                                }
                                if (this.lexer.token() != MySQLToken.EOF) {
                                    this.lexer.nextToken();
                                }
                                return new CreateSequence(name, batch, increment, start);
                            }
                        }
                        throw this.err("unsupported DDL for CREATE " + new String(this.lexer.getSQL()));
                    }
                }
                throw this.err("unsupported DDL for CREATE " + new String(this.lexer.getSQL()));
            }
            case KW_DROP: {
                switch (this.lexer.nextToken()) {
                    case KW_INDEX: {
                        this.lexer.nextToken();
                        Identifier idTemp1 = this.identifier();
                        this.match(MySQLToken.KW_ON);
                        Identifier idTemp2 = this.identifier();
                        Algorithm.AlgorithmType algorithmType = null;
                        LockOperation.LockType lockType = null;
                        block61 : switch (this.lexer.token()) {
                            case IDENTIFIER: {
                                SpecialIdentifier si = specialIdentifiers.get(this.lexer.stringValueUppercase());
                                if (si != null) {
                                    block65 : switch (si) {
                                        case ALGORITHM: {
                                            this.lexer.nextToken();
                                            if (this.lexer.token() == MySQLToken.OP_EQUALS) {
                                                this.lexer.nextToken();
                                            }
                                            if (this.lexer.token() == MySQLToken.KW_DEFAULT) {
                                                algorithmType = Algorithm.AlgorithmType.DEFAULT;
                                                this.lexer.nextToken();
                                                break;
                                            }
                                            si = specialIdentifiers.get(this.lexer.stringValueUppercase());
                                            if (si == null) break;
                                            switch (si) {
                                                case INPLACE: {
                                                    algorithmType = Algorithm.AlgorithmType.INPLACE;
                                                    this.lexer.nextToken();
                                                    break block65;
                                                }
                                                case COPY: {
                                                    algorithmType = Algorithm.AlgorithmType.COPY;
                                                    this.lexer.nextToken();
                                                    break block65;
                                                }
                                            }
                                            break;
                                        }
                                    }
                                }
                            }
                            case KW_LOCK: {
                                this.lexer.nextToken();
                                if (this.lexer.token() == MySQLToken.OP_EQUALS) {
                                    this.lexer.nextToken();
                                }
                                if (this.lexer.token() == MySQLToken.KW_DEFAULT) {
                                    lockType = LockOperation.LockType.DEFAULT;
                                    this.lexer.nextToken();
                                    break;
                                }
                                SpecialIdentifier si = specialIdentifiers.get(this.lexer.stringValueUppercase());
                                if (si == null) break;
                                switch (si) {
                                    case NONE: {
                                        lockType = LockOperation.LockType.NONE;
                                        this.lexer.nextToken();
                                        break block61;
                                    }
                                    case SHARED: {
                                        lockType = LockOperation.LockType.SHARED;
                                        this.lexer.nextToken();
                                        break block61;
                                    }
                                    case EXCLUSIVE: {
                                        lockType = LockOperation.LockType.EXCLUSIVE;
                                        this.lexer.nextToken();
                                        break block61;
                                    }
                                }
                                break;
                            }
                        }
                        return new DDLDropIndexStatement(idTemp1, idTemp2, algorithmType, lockType);
                    }
                    case KW_TABLE: {
                        this.lexer.nextToken();
                        return this.dropTable(false);
                    }
                    case IDENTIFIER: {
                        SpecialIdentifier siTemp = specialIdentifiers.get(this.lexer.stringValueUppercase());
                        if (siTemp == null) break;
                        switch (siTemp) {
                            case TEMPORARY: {
                                this.lexer.nextToken();
                                this.match(MySQLToken.KW_TABLE);
                                return this.dropTable(true);
                            }
                            case POLICY: {
                                this.lexer.nextToken();
                                Identifier policyName = this.identifier();
                                return new ExtDDLDropPolicy(policyName);
                            }
                            case SEQUENCE: {
                                this.lexer.nextToken();
                                Identifier name = this.identifier();
                                return new DropSequence(name);
                            }
                        }
                        throw this.err("unsupported DDL for DROP");
                    }
                }
                throw this.err("unsupported DDL for DROP");
            }
            case KW_RENAME: {
                this.lexer.nextToken();
                this.match(MySQLToken.KW_TABLE);
                Identifier idTemp1 = this.identifier();
                this.match(MySQLToken.KW_TO);
                Identifier idTemp2 = this.identifier();
                if (this.lexer.token() != MySQLToken.PUNC_COMMA) {
                    ArrayList<Pair<Identifier, Identifier>> list = new ArrayList<Pair<Identifier, Identifier>>(1);
                    list.add(new Pair<Identifier, Identifier>(idTemp1, idTemp2));
                    return new DDLRenameTableStatement(list);
                }
                LinkedList<Pair<Identifier, Identifier>> list = new LinkedList<Pair<Identifier, Identifier>>();
                list.add(new Pair<Identifier, Identifier>(idTemp1, idTemp2));
                while (this.lexer.token() == MySQLToken.PUNC_COMMA) {
                    this.lexer.nextToken();
                    idTemp1 = this.identifier();
                    this.match(MySQLToken.KW_TO);
                    idTemp2 = this.identifier();
                    list.add(new Pair<Identifier, Identifier>(idTemp1, idTemp2));
                }
                return new DDLRenameTableStatement(list);
            }
            case IDENTIFIER: {
                SpecialIdentifier si = specialIdentifiers.get(this.lexer.stringValueUppercase());
                if (si == null) break;
                switch (si) {
                    case TRUNCATE: {
                        return this.truncate();
                    }
                }
                throw this.err("unsupported DDL");
            }
        }
        throw this.err("unsupported DDL");
    }

    private DDLDropTableStatement dropTable(boolean temp) throws SQLSyntaxErrorException {
        AbstractList list;
        boolean ifExists = false;
        if (this.lexer.token() == MySQLToken.KW_IF) {
            this.lexer.nextToken();
            this.match(MySQLToken.KW_EXISTS);
            ifExists = true;
        }
        Identifier tb = this.identifier();
        if (this.lexer.token() != MySQLToken.PUNC_COMMA) {
            list = new ArrayList(1);
            list.add(tb);
        } else {
            list = new LinkedList();
            list.add(tb);
            while (this.lexer.token() == MySQLToken.PUNC_COMMA) {
                this.lexer.nextToken();
                tb = this.identifier();
                list.add(tb);
            }
        }
        DDLDropTableStatement.Mode mode = DDLDropTableStatement.Mode.UNDEF;
        switch (this.lexer.token()) {
            case KW_RESTRICT: {
                this.lexer.nextToken();
                mode = DDLDropTableStatement.Mode.RESTRICT;
                break;
            }
            case KW_CASCADE: {
                this.lexer.nextToken();
                mode = DDLDropTableStatement.Mode.CASCADE;
                break;
            }
            case EOF: 
            case PUNC_SEMICOLON: {
                break;
            }
            default: {
                throw this.err("unsupported DDL");
            }
        }
        return new DDLDropTableStatement(list, temp, ifExists, mode);
    }

    private DDLAlterTableStatement alterTable(DDLAlterTableStatement stmt) throws SQLSyntaxErrorException {
        TableOptions options = new TableOptions();
        stmt.setTableOptions(options);
        DBPartitionOptions DBPartitionOptions2 = new DBPartitionOptions();
        stmt.setDBPartitionOptions(DBPartitionOptions2);
        Identifier id = null;
        Identifier id2 = null;
        Identifier id3 = null;
        ColumnDefinition colDef = null;
        IndexDefinition indexDef = null;
        ReferenceDefinition referenceDefinition = null;
        Expression expr = null;
        boolean hasIndexType = false;
        Algorithm.AlgorithmType algorithmType = null;
        LockOperation.LockType lockType = null;
        RenameOperation.RenameType renameType = null;
        boolean defaultchar = false;
        boolean skipcommatest = false;
        Orderby orderby = null;
        int i = 0;
        while (this.lexer.token() != MySQLToken.EOF) {
            if (this.lexer.token() == MySQLToken.PUNC_SEMICOLON) {
                return stmt;
            }
            if (i > 0 && !skipcommatest) {
                this.match(MySQLToken.PUNC_COMMA);
            } else {
                skipcommatest = false;
            }
            if (!this.tableOptions(options)) {
                block0 : switch (this.lexer.token()) {
                    case KW_CONVERT: {
                        this.lexer.nextToken();
                        this.match(MySQLToken.KW_TO);
                        this.match(MySQLToken.KW_CHARACTER);
                        this.match(MySQLToken.KW_SET);
                        id = this.identifier();
                        id2 = null;
                        if (this.lexer.token() == MySQLToken.KW_COLLATE) {
                            this.lexer.nextToken();
                            id2 = this.identifier();
                        }
                        stmt.addAlterSpecification(new ConvertCharset(new Pair<Identifier, Identifier>(id, id2)));
                        break;
                    }
                    case KW_DEFAULT: {
                        this.lexer.nextToken();
                        defaultchar = true;
                    }
                    case KW_CHARACTER: {
                        this.match(MySQLToken.KW_CHARACTER);
                        this.match(MySQLToken.KW_SET);
                        if (this.lexer.token() == MySQLToken.OP_EQUALS) {
                            this.lexer.nextToken();
                        }
                        id = this.identifier();
                        id2 = null;
                        if (this.lexer.token() == MySQLToken.KW_COLLATE) {
                            this.lexer.nextToken();
                            if (this.lexer.token() == MySQLToken.OP_EQUALS) {
                                this.lexer.nextToken();
                            }
                            id2 = this.identifier();
                        }
                        stmt.addAlterSpecification(new CharacterSet(new Pair<Identifier, Identifier>(id, id2), defaultchar));
                        defaultchar = false;
                        break;
                    }
                    case KW_ORDER: {
                        SpecialIdentifier si;
                        this.match(MySQLToken.KW_ORDER);
                        this.match(MySQLToken.KW_BY);
                        orderby = new Orderby();
                        id = this.identifier();
                        orderby.addColName(id);
                        stmt.addAlterSpecification(orderby);
                        while (this.lexer.token() == MySQLToken.PUNC_COMMA) {
                            this.lexer.nextToken();
                            if (this.lexer.token() == MySQLToken.IDENTIFIER) {
                                si = specialIdentifiers.get(this.lexer.stringValueUppercase());
                                if (si != null && (si == SpecialIdentifier.IMPORT || si == SpecialIdentifier.DISCARD || si == SpecialIdentifier.ENABLE || si == SpecialIdentifier.DISABLE || si == SpecialIdentifier.MODIFY || si == SpecialIdentifier.ALGORITHM)) {
                                    skipcommatest = true;
                                    break block0;
                                }
                                id = this.identifier();
                                orderby.addColName(id);
                                continue;
                            }
                            skipcommatest = true;
                            break block0;
                        }
                        break;
                    }
                    case KW_RENAME: {
                        switch (this.lexer.nextToken()) {
                            case KW_TO: {
                                renameType = RenameOperation.RenameType.TO;
                                this.lexer.nextToken();
                                break;
                            }
                            case KW_AS: {
                                renameType = RenameOperation.RenameType.AS;
                                this.lexer.nextToken();
                                break;
                            }
                        }
                        id = this.identifier();
                        stmt.addAlterSpecification(new RenameOperation(renameType, id));
                        break;
                    }
                    case KW_DROP: {
                        List<Identifier> partition_names;
                        SpecialIdentifier si;
                        switch (this.lexer.nextToken()) {
                            case KW_INDEX: 
                            case KW_KEY: {
                                this.lexer.nextToken();
                                id = this.identifier();
                                stmt.addAlterSpecification(new DropIndex(id));
                                break block0;
                            }
                            case KW_PRIMARY: {
                                this.lexer.nextToken();
                                this.match(MySQLToken.KW_KEY);
                                stmt.addAlterSpecification(new DropPrimaryKey());
                                break block0;
                            }
                            case KW_FOREIGN: {
                                this.lexer.nextToken();
                                this.match(MySQLToken.KW_KEY);
                                id = this.identifier();
                                stmt.addAlterSpecification(new DropForeignKey(id));
                                break block0;
                            }
                            case IDENTIFIER: {
                                si = specialIdentifiers.get(this.lexer.stringValueUppercase());
                                if (si != null && si == SpecialIdentifier.PARTITION) {
                                    this.lexer.nextToken();
                                    partition_names = this.parseIdentifierList();
                                    stmt.addAlterSpecification(new DropPartitition(partition_names));
                                    break block0;
                                }
                                id = this.identifier();
                                stmt.addAlterSpecification(new DropColumn(id));
                                break block0;
                            }
                            case KW_COLUMN: {
                                this.lexer.nextToken();
                                id = this.identifier();
                                stmt.addAlterSpecification(new DropColumn(id));
                                break block0;
                            }
                        }
                        throw new SQLSyntaxErrorException("ALTER TABLE error for DROP");
                    }
                    case KW_CHANGE: {
                        if (this.lexer.nextToken() == MySQLToken.KW_COLUMN) {
                            this.lexer.nextToken();
                        }
                        id = this.identifier();
                        id2 = this.identifier();
                        colDef = this.columnDefinition();
                        if (this.lexer.token() == MySQLToken.IDENTIFIER) {
                            if ("FIRST".equals(this.lexer.stringValueUppercase())) {
                                this.lexer.nextToken();
                                stmt.addAlterSpecification(new ChangeColumn(id, id2, colDef, null));
                                break;
                            }
                            if ("AFTER".equals(this.lexer.stringValueUppercase())) {
                                this.lexer.nextToken();
                                id3 = this.identifier();
                                stmt.addAlterSpecification(new ChangeColumn(id, id2, colDef, id3));
                                break;
                            }
                            stmt.addAlterSpecification(new ChangeColumn(id, id2, colDef));
                            break;
                        }
                        stmt.addAlterSpecification(new ChangeColumn(id, id2, colDef));
                        break;
                    }
                    case KW_LOCK: {
                        SpecialIdentifier si;
                        this.lexer.nextToken();
                        if (this.lexer.token() == MySQLToken.OP_EQUALS) {
                            this.lexer.nextToken();
                        }
                        if (this.lexer.token() == MySQLToken.KW_DEFAULT) {
                            lockType = LockOperation.LockType.DEFAULT;
                            this.lexer.nextToken();
                        } else {
                            si = specialIdentifiers.get(this.lexer.stringValueUppercase());
                            if (si != null) {
                                switch (si) {
                                    case NONE: {
                                        lockType = LockOperation.LockType.NONE;
                                        this.lexer.nextToken();
                                        break;
                                    }
                                    case SHARED: {
                                        lockType = LockOperation.LockType.SHARED;
                                        this.lexer.nextToken();
                                        break;
                                    }
                                    case EXCLUSIVE: {
                                        lockType = LockOperation.LockType.EXCLUSIVE;
                                        this.lexer.nextToken();
                                        break;
                                    }
                                }
                            }
                        }
                        if (lockType == null) break;
                        stmt.addAlterSpecification(new LockOperation(lockType));
                        break;
                    }
                    case KW_FORCE: {
                        this.lexer.nextToken();
                        stmt.addAlterSpecification(new ForceOperation());
                        break;
                    }
                    case KW_ALTER: {
                        if (this.lexer.nextToken() == MySQLToken.KW_COLUMN) {
                            this.lexer.nextToken();
                        }
                        id = this.identifier();
                        switch (this.lexer.token()) {
                            case KW_SET: {
                                this.lexer.nextToken();
                                this.match(MySQLToken.KW_DEFAULT);
                                expr = this.exprParser.valueExpression();
                                stmt.addAlterSpecification(new AlterColumnDefaultVal(id, expr));
                                break block0;
                            }
                            case KW_DROP: {
                                this.lexer.nextToken();
                                this.match(MySQLToken.KW_DEFAULT);
                                stmt.addAlterSpecification(new AlterColumnDefaultVal(id));
                                break block0;
                            }
                        }
                        throw new SQLSyntaxErrorException("ALTER TABLE error for ALTER");
                    }
                    case KW_CHECK: {
                        List<Identifier> partition_names;
                        this.lexer.nextToken();
                        this.matchIdentifier("PARTITION");
                        CheckPartition checkPartition = new CheckPartition();
                        if ("ALL".equals(this.lexer.stringValueUppercase())) {
                            this.lexer.nextToken();
                            checkPartition.setCheckPartitionType(CheckPartition.CheckPartitionType.ALL);
                        } else {
                            partition_names = this.parseIdentifierList();
                            checkPartition.setCheckPartitionType(CheckPartition.CheckPartitionType.PARTITION_NAMES);
                            checkPartition.setPartition_names(partition_names);
                        }
                        stmt.addAlterSpecification(checkPartition);
                        break;
                    }
                    case KW_OPTIMIZE: {
                        List<Identifier> partition_names;
                        this.lexer.nextToken();
                        this.matchIdentifier("PARTITION");
                        OptimizePartition optimizePartition = new OptimizePartition();
                        if ("ALL".equals(this.lexer.stringValueUppercase())) {
                            this.lexer.nextToken();
                            optimizePartition.setOptimizePartitionType(OptimizePartition.OptimizePartitionType.ALL);
                        } else {
                            partition_names = this.parseIdentifierList();
                            optimizePartition.setOptimizePartitionType(OptimizePartition.OptimizePartitionType.PARTITION_NAMES);
                            optimizePartition.setPartition_names(partition_names);
                        }
                        stmt.addAlterSpecification(optimizePartition);
                        break;
                    }
                    case KW_ADD: {
                        SpecialIdentifier si;
                        switch (this.lexer.nextToken()) {
                            case IDENTIFIER: {
                                si = specialIdentifiers.get(this.lexer.stringValueUppercase());
                                if (si != null && si == SpecialIdentifier.PARTITION) {
                                    this.lexer.nextToken();
                                    this.match(MySQLToken.PUNC_LEFT_PAREN);
                                    PartitionDefinition partitionDefinition = this.parsePartitionDefinition();
                                    this.match(MySQLToken.PUNC_RIGHT_PAREN);
                                    stmt.addAlterSpecification(new AddPartitition(partitionDefinition));
                                    break block0;
                                }
                                id = this.identifier();
                                colDef = this.columnDefinition();
                                if (this.lexer.token() == MySQLToken.IDENTIFIER) {
                                    if ("FIRST".equals(this.lexer.stringValueUppercase())) {
                                        this.lexer.nextToken();
                                        stmt.addAlterSpecification(new AddColumn(id, colDef, null));
                                        break block0;
                                    }
                                    if ("AFTER".equals(this.lexer.stringValueUppercase())) {
                                        this.lexer.nextToken();
                                        id2 = this.identifier();
                                        stmt.addAlterSpecification(new AddColumn(id, colDef, id2));
                                        break block0;
                                    }
                                    stmt.addAlterSpecification(new AddColumn(id, colDef));
                                    break block0;
                                }
                                stmt.addAlterSpecification(new AddColumn(id, colDef));
                                break block0;
                            }
                            case PUNC_LEFT_PAREN: {
                                AddColumns addColumns;
                                this.lexer.nextToken();
                                int j = 0;
                                while (this.lexer.token() != MySQLToken.PUNC_RIGHT_PAREN) {
                                    addColumns = new AddColumns();
                                    stmt.addAlterSpecification(addColumns);
                                    if (j > 0) {
                                        this.match(MySQLToken.PUNC_COMMA);
                                    }
                                    id = this.identifier();
                                    colDef = this.columnDefinition();
                                    addColumns.addColumn(id, colDef);
                                    ++j;
                                }
                                this.match(MySQLToken.PUNC_RIGHT_PAREN);
                                break block0;
                            }
                            case KW_COLUMN: {
                                AddColumns addColumns;
                                if (this.lexer.nextToken() == MySQLToken.PUNC_LEFT_PAREN) {
                                    this.lexer.nextToken();
                                    int j = 0;
                                    while (this.lexer.token() != MySQLToken.PUNC_RIGHT_PAREN) {
                                        addColumns = new AddColumns();
                                        stmt.addAlterSpecification(addColumns);
                                        if (j > 0) {
                                            this.match(MySQLToken.PUNC_COMMA);
                                        }
                                        id = this.identifier();
                                        colDef = this.columnDefinition();
                                        addColumns.addColumn(id, colDef);
                                        ++j;
                                    }
                                    this.match(MySQLToken.PUNC_RIGHT_PAREN);
                                    break block0;
                                }
                                id = this.identifier();
                                colDef = this.columnDefinition();
                                if (this.lexer.token() == MySQLToken.IDENTIFIER) {
                                    if ("FIRST".equals(this.lexer.stringValueUppercase())) {
                                        this.lexer.nextToken();
                                        stmt.addAlterSpecification(new AddColumn(id, colDef, null));
                                        break block0;
                                    }
                                    if ("AFTER".equals(this.lexer.stringValueUppercase())) {
                                        this.lexer.nextToken();
                                        id2 = this.identifier();
                                        stmt.addAlterSpecification(new AddColumn(id, colDef, id2));
                                        break block0;
                                    }
                                    stmt.addAlterSpecification(new AddColumn(id, colDef));
                                    break block0;
                                }
                                stmt.addAlterSpecification(new AddColumn(id, colDef));
                                break block0;
                            }
                            case KW_CONSTRAINT: {
                                Identifier constraint = null;
                                this.lexer.nextToken();
                                constraint = this.lexer.token() == MySQLToken.IDENTIFIER ? this.identifier() : new Identifier(null, "");
                                switch (this.lexer.token()) {
                                    case KW_PRIMARY: {
                                        this.lexer.nextToken();
                                        this.match(MySQLToken.KW_KEY);
                                        indexDef = this.indexDefinition();
                                        stmt.addAlterSpecification(new AddPrimaryKey(indexDef, constraint));
                                        constraint = null;
                                        break block0;
                                    }
                                    case KW_FOREIGN: {
                                        this.lexer.nextToken();
                                        this.match(MySQLToken.KW_KEY);
                                        id = null;
                                        if (this.lexer.token() == MySQLToken.IDENTIFIER) {
                                            id = this.identifier();
                                        }
                                        indexDef = this.indexDefinition();
                                        referenceDefinition = this.referenceDefinition();
                                        stmt.addAlterSpecification(new AddForeignKey(indexDef, referenceDefinition, constraint, id));
                                        constraint = null;
                                        break block0;
                                    }
                                    case KW_UNIQUE: {
                                        switch (this.lexer.nextToken()) {
                                            case KW_INDEX: 
                                            case KW_KEY: {
                                                this.lexer.nextToken();
                                                hasIndexType = true;
                                            }
                                        }
                                        id = null;
                                        if (this.lexer.token() == MySQLToken.IDENTIFIER) {
                                            id = this.identifier();
                                        }
                                        indexDef = this.indexDefinition();
                                        stmt.addAlterSpecification(new AddUniqueKey(id, indexDef, constraint, hasIndexType));
                                        constraint = null;
                                        break block0;
                                    }
                                }
                                break block0;
                            }
                            case KW_INDEX: 
                            case KW_KEY: {
                                Identifier constraint;
                                id = null;
                                if (this.lexer.nextToken() == MySQLToken.IDENTIFIER) {
                                    id = this.identifier();
                                } else {
                                    constraint = null;
                                }
                                indexDef = this.indexDefinition();
                                stmt.addAlterSpecification(new AddIndex(id, indexDef));
                                break block0;
                            }
                            case KW_PRIMARY: {
                                this.lexer.nextToken();
                                this.match(MySQLToken.KW_KEY);
                                indexDef = this.indexDefinition();
                                stmt.addAlterSpecification(new AddPrimaryKey(indexDef, null));
                                Identifier constraint = null;
                                break block0;
                            }
                            case KW_FOREIGN: {
                                this.lexer.nextToken();
                                this.match(MySQLToken.KW_KEY);
                                id = null;
                                if (this.lexer.token() == MySQLToken.IDENTIFIER) {
                                    id = this.identifier();
                                }
                                indexDef = this.indexDefinition();
                                referenceDefinition = this.referenceDefinition();
                                stmt.addAlterSpecification(new AddForeignKey(indexDef, referenceDefinition, null, id));
                                Identifier constraint = null;
                                break block0;
                            }
                            case KW_UNIQUE: {
                                switch (this.lexer.nextToken()) {
                                    case KW_INDEX: 
                                    case KW_KEY: {
                                        this.lexer.nextToken();
                                        hasIndexType = true;
                                    }
                                }
                                id = null;
                                if (this.lexer.token() == MySQLToken.IDENTIFIER) {
                                    id = this.identifier();
                                }
                                indexDef = this.indexDefinition();
                                stmt.addAlterSpecification(new AddUniqueKey(id, indexDef, null, hasIndexType));
                                Identifier constraint = null;
                                break block0;
                            }
                            case KW_FULLTEXT: {
                                switch (this.lexer.nextToken()) {
                                    case KW_INDEX: 
                                    case KW_KEY: {
                                        hasIndexType = true;
                                        this.lexer.nextToken();
                                    }
                                }
                                id = null;
                                if (this.lexer.token() == MySQLToken.IDENTIFIER) {
                                    id = this.identifier();
                                }
                                indexDef = this.indexDefinition();
                                stmt.addAlterSpecification(new AddFullTextIndex(id, indexDef, hasIndexType));
                                break block0;
                            }
                            case KW_SPATIAL: {
                                switch (this.lexer.nextToken()) {
                                    case KW_INDEX: 
                                    case KW_KEY: {
                                        hasIndexType = true;
                                        this.lexer.nextToken();
                                    }
                                }
                                id = null;
                                if (this.lexer.token() == MySQLToken.IDENTIFIER) {
                                    id = this.identifier();
                                }
                                indexDef = this.indexDefinition();
                                stmt.addAlterSpecification(new AddSpatialIndex(id, indexDef, hasIndexType));
                                break block0;
                            }
                        }
                        throw new SQLSyntaxErrorException("ALTER TABLE error for ADD");
                    }
                    case IDENTIFIER: {
                        List<Identifier> partition_names;
                        SpecialIdentifier si = specialIdentifiers.get(this.lexer.stringValueUppercase());
                        if (si == null) break;
                        switch (si) {
                            case IMPORT: {
                                this.lexer.nextToken();
                                this.matchIdentifier("TABLESPACE");
                                stmt.addAlterSpecification(new ImportTablespace(ImportTablespace.ImportTSType.IMPORT));
                                break block0;
                            }
                            case DISCARD: {
                                this.lexer.nextToken();
                                this.matchIdentifier("TABLESPACE");
                                stmt.addAlterSpecification(new ImportTablespace(ImportTablespace.ImportTSType.DISCARD));
                                break block0;
                            }
                            case ENABLE: {
                                this.lexer.nextToken();
                                this.match(MySQLToken.KW_KEYS);
                                stmt.addAlterSpecification(new EnableKeys(EnableKeys.EnableType.ENABLE));
                                break block0;
                            }
                            case DISABLE: {
                                this.lexer.nextToken();
                                this.match(MySQLToken.KW_KEYS);
                                stmt.addAlterSpecification(new EnableKeys(EnableKeys.EnableType.DISABLE));
                                break block0;
                            }
                            case MODIFY: {
                                if (this.lexer.nextToken() == MySQLToken.KW_COLUMN) {
                                    this.lexer.nextToken();
                                }
                                id = this.identifier();
                                colDef = this.columnDefinition();
                                if (this.lexer.token() == MySQLToken.IDENTIFIER) {
                                    if ("FIRST".equals(this.lexer.stringValueUppercase())) {
                                        this.lexer.nextToken();
                                        stmt.addAlterSpecification(new ModifyColumn(id, colDef, null));
                                        break block0;
                                    }
                                    if ("AFTER".equals(this.lexer.stringValueUppercase())) {
                                        this.lexer.nextToken();
                                        id2 = this.identifier();
                                        stmt.addAlterSpecification(new ModifyColumn(id, colDef, id2));
                                        break block0;
                                    }
                                    stmt.addAlterSpecification(new ModifyColumn(id, colDef));
                                    break block0;
                                }
                                stmt.addAlterSpecification(new ModifyColumn(id, colDef));
                                break block0;
                            }
                            case ALGORITHM: {
                                this.lexer.nextToken();
                                if (this.lexer.token() == MySQLToken.OP_EQUALS) {
                                    this.lexer.nextToken();
                                }
                                if (this.lexer.token() == MySQLToken.KW_DEFAULT) {
                                    algorithmType = Algorithm.AlgorithmType.DEFAULT;
                                    this.lexer.nextToken();
                                } else {
                                    si = specialIdentifiers.get(this.lexer.stringValueUppercase());
                                    if (si != null) {
                                        switch (si) {
                                            case INPLACE: {
                                                algorithmType = Algorithm.AlgorithmType.INPLACE;
                                                this.lexer.nextToken();
                                                break;
                                            }
                                            case COPY: {
                                                algorithmType = Algorithm.AlgorithmType.COPY;
                                                this.lexer.nextToken();
                                                break;
                                            }
                                        }
                                    }
                                }
                                if (algorithmType == null) break block0;
                                stmt.addAlterSpecification(new Algorithm(algorithmType));
                                break block0;
                            }
                            case TRUNCATE: {
                                this.lexer.nextToken();
                                this.matchIdentifier("PARTITION");
                                TruncatePartitition truncatePartitition = new TruncatePartitition();
                                if ("ALL".equals(this.lexer.stringValueUppercase())) {
                                    this.lexer.nextToken();
                                    truncatePartitition.setTruncatePartitionType(TruncatePartitition.TruncatePartitionType.ALL);
                                } else {
                                    truncatePartitition.setTruncatePartitionType(TruncatePartitition.TruncatePartitionType.PARTITION_NAMES);
                                    partition_names = this.parseIdentifierList();
                                    truncatePartitition.setPartition_names(partition_names);
                                }
                                stmt.addAlterSpecification(truncatePartitition);
                                break block0;
                            }
                            case COALESCE: {
                                this.lexer.nextToken();
                                this.matchIdentifier("PARTITION");
                                LiteralNumber number = (LiteralNumber)this.exprParser.valueExpression();
                                stmt.addAlterSpecification(new CoalescePartition(number));
                                break block0;
                            }
                            case REORGANIZE: {
                                this.lexer.nextToken();
                                this.matchIdentifier("PARTITION");
                                partition_names = this.parseIdentifierList();
                                this.match(MySQLToken.KW_INTO);
                                this.match(MySQLToken.PUNC_LEFT_PAREN);
                                List<PartitionDefinition> partitionDefinitionList = this.parsePartitionDefinitionList();
                                this.match(MySQLToken.PUNC_RIGHT_PAREN);
                                stmt.addAlterSpecification(new ReorganizePartition(partition_names, partitionDefinitionList));
                                break block0;
                            }
                            case EXCHANGE: {
                                this.lexer.nextToken();
                                this.matchIdentifier("PARTITION");
                                Identifier partition_name = this.identifier();
                                this.match(MySQLToken.KW_WITH);
                                this.match(MySQLToken.KW_TABLE);
                                Identifier table_name = this.identifier();
                                stmt.addAlterSpecification(new ExchangePartition(partition_name, table_name));
                                break block0;
                            }
                            case ANALYZE: {
                                this.lexer.nextToken();
                                this.matchIdentifier("PARTITION");
                                AnalyzePartition analyzePartition = new AnalyzePartition();
                                if ("ALL".equals(this.lexer.stringValueUppercase())) {
                                    this.lexer.nextToken();
                                    analyzePartition.setAnalyzePartitionType(AnalyzePartition.AnalyzePartitionType.ALL);
                                } else {
                                    analyzePartition.setAnalyzePartitionType(AnalyzePartition.AnalyzePartitionType.PARTITION_NAMES);
                                    partition_names = this.parseIdentifierList();
                                    analyzePartition.setPartition_names(partition_names);
                                }
                                stmt.addAlterSpecification(analyzePartition);
                                break block0;
                            }
                            case REBUILD: {
                                this.lexer.nextToken();
                                this.matchIdentifier("PARTITION");
                                RebuildPartition rebuildPartition = new RebuildPartition();
                                if ("ALL".equals(this.lexer.stringValueUppercase())) {
                                    this.lexer.nextToken();
                                    rebuildPartition.setRebuildPartitionType(RebuildPartition.RebuildPartitionType.ALL);
                                } else {
                                    rebuildPartition.setRebuildPartitionType(RebuildPartition.RebuildPartitionType.PARTITION_NAMES);
                                    partition_names = this.parseIdentifierList();
                                    rebuildPartition.setPartition_names(partition_names);
                                }
                                stmt.addAlterSpecification(rebuildPartition);
                                break block0;
                            }
                            case REPAIR: {
                                this.lexer.nextToken();
                                this.matchIdentifier("PARTITION");
                                RepairPartition repairPartition = new RepairPartition();
                                if ("ALL".equals(this.lexer.stringValueUppercase())) {
                                    this.lexer.nextToken();
                                    repairPartition.setRepairPartitionType(RepairPartition.RepairPartitionType.ALL);
                                } else {
                                    repairPartition.setRepairPartitionType(RepairPartition.RepairPartitionType.PARTITION_NAMES);
                                    partition_names = this.parseIdentifierList();
                                    repairPartition.setPartition_names(partition_names);
                                }
                                stmt.addAlterSpecification(repairPartition);
                                break block0;
                            }
                            case REMOVE: {
                                this.lexer.nextToken();
                                this.matchIdentifier("PARTITIONING");
                                stmt.addAlterSpecification(new RemovePartitioning());
                                break block0;
                            }
                        }
                        throw new SQLSyntaxErrorException("unknown ALTER");
                    }
                }
                if (!this.dbPartitionOptions(DBPartitionOptions2)) {
                    throw new SQLSyntaxErrorException("unknown ALTER specification");
                }
            }
            ++i;
        }
        return stmt;
    }

    private DDLCreateTableStatement createTable(boolean temp) throws SQLSyntaxErrorException {
        boolean ifNotExists = false;
        if (this.lexer.token() == MySQLToken.KW_IF) {
            this.lexer.nextToken();
            this.match(MySQLToken.KW_NOT);
            this.match(MySQLToken.KW_EXISTS);
            ifNotExists = true;
        }
        Identifier table = this.identifier();
        DDLCreateTableStatement stmt = new DDLCreateTableStatement(temp, ifNotExists, table);
        this.createTableDefs(stmt);
        boolean tableOptionProcessed = false;
        boolean partitionProcessed = false;
        boolean dbpartitionProcessed = false;
        while (!(this.lexer.token() == MySQLToken.EOF || this.lexer.token() == MySQLToken.PUNC_SEMICOLON || this.lexer.token() == MySQLToken.KW_IGNORE || this.lexer.token() == MySQLToken.KW_REPLACE || this.lexer.token() == MySQLToken.KW_LIKE || this.lexer.token() == MySQLToken.KW_AS || this.lexer.token() == MySQLToken.KW_SELECT || tableOptionProcessed && partitionProcessed && dbpartitionProcessed)) {
            DBPartitionOptions dbpartitionOptions;
            if (!dbpartitionProcessed && "DBPARTITION".equals(this.lexer.stringValueUppercase())) {
                dbpartitionOptions = new DBPartitionOptions();
                stmt.setDBPartitionOptions(dbpartitionOptions);
                this.dbPartitionOptions(dbpartitionOptions);
                dbpartitionProcessed = true;
                continue;
            }
            if (!partitionProcessed && "PARTITION".equals(this.lexer.stringValueUppercase())) {
                PartitionOptions partitionOptions = new PartitionOptions();
                stmt.setPartitionOptions(partitionOptions);
                this.parsePartitionOptions(partitionOptions);
                partitionProcessed = true;
                continue;
            }
            if (!tableOptionProcessed) {
                TableOptions options = new TableOptions();
                stmt.setTableOptions(options);
                this.tableOptions(options);
                tableOptionProcessed = true;
                continue;
            }
            if (!dbpartitionProcessed && "TBPARTITION".equals(this.lexer.stringValueUppercase())) {
                dbpartitionOptions = new DBPartitionOptions();
                stmt.setDBPartitionOptions(dbpartitionOptions);
                this.dbPartitionOptions(dbpartitionOptions);
                dbpartitionProcessed = true;
                continue;
            }
            if (dbpartitionProcessed || !"DBPARTITIONS".equals(this.lexer.stringValueUppercase())) break;
            dbpartitionOptions = new DBPartitionOptions();
            stmt.setDBPartitionOptions(dbpartitionOptions);
            this.dbPartitionOptions(dbpartitionOptions);
            dbpartitionProcessed = true;
        }
        MyDBPartitionCharsetVisitor visitor = new MyDBPartitionCharsetVisitor();
        stmt.accept(visitor);
        DDLCreateTableStatement.SelectOption selectOpt = null;
        switch (this.lexer.token()) {
            case KW_IGNORE: {
                selectOpt = DDLCreateTableStatement.SelectOption.IGNORED;
                if (this.lexer.nextToken() != MySQLToken.KW_AS) break;
                this.lexer.nextToken();
                break;
            }
            case KW_REPLACE: {
                selectOpt = DDLCreateTableStatement.SelectOption.REPLACE;
                if (this.lexer.nextToken() != MySQLToken.KW_AS) break;
                this.lexer.nextToken();
                break;
            }
            case KW_LIKE: {
                this.lexer.nextToken();
                Identifier old_tbl_name = this.identifier();
                stmt.setOldTblName(old_tbl_name);
                this.match(MySQLToken.EOF);
                return stmt;
            }
            case KW_AS: {
                this.lexer.nextToken();
            }
            case KW_SELECT: {
                break;
            }
            case EOF: 
            case PUNC_SEMICOLON: {
                return stmt;
            }
            default: {
                throw new SQLSyntaxErrorException("DDL CREATE TABLE statement not end properly " + new String(this.lexer.getSQL()));
            }
        }
        DMLSelectStatement select = new MySQLDMLSelectParser(this.lexer, this.exprParser).select();
        stmt.setSelect(selectOpt, select);
        this.match(MySQLToken.EOF);
        return stmt;
    }

    private void createTableDefs(DDLCreateTableStatement stmt) throws SQLSyntaxErrorException {
        if (this.lexer.token() != MySQLToken.PUNC_LEFT_PAREN) {
            return;
        }
        this.match(MySQLToken.PUNC_LEFT_PAREN);
        Identifier constraint = null;
        int i = 0;
        while (this.lexer.token() != MySQLToken.PUNC_RIGHT_PAREN) {
            if (i > 0) {
                this.match(MySQLToken.PUNC_COMMA);
            }
            block0 : switch (this.lexer.token()) {
                case KW_CONSTRAINT: {
                    ReferenceDefinition referenceDefinition;
                    Identifier id;
                    IndexDefinition indexDef;
                    this.lexer.nextToken();
                    constraint = this.lexer.token() == MySQLToken.IDENTIFIER ? this.identifier() : null;
                    switch (this.lexer.token()) {
                        case KW_PRIMARY: {
                            this.lexer.nextToken();
                            this.match(MySQLToken.KW_KEY);
                            indexDef = this.indexDefinition();
                            stmt.setPrimaryKey(indexDef);
                            stmt.setHasPrimaryKeyConstraint(true);
                            if (constraint == null) break block0;
                            stmt.setPaimaryKeyConstraint(constraint);
                            break block0;
                        }
                        case KW_UNIQUE: {
                            switch (this.lexer.nextToken()) {
                                case KW_INDEX: 
                                case KW_KEY: {
                                    this.lexer.nextToken();
                                    break;
                                }
                            }
                            id = this.lexer.token() == MySQLToken.IDENTIFIER ? this.identifier() : null;
                            indexDef = this.indexDefinition();
                            indexDef.setHasConstraint(true);
                            if (constraint != null) {
                                indexDef.setUniqueConstraint(constraint);
                            }
                            stmt.addUniqueIndex(id, indexDef);
                            break block0;
                        }
                        case KW_FOREIGN: {
                            this.lexer.nextToken();
                            this.match(MySQLToken.KW_KEY);
                            id = this.lexer.token() == MySQLToken.IDENTIFIER ? this.identifier() : null;
                            indexDef = this.indexDefinition();
                            indexDef.setHasConstraint(true);
                            referenceDefinition = this.referenceDefinition();
                            indexDef.setForeignKeyReferenceDefinition(referenceDefinition);
                            if (constraint != null) {
                                indexDef.setForeignKeyConstraint(constraint);
                            }
                            stmt.addForeignKey(id, indexDef);
                            break block0;
                        }
                        default: {
                            throw new SQLSyntaxErrorException("unsupportted CONSTRAINT column definition");
                        }
                    }
                }
                case KW_PRIMARY: {
                    this.lexer.nextToken();
                    this.match(MySQLToken.KW_KEY);
                    IndexDefinition indexDef = this.indexDefinition();
                    stmt.setPrimaryKey(indexDef);
                    break;
                }
                case KW_FOREIGN: {
                    this.lexer.nextToken();
                    this.match(MySQLToken.KW_KEY);
                    Identifier id = this.lexer.token() == MySQLToken.IDENTIFIER ? this.identifier() : null;
                    IndexDefinition indexDef = this.indexDefinition();
                    ReferenceDefinition referenceDefinition = this.referenceDefinition();
                    indexDef.setForeignKeyReferenceDefinition(referenceDefinition);
                    stmt.addForeignKey(id, indexDef);
                    break;
                }
                case KW_INDEX: 
                case KW_KEY: {
                    this.lexer.nextToken();
                    Identifier id = this.lexer.token() == MySQLToken.IDENTIFIER ? this.identifier() : null;
                    IndexDefinition indexDef = this.indexDefinition();
                    stmt.addIndex(id, indexDef);
                    break;
                }
                case KW_UNIQUE: {
                    switch (this.lexer.nextToken()) {
                        case KW_INDEX: 
                        case KW_KEY: {
                            this.lexer.nextToken();
                            break;
                        }
                    }
                    Identifier id = this.lexer.token() == MySQLToken.IDENTIFIER ? this.identifier() : null;
                    IndexDefinition indexDef = this.indexDefinition();
                    stmt.addUniqueIndex(id, indexDef);
                    break;
                }
                case KW_FULLTEXT: {
                    switch (this.lexer.nextToken()) {
                        case KW_INDEX: 
                        case KW_KEY: {
                            this.lexer.nextToken();
                            break;
                        }
                    }
                    Identifier id = this.lexer.token() == MySQLToken.IDENTIFIER ? this.identifier() : null;
                    IndexDefinition indexDef = this.indexDefinition();
                    if (indexDef.getIndexType() != null) {
                        throw new SQLSyntaxErrorException("FULLTEXT INDEX can specify no index_type");
                    }
                    stmt.addFullTextIndex(id, indexDef);
                    break;
                }
                case KW_SPATIAL: {
                    switch (this.lexer.nextToken()) {
                        case KW_INDEX: 
                        case KW_KEY: {
                            this.lexer.nextToken();
                            break;
                        }
                    }
                    Identifier id = this.lexer.token() == MySQLToken.IDENTIFIER ? this.identifier() : null;
                    IndexDefinition indexDef = this.indexDefinition();
                    if (indexDef.getIndexType() != null) {
                        throw new SQLSyntaxErrorException("SPATIAL INDEX can specify no index_type");
                    }
                    stmt.addSpatialIndex(id, indexDef);
                    break;
                }
                case KW_CHECK: {
                    this.lexer.nextToken();
                    this.match(MySQLToken.PUNC_LEFT_PAREN);
                    Expression expr = this.exprParser.expression();
                    this.match(MySQLToken.PUNC_RIGHT_PAREN);
                    stmt.addCheck(expr);
                    break;
                }
                case KW_LIKE: {
                    this.lexer.nextToken();
                    Identifier old_tbl_name = this.identifier();
                    stmt.setOldTblName(old_tbl_name);
                    break;
                }
                case IDENTIFIER: {
                    Identifier columnName = this.identifier();
                    ColumnDefinition columnDef = this.columnDefinition();
                    if (columnDef.getSpecialIndex() != null) {
                        ArrayList<IndexColumnName> columns = new ArrayList<IndexColumnName>(1);
                        columns.add(new IndexColumnName(columnName, null, true));
                        switch (columnDef.getSpecialIndex()) {
                            case PRIMARY: {
                                break;
                            }
                            case UNIQUE: {
                                break;
                            }
                            default: {
                                throw new SQLSyntaxErrorException("Not support index type defined in column " + columnName.getIdTextUnescape());
                            }
                        }
                    }
                    stmt.addColumnDefinition(columnName, columnDef);
                    break;
                }
                default: {
                    throw new SQLSyntaxErrorException("unsupportted column definition");
                }
            }
            ++i;
        }
        this.match(MySQLToken.PUNC_RIGHT_PAREN);
    }

    private IndexDefinition indexDefinition() throws SQLSyntaxErrorException {
        IndexDefinition.IndexType indexType = null;
        ArrayList<IndexColumnName> columns = new ArrayList<IndexColumnName>(1);
        if (this.lexer.token() == MySQLToken.KW_USING) {
            this.lexer.nextToken();
            int tp = this.matchIdentifier("BTREE", "HASH");
            indexType = tp == 0 ? IndexDefinition.IndexType.BTREE : IndexDefinition.IndexType.HASH;
        }
        this.match(MySQLToken.PUNC_LEFT_PAREN);
        int i = 0;
        while (this.lexer.token() != MySQLToken.PUNC_RIGHT_PAREN) {
            if (i > 0) {
                this.match(MySQLToken.PUNC_COMMA);
            }
            IndexColumnName indexColumnName = this.indexColumnName();
            columns.add(indexColumnName);
            ++i;
        }
        this.match(MySQLToken.PUNC_RIGHT_PAREN);
        List<IndexOption> options = this.indexOptions();
        return new IndexDefinition(indexType, columns, options);
    }

    private ReferenceDefinition referenceDefinition() throws SQLSyntaxErrorException {
        Identifier tblName = null;
        ArrayList<IndexColumnName> columns = new ArrayList<IndexColumnName>();
        ReferenceDefinition.MatchType matchType = null;
        ReferenceOption.OnType onType = null;
        ReferenceOption.ReferenceOptionType referenceOptionType = null;
        this.match(MySQLToken.KW_REFERENCES);
        tblName = this.identifier();
        this.match(MySQLToken.PUNC_LEFT_PAREN);
        int i = 0;
        while (this.lexer.token() != MySQLToken.PUNC_RIGHT_PAREN) {
            if (i > 0) {
                this.match(MySQLToken.PUNC_COMMA);
            }
            IndexColumnName indexColumnName = this.indexColumnName();
            columns.add(indexColumnName);
            ++i;
        }
        this.match(MySQLToken.PUNC_RIGHT_PAREN);
        if (this.lexer.token() == MySQLToken.KW_MATCH) {
            this.match(MySQLToken.KW_MATCH);
            String tempStrUp = this.lexer.stringValueUppercase();
            SpecialIdentifier tempSi = specialIdentifiers.get(tempStrUp);
            if (tempSi == null) {
                throw new SQLSyntaxErrorException("MATCH option is invalid");
            }
            this.lexer.nextToken();
            switch (tempSi) {
                case FULL: {
                    matchType = ReferenceDefinition.MatchType.MATCH_FULL;
                    break;
                }
                case PARTIAL: {
                    matchType = ReferenceDefinition.MatchType.MATCH_PARTIAL;
                    break;
                }
                case SIMPLE: {
                    matchType = ReferenceDefinition.MatchType.MATCH_SIMPLE;
                    break;
                }
                default: {
                    throw new SQLSyntaxErrorException("MATCH option is invalid");
                }
            }
        }
        ArrayList<ReferenceOption> referenceOptions = new ArrayList<ReferenceOption>();
        for (int i2 = 0; i2 < 2; ++i2) {
            if (this.lexer.token() != MySQLToken.KW_ON) continue;
            this.match(MySQLToken.KW_ON);
            if (this.lexer.token() == MySQLToken.KW_DELETE) {
                this.match(MySQLToken.KW_DELETE);
                onType = ReferenceOption.OnType.ON_DELETE;
            } else if (this.lexer.token() == MySQLToken.KW_UPDATE) {
                this.match(MySQLToken.KW_UPDATE);
                onType = ReferenceOption.OnType.ON_UPDATE;
            } else {
                throw new SQLSyntaxErrorException("ON option is invalid");
            }
            if (this.lexer.token() == MySQLToken.KW_RESTRICT) {
                this.match(MySQLToken.KW_RESTRICT);
                referenceOptionType = ReferenceOption.ReferenceOptionType.RESTRICT;
            } else if (this.lexer.token() == MySQLToken.KW_CASCADE) {
                this.match(MySQLToken.KW_CASCADE);
                referenceOptionType = ReferenceOption.ReferenceOptionType.CASCADE;
            } else if (this.lexer.token() == MySQLToken.KW_SET) {
                this.match(MySQLToken.KW_SET);
                this.match(MySQLToken.LITERAL_NULL);
                referenceOptionType = ReferenceOption.ReferenceOptionType.SET_NULL;
            } else if (specialIdentifiers.get(this.lexer.stringValueUppercase()) == SpecialIdentifier.NO) {
                this.matchIdentifier("NO");
                this.matchIdentifier("ACTION");
                referenceOptionType = ReferenceOption.ReferenceOptionType.NO_ACTION;
            }
            referenceOptions.add(new ReferenceOption(onType, referenceOptionType));
        }
        return new ReferenceDefinition(tblName, columns, matchType, referenceOptions);
    }

    private List<IndexOption> indexOptions() throws SQLSyntaxErrorException {
        ArrayList<IndexOption> list = null;
        block9: while (true) {
            switch (this.lexer.token()) {
                case KW_USING: {
                    IndexOption.IndexType indexType;
                    this.lexer.nextToken();
                    IndexOption.IndexType indexType2 = indexType = this.matchIdentifier("BTREE", "HASH") == 0 ? IndexOption.IndexType.BTREE : IndexOption.IndexType.HASH;
                    if (list == null) {
                        list = new ArrayList(1);
                    }
                    list.add(new IndexOption(indexType));
                    continue block9;
                }
                case KW_WITH: {
                    this.lexer.nextToken();
                    this.matchIdentifier("PARSER");
                    Identifier id = this.identifier();
                    if (list == null) {
                        list = new ArrayList<IndexOption>(1);
                    }
                    list.add(new IndexOption(id));
                    continue block9;
                }
                case IDENTIFIER: {
                    SpecialIdentifier si = specialIdentifiers.get(this.lexer.stringValueUppercase());
                    if (si == null) break block9;
                    switch (si) {
                        case KEY_BLOCK_SIZE: {
                            this.lexer.nextToken();
                            if (this.lexer.token() == MySQLToken.OP_EQUALS) {
                                this.lexer.nextToken();
                            }
                            Expression val = this.exprParser.valueExpression();
                            if (list == null) {
                                list = new ArrayList(1);
                            }
                            list.add(new IndexOption(val));
                            continue block9;
                        }
                        case COMMENT: {
                            this.lexer.nextToken();
                            LiteralString string = (LiteralString)this.exprParser.valueExpression();
                            if (list == null) {
                                list = new ArrayList(1);
                            }
                            list.add(new IndexOption(string));
                            continue block9;
                        }
                    }
                }
            }
            break;
        }
        return list;
    }

    private IndexColumnName indexColumnName() throws SQLSyntaxErrorException {
        Identifier colName = this.identifier();
        Expression len = null;
        if (this.lexer.token() == MySQLToken.PUNC_LEFT_PAREN) {
            this.lexer.nextToken();
            len = this.exprParser.valueExpression();
            this.match(MySQLToken.PUNC_RIGHT_PAREN);
        }
        switch (this.lexer.token()) {
            case KW_ASC: {
                this.lexer.nextToken();
                return new IndexColumnName(colName, len, true);
            }
            case KW_DESC: {
                this.lexer.nextToken();
                return new IndexColumnName(colName, len, false);
            }
        }
        return new IndexColumnName(colName, len, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    private DataType dataType() throws SQLSyntaxErrorException {
        DataType.DataTypeName typeName = null;
        boolean unsigned = false;
        boolean zerofill = false;
        boolean binary = false;
        Expression length = null;
        Expression decimals = null;
        Identifier charSet = null;
        Identifier collation = null;
        ArrayList<Expression> collectionVals = null;
        Expression fsp = null;
        switch (this.lexer.token()) {
            case KW_TINYINT: {
                typeName = DataType.DataTypeName.TINYINT;
                if (this.lexer.nextToken() == MySQLToken.PUNC_LEFT_PAREN) {
                    this.lexer.nextToken();
                    length = this.exprParser.valueExpression();
                    this.match(MySQLToken.PUNC_RIGHT_PAREN);
                }
                if (this.lexer.token() == MySQLToken.KW_UNSIGNED) {
                    unsigned = true;
                    this.lexer.nextToken();
                }
                if (this.lexer.token() != MySQLToken.KW_ZEROFILL) return new DataType(typeName, unsigned, zerofill, binary, length, decimals, charSet, collation, collectionVals, fsp);
                zerofill = true;
                this.lexer.nextToken();
                return new DataType(typeName, unsigned, zerofill, binary, length, decimals, charSet, collation, collectionVals, fsp);
            }
            case KW_SMALLINT: {
                typeName = DataType.DataTypeName.SMALLINT;
                if (this.lexer.nextToken() == MySQLToken.PUNC_LEFT_PAREN) {
                    this.lexer.nextToken();
                    length = this.exprParser.valueExpression();
                    this.match(MySQLToken.PUNC_RIGHT_PAREN);
                }
                if (this.lexer.token() == MySQLToken.KW_UNSIGNED) {
                    unsigned = true;
                    this.lexer.nextToken();
                }
                if (this.lexer.token() != MySQLToken.KW_ZEROFILL) return new DataType(typeName, unsigned, zerofill, binary, length, decimals, charSet, collation, collectionVals, fsp);
                zerofill = true;
                this.lexer.nextToken();
                return new DataType(typeName, unsigned, zerofill, binary, length, decimals, charSet, collation, collectionVals, fsp);
            }
            case KW_MEDIUMINT: {
                typeName = DataType.DataTypeName.MEDIUMINT;
                if (this.lexer.nextToken() == MySQLToken.PUNC_LEFT_PAREN) {
                    this.lexer.nextToken();
                    length = this.exprParser.valueExpression();
                    this.match(MySQLToken.PUNC_RIGHT_PAREN);
                }
                if (this.lexer.token() == MySQLToken.KW_UNSIGNED) {
                    unsigned = true;
                    this.lexer.nextToken();
                }
                if (this.lexer.token() != MySQLToken.KW_ZEROFILL) return new DataType(typeName, unsigned, zerofill, binary, length, decimals, charSet, collation, collectionVals, fsp);
                zerofill = true;
                this.lexer.nextToken();
                return new DataType(typeName, unsigned, zerofill, binary, length, decimals, charSet, collation, collectionVals, fsp);
            }
            case KW_INTEGER: 
            case KW_INT: {
                typeName = DataType.DataTypeName.INT;
                if (this.lexer.nextToken() == MySQLToken.PUNC_LEFT_PAREN) {
                    this.lexer.nextToken();
                    length = this.exprParser.valueExpression();
                    this.match(MySQLToken.PUNC_RIGHT_PAREN);
                }
                if (this.lexer.token() == MySQLToken.KW_UNSIGNED) {
                    unsigned = true;
                    this.lexer.nextToken();
                }
                if (this.lexer.token() != MySQLToken.KW_ZEROFILL) return new DataType(typeName, unsigned, zerofill, binary, length, decimals, charSet, collation, collectionVals, fsp);
                zerofill = true;
                this.lexer.nextToken();
                return new DataType(typeName, unsigned, zerofill, binary, length, decimals, charSet, collation, collectionVals, fsp);
            }
            case KW_BIGINT: {
                typeName = DataType.DataTypeName.BIGINT;
                if (this.lexer.nextToken() == MySQLToken.PUNC_LEFT_PAREN) {
                    this.lexer.nextToken();
                    length = this.exprParser.valueExpression();
                    this.match(MySQLToken.PUNC_RIGHT_PAREN);
                }
                if (this.lexer.token() == MySQLToken.KW_UNSIGNED) {
                    unsigned = true;
                    this.lexer.nextToken();
                }
                if (this.lexer.token() != MySQLToken.KW_ZEROFILL) return new DataType(typeName, unsigned, zerofill, binary, length, decimals, charSet, collation, collectionVals, fsp);
                zerofill = true;
                this.lexer.nextToken();
                return new DataType(typeName, unsigned, zerofill, binary, length, decimals, charSet, collation, collectionVals, fsp);
            }
            case KW_REAL: {
                typeName = DataType.DataTypeName.REAL;
                if (this.lexer.nextToken() == MySQLToken.PUNC_LEFT_PAREN) {
                    this.lexer.nextToken();
                    length = this.exprParser.valueExpression();
                    this.match(MySQLToken.PUNC_COMMA);
                    decimals = this.exprParser.valueExpression();
                    this.match(MySQLToken.PUNC_RIGHT_PAREN);
                }
                if (this.lexer.token() == MySQLToken.KW_UNSIGNED) {
                    unsigned = true;
                    this.lexer.nextToken();
                }
                if (this.lexer.token() != MySQLToken.KW_ZEROFILL) return new DataType(typeName, unsigned, zerofill, binary, length, decimals, charSet, collation, collectionVals, fsp);
                zerofill = true;
                this.lexer.nextToken();
                return new DataType(typeName, unsigned, zerofill, binary, length, decimals, charSet, collation, collectionVals, fsp);
            }
            case KW_DOUBLE: {
                typeName = DataType.DataTypeName.DOUBLE;
                if (this.lexer.nextToken() == MySQLToken.PUNC_LEFT_PAREN) {
                    this.lexer.nextToken();
                    length = this.exprParser.valueExpression();
                    this.match(MySQLToken.PUNC_COMMA);
                    decimals = this.exprParser.valueExpression();
                    this.match(MySQLToken.PUNC_RIGHT_PAREN);
                }
                if (this.lexer.token() == MySQLToken.KW_UNSIGNED) {
                    unsigned = true;
                    this.lexer.nextToken();
                }
                if (this.lexer.token() != MySQLToken.KW_ZEROFILL) return new DataType(typeName, unsigned, zerofill, binary, length, decimals, charSet, collation, collectionVals, fsp);
                zerofill = true;
                this.lexer.nextToken();
                return new DataType(typeName, unsigned, zerofill, binary, length, decimals, charSet, collation, collectionVals, fsp);
            }
            case KW_FLOAT: {
                typeName = DataType.DataTypeName.FLOAT;
                if (this.lexer.nextToken() == MySQLToken.PUNC_LEFT_PAREN) {
                    this.lexer.nextToken();
                    length = this.exprParser.valueExpression();
                    if (this.lexer.token() == MySQLToken.PUNC_COMMA) {
                        this.match(MySQLToken.PUNC_COMMA);
                        decimals = this.exprParser.valueExpression();
                    }
                    this.match(MySQLToken.PUNC_RIGHT_PAREN);
                }
                if (this.lexer.token() == MySQLToken.KW_UNSIGNED) {
                    unsigned = true;
                    this.lexer.nextToken();
                }
                if (this.lexer.token() != MySQLToken.KW_ZEROFILL) return new DataType(typeName, unsigned, zerofill, binary, length, decimals, charSet, collation, collectionVals, fsp);
                zerofill = true;
                this.lexer.nextToken();
                return new DataType(typeName, unsigned, zerofill, binary, length, decimals, charSet, collation, collectionVals, fsp);
            }
            case KW_NUMERIC: 
            case KW_DECIMAL: 
            case KW_DEC: {
                typeName = DataType.DataTypeName.DECIMAL;
                if (this.lexer.nextToken() == MySQLToken.PUNC_LEFT_PAREN) {
                    this.lexer.nextToken();
                    length = this.exprParser.valueExpression();
                    if (this.lexer.token() == MySQLToken.PUNC_COMMA) {
                        this.match(MySQLToken.PUNC_COMMA);
                        decimals = this.exprParser.valueExpression();
                    }
                    this.match(MySQLToken.PUNC_RIGHT_PAREN);
                }
                if (this.lexer.token() == MySQLToken.KW_UNSIGNED) {
                    unsigned = true;
                    this.lexer.nextToken();
                }
                if (this.lexer.token() != MySQLToken.KW_ZEROFILL) return new DataType(typeName, unsigned, zerofill, binary, length, decimals, charSet, collation, collectionVals, fsp);
                zerofill = true;
                this.lexer.nextToken();
                return new DataType(typeName, unsigned, zerofill, binary, length, decimals, charSet, collation, collectionVals, fsp);
            }
            case KW_CHAR: {
                typeName = DataType.DataTypeName.CHAR;
                if (this.lexer.nextToken() == MySQLToken.PUNC_LEFT_PAREN) {
                    this.lexer.nextToken();
                    length = this.exprParser.valueExpression();
                    this.match(MySQLToken.PUNC_RIGHT_PAREN);
                }
                if (this.lexer.token() == MySQLToken.KW_BINARY) {
                    this.match(MySQLToken.KW_BINARY);
                    binary = true;
                }
                if (this.lexer.token() == MySQLToken.KW_CHARACTER) {
                    this.lexer.nextToken();
                    this.match(MySQLToken.KW_SET);
                    charSet = this.identifier();
                }
                if (this.lexer.token() != MySQLToken.KW_COLLATE) return new DataType(typeName, unsigned, zerofill, binary, length, decimals, charSet, collation, collectionVals, fsp);
                this.lexer.nextToken();
                collation = this.identifier();
                return new DataType(typeName, unsigned, zerofill, binary, length, decimals, charSet, collation, collectionVals, fsp);
            }
            case KW_NCHAR: {
                typeName = DataType.DataTypeName.NCHAR;
                if (this.lexer.nextToken() == MySQLToken.PUNC_LEFT_PAREN) {
                    this.lexer.nextToken();
                    length = this.exprParser.valueExpression();
                    this.match(MySQLToken.PUNC_RIGHT_PAREN);
                }
                if (this.lexer.token() == MySQLToken.KW_BINARY) {
                    this.match(MySQLToken.KW_BINARY);
                    binary = true;
                }
                if (this.lexer.token() == MySQLToken.KW_CHARACTER) {
                    this.lexer.nextToken();
                    this.match(MySQLToken.KW_SET);
                    charSet = this.identifier();
                }
                if (this.lexer.token() != MySQLToken.KW_COLLATE) return new DataType(typeName, unsigned, zerofill, binary, length, decimals, charSet, collation, collectionVals, fsp);
                this.lexer.nextToken();
                collation = this.identifier();
                return new DataType(typeName, unsigned, zerofill, binary, length, decimals, charSet, collation, collectionVals, fsp);
            }
            case KW_VARCHAR: {
                typeName = DataType.DataTypeName.VARCHAR;
                this.lexer.nextToken();
                this.match(MySQLToken.PUNC_LEFT_PAREN);
                length = this.exprParser.valueExpression();
                this.match(MySQLToken.PUNC_RIGHT_PAREN);
                if (this.lexer.token() == MySQLToken.KW_BINARY) {
                    this.lexer.nextToken();
                    binary = true;
                }
                if (this.lexer.token() == MySQLToken.KW_CHARACTER) {
                    this.lexer.nextToken();
                    this.match(MySQLToken.KW_SET);
                    charSet = this.identifier();
                }
                if (this.lexer.token() != MySQLToken.KW_COLLATE) return new DataType(typeName, unsigned, zerofill, binary, length, decimals, charSet, collation, collectionVals, fsp);
                this.lexer.nextToken();
                collation = this.identifier();
                return new DataType(typeName, unsigned, zerofill, binary, length, decimals, charSet, collation, collectionVals, fsp);
            }
            case KW_NVARCHAR: {
                typeName = DataType.DataTypeName.NVARCHAR;
                this.lexer.nextToken();
                this.match(MySQLToken.PUNC_LEFT_PAREN);
                length = this.exprParser.valueExpression();
                this.match(MySQLToken.PUNC_RIGHT_PAREN);
                if (this.lexer.token() == MySQLToken.KW_BINARY) {
                    this.lexer.nextToken();
                    binary = true;
                }
                if (this.lexer.token() == MySQLToken.KW_CHARACTER) {
                    this.lexer.nextToken();
                    this.match(MySQLToken.KW_SET);
                    charSet = this.identifier();
                }
                if (this.lexer.token() != MySQLToken.KW_COLLATE) return new DataType(typeName, unsigned, zerofill, binary, length, decimals, charSet, collation, collectionVals, fsp);
                this.lexer.nextToken();
                collation = this.identifier();
                return new DataType(typeName, unsigned, zerofill, binary, length, decimals, charSet, collation, collectionVals, fsp);
            }
            case KW_BINARY: {
                typeName = DataType.DataTypeName.BINARY;
                if (this.lexer.nextToken() != MySQLToken.PUNC_LEFT_PAREN) return new DataType(typeName, unsigned, zerofill, binary, length, decimals, charSet, collation, collectionVals, fsp);
                this.lexer.nextToken();
                length = this.exprParser.valueExpression();
                this.match(MySQLToken.PUNC_RIGHT_PAREN);
                return new DataType(typeName, unsigned, zerofill, binary, length, decimals, charSet, collation, collectionVals, fsp);
            }
            case KW_VARBINARY: {
                typeName = DataType.DataTypeName.VARBINARY;
                this.lexer.nextToken();
                this.match(MySQLToken.PUNC_LEFT_PAREN);
                length = this.exprParser.valueExpression();
                this.match(MySQLToken.PUNC_RIGHT_PAREN);
                return new DataType(typeName, unsigned, zerofill, binary, length, decimals, charSet, collation, collectionVals, fsp);
            }
            case KW_TINYBLOB: {
                typeName = DataType.DataTypeName.TINYBLOB;
                this.lexer.nextToken();
                return new DataType(typeName, unsigned, zerofill, binary, length, decimals, charSet, collation, collectionVals, fsp);
            }
            case KW_BLOB: {
                typeName = DataType.DataTypeName.BLOB;
                this.lexer.nextToken();
                return new DataType(typeName, unsigned, zerofill, binary, length, decimals, charSet, collation, collectionVals, fsp);
            }
            case KW_MEDIUMBLOB: {
                typeName = DataType.DataTypeName.MEDIUMBLOB;
                this.lexer.nextToken();
                return new DataType(typeName, unsigned, zerofill, binary, length, decimals, charSet, collation, collectionVals, fsp);
            }
            case KW_LONGBLOB: {
                typeName = DataType.DataTypeName.LONGBLOB;
                this.lexer.nextToken();
                return new DataType(typeName, unsigned, zerofill, binary, length, decimals, charSet, collation, collectionVals, fsp);
            }
            case KW_TINYTEXT: {
                typeName = DataType.DataTypeName.TINYTEXT;
                if (this.lexer.nextToken() == MySQLToken.KW_BINARY) {
                    this.lexer.nextToken();
                    binary = true;
                }
                if (this.lexer.token() == MySQLToken.KW_CHARACTER) {
                    this.lexer.nextToken();
                    this.match(MySQLToken.KW_SET);
                    charSet = this.identifier();
                }
                if (this.lexer.token() != MySQLToken.KW_COLLATE) return new DataType(typeName, unsigned, zerofill, binary, length, decimals, charSet, collation, collectionVals, fsp);
                this.lexer.nextToken();
                collation = this.identifier();
                return new DataType(typeName, unsigned, zerofill, binary, length, decimals, charSet, collation, collectionVals, fsp);
            }
            case KW_MEDIUMTEXT: {
                typeName = DataType.DataTypeName.MEDIUMTEXT;
                if (this.lexer.nextToken() == MySQLToken.KW_BINARY) {
                    this.lexer.nextToken();
                    binary = true;
                }
                if (this.lexer.token() == MySQLToken.KW_CHARACTER) {
                    this.lexer.nextToken();
                    this.match(MySQLToken.KW_SET);
                    charSet = this.identifier();
                }
                if (this.lexer.token() != MySQLToken.KW_COLLATE) return new DataType(typeName, unsigned, zerofill, binary, length, decimals, charSet, collation, collectionVals, fsp);
                this.lexer.nextToken();
                collation = this.identifier();
                return new DataType(typeName, unsigned, zerofill, binary, length, decimals, charSet, collation, collectionVals, fsp);
            }
            case KW_LONGTEXT: {
                typeName = DataType.DataTypeName.LONGTEXT;
                if (this.lexer.nextToken() == MySQLToken.KW_BINARY) {
                    this.lexer.nextToken();
                    binary = true;
                }
                if (this.lexer.token() == MySQLToken.KW_CHARACTER) {
                    this.lexer.nextToken();
                    this.match(MySQLToken.KW_SET);
                    charSet = this.identifier();
                }
                if (this.lexer.token() != MySQLToken.KW_COLLATE) return new DataType(typeName, unsigned, zerofill, binary, length, decimals, charSet, collation, collectionVals, fsp);
                this.lexer.nextToken();
                collation = this.identifier();
                return new DataType(typeName, unsigned, zerofill, binary, length, decimals, charSet, collation, collectionVals, fsp);
            }
            case KW_SET: {
                typeName = DataType.DataTypeName.SET;
                this.lexer.nextToken();
                this.match(MySQLToken.PUNC_LEFT_PAREN);
                int i = 0;
                while (this.lexer.token() != MySQLToken.PUNC_RIGHT_PAREN) {
                    if (i > 0) {
                        this.match(MySQLToken.PUNC_COMMA);
                    } else {
                        collectionVals = new ArrayList<Expression>(2);
                    }
                    collectionVals.add(this.exprParser.valueExpression());
                    ++i;
                }
                this.match(MySQLToken.PUNC_RIGHT_PAREN);
                if (this.lexer.token() == MySQLToken.KW_CHARACTER) {
                    this.lexer.nextToken();
                    this.match(MySQLToken.KW_SET);
                    charSet = this.identifier();
                }
                if (this.lexer.token() != MySQLToken.KW_COLLATE) return new DataType(typeName, unsigned, zerofill, binary, length, decimals, charSet, collation, collectionVals, fsp);
                this.lexer.nextToken();
                collation = this.identifier();
                return new DataType(typeName, unsigned, zerofill, binary, length, decimals, charSet, collation, collectionVals, fsp);
            }
            case IDENTIFIER: {
                SpecialIdentifier si = specialIdentifiers.get(this.lexer.stringValueUppercase());
                if (si == null) return null;
                switch (si) {
                    case BIT: {
                        typeName = DataType.DataTypeName.BIT;
                        if (this.lexer.nextToken() != MySQLToken.PUNC_LEFT_PAREN) return new DataType(typeName, unsigned, zerofill, binary, length, decimals, charSet, collation, collectionVals, fsp);
                        this.lexer.nextToken();
                        length = this.exprParser.valueExpression();
                        this.match(MySQLToken.PUNC_RIGHT_PAREN);
                        return new DataType(typeName, unsigned, zerofill, binary, length, decimals, charSet, collation, collectionVals, fsp);
                    }
                    case DATE: {
                        typeName = DataType.DataTypeName.DATE;
                        this.lexer.nextToken();
                        return new DataType(typeName, unsigned, zerofill, binary, length, decimals, charSet, collation, collectionVals, fsp);
                    }
                    case TIME: {
                        typeName = DataType.DataTypeName.TIME;
                        if (this.lexer.nextToken() != MySQLToken.PUNC_LEFT_PAREN) return new DataType(typeName, unsigned, zerofill, binary, length, decimals, charSet, collation, collectionVals, fsp);
                        this.lexer.nextToken();
                        fsp = this.exprParser.valueExpression();
                        this.match(MySQLToken.PUNC_RIGHT_PAREN);
                        return new DataType(typeName, unsigned, zerofill, binary, length, decimals, charSet, collation, collectionVals, fsp);
                    }
                    case TIMESTAMP: {
                        typeName = DataType.DataTypeName.TIMESTAMP;
                        if (this.lexer.nextToken() != MySQLToken.PUNC_LEFT_PAREN) return new DataType(typeName, unsigned, zerofill, binary, length, decimals, charSet, collation, collectionVals, fsp);
                        this.lexer.nextToken();
                        fsp = this.exprParser.valueExpression();
                        this.match(MySQLToken.PUNC_RIGHT_PAREN);
                        return new DataType(typeName, unsigned, zerofill, binary, length, decimals, charSet, collation, collectionVals, fsp);
                    }
                    case DATETIME: {
                        typeName = DataType.DataTypeName.DATETIME;
                        if (this.lexer.nextToken() != MySQLToken.PUNC_LEFT_PAREN) return new DataType(typeName, unsigned, zerofill, binary, length, decimals, charSet, collation, collectionVals, fsp);
                        this.lexer.nextToken();
                        fsp = this.exprParser.valueExpression();
                        this.match(MySQLToken.PUNC_RIGHT_PAREN);
                        return new DataType(typeName, unsigned, zerofill, binary, length, decimals, charSet, collation, collectionVals, fsp);
                    }
                    case YEAR: {
                        typeName = DataType.DataTypeName.YEAR;
                        if (this.lexer.nextToken() != MySQLToken.PUNC_LEFT_PAREN) return new DataType(typeName, unsigned, zerofill, binary, length, decimals, charSet, collation, collectionVals, fsp);
                        this.lexer.nextToken();
                        length = this.exprParser.valueExpression();
                        this.match(MySQLToken.PUNC_RIGHT_PAREN);
                        return new DataType(typeName, unsigned, zerofill, binary, length, decimals, charSet, collation, collectionVals, fsp);
                    }
                    case TEXT: {
                        typeName = DataType.DataTypeName.TEXT;
                        if (this.lexer.nextToken() == MySQLToken.PUNC_LEFT_PAREN) {
                            this.lexer.nextToken();
                            length = this.exprParser.valueExpression();
                            this.match(MySQLToken.PUNC_RIGHT_PAREN);
                        }
                        if (this.lexer.token() == MySQLToken.KW_BINARY) {
                            this.lexer.nextToken();
                            binary = true;
                        }
                        if (this.lexer.token() == MySQLToken.KW_CHARACTER) {
                            this.lexer.nextToken();
                            this.match(MySQLToken.KW_SET);
                            charSet = this.identifier();
                        }
                        if (this.lexer.token() != MySQLToken.KW_COLLATE) return new DataType(typeName, unsigned, zerofill, binary, length, decimals, charSet, collation, collectionVals, fsp);
                        this.lexer.nextToken();
                        collation = this.identifier();
                        return new DataType(typeName, unsigned, zerofill, binary, length, decimals, charSet, collation, collectionVals, fsp);
                    }
                    case ENUM: {
                        typeName = DataType.DataTypeName.ENUM;
                        this.lexer.nextToken();
                        this.match(MySQLToken.PUNC_LEFT_PAREN);
                        int i = 0;
                        while (this.lexer.token() != MySQLToken.PUNC_RIGHT_PAREN) {
                            if (i > 0) {
                                this.match(MySQLToken.PUNC_COMMA);
                            } else {
                                collectionVals = new ArrayList(2);
                            }
                            collectionVals.add(this.exprParser.valueExpression());
                            ++i;
                        }
                        this.match(MySQLToken.PUNC_RIGHT_PAREN);
                        if (this.lexer.token() == MySQLToken.KW_CHARACTER) {
                            this.lexer.nextToken();
                            this.match(MySQLToken.KW_SET);
                            charSet = this.identifier();
                        }
                        if (this.lexer.token() != MySQLToken.KW_COLLATE) return new DataType(typeName, unsigned, zerofill, binary, length, decimals, charSet, collation, collectionVals, fsp);
                        this.lexer.nextToken();
                        collation = this.identifier();
                        return new DataType(typeName, unsigned, zerofill, binary, length, decimals, charSet, collation, collectionVals, fsp);
                    }
                    case BOOL: 
                    case BOOLEAN: {
                        this.lexer.nextToken();
                        typeName = DataType.DataTypeName.TINYINT;
                        length = new LiteralNumber(1);
                        return new DataType(typeName, unsigned, zerofill, binary, length, decimals, charSet, collation, collectionVals, fsp);
                    }
                    case GEOMETRY: {
                        this.lexer.nextToken();
                        typeName = DataType.DataTypeName.GEOMETRY;
                        return new DataType(typeName, unsigned, zerofill, binary, length, decimals, charSet, collation, collectionVals, fsp);
                    }
                    case POINT: {
                        this.lexer.nextToken();
                        typeName = DataType.DataTypeName.POINT;
                        return new DataType(typeName, unsigned, zerofill, binary, length, decimals, charSet, collation, collectionVals, fsp);
                    }
                    case LINESTRING: {
                        this.lexer.nextToken();
                        typeName = DataType.DataTypeName.LINESTRING;
                        return new DataType(typeName, unsigned, zerofill, binary, length, decimals, charSet, collation, collectionVals, fsp);
                    }
                    case POLYGON: {
                        this.lexer.nextToken();
                        typeName = DataType.DataTypeName.POLYGON;
                        return new DataType(typeName, unsigned, zerofill, binary, length, decimals, charSet, collation, collectionVals, fsp);
                    }
                    case MULTIPOINT: {
                        this.lexer.nextToken();
                        typeName = DataType.DataTypeName.MULTIPOINT;
                        return new DataType(typeName, unsigned, zerofill, binary, length, decimals, charSet, collation, collectionVals, fsp);
                    }
                    case MULTILINESTRING: {
                        this.lexer.nextToken();
                        typeName = DataType.DataTypeName.MULTILINESTRING;
                        return new DataType(typeName, unsigned, zerofill, binary, length, decimals, charSet, collation, collectionVals, fsp);
                    }
                    case MULTIPOLYGON: {
                        this.lexer.nextToken();
                        typeName = DataType.DataTypeName.MULTIPOLYGON;
                        return new DataType(typeName, unsigned, zerofill, binary, length, decimals, charSet, collation, collectionVals, fsp);
                    }
                    case GEOMETRYCOLLECTION: {
                        this.lexer.nextToken();
                        typeName = DataType.DataTypeName.GEOMETRYCOLLECTION;
                        return new DataType(typeName, unsigned, zerofill, binary, length, decimals, charSet, collation, collectionVals, fsp);
                    }
                }
            }
        }
        return null;
    }

    private ColumnDefinition columnDefinition() throws SQLSyntaxErrorException {
        DataType dataType = this.dataType();
        ColumnDefinition.ColumnNull columnNull = null;
        Expression defaultVal = null;
        boolean autoIncrement = false;
        ColumnDefinition.SpecialIndex sindex = null;
        ColumnDefinition.ColumnFormat format = null;
        LiteralString comment = null;
        ColumnDefinition.Storage storage = null;
        ReferenceDefinition referenceDefinition = null;
        boolean onUpdateCurrentTimestamp = false;
        block31: while (this.lexer.token() != MySQLToken.PUNC_COMMA && this.lexer.token() != MySQLToken.PUNC_RIGHT_PAREN && this.lexer.token() != MySQLToken.EOF) {
            switch (this.lexer.token()) {
                case KW_NOT: {
                    this.lexer.nextToken();
                    this.match(MySQLToken.LITERAL_NULL);
                    columnNull = ColumnDefinition.ColumnNull.NOTNULL;
                    continue block31;
                }
                case LITERAL_NULL: {
                    this.lexer.nextToken();
                    columnNull = ColumnDefinition.ColumnNull.NULL;
                    if (this.lexer.token() != MySQLToken.KW_ON) continue block31;
                    this.match(MySQLToken.KW_ON);
                    this.match(MySQLToken.KW_UPDATE);
                    this.match(MySQLToken.KW_CURRENT_TIMESTAMP);
                    onUpdateCurrentTimestamp = true;
                    continue block31;
                }
                case KW_DEFAULT: {
                    this.lexer.nextToken();
                    switch (this.lexer.token()) {
                        case KW_CURRENT_TIMESTAMP: {
                            defaultVal = this.exprParser.valueExpression();
                            continue block31;
                        }
                        case KW_CURRENT_DATE: {
                            defaultVal = this.exprParser.valueExpression();
                            continue block31;
                        }
                    }
                    defaultVal = this.exprParser.valueExpression();
                    if (defaultVal instanceof Literal || defaultVal instanceof UnaryOperatorExpression) continue block31;
                    throw new SQLSyntaxErrorException("default value of column must be a literal or UnaryOperator: " + defaultVal);
                }
                case KW_ON: {
                    this.lexer.nextToken();
                    this.match(MySQLToken.KW_UPDATE);
                    this.match(MySQLToken.KW_CURRENT_TIMESTAMP);
                    onUpdateCurrentTimestamp = true;
                    continue block31;
                }
                case IDENTIFIER: {
                    SpecialIdentifier si;
                    if ("AUTO_INCREMENT".equals(this.lexer.stringValueUppercase())) {
                        this.lexer.nextToken();
                        autoIncrement = true;
                        continue block31;
                    }
                    if ("COMMENT".equals(this.lexer.stringValueUppercase())) {
                        this.lexer.nextToken();
                        comment = (LiteralString)this.exprParser.valueExpression();
                        continue block31;
                    }
                    if ("COLUMN_FORMAT".equals(this.lexer.stringValueUppercase())) {
                        switch (this.lexer.nextToken()) {
                            case KW_DEFAULT: {
                                this.lexer.nextToken();
                                format = ColumnDefinition.ColumnFormat.DEFAULT;
                                continue block31;
                            }
                            case IDENTIFIER: {
                                si = specialIdentifiers.get(this.lexer.stringValueUppercase());
                                if (si == null) continue block31;
                                switch (si) {
                                    case FIXED: {
                                        this.lexer.nextToken();
                                        format = ColumnDefinition.ColumnFormat.FIXED;
                                        continue block31;
                                    }
                                    case DYNAMIC: {
                                        this.lexer.nextToken();
                                        format = ColumnDefinition.ColumnFormat.DYNAMIC;
                                        continue block31;
                                    }
                                }
                                break block31;
                            }
                        }
                        break block31;
                    }
                    if (!"STORAGE".equals(this.lexer.stringValueUppercase())) break block31;
                    switch (this.lexer.nextToken()) {
                        case KW_DEFAULT: {
                            this.lexer.nextToken();
                            storage = ColumnDefinition.Storage.DEFAULT;
                            continue block31;
                        }
                        case IDENTIFIER: {
                            si = specialIdentifiers.get(this.lexer.stringValueUppercase());
                            if (si == null) continue block31;
                            switch (si) {
                                case DISK: {
                                    this.lexer.nextToken();
                                    storage = ColumnDefinition.Storage.DISK;
                                    continue block31;
                                }
                                case MEMORY: {
                                    this.lexer.nextToken();
                                    storage = ColumnDefinition.Storage.MEMORY;
                                    continue block31;
                                }
                            }
                            break block31;
                        }
                    }
                    break block31;
                }
                case KW_UNIQUE: {
                    if (this.lexer.nextToken() == MySQLToken.KW_KEY) {
                        this.lexer.nextToken();
                    }
                    sindex = ColumnDefinition.SpecialIndex.UNIQUE;
                    continue block31;
                }
                case KW_PRIMARY: {
                    this.lexer.nextToken();
                }
                case KW_KEY: {
                    this.match(MySQLToken.KW_KEY);
                    sindex = ColumnDefinition.SpecialIndex.PRIMARY;
                    continue block31;
                }
                case KW_REFERENCES: {
                    referenceDefinition = this.referenceDefinition();
                    continue block31;
                }
            }
        }
        return new ColumnDefinition(dataType, columnNull, defaultVal, autoIncrement, sindex, comment, format, storage, onUpdateCurrentTimestamp, referenceDefinition);
    }

    private boolean tableOptions(TableOptions options) throws SQLSyntaxErrorException {
        boolean matched = false;
        int i = 0;
        while (true) {
            boolean comma = false;
            if (i > 0 && this.lexer.token() == MySQLToken.PUNC_COMMA) {
                this.lexer.nextToken();
                comma = true;
            }
            if (!this.tableOption(options)) {
                if (!comma) break;
                this.lexer.addCacheToke(MySQLToken.PUNC_COMMA);
                break;
            }
            matched = true;
            ++i;
        }
        return matched;
    }

    private boolean dbPartitionOptions(DBPartitionOptions options) throws SQLSyntaxErrorException {
        if (!("DBPARTITION".equals(this.lexer.stringValueUppercase()) || "TBPARTITION".equals(this.lexer.stringValueUppercase()) || "DBPARTITIONS".equals(this.lexer.stringValueUppercase()))) {
            return true;
        }
        boolean loopend = false;
        boolean processed = false;
        block10: while (!loopend) {
            switch (this.lexer.token()) {
                case PUNC_LEFT_PAREN: {
                    this.match(MySQLToken.PUNC_LEFT_PAREN);
                    this.processDBPartitionDefination(options);
                    this.match(MySQLToken.PUNC_RIGHT_PAREN);
                    continue block10;
                }
                case IDENTIFIER: {
                    String tempStrUp = this.lexer.stringValueUppercase();
                    SpecialIdentifier tempSi = specialIdentifiers.get(tempStrUp);
                    if (tempSi == null) {
                        throw new SQLSyntaxErrorException("dbpartition sql error with " + tempStrUp);
                    }
                    switch (tempSi) {
                        case DBPARTITIONS: {
                            this.lexer.nextToken();
                            if (this.lexer.token() != MySQLToken.LITERAL_NUM_PURE_DIGIT) {
                                throw new SQLSyntaxErrorException("partition of DBPARTITIONS error");
                            }
                            int intVal = this.lexer.integerValue().intValue();
                            options.setDbpartitions(intVal);
                            this.lexer.nextToken();
                            continue block10;
                        }
                        case DBPARTITION: {
                            this.lexer.nextToken();
                            this.match(MySQLToken.KW_BY);
                            this.processDBPartitionType(options);
                            processed = true;
                            continue block10;
                        }
                        case TBPARTITION: {
                            this.lexer.nextToken();
                            this.match(MySQLToken.KW_BY);
                            this.processTBPartitionType(options);
                            continue block10;
                        }
                        case TBPARTITIONS: {
                            this.lexer.nextToken();
                            if (this.lexer.token() != MySQLToken.LITERAL_NUM_PURE_DIGIT) {
                                throw new SQLSyntaxErrorException("partition of TBPARTITIONS error");
                            }
                            int intVal = this.lexer.integerValue().intValue();
                            options.setTbpartitions(intVal);
                            this.lexer.nextToken();
                            continue block10;
                        }
                    }
                    loopend = true;
                    continue block10;
                }
            }
            loopend = true;
        }
        return processed;
    }

    private void processDBPartitionDefination(DBPartitionOptions options) throws SQLSyntaxErrorException {
        if (!"DBPARTITION".equals(this.lexer.stringValueUppercase())) {
            return;
        }
        ArrayList<DBPartitionDefinition> DBPartitionDefinitionList = new ArrayList<DBPartitionDefinition>();
        boolean loopend = false;
        block4: while (!loopend) {
            switch (this.lexer.token()) {
                case IDENTIFIER: {
                    this.matchIdentifier("DBPARTITION");
                    DBPartitionDefinition DBPartitionDefinition2 = new DBPartitionDefinition();
                    this.processDBPartitionDefinition(DBPartitionDefinition2);
                    DBPartitionDefinitionList.add(DBPartitionDefinition2);
                    continue block4;
                }
                case PUNC_COMMA: {
                    this.match(MySQLToken.PUNC_COMMA);
                    continue block4;
                }
            }
            loopend = true;
        }
        options.setDbpartitionDefinitionList(DBPartitionDefinitionList);
    }

    private void processDBPartitionDefinition(DBPartitionDefinition DBPartitionDefinition2) throws SQLSyntaxErrorException {
        if (this.lexer.token() != MySQLToken.PUNC_LEFT_PAREN) {
            Expression partition_name = this.exprParser.freeText();
            DBPartitionDefinition2.setPartition_name(partition_name);
        }
        boolean loopend = false;
        block4: while (!loopend) {
            switch (this.lexer.token()) {
                case KW_VALUES: {
                    this.match(MySQLToken.KW_VALUES);
                    if (this.lexer.token() == MySQLToken.IDENTIFIER && "LESS".equals(this.lexer.stringValueUppercase())) {
                        this.matchIdentifier("LESS");
                        this.matchIdentifier("THAN");
                        Expression expr = this.exprParser.valueExpression();
                        DBPartitionDefinition2.setLessThan(expr);
                        DBPartitionDefinition2.setType(DBPartitionDefinitionType.RANGE);
                        continue block4;
                    }
                    if (this.lexer.token() != MySQLToken.KW_IN) continue block4;
                    this.match(MySQLToken.KW_IN);
                    continue block4;
                }
                case PUNC_LEFT_PAREN: {
                    this.match(MySQLToken.PUNC_LEFT_PAREN);
                    this.processTBPartitionDefination(DBPartitionDefinition2);
                    this.match(MySQLToken.PUNC_RIGHT_PAREN);
                    continue block4;
                }
            }
            loopend = true;
        }
    }

    private void processTBPartitionDefination(DBPartitionDefinition DBPartitionDefinition2) throws SQLSyntaxErrorException {
        if (!"TBPARTITION".equals(this.lexer.stringValueUppercase())) {
            return;
        }
        ArrayList<TBPartitionDefinition> TBPartitionDefinitionList = new ArrayList<TBPartitionDefinition>();
        boolean loopend = false;
        block4: while (!loopend) {
            switch (this.lexer.token()) {
                case IDENTIFIER: {
                    this.matchIdentifier("TBPARTITION");
                    TBPartitionDefinition TBPartitionDefinition2 = new TBPartitionDefinition();
                    this.processTBPartitionDefinition(TBPartitionDefinition2);
                    TBPartitionDefinitionList.add(TBPartitionDefinition2);
                    continue block4;
                }
                case PUNC_COMMA: {
                    this.match(MySQLToken.PUNC_COMMA);
                    continue block4;
                }
            }
            loopend = true;
        }
        DBPartitionDefinition2.setTbpartitionDefinitionList(TBPartitionDefinitionList);
    }

    private void processTBPartitionDefinition(TBPartitionDefinition TBPartitionDefinition2) throws SQLSyntaxErrorException {
        Expression logical_name = this.exprParser.freeText();
        TBPartitionDefinition2.setLogical_name(logical_name);
    }

    private void processTBPartitionType(DBPartitionOptions options) throws SQLSyntaxErrorException {
        TBPartitionBy subpartition = new TBPartitionBy();
        SpecialIdentifier si = specialIdentifiers.get(this.lexer.stringValueUppercase());
        if (si == null) {
            throw new IllegalArgumentException("TBPARTITION type is invalid");
        }
        this.lexer.nextToken();
        switch (si) {
            case HASH: {
                Expression expr = this.freeText();
                subpartition.setColExpr(expr);
                subpartition.setType(PartitionByType.HASH);
                break;
            }
            case MM: {
                Expression expr = this.freeText();
                subpartition.setColExpr(expr);
                subpartition.setType(PartitionByType.MM);
                break;
            }
            case DD: {
                Expression expr = this.freeText();
                subpartition.setColExpr(expr);
                subpartition.setType(PartitionByType.DD);
                break;
            }
            case WEEK: {
                Expression expr = this.freeText();
                subpartition.setColExpr(expr);
                subpartition.setType(PartitionByType.WEEK);
                break;
            }
            case MMDD: {
                Expression expr = this.freeText();
                subpartition.setColExpr(expr);
                subpartition.setType(PartitionByType.MMDD);
                break;
            }
            case YYYYMM: {
                Expression expr = this.freeText();
                subpartition.setColExpr(expr);
                subpartition.setType(PartitionByType.YYYYMM);
                break;
            }
            default: {
                throw new IllegalArgumentException("TBPARTITION type is invalid");
            }
        }
        options.setTbpartitionBy(subpartition);
    }

    private void processDBPartitionType(DBPartitionOptions options) throws SQLSyntaxErrorException {
        DBPartitionBy partition = new DBPartitionBy();
        SpecialIdentifier si = specialIdentifiers.get(this.lexer.stringValueUppercase());
        if (si == null) {
            throw new IllegalArgumentException("DBPARTITION type is invalid");
        }
        this.lexer.nextToken();
        switch (si) {
            case HASH: {
                Expression expr = this.freeText();
                partition.setColExpr(expr);
                partition.setType(PartitionByType.HASH);
                break;
            }
            case MM: {
                Expression expr = this.freeText();
                partition.setColExpr(expr);
                partition.setType(PartitionByType.MM);
                break;
            }
            case DD: {
                Expression expr = this.freeText();
                partition.setColExpr(expr);
                partition.setType(PartitionByType.DD);
                break;
            }
            case WEEK: {
                Expression expr = this.freeText();
                partition.setColExpr(expr);
                partition.setType(PartitionByType.WEEK);
                break;
            }
            case MMDD: {
                Expression expr = this.freeText();
                partition.setColExpr(expr);
                partition.setType(PartitionByType.MMDD);
                break;
            }
            default: {
                throw new IllegalArgumentException("DBPARTITION type is invalid");
            }
        }
        options.setDbpartitionBy(partition);
    }

    private Expression freeText() throws SQLSyntaxErrorException {
        return this.exprParser.freeText();
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean tableOption(TableOptions options) throws SQLSyntaxErrorException {
        Identifier id = null;
        Expression expr = null;
        switch (this.lexer.token()) {
            case KW_CHARACTER: {
                this.lexer.nextToken();
                this.match(MySQLToken.KW_SET);
                if (this.lexer.token() == MySQLToken.OP_EQUALS) {
                    this.lexer.nextToken();
                }
                id = this.identifier();
                options.setCharSet(id);
                switch (this.lexer.token()) {
                    case KW_DEFAULT: {
                        this.lexer.nextToken();
                        if (this.lexer.token() != MySQLToken.KW_COLLATE) return true;
                        this.lexer.nextToken();
                        if (this.lexer.token() == MySQLToken.OP_EQUALS) {
                            this.lexer.nextToken();
                        }
                        id = this.identifier();
                        options.setDefaultCollateWithCharset(true);
                        options.setCollateWithCharset(id);
                        return true;
                    }
                    case KW_COLLATE: {
                        this.lexer.nextToken();
                        if (this.lexer.token() == MySQLToken.OP_EQUALS) {
                            this.lexer.nextToken();
                        }
                        id = this.identifier();
                        options.setCollateWithCharset(id);
                        return true;
                    }
                }
                return true;
            }
            case KW_COLLATE: {
                this.lexer.nextToken();
                if (this.lexer.token() == MySQLToken.OP_EQUALS) {
                    this.lexer.nextToken();
                }
                id = this.identifier();
                options.setCollation(id);
                return true;
            }
            case KW_DEFAULT: {
                switch (this.lexer.nextToken()) {
                    case KW_CHARACTER: {
                        this.lexer.saveCurrentPos();
                        this.lexer.nextToken();
                        this.match(MySQLToken.KW_SET);
                        if (this.lexer.token() == MySQLToken.OP_EQUALS) {
                            this.lexer.nextToken();
                        }
                        id = this.identifier();
                        options.setCharSet(id);
                        options.setDefaultCharset(true);
                        switch (this.lexer.token()) {
                            case KW_DEFAULT: {
                                this.lexer.nextToken();
                                if (this.lexer.token() != MySQLToken.KW_COLLATE) return true;
                                this.lexer.nextToken();
                                if (this.lexer.token() == MySQLToken.OP_EQUALS) {
                                    this.lexer.nextToken();
                                }
                                id = this.identifier();
                                options.setDefaultCollateWithCharset(true);
                                options.setCollateWithCharset(id);
                                return true;
                            }
                            case KW_COLLATE: {
                                this.lexer.nextToken();
                                if (this.lexer.token() == MySQLToken.OP_EQUALS) {
                                    this.lexer.nextToken();
                                }
                                id = this.identifier();
                                options.setCollateWithCharset(id);
                                return true;
                            }
                        }
                        return true;
                    }
                    case KW_COLLATE: {
                        this.lexer.nextToken();
                        if (this.lexer.token() == MySQLToken.OP_EQUALS) {
                            this.lexer.nextToken();
                        }
                        id = this.identifier();
                        options.setCollation(id);
                        options.setDefaultCollate(true);
                        return true;
                    }
                    case IDENTIFIER: {
                        SpecialIdentifier si = specialIdentifiers.get(this.lexer.stringValueUppercase());
                        if (si == null) break;
                        switch (si) {
                            case CHARSET: {
                                this.lexer.nextToken();
                                if (this.lexer.token() == MySQLToken.OP_EQUALS) {
                                    this.lexer.nextToken();
                                }
                                id = this.identifier();
                                options.setCharSet(id);
                                return true;
                            }
                        }
                    }
                }
                this.lexer.addCacheToke(MySQLToken.KW_DEFAULT);
                return false;
            }
            case KW_INDEX: {
                this.lexer.nextToken();
                if (this.lexer.token() == MySQLToken.IDENTIFIER && "DIRECTORY".equals(this.lexer.stringValueUppercase())) {
                    if (this.lexer.nextToken() == MySQLToken.OP_EQUALS) {
                        this.lexer.nextToken();
                    }
                    options.setIndexDir((LiteralString)this.exprParser.valueExpression());
                    return true;
                }
                this.lexer.addCacheToke(MySQLToken.KW_INDEX);
                return true;
            }
            case KW_UNION: {
                if (this.lexer.nextToken() == MySQLToken.OP_EQUALS) {
                    this.lexer.nextToken();
                }
                this.match(MySQLToken.PUNC_LEFT_PAREN);
                ArrayList<Identifier> union = new ArrayList<Identifier>(2);
                int j = 0;
                while (true) {
                    if (this.lexer.token() == MySQLToken.PUNC_RIGHT_PAREN) {
                        this.match(MySQLToken.PUNC_RIGHT_PAREN);
                        options.setUnion(union);
                        return true;
                    }
                    if (j > 0) {
                        this.match(MySQLToken.PUNC_COMMA);
                    }
                    id = this.identifier();
                    union.add(id);
                    ++j;
                }
            }
            case IDENTIFIER: {
                SpecialIdentifier si = specialIdentifiers.get(this.lexer.stringValueUppercase());
                if (si == null) return false;
                switch (si) {
                    case CHARSET: {
                        this.lexer.nextToken();
                        if (this.lexer.token() == MySQLToken.OP_EQUALS) {
                            this.lexer.nextToken();
                        }
                        id = this.identifier();
                        options.setCharSet(id);
                        return true;
                    }
                    case ENGINE: {
                        if (this.lexer.nextToken() == MySQLToken.OP_EQUALS) {
                            this.lexer.nextToken();
                        }
                        id = this.identifier();
                        options.setEngine(id);
                        return true;
                    }
                    case AUTO_INCREMENT: {
                        if (this.lexer.nextToken() == MySQLToken.OP_EQUALS) {
                            this.lexer.nextToken();
                        }
                        expr = this.exprParser.valueExpression();
                        options.setAutoIncrement(expr);
                        return true;
                    }
                    case AVG_ROW_LENGTH: {
                        if (this.lexer.nextToken() == MySQLToken.OP_EQUALS) {
                            this.lexer.nextToken();
                        }
                        expr = this.exprParser.valueExpression();
                        options.setAvgRowLength(expr);
                        return true;
                    }
                    case CHECKSUM: {
                        if (this.lexer.nextToken() == MySQLToken.OP_EQUALS) {
                            this.lexer.nextToken();
                        }
                        switch (this.lexer.token()) {
                            case LITERAL_BOOL_FALSE: {
                                this.lexer.nextToken();
                                options.setCheckSum(false);
                            }
                            case LITERAL_BOOL_TRUE: {
                                this.lexer.nextToken();
                                options.setCheckSum(true);
                                return true;
                            }
                            case LITERAL_NUM_PURE_DIGIT: {
                                int intVal = this.lexer.integerValue().intValue();
                                this.lexer.nextToken();
                                if (intVal == 0) {
                                    options.setCheckSum(false);
                                    return true;
                                }
                                options.setCheckSum(true);
                                return true;
                            }
                        }
                        throw new SQLSyntaxErrorException("table option of CHECKSUM error");
                    }
                    case DELAY_KEY_WRITE: {
                        if (this.lexer.nextToken() == MySQLToken.OP_EQUALS) {
                            this.lexer.nextToken();
                        }
                        switch (this.lexer.token()) {
                            case LITERAL_BOOL_FALSE: {
                                this.lexer.nextToken();
                                options.setDelayKeyWrite(false);
                            }
                            case LITERAL_BOOL_TRUE: {
                                this.lexer.nextToken();
                                options.setDelayKeyWrite(true);
                                return true;
                            }
                            case LITERAL_NUM_PURE_DIGIT: {
                                int intVal = this.lexer.integerValue().intValue();
                                this.lexer.nextToken();
                                if (intVal == 0) {
                                    options.setDelayKeyWrite(false);
                                    return true;
                                }
                                options.setDelayKeyWrite(true);
                                return true;
                            }
                        }
                        throw new SQLSyntaxErrorException("table option of DELAY_KEY_WRITE error");
                    }
                    case COMMENT: {
                        if (this.lexer.nextToken() == MySQLToken.OP_EQUALS) {
                            this.lexer.nextToken();
                        }
                        options.setComment((LiteralString)this.exprParser.valueExpression());
                        return true;
                    }
                    case CONNECTION: {
                        if (this.lexer.nextToken() == MySQLToken.OP_EQUALS) {
                            this.lexer.nextToken();
                        }
                        options.setConnection((LiteralString)this.exprParser.valueExpression());
                        return true;
                    }
                    case DATA: {
                        this.lexer.nextToken();
                        this.matchIdentifier("DIRECTORY");
                        if (this.lexer.token() == MySQLToken.OP_EQUALS) {
                            this.lexer.nextToken();
                        }
                        options.setDataDir((LiteralString)this.exprParser.valueExpression());
                        return true;
                    }
                    case INSERT_METHOD: {
                        if (this.lexer.nextToken() == MySQLToken.OP_EQUALS) {
                            this.lexer.nextToken();
                        }
                        switch (this.matchIdentifier("NO", "FIRST", "LAST")) {
                            case 0: {
                                options.setInsertMethod(TableOptions.InsertMethod.NO);
                                return true;
                            }
                            case 1: {
                                options.setInsertMethod(TableOptions.InsertMethod.FIRST);
                                return true;
                            }
                            case 2: {
                                options.setInsertMethod(TableOptions.InsertMethod.LAST);
                                return true;
                            }
                        }
                        return true;
                    }
                    case KEY_BLOCK_SIZE: {
                        if (this.lexer.nextToken() == MySQLToken.OP_EQUALS) {
                            this.lexer.nextToken();
                        }
                        options.setKeyBlockSize(this.exprParser.valueExpression());
                        return true;
                    }
                    case MAX_ROWS: {
                        if (this.lexer.nextToken() == MySQLToken.OP_EQUALS) {
                            this.lexer.nextToken();
                        }
                        options.setMaxRows(this.exprParser.valueExpression());
                        return true;
                    }
                    case MIN_ROWS: {
                        if (this.lexer.nextToken() == MySQLToken.OP_EQUALS) {
                            this.lexer.nextToken();
                        }
                        options.setMinRows(this.exprParser.valueExpression());
                        return true;
                    }
                    case PACK_KEYS: {
                        if (this.lexer.nextToken() == MySQLToken.OP_EQUALS) {
                            this.lexer.nextToken();
                        }
                        switch (this.lexer.token()) {
                            case LITERAL_BOOL_FALSE: {
                                this.lexer.nextToken();
                                options.setPackKeys(TableOptions.PackKeys.FALSE);
                                return true;
                            }
                            case LITERAL_BOOL_TRUE: {
                                this.lexer.nextToken();
                                options.setPackKeys(TableOptions.PackKeys.TRUE);
                                return true;
                            }
                            case LITERAL_NUM_PURE_DIGIT: {
                                int intVal = this.lexer.integerValue().intValue();
                                this.lexer.nextToken();
                                if (intVal == 0) {
                                    options.setPackKeys(TableOptions.PackKeys.FALSE);
                                    return true;
                                }
                                options.setPackKeys(TableOptions.PackKeys.TRUE);
                                return true;
                            }
                            case KW_DEFAULT: {
                                this.lexer.nextToken();
                                options.setPackKeys(TableOptions.PackKeys.DEFAULT);
                                return true;
                            }
                        }
                        throw new SQLSyntaxErrorException("table option of PACK_KEYS error");
                    }
                    case PASSWORD: {
                        if (this.lexer.nextToken() == MySQLToken.OP_EQUALS) {
                            this.lexer.nextToken();
                        }
                        options.setPassword((LiteralString)this.exprParser.valueExpression());
                        return true;
                    }
                    case STATS_AUTO_RECALC: {
                        if (this.lexer.nextToken() == MySQLToken.OP_EQUALS) {
                            this.lexer.nextToken();
                        }
                        switch (this.lexer.token()) {
                            case LITERAL_BOOL_FALSE: {
                                options.setStatsAutoRecalc(TableOptions.StatsAutoRecalc.FALSE);
                                this.lexer.nextToken();
                                return true;
                            }
                            case LITERAL_BOOL_TRUE: {
                                options.setStatsAutoRecalc(TableOptions.StatsAutoRecalc.TRUE);
                                this.lexer.nextToken();
                                return true;
                            }
                            case LITERAL_NUM_PURE_DIGIT: {
                                int intVal = this.lexer.integerValue().intValue();
                                this.lexer.nextToken();
                                if (intVal == 0) {
                                    options.setStatsAutoRecalc(TableOptions.StatsAutoRecalc.FALSE);
                                    return true;
                                }
                                options.setStatsAutoRecalc(TableOptions.StatsAutoRecalc.TRUE);
                                return true;
                            }
                            case KW_DEFAULT: {
                                options.setStatsAutoRecalc(TableOptions.StatsAutoRecalc.DEFAULT);
                                this.lexer.nextToken();
                                return true;
                            }
                        }
                        throw new SQLSyntaxErrorException("table option of STATS_AUTO_RECALC error");
                    }
                    case STATS_PERSISTENT: {
                        if (this.lexer.nextToken() == MySQLToken.OP_EQUALS) {
                            this.lexer.nextToken();
                        }
                        switch (this.lexer.token()) {
                            case LITERAL_BOOL_FALSE: {
                                options.setStatsPersistent(TableOptions.StatsPersistent.FALSE);
                                this.lexer.nextToken();
                                return true;
                            }
                            case LITERAL_BOOL_TRUE: {
                                options.setStatsPersistent(TableOptions.StatsPersistent.TRUE);
                                this.lexer.nextToken();
                                return true;
                            }
                            case LITERAL_NUM_PURE_DIGIT: {
                                int intVal = this.lexer.integerValue().intValue();
                                this.lexer.nextToken();
                                if (intVal == 0) {
                                    options.setStatsPersistent(TableOptions.StatsPersistent.FALSE);
                                    return true;
                                }
                                options.setStatsPersistent(TableOptions.StatsPersistent.TRUE);
                                return true;
                            }
                            case KW_DEFAULT: {
                                options.setStatsPersistent(TableOptions.StatsPersistent.DEFAULT);
                                this.lexer.nextToken();
                                return true;
                            }
                        }
                        throw new SQLSyntaxErrorException("table option of STATS_PERSISTENT error");
                    }
                    case STATS_SAMPLE_PAGES: {
                        if (this.lexer.nextToken() == MySQLToken.OP_EQUALS) {
                            this.lexer.nextToken();
                        }
                        options.setStatsSamplePages(this.exprParser.valueExpression());
                        return true;
                    }
                    case TABLESPACE: {
                        this.lexer.nextToken();
                        Identifier tablespaceName = this.identifier();
                        options.setTablespaceName(tablespaceName);
                        if (this.lexer.token() != MySQLToken.IDENTIFIER) return true;
                        SpecialIdentifier storage = specialIdentifiers.get(this.lexer.stringValueUppercase());
                        if (storage == null) return true;
                        if (storage != SpecialIdentifier.STORAGE) return true;
                        this.lexer.nextToken();
                        if (this.lexer.token() == MySQLToken.KW_DEFAULT) {
                            options.setTableSpaceStorage(TableOptions.TableSpaceStorage.DEFAULT);
                            this.lexer.nextToken();
                            return true;
                        }
                        storage = specialIdentifiers.get(this.lexer.stringValueUppercase());
                        if (storage == null) return true;
                        switch (storage) {
                            case DISK: {
                                options.setTableSpaceStorage(TableOptions.TableSpaceStorage.DISK);
                                this.lexer.nextToken();
                                return true;
                            }
                            case MEMORY: {
                                options.setTableSpaceStorage(TableOptions.TableSpaceStorage.MEMORY);
                                this.lexer.nextToken();
                                return true;
                            }
                        }
                        throw new SQLSyntaxErrorException("table option of TABLESPACE error");
                    }
                    case ROW_FORMAT: {
                        if (this.lexer.nextToken() == MySQLToken.OP_EQUALS) {
                            this.lexer.nextToken();
                        }
                        switch (this.lexer.token()) {
                            case KW_DEFAULT: {
                                this.lexer.nextToken();
                                options.setRowFormat(TableOptions.RowFormat.DEFAULT);
                                return true;
                            }
                            case IDENTIFIER: {
                                SpecialIdentifier sid = specialIdentifiers.get(this.lexer.stringValueUppercase());
                                if (sid == null) throw new SQLSyntaxErrorException("table option of ROW_FORMAT error");
                                switch (sid) {
                                    case DYNAMIC: {
                                        this.lexer.nextToken();
                                        options.setRowFormat(TableOptions.RowFormat.DYNAMIC);
                                        return true;
                                    }
                                    case FIXED: {
                                        this.lexer.nextToken();
                                        options.setRowFormat(TableOptions.RowFormat.FIXED);
                                        return true;
                                    }
                                    case COMPRESSED: {
                                        this.lexer.nextToken();
                                        options.setRowFormat(TableOptions.RowFormat.COMPRESSED);
                                        return true;
                                    }
                                    case REDUNDANT: {
                                        this.lexer.nextToken();
                                        options.setRowFormat(TableOptions.RowFormat.REDUNDANT);
                                        return true;
                                    }
                                    case COMPACT: {
                                        this.lexer.nextToken();
                                        options.setRowFormat(TableOptions.RowFormat.COMPACT);
                                        return true;
                                    }
                                }
                                throw new SQLSyntaxErrorException("table option of ROW_FORMAT error");
                            }
                        }
                        throw new SQLSyntaxErrorException("table option of ROW_FORMAT error");
                    }
                    case BROADCAST: {
                        this.lexer.nextToken();
                        options.setBroadcast(true);
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private List<Identifier> parseIdentifierList() throws SQLSyntaxErrorException {
        AbstractList columnList;
        Identifier column = this.identifier();
        if (this.lexer.token() != MySQLToken.PUNC_COMMA) {
            columnList = new ArrayList(1);
            columnList.add(column);
        } else {
            columnList = new LinkedList();
            columnList.add(column);
            while (this.lexer.token() == MySQLToken.PUNC_COMMA) {
                this.lexer.nextToken();
                column = this.identifier();
                columnList.add(column);
            }
        }
        return columnList;
    }

    private void parseSubPartitionBy(PartitionOptions partitionOptions) throws SQLSyntaxErrorException {
        SpecialIdentifier sid;
        SubPartitionBy subPartitionBy = new SubPartitionBy();
        this.lexer.nextToken();
        this.match(MySQLToken.KW_BY);
        block0 : switch (this.lexer.token()) {
            case KW_LINEAR: {
                Expression hashExpr;
                LiteralNumber algorithm;
                subPartitionBy.setLiner(true);
                this.match(MySQLToken.KW_LINEAR);
                switch (this.lexer.token()) {
                    case KW_KEY: {
                        this.match(MySQLToken.KW_KEY);
                        subPartitionBy.setSubPartitionByType(SubPartitionBy.SubPartitionByType.KEY);
                        if ("ALGORITHM".equals(this.lexer.stringValueUppercase())) {
                            this.lexer.nextToken();
                            if (this.lexer.token() == MySQLToken.OP_EQUALS) {
                                this.lexer.nextToken();
                            }
                            algorithm = (LiteralNumber)this.exprParser.valueExpression();
                            subPartitionBy.setAlgorithm(algorithm);
                        }
                        this.match(MySQLToken.PUNC_LEFT_PAREN);
                        List<Identifier> columnList = this.parseIdentifierList();
                        this.match(MySQLToken.PUNC_RIGHT_PAREN);
                        subPartitionBy.setColumnList(columnList);
                        break block0;
                    }
                    case IDENTIFIER: {
                        sid = specialIdentifiers.get(this.lexer.stringValueUppercase());
                        if (sid == null) break block0;
                        switch (sid) {
                            case HASH: {
                                this.lexer.nextToken();
                                hashExpr = this.exprParser.expression();
                                subPartitionBy.setSubPartitionByType(SubPartitionBy.SubPartitionByType.HASH);
                                subPartitionBy.setHashExpr(hashExpr);
                                break block0;
                            }
                        }
                        throw new SQLSyntaxErrorException("subpartition LINEAR with unknown options");
                    }
                    default: {
                        throw new SQLSyntaxErrorException("subpartition LINEAR with unknown options");
                    }
                }
            }
            case KW_KEY: {
                LiteralNumber algorithm;
                this.match(MySQLToken.KW_KEY);
                subPartitionBy.setSubPartitionByType(SubPartitionBy.SubPartitionByType.KEY);
                if ("ALGORITHM".equals(this.lexer.stringValueUppercase())) {
                    this.lexer.nextToken();
                    if (this.lexer.token() == MySQLToken.OP_EQUALS) {
                        this.lexer.nextToken();
                    }
                    algorithm = (LiteralNumber)this.exprParser.valueExpression();
                    subPartitionBy.setAlgorithm(algorithm);
                }
                this.match(MySQLToken.PUNC_LEFT_PAREN);
                List<Identifier> columnList = this.parseIdentifierList();
                this.match(MySQLToken.PUNC_RIGHT_PAREN);
                subPartitionBy.setColumnList(columnList);
                break;
            }
            case IDENTIFIER: {
                Expression hashExpr;
                sid = specialIdentifiers.get(this.lexer.stringValueUppercase());
                if (sid == null) break;
                switch (sid) {
                    case HASH: {
                        this.lexer.nextToken();
                        hashExpr = this.exprParser.expression();
                        subPartitionBy.setSubPartitionByType(SubPartitionBy.SubPartitionByType.HASH);
                        subPartitionBy.setHashExpr(hashExpr);
                        break block0;
                    }
                }
                throw new SQLSyntaxErrorException("subpartition unknown options");
            }
            default: {
                throw new SQLSyntaxErrorException("subpartition unknown options");
            }
        }
        sid = specialIdentifiers.get(this.lexer.stringValueUppercase());
        if (sid != null && sid == SpecialIdentifier.SUBPARTITIONS) {
            this.lexer.nextToken();
            LiteralNumber num = (LiteralNumber)this.exprParser.valueExpression();
            subPartitionBy.setNum(num);
        }
        partitionOptions.setSubPartitionBy(subPartitionBy);
    }

    private void parsePartitionBy(PartitionOptions partitionOptions) throws SQLSyntaxErrorException {
        PartitionBy partitionBy = new PartitionBy();
        this.lexer.nextToken();
        this.match(MySQLToken.KW_BY);
        block0 : switch (this.lexer.token()) {
            case KW_LINEAR: {
                partitionBy.setLiner(true);
                this.match(MySQLToken.KW_LINEAR);
                switch (this.lexer.token()) {
                    case KW_KEY: {
                        this.match(MySQLToken.KW_KEY);
                        partitionBy.setPartitionByType(PartitionBy.PartitionByType.KEY);
                        if ("ALGORITHM".equals(this.lexer.stringValueUppercase())) {
                            this.lexer.nextToken();
                            if (this.lexer.token() == MySQLToken.OP_EQUALS) {
                                this.lexer.nextToken();
                            }
                            LiteralNumber algorithm = (LiteralNumber)this.exprParser.valueExpression();
                            partitionBy.setAlgorithm(algorithm);
                        }
                        this.match(MySQLToken.PUNC_LEFT_PAREN);
                        List<Identifier> columnList = this.parseIdentifierList();
                        this.match(MySQLToken.PUNC_RIGHT_PAREN);
                        partitionBy.setKeyColumnList(columnList);
                        break block0;
                    }
                    case IDENTIFIER: {
                        SpecialIdentifier sid = specialIdentifiers.get(this.lexer.stringValueUppercase());
                        if (sid == null) break block0;
                        switch (sid) {
                            case HASH: {
                                this.lexer.nextToken();
                                Expression hashExpr = this.exprParser.expression();
                                partitionBy.setPartitionByType(PartitionBy.PartitionByType.HASH);
                                partitionBy.setHashExpr(hashExpr);
                                break block0;
                            }
                        }
                        throw new SQLSyntaxErrorException("partition LINEAR with unknown options");
                    }
                    default: {
                        throw new SQLSyntaxErrorException("partition LINEAR with unknown options");
                    }
                }
            }
            case KW_KEY: {
                this.match(MySQLToken.KW_KEY);
                partitionBy.setPartitionByType(PartitionBy.PartitionByType.KEY);
                if ("ALGORITHM".equals(this.lexer.stringValueUppercase())) {
                    this.lexer.nextToken();
                    if (this.lexer.token() == MySQLToken.OP_EQUALS) {
                        this.lexer.nextToken();
                    }
                    LiteralNumber algorithm = (LiteralNumber)this.exprParser.valueExpression();
                    partitionBy.setAlgorithm(algorithm);
                }
                this.match(MySQLToken.PUNC_LEFT_PAREN);
                List<Identifier> columnList = this.parseIdentifierList();
                this.match(MySQLToken.PUNC_RIGHT_PAREN);
                partitionBy.setKeyColumnList(columnList);
                break;
            }
            case KW_RANGE: {
                this.match(MySQLToken.KW_RANGE);
                partitionBy.setPartitionByType(PartitionBy.PartitionByType.RANGE);
                if (this.lexer.token() == MySQLToken.PUNC_LEFT_PAREN) {
                    this.match(MySQLToken.PUNC_LEFT_PAREN);
                    Expression expr = this.exprParser.expression();
                    partitionBy.setRangeExpr(expr);
                    this.match(MySQLToken.PUNC_RIGHT_PAREN);
                    break;
                }
                if (!"COLUMNS".equals(this.lexer.stringValueUppercase())) break;
                this.lexer.nextToken();
                this.match(MySQLToken.PUNC_LEFT_PAREN);
                List<Identifier> columnList = this.parseIdentifierList();
                this.match(MySQLToken.PUNC_RIGHT_PAREN);
                partitionBy.setRangeColumnList(columnList);
                break;
            }
            case IDENTIFIER: {
                SpecialIdentifier sid = specialIdentifiers.get(this.lexer.stringValueUppercase());
                if (sid == null) break;
                switch (sid) {
                    case HASH: {
                        this.lexer.nextToken();
                        Expression hashExpr = this.exprParser.expression();
                        partitionBy.setPartitionByType(PartitionBy.PartitionByType.HASH);
                        partitionBy.setHashExpr(hashExpr);
                        break block0;
                    }
                    case LIST: {
                        this.lexer.nextToken();
                        partitionBy.setPartitionByType(PartitionBy.PartitionByType.LIST);
                        if (this.lexer.token() == MySQLToken.PUNC_LEFT_PAREN) {
                            this.match(MySQLToken.PUNC_LEFT_PAREN);
                            Expression expr = this.exprParser.expression();
                            partitionBy.setListExpr(expr);
                            this.match(MySQLToken.PUNC_RIGHT_PAREN);
                            break block0;
                        }
                        if (!"COLUMNS".equals(this.lexer.stringValueUppercase())) break block0;
                        this.lexer.nextToken();
                        this.match(MySQLToken.PUNC_LEFT_PAREN);
                        List<Identifier> columnList = this.parseIdentifierList();
                        this.match(MySQLToken.PUNC_RIGHT_PAREN);
                        partitionBy.setListColumnList(columnList);
                        break block0;
                    }
                    default: {
                        throw new SQLSyntaxErrorException("partition unknown options");
                    }
                }
            }
            default: {
                throw new SQLSyntaxErrorException("partition unknown options");
            }
        }
        partitionOptions.setPartitionBy(partitionBy);
    }

    private List<Expression> parseValueList() throws SQLSyntaxErrorException {
        AbstractList list;
        Expression expr = this.exprParser.expression();
        if (this.lexer.token() == MySQLToken.PUNC_RIGHT_PAREN) {
            list = new ArrayList(1);
            list.add(expr);
        } else {
            list = new LinkedList();
            list.add(expr);
            while (this.lexer.token() == MySQLToken.PUNC_COMMA) {
                this.lexer.nextToken();
                expr = this.exprParser.expression();
                list.add(expr);
            }
        }
        return list;
    }

    PartitionDefinition parsePartitionDefinition() throws SQLSyntaxErrorException {
        this.matchIdentifier("PARTITION");
        Identifier partition_name = this.identifier();
        PartitionDefinition partitionDefinition = new PartitionDefinition(partition_name);
        boolean loopend = false;
        block15: while (!loopend && this.lexer.token() != MySQLToken.EOF) {
            switch (this.lexer.token()) {
                case KW_VALUES: {
                    List<Expression> value_list;
                    this.lexer.nextToken();
                    partitionDefinition.setHasValues(true);
                    if ("LESS".equals(this.lexer.stringValueUppercase())) {
                        this.matchIdentifier("LESS");
                        this.matchIdentifier("THAN");
                        if (this.lexer.token() == MySQLToken.PUNC_LEFT_PAREN) {
                            this.match(MySQLToken.PUNC_LEFT_PAREN);
                            value_list = this.parseValueList();
                            if (value_list != null) {
                                if (value_list.size() > 1) {
                                    partitionDefinition.setValueLessThanValueList(value_list);
                                    partitionDefinition.setPartitionDefinitionValuesType(PartitionDefinition.PartitionDefinitionValuesType.LESSTHAN_VALUELIST);
                                } else {
                                    partitionDefinition.setValuesLessThanExpr(value_list.get(0));
                                    partitionDefinition.setPartitionDefinitionValuesType(PartitionDefinition.PartitionDefinitionValuesType.LESSTHAN_EXPR);
                                }
                            }
                            this.match(MySQLToken.PUNC_RIGHT_PAREN);
                            continue block15;
                        }
                        if ("MAXVALUE".equals(this.lexer.stringValueUppercase())) {
                            this.lexer.nextToken();
                            partitionDefinition.setPartitionDefinitionValuesType(PartitionDefinition.PartitionDefinitionValuesType.LESSTHAN_MAXVALUE);
                            continue block15;
                        }
                        throw new SQLSyntaxErrorException("partition definition unknown VALUES options");
                    }
                    if ("IN".equals(this.lexer.stringValueUppercase())) {
                        this.match(MySQLToken.KW_IN);
                        partitionDefinition.setPartitionDefinitionValuesType(PartitionDefinition.PartitionDefinitionValuesType.IN);
                        this.match(MySQLToken.PUNC_LEFT_PAREN);
                        value_list = this.parseValueList();
                        this.match(MySQLToken.PUNC_RIGHT_PAREN);
                        partitionDefinition.setValuesInValueList(value_list);
                        continue block15;
                    }
                    throw new SQLSyntaxErrorException("partition definition unknown VALUES options");
                }
                case KW_INDEX: {
                    this.lexer.nextToken();
                    this.matchIdentifier("DIRECTORY");
                    if (this.lexer.token() == MySQLToken.OP_EQUALS) {
                        this.lexer.nextToken();
                    }
                    LiteralString index_dir = (LiteralString)this.exprParser.valueExpression();
                    partitionDefinition.setIndexDir(index_dir);
                    continue block15;
                }
                case IDENTIFIER: {
                    SpecialIdentifier sid = specialIdentifiers.get(this.lexer.stringValueUppercase());
                    if (sid == null) continue block15;
                    switch (sid) {
                        case STORAGE: {
                            this.lexer.nextToken();
                            partitionDefinition.setHasStorage(true);
                            if (!"ENGINE".equals(this.lexer.stringValueUppercase())) continue block15;
                            this.lexer.nextToken();
                            if (this.lexer.token() == MySQLToken.OP_EQUALS) {
                                this.lexer.nextToken();
                            }
                            Identifier engine_name = this.identifier();
                            partitionDefinition.setEngineName(engine_name);
                            continue block15;
                        }
                        case ENGINE: {
                            this.lexer.nextToken();
                            if (this.lexer.token() == MySQLToken.OP_EQUALS) {
                                this.lexer.nextToken();
                            }
                            Identifier engine_name = this.identifier();
                            partitionDefinition.setEngineName(engine_name);
                            continue block15;
                        }
                        case COMMENT: {
                            this.lexer.nextToken();
                            if (this.lexer.token() == MySQLToken.OP_EQUALS) {
                                this.lexer.nextToken();
                            }
                            LiteralString comment = (LiteralString)this.exprParser.valueExpression();
                            partitionDefinition.setCommentText(comment);
                            continue block15;
                        }
                        case DATA: {
                            this.lexer.nextToken();
                            this.matchIdentifier("DIRECTORY");
                            if (this.lexer.token() == MySQLToken.OP_EQUALS) {
                                this.lexer.nextToken();
                            }
                            LiteralString data_dir = (LiteralString)this.exprParser.valueExpression();
                            partitionDefinition.setDataDir(data_dir);
                            continue block15;
                        }
                        case MAX_ROWS: {
                            this.lexer.nextToken();
                            if (this.lexer.token() == MySQLToken.OP_EQUALS) {
                                this.lexer.nextToken();
                            }
                            LiteralNumber max_number_of_rows = (LiteralNumber)this.exprParser.valueExpression();
                            partitionDefinition.setMaxNumberOfRows(max_number_of_rows);
                            continue block15;
                        }
                        case MIN_ROWS: {
                            this.lexer.nextToken();
                            if (this.lexer.token() == MySQLToken.OP_EQUALS) {
                                this.lexer.nextToken();
                            }
                            LiteralNumber min_number_of_rows = (LiteralNumber)this.exprParser.valueExpression();
                            partitionDefinition.setMinNumberOfRows(min_number_of_rows);
                            continue block15;
                        }
                        case TABLESPACE: {
                            this.lexer.nextToken();
                            if (this.lexer.token() == MySQLToken.OP_EQUALS) {
                                this.lexer.nextToken();
                            }
                            Identifier tablespace_name = this.identifier();
                            partitionDefinition.setTablespaceName(tablespace_name);
                            continue block15;
                        }
                        case NODEGROUP: {
                            this.lexer.nextToken();
                            if (this.lexer.token() == MySQLToken.OP_EQUALS) {
                                this.lexer.nextToken();
                            }
                            Identifier node_group_id = this.identifier();
                            partitionDefinition.setNodeGroupId(node_group_id);
                            continue block15;
                        }
                    }
                    loopend = true;
                    continue block15;
                }
            }
            loopend = true;
        }
        if (this.lexer.token() == MySQLToken.PUNC_LEFT_PAREN) {
            this.match(MySQLToken.PUNC_LEFT_PAREN);
            List<SubpartitionDefinition> subpartitionDefinitions = this.parseSubPartitionDefinitionList();
            partitionDefinition.setSubpartitionDefinitionList(subpartitionDefinitions);
            this.match(MySQLToken.PUNC_RIGHT_PAREN);
        }
        return partitionDefinition;
    }

    List<PartitionDefinition> parsePartitionDefinitionList() throws SQLSyntaxErrorException {
        AbstractList partitionDefinitionList;
        PartitionDefinition partitionDefinition = this.parsePartitionDefinition();
        if (this.lexer.token() != MySQLToken.PUNC_COMMA && !"PARTITION".equals(this.lexer.stringValueUppercase())) {
            partitionDefinitionList = new ArrayList(1);
            partitionDefinitionList.add(partitionDefinition);
        } else {
            partitionDefinitionList = new LinkedList<PartitionDefinition>();
            partitionDefinitionList.add(partitionDefinition);
            while (this.lexer.token() == MySQLToken.PUNC_COMMA) {
                this.lexer.nextToken();
                partitionDefinition = this.parsePartitionDefinition();
                partitionDefinitionList.add(partitionDefinition);
            }
        }
        return partitionDefinitionList;
    }

    private SubpartitionDefinition parseSubPartitionDefinition() throws SQLSyntaxErrorException {
        this.matchIdentifier("SUBPARTITION");
        Identifier logical_name = this.identifier();
        SubpartitionDefinition subpartitionDefinition = new SubpartitionDefinition(logical_name);
        boolean loopend = false;
        block14: while (!loopend && this.lexer.token() != MySQLToken.EOF) {
            switch (this.lexer.token()) {
                case KW_INDEX: {
                    this.lexer.nextToken();
                    this.matchIdentifier("DIRECTORY");
                    if (this.lexer.token() == MySQLToken.OP_EQUALS) {
                        this.lexer.nextToken();
                    }
                    LiteralString index_dir = (LiteralString)this.exprParser.valueExpression();
                    subpartitionDefinition.setIndexDir(index_dir);
                    continue block14;
                }
                case IDENTIFIER: {
                    SpecialIdentifier sid = specialIdentifiers.get(this.lexer.stringValueUppercase());
                    if (sid == null) continue block14;
                    switch (sid) {
                        case STORAGE: {
                            this.lexer.nextToken();
                            subpartitionDefinition.setIsStorage(true);
                            if (!"ENGINE".equals(this.lexer.stringValueUppercase())) continue block14;
                            this.lexer.nextToken();
                            if (this.lexer.token() == MySQLToken.OP_EQUALS) {
                                this.lexer.nextToken();
                            }
                            Identifier engine_name = this.identifier();
                            subpartitionDefinition.setEngineName(engine_name);
                            continue block14;
                        }
                        case ENGINE: {
                            this.lexer.nextToken();
                            if (this.lexer.token() == MySQLToken.OP_EQUALS) {
                                this.lexer.nextToken();
                            }
                            Identifier engine_name = this.identifier();
                            subpartitionDefinition.setEngineName(engine_name);
                            continue block14;
                        }
                        case COMMENT: {
                            this.lexer.nextToken();
                            if (this.lexer.token() == MySQLToken.OP_EQUALS) {
                                this.lexer.nextToken();
                            }
                            LiteralString comment = (LiteralString)this.exprParser.valueExpression();
                            subpartitionDefinition.setCommentText(comment);
                            continue block14;
                        }
                        case DATA: {
                            this.lexer.nextToken();
                            this.matchIdentifier("DIRECTORY");
                            if (this.lexer.token() == MySQLToken.OP_EQUALS) {
                                this.lexer.nextToken();
                            }
                            LiteralString data_dir = (LiteralString)this.exprParser.valueExpression();
                            subpartitionDefinition.setDataDir(data_dir);
                            continue block14;
                        }
                        case MAX_ROWS: {
                            this.lexer.nextToken();
                            if (this.lexer.token() == MySQLToken.OP_EQUALS) {
                                this.lexer.nextToken();
                            }
                            LiteralNumber max_number_of_rows = (LiteralNumber)this.exprParser.valueExpression();
                            subpartitionDefinition.setMaxNumberOfRows(max_number_of_rows);
                            continue block14;
                        }
                        case MIN_ROWS: {
                            this.lexer.nextToken();
                            if (this.lexer.token() == MySQLToken.OP_EQUALS) {
                                this.lexer.nextToken();
                            }
                            LiteralNumber min_number_of_rows = (LiteralNumber)this.exprParser.valueExpression();
                            subpartitionDefinition.setMinNumberOfRows(min_number_of_rows);
                            continue block14;
                        }
                        case TABLESPACE: {
                            this.lexer.nextToken();
                            if (this.lexer.token() == MySQLToken.OP_EQUALS) {
                                this.lexer.nextToken();
                            }
                            Identifier tablespace_name = this.identifier();
                            subpartitionDefinition.setTablespaceName(tablespace_name);
                            continue block14;
                        }
                        case NODEGROUP: {
                            this.lexer.nextToken();
                            if (this.lexer.token() == MySQLToken.OP_EQUALS) {
                                this.lexer.nextToken();
                            }
                            Identifier node_group_id = this.identifier();
                            subpartitionDefinition.setNodeGroupId(node_group_id);
                            continue block14;
                        }
                    }
                    loopend = true;
                    continue block14;
                }
            }
            loopend = true;
        }
        return subpartitionDefinition;
    }

    private List<SubpartitionDefinition> parseSubPartitionDefinitionList() throws SQLSyntaxErrorException {
        AbstractList subpartitionDefinitionList;
        SubpartitionDefinition subpartitionDefinition = this.parseSubPartitionDefinition();
        if (this.lexer.token() != MySQLToken.PUNC_COMMA && !"SUBPARTITION".equals(this.lexer.stringValueUppercase())) {
            subpartitionDefinitionList = new ArrayList(1);
            subpartitionDefinitionList.add(subpartitionDefinition);
        } else {
            subpartitionDefinitionList = new LinkedList<SubpartitionDefinition>();
            subpartitionDefinitionList.add(subpartitionDefinition);
            while (this.lexer.token() == MySQLToken.PUNC_COMMA) {
                this.lexer.nextToken();
                subpartitionDefinition = this.parseSubPartitionDefinition();
                subpartitionDefinitionList.add(subpartitionDefinition);
            }
        }
        return subpartitionDefinitionList;
    }

    private void parsePartitionOptions(PartitionOptions partitionOptions) throws SQLSyntaxErrorException {
        if (!"PARTITION".equals(this.lexer.stringValueUppercase())) {
            return;
        }
        boolean endloop = false;
        block5: while (!endloop && this.lexer.token() != MySQLToken.EOF) {
            SpecialIdentifier sid = specialIdentifiers.get(this.lexer.stringValueUppercase());
            if (sid != null) {
                switch (sid) {
                    case PARTITION: {
                        this.parsePartitionBy(partitionOptions);
                        continue block5;
                    }
                    case PARTITIONS: {
                        this.lexer.nextToken();
                        LiteralNumber num = (LiteralNumber)this.exprParser.valueExpression();
                        partitionOptions.setNum(num);
                        continue block5;
                    }
                    case SUBPARTITION: {
                        this.parseSubPartitionBy(partitionOptions);
                        continue block5;
                    }
                }
                endloop = true;
                continue;
            }
            endloop = true;
        }
        if (this.lexer.token() == MySQLToken.PUNC_LEFT_PAREN) {
            this.match(MySQLToken.PUNC_LEFT_PAREN);
            List<PartitionDefinition> partition_definitions = this.parsePartitionDefinitionList();
            partitionOptions.setPartitionDefinitionList(partition_definitions);
            this.match(MySQLToken.PUNC_RIGHT_PAREN);
        }
    }

    static {
        specialIdentifiers.put("TRUNCATE", SpecialIdentifier.TRUNCATE);
        specialIdentifiers.put("TEMPORARY", SpecialIdentifier.TEMPORARY);
        specialIdentifiers.put("DEFINER", SpecialIdentifier.DEFINER);
        specialIdentifiers.put("KEY_BLOCK_SIZE", SpecialIdentifier.KEY_BLOCK_SIZE);
        specialIdentifiers.put("COMMENT", SpecialIdentifier.COMMENT);
        specialIdentifiers.put("DYNAMIC", SpecialIdentifier.DYNAMIC);
        specialIdentifiers.put("FIXED", SpecialIdentifier.FIXED);
        specialIdentifiers.put("BIT", SpecialIdentifier.BIT);
        specialIdentifiers.put("DATE", SpecialIdentifier.DATE);
        specialIdentifiers.put("TIME", SpecialIdentifier.TIME);
        specialIdentifiers.put("TIMESTAMP", SpecialIdentifier.TIMESTAMP);
        specialIdentifiers.put("DATETIME", SpecialIdentifier.DATETIME);
        specialIdentifiers.put("YEAR", SpecialIdentifier.YEAR);
        specialIdentifiers.put("TEXT", SpecialIdentifier.TEXT);
        specialIdentifiers.put("ENUM", SpecialIdentifier.ENUM);
        specialIdentifiers.put("ENGINE", SpecialIdentifier.ENGINE);
        specialIdentifiers.put("AUTO_INCREMENT", SpecialIdentifier.AUTO_INCREMENT);
        specialIdentifiers.put("AVG_ROW_LENGTH", SpecialIdentifier.AVG_ROW_LENGTH);
        specialIdentifiers.put("CHECKSUM", SpecialIdentifier.CHECKSUM);
        specialIdentifiers.put("CONNECTION", SpecialIdentifier.CONNECTION);
        specialIdentifiers.put("DATA", SpecialIdentifier.DATA);
        specialIdentifiers.put("DELAY_KEY_WRITE", SpecialIdentifier.DELAY_KEY_WRITE);
        specialIdentifiers.put("INSERT_METHOD", SpecialIdentifier.INSERT_METHOD);
        specialIdentifiers.put("MAX_ROWS", SpecialIdentifier.MAX_ROWS);
        specialIdentifiers.put("MIN_ROWS", SpecialIdentifier.MIN_ROWS);
        specialIdentifiers.put("PACK_KEYS", SpecialIdentifier.PACK_KEYS);
        specialIdentifiers.put("PASSWORD", SpecialIdentifier.PASSWORD);
        specialIdentifiers.put("ROW_FORMAT", SpecialIdentifier.ROW_FORMAT);
        specialIdentifiers.put("COMPRESSED", SpecialIdentifier.COMPRESSED);
        specialIdentifiers.put("REDUNDANT", SpecialIdentifier.REDUNDANT);
        specialIdentifiers.put("COMPACT", SpecialIdentifier.COMPACT);
        specialIdentifiers.put("MODIFY", SpecialIdentifier.MODIFY);
        specialIdentifiers.put("DISABLE", SpecialIdentifier.DISABLE);
        specialIdentifiers.put("ENABLE", SpecialIdentifier.ENABLE);
        specialIdentifiers.put("DISCARD", SpecialIdentifier.DISCARD);
        specialIdentifiers.put("IMPORT", SpecialIdentifier.IMPORT);
        specialIdentifiers.put("CHARSET", SpecialIdentifier.CHARSET);
        specialIdentifiers.put("POLICY", SpecialIdentifier.POLICY);
        specialIdentifiers.put("SEQUENCE", SpecialIdentifier.SEQUENCE);
        specialIdentifiers.put("FULL", SpecialIdentifier.FULL);
        specialIdentifiers.put("PARTIAL", SpecialIdentifier.PARTIAL);
        specialIdentifiers.put("SIMPLE", SpecialIdentifier.SIMPLE);
        specialIdentifiers.put("NO", SpecialIdentifier.NO);
        specialIdentifiers.put("LESS", SpecialIdentifier.LESS);
        specialIdentifiers.put("THAN", SpecialIdentifier.THAN);
        specialIdentifiers.put("ACTION", SpecialIdentifier.ACTION);
        specialIdentifiers.put("TBPARTITION", SpecialIdentifier.TBPARTITION);
        specialIdentifiers.put("TBPARTITIONS", SpecialIdentifier.TBPARTITIONS);
        specialIdentifiers.put("DBPARTITION", SpecialIdentifier.DBPARTITION);
        specialIdentifiers.put("DBPARTITIONS", SpecialIdentifier.DBPARTITIONS);
        specialIdentifiers.put("DISK", SpecialIdentifier.DISK);
        specialIdentifiers.put("MEMORY", SpecialIdentifier.MEMORY);
        specialIdentifiers.put("ALGORITHM", SpecialIdentifier.ALGORITHM);
        specialIdentifiers.put("INPLACE", SpecialIdentifier.INPLACE);
        specialIdentifiers.put("COPY", SpecialIdentifier.COPY);
        specialIdentifiers.put("NONE", SpecialIdentifier.NONE);
        specialIdentifiers.put("SHARED", SpecialIdentifier.SHARED);
        specialIdentifiers.put("EXCLUSIVE", SpecialIdentifier.EXCLUSIVE);
        specialIdentifiers.put("STATS_AUTO_RECALC", SpecialIdentifier.STATS_AUTO_RECALC);
        specialIdentifiers.put("STATS_PERSISTENT", SpecialIdentifier.STATS_PERSISTENT);
        specialIdentifiers.put("STATS_SAMPLE_PAGES", SpecialIdentifier.STATS_SAMPLE_PAGES);
        specialIdentifiers.put("TABLESPACE", SpecialIdentifier.TABLESPACE);
        specialIdentifiers.put("STORAGE", SpecialIdentifier.STORAGE);
        specialIdentifiers.put("BOOL", SpecialIdentifier.BOOL);
        specialIdentifiers.put("BOOLEAN", SpecialIdentifier.BOOLEAN);
        specialIdentifiers.put("GEOMETRY", SpecialIdentifier.GEOMETRY);
        specialIdentifiers.put("POINT", SpecialIdentifier.POINT);
        specialIdentifiers.put("LINESTRING", SpecialIdentifier.LINESTRING);
        specialIdentifiers.put("POLYGON", SpecialIdentifier.POLYGON);
        specialIdentifiers.put("MULTIPOINT", SpecialIdentifier.MULTIPOINT);
        specialIdentifiers.put("MULTILINESTRING", SpecialIdentifier.MULTILINESTRING);
        specialIdentifiers.put("MULTIPOLYGON", SpecialIdentifier.MULTIPOLYGON);
        specialIdentifiers.put("GEOMETRYCOLLECTION", SpecialIdentifier.GEOMETRYCOLLECTION);
        specialIdentifiers.put("PARTITION", SpecialIdentifier.PARTITION);
        specialIdentifiers.put("PARTITIONS", SpecialIdentifier.PARTITIONS);
        specialIdentifiers.put("SUBPARTITION", SpecialIdentifier.SUBPARTITION);
        specialIdentifiers.put("SUBPARTITIONS", SpecialIdentifier.SUBPARTITIONS);
        specialIdentifiers.put("LIST", SpecialIdentifier.LIST);
        specialIdentifiers.put("HASH", SpecialIdentifier.HASH);
        specialIdentifiers.put("COLUMNS", SpecialIdentifier.COLUMNS);
        specialIdentifiers.put("NODEGROUP", SpecialIdentifier.NODEGROUP);
        specialIdentifiers.put("COALESCE", SpecialIdentifier.COALESCE);
        specialIdentifiers.put("REORGANIZE", SpecialIdentifier.REORGANIZE);
        specialIdentifiers.put("EXCHANGE", SpecialIdentifier.EXCHANGE);
        specialIdentifiers.put("ANALYZE", SpecialIdentifier.ANALYZE);
        specialIdentifiers.put("REBUILD", SpecialIdentifier.REBUILD);
        specialIdentifiers.put("REPAIR", SpecialIdentifier.REPAIR);
        specialIdentifiers.put("REMOVE", SpecialIdentifier.REMOVE);
        specialIdentifiers.put("MM", SpecialIdentifier.MM);
        specialIdentifiers.put("DD", SpecialIdentifier.DD);
        specialIdentifiers.put("WEEK", SpecialIdentifier.WEEK);
        specialIdentifiers.put("MMDD", SpecialIdentifier.MMDD);
        specialIdentifiers.put("YYYYMM", SpecialIdentifier.YYYYMM);
        specialIdentifiers.put("BROADCAST", SpecialIdentifier.BROADCAST);
    }

    private static enum SpecialIdentifier {
        TRUNCATE,
        TEMPORARY,
        DEFINER,
        KEY_BLOCK_SIZE,
        COMMENT,
        DYNAMIC,
        FIXED,
        BIT,
        DATE,
        TIME,
        TIMESTAMP,
        DATETIME,
        YEAR,
        TEXT,
        ENUM,
        ENGINE,
        AUTO_INCREMENT,
        AVG_ROW_LENGTH,
        CHECKSUM,
        CONNECTION,
        DATA,
        DELAY_KEY_WRITE,
        INSERT_METHOD,
        MAX_ROWS,
        MIN_ROWS,
        PACK_KEYS,
        PASSWORD,
        ROW_FORMAT,
        COMPRESSED,
        REDUNDANT,
        COMPACT,
        MODIFY,
        DISABLE,
        ENABLE,
        DISCARD,
        IMPORT,
        NO,
        STATS_AUTO_RECALC,
        STATS_PERSISTENT,
        STATS_SAMPLE_PAGES,
        TABLESPACE,
        STORAGE,
        CHARSET,
        POLICY,
        SEQUENCE,
        FULL,
        PARTIAL,
        SIMPLE,
        LESS,
        THAN,
        ACTION,
        PARTITION,
        PARTITIONS,
        SUBPARTITION,
        SUBPARTITIONS,
        LIST,
        HASH,
        COLUMNS,
        NODEGROUP,
        TBPARTITION,
        TBPARTITIONS,
        DBPARTITION,
        DBPARTITIONS,
        DISK,
        MEMORY,
        ALGORITHM,
        INPLACE,
        COPY,
        NONE,
        SHARED,
        EXCLUSIVE,
        BOOL,
        BOOLEAN,
        GEOMETRY,
        POINT,
        LINESTRING,
        POLYGON,
        MULTIPOINT,
        MULTILINESTRING,
        MULTIPOLYGON,
        GEOMETRYCOLLECTION,
        COALESCE,
        REORGANIZE,
        EXCHANGE,
        ANALYZE,
        REBUILD,
        REPAIR,
        REMOVE,
        MM,
        DD,
        WEEK,
        MMDD,
        YYYYMM,
        BROADCAST;

    }
}

