/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.txc.parser.recognizer.mysql.syntax;

import com.alibaba.txc.parser.ast.expression.Expression;
import com.alibaba.txc.parser.ast.expression.primary.Identifier;
import com.alibaba.txc.parser.ast.expression.primary.ParamMarker;
import com.alibaba.txc.parser.ast.expression.primary.RowExpression;
import com.alibaba.txc.parser.ast.stmt.dml.DMLInsertStatement;
import com.alibaba.txc.parser.ast.stmt.dml.DMLQueryStatement;
import com.alibaba.txc.parser.recognizer.mysql.MySQLToken;
import com.alibaba.txc.parser.recognizer.mysql.lexer.MySQLLexer;
import com.alibaba.txc.parser.recognizer.mysql.syntax.MySQLDMLInsertReplaceParser;
import com.alibaba.txc.parser.recognizer.mysql.syntax.MySQLExprParser;
import com.alibaba.txc.parser.util.Pair;
import java.sql.SQLSyntaxErrorException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class MySQLDMLInsertParser
extends MySQLDMLInsertReplaceParser {
    private static final Map<String, SpecialIdentifier> specialIdentifiers = new HashMap<String, SpecialIdentifier>();

    public MySQLDMLInsertParser(MySQLLexer lexer, MySQLExprParser exprParser) {
        super(lexer, exprParser);
    }

    public DMLInsertStatement insert() throws SQLSyntaxErrorException {
        this.match(MySQLToken.KW_INSERT);
        DMLInsertStatement.InsertMode mode = DMLInsertStatement.InsertMode.UNDEF;
        boolean ignore = false;
        switch (this.lexer.token()) {
            case KW_LOW_PRIORITY: {
                this.lexer.nextToken();
                mode = DMLInsertStatement.InsertMode.LOW;
                break;
            }
            case KW_DELAYED: {
                this.lexer.nextToken();
                mode = DMLInsertStatement.InsertMode.DELAY;
                break;
            }
            case KW_HIGH_PRIORITY: {
                this.lexer.nextToken();
                mode = DMLInsertStatement.InsertMode.HIGH;
                break;
            }
        }
        boolean commitOnSuccess = false;
        boolean rollbackOnFail = false;
        boolean queueOnPk = false;
        boolean targetAffectRow = false;
        Number queueOnPkNum = null;
        ParamMarker queueOnPkNumP = null;
        Number num = null;
        ParamMarker numP = null;
        block36: while (true) {
            block5 : switch (this.lexer.token()) {
                case IDENTIFIER: {
                    String optionStringUp = this.lexer.stringValueUppercase();
                    SpecialIdentifier specialId = specialIdentifiers.get(optionStringUp);
                    if (specialId == null) break block36;
                    switch (specialId) {
                        case COMMIT_ON_SUCCESS: {
                            commitOnSuccess = true;
                            break block5;
                        }
                        case ROLLBACK_ON_FAIL: {
                            rollbackOnFail = true;
                            break block5;
                        }
                        case QUEUE_ON_PK: {
                            int paramIndex1;
                            Number num1;
                            queueOnPk = true;
                            switch (this.lexer.nextToken()) {
                                case LITERAL_NUM_PURE_DIGIT: {
                                    queueOnPkNum = num1 = this.lexer.integerValue();
                                    break block5;
                                }
                                case QUESTION_MARK: {
                                    paramIndex1 = this.lexer.paramIndex();
                                    queueOnPkNumP = this.createParam(paramIndex1);
                                    break block5;
                                }
                            }
                            throw this.err("expect digit or ? after QUEUE_ON_PK");
                        }
                        case TARGET_AFFECT_ROW: {
                            int paramIndex1;
                            Number num1;
                            targetAffectRow = true;
                            switch (this.lexer.nextToken()) {
                                case LITERAL_NUM_PURE_DIGIT: {
                                    num = num1 = this.lexer.integerValue();
                                    break block5;
                                }
                                case QUESTION_MARK: {
                                    paramIndex1 = this.lexer.paramIndex();
                                    numP = this.createParam(paramIndex1);
                                    break block5;
                                }
                            }
                            throw this.err("expect digit or ? after TARGET_AFFECT_ROW");
                        }
                    }
                    break block36;
                }
                default: {
                    break block36;
                }
            }
            this.lexer.nextToken();
        }
        if (this.lexer.token() == MySQLToken.KW_IGNORE) {
            ignore = true;
            this.lexer.nextToken();
        }
        if (this.lexer.token() == MySQLToken.KW_INTO) {
            this.lexer.nextToken();
        }
        Identifier table = this.identifier();
        switch (this.lexer.token()) {
            case KW_SET: {
                this.lexer.nextToken();
                LinkedList<Identifier> columnNameList = new LinkedList<Identifier>();
                LinkedList<Expression> tempRowValue = new LinkedList<Expression>();
                while (true) {
                    Identifier id = this.identifier();
                    this.match(MySQLToken.OP_EQUALS, MySQLToken.OP_ASSIGN);
                    Expression expr = this.exprParser.expression();
                    columnNameList.add(id);
                    tempRowValue.add(expr);
                    if (this.lexer.token() != MySQLToken.PUNC_COMMA) break;
                    this.lexer.nextToken();
                }
                ArrayList<RowExpression> rowList = new ArrayList<RowExpression>(1);
                rowList.add(new RowExpression(tempRowValue));
                List<Pair<Identifier, Expression>> dupUpdate = this.onDuplicateUpdate();
                return new DMLInsertStatement(mode, ignore, table, columnNameList, rowList, dupUpdate, commitOnSuccess, rollbackOnFail, queueOnPk, targetAffectRow, queueOnPkNum, queueOnPkNumP, num, numP);
            }
            case IDENTIFIER: {
                if (!"VALUE".equals(this.lexer.stringValueUppercase())) break;
            }
            case KW_VALUES: {
                this.lexer.nextToken();
                List<Identifier> columnNameList = null;
                List<RowExpression> rowList = this.rowList();
                List<Pair<Identifier, Expression>> dupUpdate = this.onDuplicateUpdate();
                return new DMLInsertStatement(mode, ignore, table, columnNameList, rowList, dupUpdate, commitOnSuccess, rollbackOnFail, queueOnPk, targetAffectRow, queueOnPkNum, queueOnPkNumP, num, numP);
            }
            case KW_SELECT: {
                List<Identifier> columnNameList = null;
                DMLQueryStatement select = this.selectUnion();
                List<Pair<Identifier, Expression>> dupUpdate = this.onDuplicateUpdate();
                return new DMLInsertStatement(mode, ignore, table, columnNameList, select, dupUpdate, commitOnSuccess, rollbackOnFail, queueOnPk, targetAffectRow, queueOnPkNum, queueOnPkNumP, num, numP);
            }
            case PUNC_LEFT_PAREN: {
                List<Pair<Identifier, Expression>> dupUpdate;
                switch (this.lexer.nextToken()) {
                    case PUNC_LEFT_PAREN: 
                    case KW_SELECT: {
                        List<Identifier> columnNameList = null;
                        DMLQueryStatement select = this.selectUnion();
                        this.match(MySQLToken.PUNC_RIGHT_PAREN);
                        dupUpdate = this.onDuplicateUpdate();
                        return new DMLInsertStatement(mode, ignore, table, columnNameList, select, dupUpdate, commitOnSuccess, rollbackOnFail, queueOnPk, targetAffectRow, queueOnPkNum, queueOnPkNumP, num, numP);
                    }
                }
                List<Identifier> columnNameList = this.idList();
                this.match(MySQLToken.PUNC_RIGHT_PAREN);
                switch (this.lexer.token()) {
                    case PUNC_LEFT_PAREN: 
                    case KW_SELECT: {
                        DMLQueryStatement select = this.selectUnion();
                        dupUpdate = this.onDuplicateUpdate();
                        return new DMLInsertStatement(mode, ignore, table, columnNameList, select, dupUpdate, commitOnSuccess, rollbackOnFail, queueOnPk, targetAffectRow, queueOnPkNum, queueOnPkNumP, num, numP);
                    }
                    case KW_VALUES: {
                        this.lexer.nextToken();
                        break;
                    }
                    default: {
                        this.matchIdentifier("VALUE");
                    }
                }
                List<RowExpression> rowList = this.rowList();
                dupUpdate = this.onDuplicateUpdate();
                return new DMLInsertStatement(mode, ignore, table, columnNameList, rowList, dupUpdate, commitOnSuccess, rollbackOnFail, queueOnPk, targetAffectRow, queueOnPkNum, queueOnPkNumP, num, numP);
            }
        }
        throw this.err("unexpected token for insert: " + (Object)((Object)this.lexer.token()));
    }

    private List<Pair<Identifier, Expression>> onDuplicateUpdate() throws SQLSyntaxErrorException {
        if (this.lexer.token() != MySQLToken.KW_ON) {
            return null;
        }
        this.lexer.nextToken();
        this.matchIdentifier("DUPLICATE");
        this.match(MySQLToken.KW_KEY);
        this.match(MySQLToken.KW_UPDATE);
        Identifier col = this.identifier();
        this.match(MySQLToken.OP_EQUALS, MySQLToken.OP_ASSIGN);
        Expression expr = this.exprParser.expression();
        if (this.lexer.token() == MySQLToken.PUNC_COMMA) {
            LinkedList<Pair<Identifier, Expression>> list = new LinkedList<Pair<Identifier, Expression>>();
            list.add(new Pair<Identifier, Expression>(col, expr));
            while (this.lexer.token() == MySQLToken.PUNC_COMMA) {
                this.lexer.nextToken();
                col = this.identifier();
                this.match(MySQLToken.OP_EQUALS, MySQLToken.OP_ASSIGN);
                expr = this.exprParser.expression();
                list.add(new Pair<Identifier, Expression>(col, expr));
            }
            return list;
        }
        ArrayList<Pair<Identifier, Expression>> list = new ArrayList<Pair<Identifier, Expression>>(1);
        list.add(new Pair<Identifier, Expression>(col, expr));
        return list;
    }

    static {
        specialIdentifiers.put("COMMIT_ON_SUCCESS", SpecialIdentifier.COMMIT_ON_SUCCESS);
        specialIdentifiers.put("ROLLBACK_ON_FAIL", SpecialIdentifier.ROLLBACK_ON_FAIL);
        specialIdentifiers.put("QUEUE_ON_PK", SpecialIdentifier.QUEUE_ON_PK);
        specialIdentifiers.put("TARGET_AFFECT_ROW", SpecialIdentifier.TARGET_AFFECT_ROW);
    }

    private static enum SpecialIdentifier {
        COMMIT_ON_SUCCESS,
        ROLLBACK_ON_FAIL,
        QUEUE_ON_PK,
        TARGET_AFFECT_ROW;

    }
}

