/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.txc.parser.recognizer.mysql.syntax;

import com.alibaba.txc.parser.ast.expression.Expression;
import com.alibaba.txc.parser.ast.expression.misc.QueryExpression;
import com.alibaba.txc.parser.ast.expression.primary.Identifier;
import com.alibaba.txc.parser.ast.fragment.GroupBy;
import com.alibaba.txc.parser.ast.fragment.OrderBy;
import com.alibaba.txc.parser.ast.fragment.SortOrder;
import com.alibaba.txc.parser.ast.fragment.tableref.IndexHint;
import com.alibaba.txc.parser.ast.fragment.tableref.InnerJoin;
import com.alibaba.txc.parser.ast.fragment.tableref.NaturalJoin;
import com.alibaba.txc.parser.ast.fragment.tableref.OuterJoin;
import com.alibaba.txc.parser.ast.fragment.tableref.StraightJoin;
import com.alibaba.txc.parser.ast.fragment.tableref.SubqueryFactor;
import com.alibaba.txc.parser.ast.fragment.tableref.TableRefFactor;
import com.alibaba.txc.parser.ast.fragment.tableref.TableReference;
import com.alibaba.txc.parser.ast.fragment.tableref.TableReferences;
import com.alibaba.txc.parser.ast.stmt.dml.DMLQueryStatement;
import com.alibaba.txc.parser.ast.stmt.dml.DMLSelectStatement;
import com.alibaba.txc.parser.ast.stmt.dml.DMLSelectUnionStatement;
import com.alibaba.txc.parser.recognizer.mysql.MySQLToken;
import com.alibaba.txc.parser.recognizer.mysql.lexer.MySQLLexer;
import com.alibaba.txc.parser.recognizer.mysql.syntax.MySQLDMLSelectParser;
import com.alibaba.txc.parser.recognizer.mysql.syntax.MySQLExprParser;
import com.alibaba.txc.parser.recognizer.mysql.syntax.MySQLParser;
import java.sql.SQLSyntaxErrorException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public abstract class MySQLDMLParser
extends MySQLParser {
    protected MySQLExprParser exprParser;

    public MySQLDMLParser(MySQLLexer lexer, MySQLExprParser exprParser) {
        super(lexer);
        this.exprParser = exprParser;
    }

    protected GroupBy groupBy() throws SQLSyntaxErrorException {
        if (this.lexer.token() != MySQLToken.KW_GROUP) {
            return null;
        }
        this.lexer.nextToken();
        this.match(MySQLToken.KW_BY);
        Expression expr = this.exprParser.expression();
        SortOrder order = SortOrder.ASC;
        switch (this.lexer.token()) {
            case KW_DESC: {
                order = SortOrder.DESC;
            }
            case KW_ASC: {
                this.lexer.nextToken();
            }
        }
        switch (this.lexer.token()) {
            case KW_WITH: {
                this.lexer.nextToken();
                this.matchIdentifier("ROLLUP");
                return new GroupBy(expr, order, true);
            }
            case PUNC_COMMA: {
                break;
            }
            default: {
                return new GroupBy(expr, order, false);
            }
        }
        GroupBy groupBy = new GroupBy().addOrderByItem(expr, order);
        while (this.lexer.token() == MySQLToken.PUNC_COMMA) {
            this.lexer.nextToken();
            order = SortOrder.ASC;
            expr = this.exprParser.expression();
            switch (this.lexer.token()) {
                case KW_DESC: {
                    order = SortOrder.DESC;
                }
                case KW_ASC: {
                    this.lexer.nextToken();
                }
            }
            groupBy.addOrderByItem(expr, order);
            if (this.lexer.token() != MySQLToken.KW_WITH) continue;
            this.lexer.nextToken();
            this.matchIdentifier("ROLLUP");
            return groupBy.setWithRollup();
        }
        return groupBy;
    }

    protected OrderBy orderBy() throws SQLSyntaxErrorException {
        OrderBy orderBy;
        if (this.lexer.token() != MySQLToken.KW_ORDER) {
            return null;
        }
        this.lexer.nextToken();
        this.match(MySQLToken.KW_BY);
        Expression expr = this.exprParser.expression();
        SortOrder order = SortOrder.ASC;
        switch (this.lexer.token()) {
            case KW_DESC: {
                order = SortOrder.DESC;
            }
            case KW_ASC: {
                if (this.lexer.nextToken() != MySQLToken.PUNC_COMMA) {
                    return new OrderBy(expr, order);
                }
            }
            case PUNC_COMMA: {
                orderBy = new OrderBy();
                orderBy.addOrderByItem(expr, order);
                break;
            }
            default: {
                return new OrderBy(expr, order);
            }
        }
        while (this.lexer.token() == MySQLToken.PUNC_COMMA) {
            this.lexer.nextToken();
            order = SortOrder.ASC;
            expr = this.exprParser.expression();
            switch (this.lexer.token()) {
                case KW_DESC: {
                    order = SortOrder.DESC;
                }
                case KW_ASC: {
                    this.lexer.nextToken();
                }
            }
            orderBy.addOrderByItem(expr, order);
        }
        return orderBy;
    }

    protected List<Identifier> buildIdList(Identifier id) throws SQLSyntaxErrorException {
        if (this.lexer.token() != MySQLToken.PUNC_COMMA) {
            ArrayList<Identifier> list = new ArrayList<Identifier>(1);
            list.add(id);
            return list;
        }
        LinkedList<Identifier> list = new LinkedList<Identifier>();
        list.add(id);
        while (this.lexer.token() == MySQLToken.PUNC_COMMA) {
            this.lexer.nextToken();
            id = this.identifier();
            list.add(id);
        }
        return list;
    }

    protected List<Identifier> idList() throws SQLSyntaxErrorException {
        return this.buildIdList(this.identifier());
    }

    protected List<String> idNameList() throws SQLSyntaxErrorException {
        AbstractList list;
        if (this.lexer.token() != MySQLToken.IDENTIFIER) {
            this.match(MySQLToken.PUNC_RIGHT_PAREN);
            return Collections.emptyList();
        }
        String str = this.lexer.stringValue();
        if (this.lexer.nextToken() == MySQLToken.PUNC_COMMA) {
            list = new LinkedList<String>();
            list.add(str);
            while (this.lexer.token() == MySQLToken.PUNC_COMMA) {
                this.lexer.nextToken();
                list.add(this.lexer.stringValue());
                this.match(MySQLToken.IDENTIFIER);
            }
        } else {
            list = new ArrayList(1);
            list.add(str);
        }
        this.match(MySQLToken.PUNC_RIGHT_PAREN);
        return list;
    }

    protected List<String> indexNameList() throws SQLSyntaxErrorException {
        AbstractList list;
        if (this.lexer.token() != MySQLToken.IDENTIFIER && this.lexer.token() != MySQLToken.KW_PRIMARY) {
            this.match(MySQLToken.PUNC_RIGHT_PAREN);
            return Collections.emptyList();
        }
        String str = this.lexer.stringValue();
        if (this.lexer.nextToken() == MySQLToken.PUNC_COMMA) {
            list = new LinkedList<String>();
            list.add(str);
            while (this.lexer.token() == MySQLToken.PUNC_COMMA) {
                this.lexer.nextToken();
                list.add(this.lexer.stringValue());
                this.match(MySQLToken.IDENTIFIER);
            }
        } else {
            list = new ArrayList(1);
            list.add(str);
        }
        this.match(MySQLToken.PUNC_RIGHT_PAREN);
        return list;
    }

    protected TableReferences tableRefs() throws SQLSyntaxErrorException {
        TableReference ref = this.tableReference();
        return this.buildTableReferences(ref);
    }

    private TableReferences buildTableReferences(TableReference ref) throws SQLSyntaxErrorException {
        AbstractList list;
        if (this.lexer.token() == MySQLToken.PUNC_COMMA) {
            list = new LinkedList<TableReference>();
            list.add(ref);
            while (this.lexer.token() == MySQLToken.PUNC_COMMA) {
                this.lexer.nextToken();
                ref = this.tableReference();
                list.add(ref);
            }
        } else {
            list = new ArrayList(1);
            list.add(ref);
        }
        return new TableReferences(list);
    }

    private TableReference tableReference() throws SQLSyntaxErrorException {
        TableReference ref = this.tableFactor();
        return this.buildTableReference(ref);
    }

    private TableReference buildTableReference(TableReference ref) throws SQLSyntaxErrorException {
        while (true) {
            boolean isOut = false;
            boolean isLeft = true;
            block0 : switch (this.lexer.token()) {
                case KW_INNER: 
                case KW_CROSS: {
                    this.lexer.nextToken();
                }
                case KW_JOIN: {
                    List<String> using;
                    Expression on;
                    this.lexer.nextToken();
                    TableReference temp = this.tableFactor();
                    switch (this.lexer.token()) {
                        case KW_ON: {
                            this.lexer.nextToken();
                            on = this.exprParser.expression();
                            ref = new InnerJoin(ref, temp, on);
                            break block0;
                        }
                        case KW_USING: {
                            this.lexer.nextToken();
                            this.match(MySQLToken.PUNC_LEFT_PAREN);
                            using = this.idNameList();
                            ref = new InnerJoin(ref, temp, using);
                            break block0;
                        }
                    }
                    ref = new InnerJoin(ref, temp);
                    break;
                }
                case KW_STRAIGHT_JOIN: {
                    Expression on;
                    this.lexer.nextToken();
                    TableReference temp = this.tableFactor();
                    switch (this.lexer.token()) {
                        case KW_ON: {
                            this.lexer.nextToken();
                            on = this.exprParser.expression();
                            ref = new StraightJoin(ref, temp, on);
                            break block0;
                        }
                    }
                    ref = new StraightJoin(ref, temp);
                    break;
                }
                case KW_RIGHT: {
                    isLeft = false;
                }
                case KW_LEFT: {
                    List<String> using;
                    Expression on;
                    this.lexer.nextToken();
                    if (this.lexer.token() == MySQLToken.KW_OUTER) {
                        this.lexer.nextToken();
                    }
                    this.match(MySQLToken.KW_JOIN);
                    TableReference temp = this.tableReference();
                    switch (this.lexer.token()) {
                        case KW_ON: {
                            this.lexer.nextToken();
                            on = this.exprParser.expression();
                            ref = new OuterJoin(isLeft, ref, temp, on);
                            break block0;
                        }
                        case KW_USING: {
                            this.lexer.nextToken();
                            this.match(MySQLToken.PUNC_LEFT_PAREN);
                            using = this.idNameList();
                            ref = new OuterJoin(isLeft, ref, temp, using);
                            break block0;
                        }
                    }
                    Object condition = temp.removeLastConditionElement();
                    if (condition instanceof Expression) {
                        ref = new OuterJoin(isLeft, ref, temp, (Expression)condition);
                        break;
                    }
                    if (condition instanceof List) {
                        ref = new OuterJoin(isLeft, ref, temp, (List)condition);
                        break;
                    }
                    throw this.err("conditionExpr cannot be null for outer join");
                }
                case KW_NATURAL: {
                    TableReference temp;
                    this.lexer.nextToken();
                    switch (this.lexer.token()) {
                        case KW_RIGHT: {
                            isLeft = false;
                        }
                        case KW_LEFT: {
                            this.lexer.nextToken();
                            if (this.lexer.token() == MySQLToken.KW_OUTER) {
                                this.lexer.nextToken();
                            }
                            isOut = true;
                        }
                        case KW_JOIN: {
                            this.lexer.nextToken();
                            temp = this.tableFactor();
                            ref = new NaturalJoin(isOut, isLeft, ref, temp);
                            break block0;
                        }
                    }
                    throw this.err("unexpected token after NATURAL for natural join:" + (Object)((Object)this.lexer.token()));
                }
                default: {
                    return ref;
                }
            }
        }
    }

    private TableReference tableFactor() throws SQLSyntaxErrorException {
        String alias = null;
        switch (this.lexer.token()) {
            case PUNC_LEFT_PAREN: {
                this.lexer.nextToken();
                Object ref = this.trsOrQuery();
                this.match(MySQLToken.PUNC_RIGHT_PAREN);
                if (ref instanceof QueryExpression) {
                    alias = this.as();
                    return new SubqueryFactor((QueryExpression)ref, alias);
                }
                return (TableReferences)ref;
            }
            case IDENTIFIER: {
                Identifier table = this.identifier();
                alias = this.as();
                List<IndexHint> hintList = this.hintList();
                return new TableRefFactor(table, alias, hintList);
            }
        }
        throw this.err("unexpected token for tableFactor: " + (Object)((Object)this.lexer.token()));
    }

    protected String as() throws SQLSyntaxErrorException {
        if (this.lexer.token() == MySQLToken.KW_AS) {
            this.lexer.nextToken();
        }
        StringBuilder alias = new StringBuilder();
        boolean id = false;
        if (this.lexer.token() == MySQLToken.IDENTIFIER) {
            alias.append(this.lexer.stringValue());
            id = true;
            this.lexer.nextToken();
        }
        if (this.lexer.token() == MySQLToken.LITERAL_CHARS && (!id || id && alias.charAt(0) == '_')) {
            alias.append(this.lexer.stringValue());
            this.lexer.nextToken();
        }
        return alias.length() > 0 ? alias.toString() : null;
    }

    private Object trsOrQuery() throws SQLSyntaxErrorException {
        Object ref;
        switch (this.lexer.token()) {
            case KW_SELECT: {
                DMLSelectStatement select = this.selectPrimary();
                return this.buildUnionSelect(select);
            }
            case PUNC_LEFT_PAREN: {
                this.lexer.nextToken();
                ref = this.trsOrQuery();
                this.match(MySQLToken.PUNC_RIGHT_PAREN);
                if (ref instanceof QueryExpression) {
                    DMLQueryStatement rst;
                    if (ref instanceof DMLSelectStatement && (rst = this.buildUnionSelect((DMLSelectStatement)ref)) != ref) {
                        return rst;
                    }
                    String alias = this.as();
                    if (alias != null) {
                        ref = new SubqueryFactor((QueryExpression)ref, alias);
                    } else {
                        return ref;
                    }
                }
                ref = this.buildTableReference((TableReference)ref);
                break;
            }
            default: {
                ref = this.tableReference();
            }
        }
        if (this.lexer.token() == MySQLToken.PUNC_COMMA) {
            LinkedList<TableReference> list = new LinkedList<TableReference>();
            list.add((TableReference)ref);
            while (this.lexer.token() == MySQLToken.PUNC_COMMA) {
                this.lexer.nextToken();
                ref = this.tableReference();
                list.add((TableReference)ref);
            }
            return new TableReferences(list);
        }
        ArrayList<TableReference> list = new ArrayList<TableReference>(1);
        list.add((TableReference)ref);
        return new TableReferences(list);
    }

    private List<IndexHint> hintList() throws SQLSyntaxErrorException {
        IndexHint hint = this.hint();
        if (hint == null) {
            return null;
        }
        IndexHint hint2 = this.hint();
        if (hint2 == null) {
            ArrayList<IndexHint> list = new ArrayList<IndexHint>(1);
            list.add(hint);
            return list;
        }
        LinkedList<IndexHint> list = new LinkedList<IndexHint>();
        list.add(hint);
        list.add(hint2);
        while ((hint2 = this.hint()) != null) {
            list.add(hint2);
        }
        return list;
    }

    private IndexHint hint() throws SQLSyntaxErrorException {
        IndexHint.IndexType type;
        IndexHint.IndexAction action;
        switch (this.lexer.token()) {
            case KW_USE: {
                action = IndexHint.IndexAction.USE;
                break;
            }
            case KW_IGNORE: {
                action = IndexHint.IndexAction.IGNORE;
                break;
            }
            case KW_FORCE: {
                action = IndexHint.IndexAction.FORCE;
                break;
            }
            default: {
                return null;
            }
        }
        switch (this.lexer.nextToken()) {
            case KW_INDEX: {
                type = IndexHint.IndexType.INDEX;
                break;
            }
            case KW_KEY: {
                type = IndexHint.IndexType.KEY;
                break;
            }
            default: {
                throw this.err("must be INDEX or KEY for hint type, not " + (Object)((Object)this.lexer.token()));
            }
        }
        IndexHint.IndexScope scope = IndexHint.IndexScope.ALL;
        if (this.lexer.nextToken() == MySQLToken.KW_FOR) {
            switch (this.lexer.nextToken()) {
                case KW_JOIN: {
                    this.lexer.nextToken();
                    scope = IndexHint.IndexScope.JOIN;
                    break;
                }
                case KW_ORDER: {
                    this.lexer.nextToken();
                    this.match(MySQLToken.KW_BY);
                    scope = IndexHint.IndexScope.ORDER_BY;
                    break;
                }
                case KW_GROUP: {
                    this.lexer.nextToken();
                    this.match(MySQLToken.KW_BY);
                    scope = IndexHint.IndexScope.GROUP_BY;
                    break;
                }
                default: {
                    throw this.err("must be JOIN or ORDER or GROUP for hint scope, not " + (Object)((Object)this.lexer.token()));
                }
            }
        }
        this.match(MySQLToken.PUNC_LEFT_PAREN);
        List<String> indexList = this.indexNameList();
        return new IndexHint(action, type, scope, indexList);
    }

    protected DMLQueryStatement buildUnionSelect(DMLSelectStatement select) throws SQLSyntaxErrorException {
        if (this.lexer.token() != MySQLToken.KW_UNION) {
            return select;
        }
        DMLSelectUnionStatement union = new DMLSelectUnionStatement(select);
        DMLSelectUnionStatement.UnionOption option = DMLSelectUnionStatement.UnionOption.DEFAULT;
        while (this.lexer.token() == MySQLToken.KW_UNION) {
            this.lexer.nextToken();
            switch (this.lexer.token()) {
                case KW_ALL: {
                    option = DMLSelectUnionStatement.UnionOption.ALL;
                    this.lexer.nextToken();
                    break;
                }
                case KW_DISTINCT: {
                    option = DMLSelectUnionStatement.UnionOption.DISTINCT;
                    this.lexer.nextToken();
                    break;
                }
            }
            select = this.selectPrimary(true);
            union.addSelect(select, option);
        }
        union.setOrderBy(this.orderBy()).setLimit(this.limit());
        return union;
    }

    protected DMLSelectStatement selectPrimary(boolean isUnion) throws SQLSyntaxErrorException {
        switch (this.lexer.token()) {
            case KW_SELECT: {
                if (isUnion) {
                    return this.select(true);
                }
                return this.select();
            }
            case PUNC_LEFT_PAREN: {
                this.lexer.nextToken();
                DMLSelectStatement select = this.selectPrimary(false);
                this.match(MySQLToken.PUNC_RIGHT_PAREN);
                return select;
            }
        }
        throw this.err("unexpected token: " + (Object)((Object)this.lexer.token()));
    }

    protected DMLSelectStatement selectPrimary() throws SQLSyntaxErrorException {
        return this.selectPrimary(false);
    }

    public DMLSelectStatement select() throws SQLSyntaxErrorException {
        return this.select(false);
    }

    public DMLSelectStatement select(boolean ignoreOrderByAndLimit) throws SQLSyntaxErrorException {
        return new MySQLDMLSelectParser(this.lexer, this.exprParser).select(ignoreOrderByAndLimit);
    }

    public DMLQueryStatement selectUnion() throws SQLSyntaxErrorException {
        return new MySQLDMLSelectParser(this.lexer, this.exprParser).selectUnion();
    }
}

