/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.txc.parser.recognizer.mysql.syntax;

import com.alibaba.txc.parser.ast.expression.Expression;
import com.alibaba.txc.parser.ast.expression.primary.Identifier;
import com.alibaba.txc.parser.ast.expression.primary.RowExpression;
import com.alibaba.txc.parser.ast.stmt.dml.DMLQueryStatement;
import com.alibaba.txc.parser.ast.stmt.dml.DMLReplaceStatement;
import com.alibaba.txc.parser.recognizer.mysql.MySQLToken;
import com.alibaba.txc.parser.recognizer.mysql.lexer.MySQLLexer;
import com.alibaba.txc.parser.recognizer.mysql.syntax.MySQLDMLInsertReplaceParser;
import com.alibaba.txc.parser.recognizer.mysql.syntax.MySQLExprParser;
import java.sql.SQLSyntaxErrorException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class MySQLDMLReplaceParser
extends MySQLDMLInsertReplaceParser {
    public MySQLDMLReplaceParser(MySQLLexer lexer, MySQLExprParser exprParser) {
        super(lexer, exprParser);
    }

    public DMLReplaceStatement replace() throws SQLSyntaxErrorException {
        this.match(MySQLToken.KW_REPLACE);
        DMLReplaceStatement.ReplaceMode mode = DMLReplaceStatement.ReplaceMode.UNDEF;
        switch (this.lexer.token()) {
            case KW_LOW_PRIORITY: {
                this.lexer.nextToken();
                mode = DMLReplaceStatement.ReplaceMode.LOW;
                break;
            }
            case KW_DELAYED: {
                this.lexer.nextToken();
                mode = DMLReplaceStatement.ReplaceMode.DELAY;
                break;
            }
        }
        if (this.lexer.token() == MySQLToken.KW_INTO) {
            this.lexer.nextToken();
        }
        Identifier table = this.identifier();
        switch (this.lexer.token()) {
            case KW_SET: {
                this.lexer.nextToken();
                LinkedList<Identifier> columnNameList = new LinkedList<Identifier>();
                LinkedList<Expression> tempRowValue = new LinkedList<Expression>();
                while (true) {
                    Identifier id = this.identifier();
                    this.match(MySQLToken.OP_EQUALS, MySQLToken.OP_ASSIGN);
                    Expression expr = this.exprParser.expression();
                    columnNameList.add(id);
                    tempRowValue.add(expr);
                    if (this.lexer.token() != MySQLToken.PUNC_COMMA) break;
                    this.lexer.nextToken();
                }
                ArrayList<RowExpression> rowList = new ArrayList<RowExpression>(1);
                rowList.add(new RowExpression(tempRowValue));
                return new DMLReplaceStatement(mode, table, columnNameList, rowList);
            }
            case IDENTIFIER: {
                if (!"VALUE".equals(this.lexer.stringValueUppercase())) break;
            }
            case KW_VALUES: {
                this.lexer.nextToken();
                List<Identifier> columnNameList = null;
                List<RowExpression> rowList = this.rowList();
                return new DMLReplaceStatement(mode, table, columnNameList, rowList);
            }
            case KW_SELECT: {
                List<Identifier> columnNameList = null;
                DMLQueryStatement select = this.selectUnion();
                return new DMLReplaceStatement(mode, table, columnNameList, select);
            }
            case PUNC_LEFT_PAREN: {
                switch (this.lexer.nextToken()) {
                    case PUNC_LEFT_PAREN: 
                    case KW_SELECT: {
                        List<Identifier> columnNameList = null;
                        DMLQueryStatement select = this.selectUnion();
                        this.match(MySQLToken.PUNC_RIGHT_PAREN);
                        return new DMLReplaceStatement(mode, table, columnNameList, select);
                    }
                }
                List<Identifier> columnNameList = this.idList();
                this.match(MySQLToken.PUNC_RIGHT_PAREN);
                switch (this.lexer.token()) {
                    case PUNC_LEFT_PAREN: 
                    case KW_SELECT: {
                        DMLQueryStatement select = this.selectUnion();
                        return new DMLReplaceStatement(mode, table, columnNameList, select);
                    }
                    case KW_VALUES: {
                        this.lexer.nextToken();
                        break;
                    }
                    default: {
                        this.matchIdentifier("VALUE");
                    }
                }
                List<RowExpression> rowList = this.rowList();
                return new DMLReplaceStatement(mode, table, columnNameList, rowList);
            }
        }
        throw this.err("unexpected token for replace: " + (Object)((Object)this.lexer.token()));
    }
}

