/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.txc.parser.recognizer.mysql.syntax;

import com.alibaba.txc.parser.ast.expression.Expression;
import com.alibaba.txc.parser.ast.expression.primary.Identifier;
import com.alibaba.txc.parser.ast.fragment.GroupBy;
import com.alibaba.txc.parser.ast.fragment.Limit;
import com.alibaba.txc.parser.ast.fragment.OrderBy;
import com.alibaba.txc.parser.ast.fragment.tableref.Dual;
import com.alibaba.txc.parser.ast.fragment.tableref.TableReference;
import com.alibaba.txc.parser.ast.fragment.tableref.TableReferences;
import com.alibaba.txc.parser.ast.stmt.dml.DMLQueryStatement;
import com.alibaba.txc.parser.ast.stmt.dml.DMLSelectFromUpdateStatement;
import com.alibaba.txc.parser.ast.stmt.dml.DMLSelectStatement;
import com.alibaba.txc.parser.recognizer.mysql.MySQLToken;
import com.alibaba.txc.parser.recognizer.mysql.lexer.MySQLLexer;
import com.alibaba.txc.parser.recognizer.mysql.syntax.MySQLDMLParser;
import com.alibaba.txc.parser.recognizer.mysql.syntax.MySQLExprParser;
import com.alibaba.txc.parser.util.Pair;
import java.sql.SQLSyntaxErrorException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class MySQLDMLSelectParser
extends MySQLDMLParser {
    private static final Map<String, SpecialIdentifier> specialIdentifiers = new HashMap<String, SpecialIdentifier>();

    public MySQLDMLSelectParser(MySQLLexer lexer, MySQLExprParser exprParser) {
        super(lexer, exprParser);
        this.exprParser.setSelectParser(this);
    }

    private DMLSelectStatement.SelectOption selectOption() throws SQLSyntaxErrorException {
        DMLSelectStatement.SelectOption option = new DMLSelectStatement.SelectOption();
        while (true) {
            block0 : switch (this.lexer.token()) {
                case KW_ALL: {
                    option.resultDup = DMLSelectStatement.SelectDuplicationStrategy.ALL;
                    break;
                }
                case KW_DISTINCT: {
                    option.resultDup = DMLSelectStatement.SelectDuplicationStrategy.DISTINCT;
                    break;
                }
                case KW_DISTINCTROW: {
                    option.resultDup = DMLSelectStatement.SelectDuplicationStrategy.DISTINCTROW;
                    break;
                }
                case KW_HIGH_PRIORITY: {
                    option.highPriority = true;
                    break;
                }
                case KW_STRAIGHT_JOIN: {
                    option.straightJoin = true;
                    break;
                }
                case KW_SQL_SMALL_RESULT: {
                    option.resultSize = DMLSelectStatement.SmallOrBigResult.SQL_SMALL_RESULT;
                    break;
                }
                case KW_SQL_BIG_RESULT: {
                    option.resultSize = DMLSelectStatement.SmallOrBigResult.SQL_BIG_RESULT;
                    break;
                }
                case KW_SQL_CALC_FOUND_ROWS: {
                    option.sqlCalcFoundRows = true;
                    break;
                }
                case IDENTIFIER: {
                    String optionStringUp = this.lexer.stringValueUppercase();
                    SpecialIdentifier specialId = specialIdentifiers.get(optionStringUp);
                    if (specialId != null) {
                        switch (specialId) {
                            case SQL_BUFFER_RESULT: {
                                if (option.sqlBufferResult) {
                                    return option;
                                }
                                option.sqlBufferResult = true;
                                break block0;
                            }
                            case SQL_CACHE: {
                                if (option.queryCache != DMLSelectStatement.QueryCacheStrategy.UNDEF) {
                                    return option;
                                }
                                option.queryCache = DMLSelectStatement.QueryCacheStrategy.SQL_CACHE;
                                break block0;
                            }
                            case SQL_NO_CACHE: {
                                if (option.queryCache != DMLSelectStatement.QueryCacheStrategy.UNDEF) {
                                    return option;
                                }
                                option.queryCache = DMLSelectStatement.QueryCacheStrategy.SQL_NO_CACHE;
                                break block0;
                            }
                        }
                    }
                }
                default: {
                    return option;
                }
            }
            this.lexer.nextToken();
        }
    }

    private List<Pair<Expression, String>> selectExprList() throws SQLSyntaxErrorException {
        LinkedList<Pair<Expression, String>> list;
        int beginOffset = this.lexer.getLastTokenIndex();
        Expression expr = this.exprParser.expression();
        int endOffset = this.lexer.getLastTokenIndex();
        String str = String.valueOf(this.lexer.getSQL(), beginOffset, endOffset - beginOffset).trim();
        expr.setOriginStr(str);
        String alias = this.as();
        if (this.lexer.token() == MySQLToken.PUNC_COMMA) {
            list = new LinkedList<Pair<Expression, String>>();
            list.add(new Pair<Expression, String>(expr, alias));
        } else {
            ArrayList<Pair<Expression, String>> list2 = new ArrayList<Pair<Expression, String>>(1);
            list2.add(new Pair<Expression, String>(expr, alias));
            return list2;
        }
        while (this.lexer.token() == MySQLToken.PUNC_COMMA) {
            this.lexer.nextToken();
            beginOffset = this.lexer.getLastTokenIndex();
            expr = this.exprParser.expression();
            endOffset = this.lexer.getLastTokenIndex();
            str = String.valueOf(this.lexer.getSQL(), beginOffset, endOffset - beginOffset).trim();
            expr.setOriginStr(str);
            alias = this.as();
            list.add(new Pair<Expression, String>(expr, alias));
        }
        return list;
    }

    @Override
    public DMLSelectStatement select(boolean ignoreOrderByAndLimit) throws SQLSyntaxErrorException {
        this.match(MySQLToken.KW_SELECT);
        DMLSelectStatement.SelectOption option = this.selectOption();
        List<Pair<Expression, String>> exprList = this.selectExprList();
        TableReferences tables = null;
        Expression where = null;
        GroupBy group = null;
        Expression having = null;
        OrderBy order = null;
        Limit limit = null;
        boolean dual = false;
        if (this.lexer.token() == MySQLToken.KW_FROM) {
            if (this.lexer.nextToken() == MySQLToken.KW_DUAL) {
                this.lexer.nextToken();
                dual = true;
                ArrayList<TableReference> trs = new ArrayList<TableReference>(1);
                trs.add(new Dual());
                tables = new TableReferences(trs);
            } else {
                if (this.lexer.token() == MySQLToken.KW_UPDATE) {
                    AbstractList values;
                    this.match(MySQLToken.KW_UPDATE);
                    DMLSelectFromUpdateStatement.SelectFromUpdateOption selectFromUpdateOption = this.selectFromUpdateOption();
                    Identifier table = this.identifier();
                    this.match(MySQLToken.KW_SET);
                    Identifier col = this.identifier();
                    this.match(MySQLToken.OP_EQUALS, MySQLToken.OP_ASSIGN);
                    Expression expr = this.exprParser.expression();
                    if (this.lexer.token() == MySQLToken.PUNC_COMMA) {
                        values = new LinkedList<Pair<Identifier, Expression>>();
                        values.add(new Pair<Identifier, Expression>(col, expr));
                        while (this.lexer.token() == MySQLToken.PUNC_COMMA) {
                            this.lexer.nextToken();
                            col = this.identifier();
                            this.match(MySQLToken.OP_EQUALS, MySQLToken.OP_ASSIGN);
                            expr = this.exprParser.expression();
                            values.add(new Pair<Identifier, Expression>(col, expr));
                        }
                    } else {
                        values = new ArrayList(1);
                        values.add(new Pair<Identifier, Expression>(col, expr));
                    }
                    if (this.lexer.token() == MySQLToken.KW_WHERE) {
                        this.lexer.nextToken();
                        where = this.exprParser.expression();
                    }
                    OrderBy orderBy = null;
                    orderBy = this.orderBy();
                    limit = this.dmlLimit();
                    return new DMLSelectFromUpdateStatement(selectFromUpdateOption, exprList, table, values, where, orderBy, limit);
                }
                tables = this.tableRefs();
            }
        }
        if (this.lexer.token() == MySQLToken.KW_WHERE) {
            this.lexer.nextToken();
            where = this.exprParser.expression();
        }
        if (!dual) {
            group = this.groupBy();
            if (this.lexer.token() == MySQLToken.KW_HAVING) {
                this.lexer.nextToken();
                having = this.exprParser.expression();
            }
            if (ignoreOrderByAndLimit) {
                return new DMLSelectStatement(option, exprList, tables, where, group, having, order, limit);
            }
            order = this.orderBy();
        }
        limit = this.limit();
        if (!dual) {
            switch (this.lexer.token()) {
                case KW_FOR: {
                    this.lexer.nextToken();
                    this.match(MySQLToken.KW_UPDATE);
                    option.lockMode = DMLSelectStatement.LockMode.FOR_UPDATE;
                    break;
                }
                case KW_LOCK: {
                    this.lexer.nextToken();
                    this.match(MySQLToken.KW_IN);
                    this.matchIdentifier("SHARE");
                    this.matchIdentifier("MODE");
                    option.lockMode = DMLSelectStatement.LockMode.LOCK_IN_SHARE_MODE;
                    break;
                }
            }
        }
        return new DMLSelectStatement(option, exprList, tables, where, group, having, order, limit);
    }

    private DMLSelectFromUpdateStatement.SelectFromUpdateOption selectFromUpdateOption() throws SQLSyntaxErrorException {
        DMLSelectFromUpdateStatement.SelectFromUpdateOption option = new DMLSelectFromUpdateStatement.SelectFromUpdateOption();
        while (true) {
            block0 : switch (this.lexer.token()) {
                case KW_LOW_PRIORITY: {
                    option.lowPriority = true;
                    break;
                }
                case KW_IGNORE: {
                    option.ignore = true;
                    break;
                }
                case IDENTIFIER: {
                    String optionStringUp = this.lexer.stringValueUppercase();
                    SpecialIdentifier specialId = specialIdentifiers.get(optionStringUp);
                    if (specialId != null) {
                        switch (specialId) {
                            case COMMIT_ON_SUCCESS: {
                                option.commitOnSuccess = true;
                                break block0;
                            }
                            case ROLLBACK_ON_FAIL: {
                                option.rollbackOnFail = true;
                                break block0;
                            }
                            case QUEUE_ON_PK: {
                                int paramIndex1;
                                Number num1;
                                option.queueOnPk = true;
                                switch (this.lexer.nextToken()) {
                                    case LITERAL_NUM_PURE_DIGIT: {
                                        option.queueOnPkNum = num1 = this.lexer.integerValue();
                                        break block0;
                                    }
                                    case QUESTION_MARK: {
                                        paramIndex1 = this.lexer.paramIndex();
                                        option.queueOnPkNumP = this.createParam(paramIndex1);
                                        break block0;
                                    }
                                }
                                throw this.err("expect digit or ? after QUEUE_ON_PK");
                            }
                            case TARGET_AFFECT_ROW: {
                                int paramIndex1;
                                Number num1;
                                option.targetAffectRow = true;
                                switch (this.lexer.nextToken()) {
                                    case LITERAL_NUM_PURE_DIGIT: {
                                        option.num = num1 = this.lexer.integerValue();
                                        break block0;
                                    }
                                    case QUESTION_MARK: {
                                        paramIndex1 = this.lexer.paramIndex();
                                        option.numP = this.createParam(paramIndex1);
                                        break block0;
                                    }
                                }
                                throw this.err("expect digit or ? after TARGET_AFFECT_ROW");
                            }
                        }
                    }
                }
                default: {
                    return option;
                }
            }
            this.lexer.nextToken();
        }
    }

    @Override
    public DMLSelectStatement select() throws SQLSyntaxErrorException {
        return this.select(false);
    }

    @Override
    public DMLQueryStatement selectUnion() throws SQLSyntaxErrorException {
        DMLSelectStatement select = this.selectPrimary();
        DMLQueryStatement query = this.buildUnionSelect(select);
        return query;
    }

    static {
        specialIdentifiers.put("SQL_BUFFER_RESULT", SpecialIdentifier.SQL_BUFFER_RESULT);
        specialIdentifiers.put("SQL_CACHE", SpecialIdentifier.SQL_CACHE);
        specialIdentifiers.put("SQL_NO_CACHE", SpecialIdentifier.SQL_NO_CACHE);
        specialIdentifiers.put("COMMIT_ON_SUCCESS", SpecialIdentifier.COMMIT_ON_SUCCESS);
        specialIdentifiers.put("ROLLBACK_ON_FAIL", SpecialIdentifier.ROLLBACK_ON_FAIL);
        specialIdentifiers.put("QUEUE_ON_PK", SpecialIdentifier.QUEUE_ON_PK);
        specialIdentifiers.put("TARGET_AFFECT_ROW", SpecialIdentifier.TARGET_AFFECT_ROW);
    }

    private static enum SpecialIdentifier {
        SQL_BUFFER_RESULT,
        SQL_CACHE,
        SQL_NO_CACHE,
        COMMIT_ON_SUCCESS,
        ROLLBACK_ON_FAIL,
        QUEUE_ON_PK,
        TARGET_AFFECT_ROW;

    }
}

