/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.txc.parser.recognizer.mysql.syntax;

import com.alibaba.txc.parser.ast.expression.Expression;
import com.alibaba.txc.parser.ast.expression.primary.Identifier;
import com.alibaba.txc.parser.ast.expression.primary.ParamMarker;
import com.alibaba.txc.parser.ast.fragment.Limit;
import com.alibaba.txc.parser.ast.fragment.OrderBy;
import com.alibaba.txc.parser.ast.fragment.tableref.TableReferences;
import com.alibaba.txc.parser.ast.stmt.dml.DMLUpdateStatement;
import com.alibaba.txc.parser.recognizer.mysql.MySQLToken;
import com.alibaba.txc.parser.recognizer.mysql.lexer.MySQLLexer;
import com.alibaba.txc.parser.recognizer.mysql.syntax.MySQLDMLParser;
import com.alibaba.txc.parser.recognizer.mysql.syntax.MySQLExprParser;
import com.alibaba.txc.parser.util.Pair;
import java.sql.SQLSyntaxErrorException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class MySQLDMLUpdateParser
extends MySQLDMLParser {
    private static final Map<String, SpecialIdentifier> specialIdentifiers = new HashMap<String, SpecialIdentifier>();

    public MySQLDMLUpdateParser(MySQLLexer lexer, MySQLExprParser exprParser) {
        super(lexer, exprParser);
    }

    public DMLUpdateStatement update() throws SQLSyntaxErrorException {
        AbstractList values;
        this.match(MySQLToken.KW_UPDATE);
        boolean lowPriority = false;
        boolean ignore = false;
        if (this.lexer.token() == MySQLToken.KW_LOW_PRIORITY) {
            this.lexer.nextToken();
            lowPriority = true;
        }
        boolean commitOnSuccess = false;
        boolean rollbackOnFail = false;
        boolean queueOnPk = false;
        boolean targetAffectRow = false;
        Number queueOnPkNum = null;
        ParamMarker queueOnPkNumP = null;
        Number num = null;
        ParamMarker numP = null;
        block17: while (true) {
            block0 : switch (this.lexer.token()) {
                case IDENTIFIER: {
                    String optionStringUp = this.lexer.stringValueUppercase();
                    SpecialIdentifier specialId = specialIdentifiers.get(optionStringUp);
                    if (specialId == null) break block17;
                    switch (specialId) {
                        case COMMIT_ON_SUCCESS: {
                            commitOnSuccess = true;
                            break block0;
                        }
                        case ROLLBACK_ON_FAIL: {
                            rollbackOnFail = true;
                            break block0;
                        }
                        case QUEUE_ON_PK: {
                            int paramIndex1;
                            Number num1;
                            queueOnPk = true;
                            switch (this.lexer.nextToken()) {
                                case LITERAL_NUM_PURE_DIGIT: {
                                    queueOnPkNum = num1 = this.lexer.integerValue();
                                    break block0;
                                }
                                case QUESTION_MARK: {
                                    paramIndex1 = this.lexer.paramIndex();
                                    queueOnPkNumP = this.createParam(paramIndex1);
                                    break block0;
                                }
                            }
                            throw this.err("expect digit or ? after QUEUE_ON_PK");
                        }
                        case TARGET_AFFECT_ROW: {
                            int paramIndex1;
                            Number num1;
                            targetAffectRow = true;
                            switch (this.lexer.nextToken()) {
                                case LITERAL_NUM_PURE_DIGIT: {
                                    num = num1 = this.lexer.integerValue();
                                    break block0;
                                }
                                case QUESTION_MARK: {
                                    paramIndex1 = this.lexer.paramIndex();
                                    numP = this.createParam(paramIndex1);
                                    break block0;
                                }
                            }
                            throw this.err("expect digit or ? after TARGET_AFFECT_ROW");
                        }
                    }
                    break block17;
                }
                default: {
                    break block17;
                }
            }
            this.lexer.nextToken();
        }
        if (this.lexer.token() == MySQLToken.KW_IGNORE) {
            this.lexer.nextToken();
            ignore = true;
        }
        TableReferences tableRefs = this.tableRefs();
        this.match(MySQLToken.KW_SET);
        Identifier col = this.identifier();
        this.match(MySQLToken.OP_EQUALS, MySQLToken.OP_ASSIGN);
        Expression expr = this.exprParser.expression();
        if (this.lexer.token() == MySQLToken.PUNC_COMMA) {
            values = new LinkedList<Pair<Identifier, Expression>>();
            values.add(new Pair<Identifier, Expression>(col, expr));
            while (this.lexer.token() == MySQLToken.PUNC_COMMA) {
                this.lexer.nextToken();
                col = this.identifier();
                this.match(MySQLToken.OP_EQUALS, MySQLToken.OP_ASSIGN);
                expr = this.exprParser.expression();
                values.add(new Pair<Identifier, Expression>(col, expr));
            }
        } else {
            values = new ArrayList(1);
            values.add(new Pair<Identifier, Expression>(col, expr));
        }
        Expression where = null;
        if (this.lexer.token() == MySQLToken.KW_WHERE) {
            this.lexer.nextToken();
            where = this.exprParser.expression();
        }
        OrderBy orderBy = null;
        Limit limit = null;
        if (tableRefs.isSingleTable()) {
            orderBy = this.orderBy();
            limit = this.dmlLimit();
        }
        return new DMLUpdateStatement(lowPriority, ignore, tableRefs, values, where, orderBy, limit, commitOnSuccess, rollbackOnFail, queueOnPk, targetAffectRow, queueOnPkNum, queueOnPkNumP, num, numP);
    }

    static {
        specialIdentifiers.put("COMMIT_ON_SUCCESS", SpecialIdentifier.COMMIT_ON_SUCCESS);
        specialIdentifiers.put("ROLLBACK_ON_FAIL", SpecialIdentifier.ROLLBACK_ON_FAIL);
        specialIdentifiers.put("QUEUE_ON_PK", SpecialIdentifier.QUEUE_ON_PK);
        specialIdentifiers.put("TARGET_AFFECT_ROW", SpecialIdentifier.TARGET_AFFECT_ROW);
    }

    private static enum SpecialIdentifier {
        COMMIT_ON_SUCCESS,
        ROLLBACK_ON_FAIL,
        QUEUE_ON_PK,
        TARGET_AFFECT_ROW;

    }
}

