/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.txc.parser.recognizer.mysql.syntax;

import com.alibaba.txc.parser.ast.expression.Expression;
import com.alibaba.txc.parser.ast.expression.arithmeic.ArithmeticAddExpression;
import com.alibaba.txc.parser.ast.expression.arithmeic.ArithmeticDivideExpression;
import com.alibaba.txc.parser.ast.expression.arithmeic.ArithmeticIntegerDivideExpression;
import com.alibaba.txc.parser.ast.expression.arithmeic.ArithmeticModExpression;
import com.alibaba.txc.parser.ast.expression.arithmeic.ArithmeticMultiplyExpression;
import com.alibaba.txc.parser.ast.expression.arithmeic.ArithmeticSubtractExpression;
import com.alibaba.txc.parser.ast.expression.arithmeic.MinusExpression;
import com.alibaba.txc.parser.ast.expression.bit.BitAndExpression;
import com.alibaba.txc.parser.ast.expression.bit.BitInvertExpression;
import com.alibaba.txc.parser.ast.expression.bit.BitOrExpression;
import com.alibaba.txc.parser.ast.expression.bit.BitShiftExpression;
import com.alibaba.txc.parser.ast.expression.bit.BitXORExpression;
import com.alibaba.txc.parser.ast.expression.comparison.BetweenAndExpression;
import com.alibaba.txc.parser.ast.expression.comparison.ComparisionEqualsExpression;
import com.alibaba.txc.parser.ast.expression.comparison.ComparisionGreaterThanExpression;
import com.alibaba.txc.parser.ast.expression.comparison.ComparisionGreaterThanOrEqualsExpression;
import com.alibaba.txc.parser.ast.expression.comparison.ComparisionIsExpression;
import com.alibaba.txc.parser.ast.expression.comparison.ComparisionLessOrGreaterThanExpression;
import com.alibaba.txc.parser.ast.expression.comparison.ComparisionLessThanExpression;
import com.alibaba.txc.parser.ast.expression.comparison.ComparisionLessThanOrEqualsExpression;
import com.alibaba.txc.parser.ast.expression.comparison.ComparisionNotEqualsExpression;
import com.alibaba.txc.parser.ast.expression.comparison.ComparisionNullSafeEqualsExpression;
import com.alibaba.txc.parser.ast.expression.comparison.InExpression;
import com.alibaba.txc.parser.ast.expression.logical.LogicalAndExpression;
import com.alibaba.txc.parser.ast.expression.logical.LogicalNotExpression;
import com.alibaba.txc.parser.ast.expression.logical.LogicalOrExpression;
import com.alibaba.txc.parser.ast.expression.logical.LogicalXORExpression;
import com.alibaba.txc.parser.ast.expression.logical.NegativeValueExpression;
import com.alibaba.txc.parser.ast.expression.misc.AssignmentExpression;
import com.alibaba.txc.parser.ast.expression.misc.InExpressionList;
import com.alibaba.txc.parser.ast.expression.misc.QueryExpression;
import com.alibaba.txc.parser.ast.expression.misc.SubqueryAllExpression;
import com.alibaba.txc.parser.ast.expression.misc.SubqueryAnyExpression;
import com.alibaba.txc.parser.ast.expression.misc.UserExpression;
import com.alibaba.txc.parser.ast.expression.primary.CaseWhenOperatorExpression;
import com.alibaba.txc.parser.ast.expression.primary.DefaultValue;
import com.alibaba.txc.parser.ast.expression.primary.ExistsPrimary;
import com.alibaba.txc.parser.ast.expression.primary.Identifier;
import com.alibaba.txc.parser.ast.expression.primary.MatchExpression;
import com.alibaba.txc.parser.ast.expression.primary.RowExpression;
import com.alibaba.txc.parser.ast.expression.primary.UsrDefVarPrimary;
import com.alibaba.txc.parser.ast.expression.primary.Wildcard;
import com.alibaba.txc.parser.ast.expression.primary.function.FunctionExpression;
import com.alibaba.txc.parser.ast.expression.primary.function.cast.Cast;
import com.alibaba.txc.parser.ast.expression.primary.function.cast.Convert;
import com.alibaba.txc.parser.ast.expression.primary.function.comparison.Interval;
import com.alibaba.txc.parser.ast.expression.primary.function.datetime.Curdate;
import com.alibaba.txc.parser.ast.expression.primary.function.datetime.Curtime;
import com.alibaba.txc.parser.ast.expression.primary.function.datetime.Extract;
import com.alibaba.txc.parser.ast.expression.primary.function.datetime.GetFormat;
import com.alibaba.txc.parser.ast.expression.primary.function.datetime.Now;
import com.alibaba.txc.parser.ast.expression.primary.function.datetime.Timestampadd;
import com.alibaba.txc.parser.ast.expression.primary.function.datetime.Timestampdiff;
import com.alibaba.txc.parser.ast.expression.primary.function.datetime.UtcDate;
import com.alibaba.txc.parser.ast.expression.primary.function.datetime.UtcTime;
import com.alibaba.txc.parser.ast.expression.primary.function.datetime.UtcTimestamp;
import com.alibaba.txc.parser.ast.expression.primary.function.groupby.Avg;
import com.alibaba.txc.parser.ast.expression.primary.function.groupby.Count;
import com.alibaba.txc.parser.ast.expression.primary.function.groupby.GroupConcat;
import com.alibaba.txc.parser.ast.expression.primary.function.groupby.Max;
import com.alibaba.txc.parser.ast.expression.primary.function.groupby.Min;
import com.alibaba.txc.parser.ast.expression.primary.function.groupby.Sum;
import com.alibaba.txc.parser.ast.expression.primary.function.info.CurrentUser;
import com.alibaba.txc.parser.ast.expression.primary.function.string.Char;
import com.alibaba.txc.parser.ast.expression.primary.function.string.Locate;
import com.alibaba.txc.parser.ast.expression.primary.function.string.Substring;
import com.alibaba.txc.parser.ast.expression.primary.function.string.Trim;
import com.alibaba.txc.parser.ast.expression.primary.literal.IntervalPrimary;
import com.alibaba.txc.parser.ast.expression.primary.literal.LiteralBitField;
import com.alibaba.txc.parser.ast.expression.primary.literal.LiteralBoolean;
import com.alibaba.txc.parser.ast.expression.primary.literal.LiteralHexadecimal;
import com.alibaba.txc.parser.ast.expression.primary.literal.LiteralNull;
import com.alibaba.txc.parser.ast.expression.primary.literal.LiteralNumber;
import com.alibaba.txc.parser.ast.expression.primary.literal.LiteralString;
import com.alibaba.txc.parser.ast.expression.string.LikeExpression;
import com.alibaba.txc.parser.ast.expression.string.RegexpExpression;
import com.alibaba.txc.parser.ast.expression.string.SoundsLikeExpression;
import com.alibaba.txc.parser.ast.expression.type.CastBinaryExpression;
import com.alibaba.txc.parser.ast.expression.type.CollateExpression;
import com.alibaba.txc.parser.ast.fragment.SortOrder;
import com.alibaba.txc.parser.recognizer.mysql.MySQLFunctionManager;
import com.alibaba.txc.parser.recognizer.mysql.MySQLToken;
import com.alibaba.txc.parser.recognizer.mysql.lexer.MySQLLexer;
import com.alibaba.txc.parser.recognizer.mysql.syntax.MySQLDMLSelectParser;
import com.alibaba.txc.parser.recognizer.mysql.syntax.MySQLParser;
import com.alibaba.txc.parser.util.Pair;
import java.math.BigDecimal;
import java.sql.SQLSyntaxErrorException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class MySQLExprParser
extends MySQLParser {
    private String charset;
    private final MySQLFunctionManager functionManager;
    private MySQLDMLSelectParser selectParser;

    public MySQLExprParser(MySQLLexer lexer) {
        this(lexer, MySQLFunctionManager.INSTANCE_MYSQL_DEFAULT, true, "utf-8");
    }

    public MySQLExprParser(MySQLLexer lexer, String charset) {
        this(lexer, MySQLFunctionManager.INSTANCE_MYSQL_DEFAULT, true, charset);
    }

    public MySQLExprParser(MySQLLexer lexer, MySQLFunctionManager functionManager, boolean cacheEvalRst, String charset) {
        super(lexer, cacheEvalRst);
        this.functionManager = functionManager;
        this.charset = charset == null ? "utf-8" : charset;
    }

    public void setSelectParser(MySQLDMLSelectParser selectParser) {
        this.selectParser = selectParser;
    }

    public Expression expression() throws SQLSyntaxErrorException {
        MySQLToken token = this.lexer.token();
        if (token == null) {
            token = this.lexer.nextToken();
        }
        if (token == MySQLToken.EOF) {
            this.err("unexpected EOF");
        }
        Expression left = this.logicalOrExpression();
        if (this.lexer.token() == MySQLToken.OP_ASSIGN) {
            this.lexer.nextToken();
            Expression right = this.expression();
            return new AssignmentExpression(left, right).setCacheEvalRst(this.cacheEvalRst);
        }
        return left;
    }

    private Expression logicalOrExpression() throws SQLSyntaxErrorException {
        LogicalOrExpression or = null;
        Expression expr = this.logicalXORExpression();
        block3: while (true) {
            switch (this.lexer.token()) {
                case OP_LOGICAL_OR: 
                case KW_OR: {
                    this.lexer.nextToken();
                    if (or == null) {
                        or = new LogicalOrExpression();
                        or.setCacheEvalRst(this.cacheEvalRst);
                        or.appendOperand(expr);
                        expr = or;
                    }
                    Expression newExpr = this.logicalXORExpression();
                    or.appendOperand(newExpr);
                    continue block3;
                }
            }
            break;
        }
        return expr;
    }

    private Expression logicalXORExpression() throws SQLSyntaxErrorException {
        Expression expr = this.logicalAndExpression();
        block3: while (true) {
            switch (this.lexer.token()) {
                case KW_XOR: {
                    this.lexer.nextToken();
                    Expression newExpr = this.logicalAndExpression();
                    expr = new LogicalXORExpression(expr, newExpr).setCacheEvalRst(this.cacheEvalRst);
                    continue block3;
                }
            }
            break;
        }
        return expr;
    }

    private Expression logicalAndExpression() throws SQLSyntaxErrorException {
        LogicalAndExpression and = null;
        Expression expr = this.logicalNotExpression();
        block3: while (true) {
            switch (this.lexer.token()) {
                case OP_LOGICAL_AND: 
                case KW_AND: {
                    this.lexer.nextToken();
                    if (and == null) {
                        and = new LogicalAndExpression();
                        and.setCacheEvalRst(this.cacheEvalRst);
                        and.appendOperand(expr);
                        expr = and;
                    }
                    Expression newExpr = this.logicalNotExpression();
                    and.appendOperand(newExpr);
                    continue block3;
                }
            }
            break;
        }
        return expr;
    }

    private Expression logicalNotExpression() throws SQLSyntaxErrorException {
        int not = 0;
        while (this.lexer.token() == MySQLToken.KW_NOT) {
            this.lexer.nextToken();
            ++not;
        }
        Expression expr = this.comparisionExpression();
        while (not > 0) {
            expr = new LogicalNotExpression(expr).setCacheEvalRst(this.cacheEvalRst);
            --not;
        }
        return expr;
    }

    private Expression comparisionExpression() throws SQLSyntaxErrorException {
        Expression fst = this.bitOrExpression(null, null);
        block33: while (true) {
            Expression temp;
            switch (this.lexer.token()) {
                case KW_NOT: {
                    int index;
                    Expression escape;
                    this.lexer.nextToken();
                    switch (this.lexer.token()) {
                        case KW_BETWEEN: {
                            this.lexer.nextToken();
                            Expression snd = this.comparisionExpression();
                            this.match(MySQLToken.KW_AND);
                            Expression trd = this.comparisionExpression();
                            return new BetweenAndExpression(true, fst, snd, trd).setCacheEvalRst(this.cacheEvalRst);
                        }
                        case KW_RLIKE: 
                        case KW_REGEXP: {
                            this.lexer.nextToken();
                            temp = this.bitOrExpression(null, null);
                            fst = new RegexpExpression(true, fst, temp).setCacheEvalRst(this.cacheEvalRst);
                            continue block33;
                        }
                        case KW_LIKE: {
                            this.lexer.nextToken();
                            temp = this.bitOrExpression(null, null);
                            escape = null;
                            if (this.equalsIdentifier("ESCAPE") >= 0) {
                                this.lexer.nextToken();
                                escape = this.bitOrExpression(null, null);
                            }
                            fst = new LikeExpression(true, fst, temp, escape).setCacheEvalRst(this.cacheEvalRst);
                            continue block33;
                        }
                        case KW_IN: {
                            if (this.lexer.nextToken() == MySQLToken.QUESTION_MARK) {
                                index = this.lexer.paramIndex();
                                this.lexer.nextToken();
                                fst = this.createParam(index);
                                continue block33;
                            }
                            if (this.lexer.token() != MySQLToken.PUNC_LEFT_PAREN) {
                                this.lexer.addCacheToke(MySQLToken.KW_IN);
                                return fst;
                            }
                            Expression in = this.rightOprandOfIn();
                            fst = new InExpression(true, fst, in).setCacheEvalRst(this.cacheEvalRst);
                            continue block33;
                        }
                    }
                    throw this.err("unexpect token after NOT: " + (Object)((Object)this.lexer.token()));
                }
                case KW_BETWEEN: {
                    this.lexer.nextToken();
                    Expression snd = this.comparisionExpression();
                    this.match(MySQLToken.KW_AND);
                    Expression trd = this.comparisionExpression();
                    return new BetweenAndExpression(false, fst, snd, trd).setCacheEvalRst(this.cacheEvalRst);
                }
                case KW_RLIKE: 
                case KW_REGEXP: {
                    this.lexer.nextToken();
                    temp = this.bitOrExpression(null, null);
                    fst = new RegexpExpression(false, fst, temp).setCacheEvalRst(this.cacheEvalRst);
                    continue block33;
                }
                case KW_LIKE: {
                    this.lexer.nextToken();
                    temp = this.bitOrExpression(null, null);
                    Expression escape = null;
                    if (this.equalsIdentifier("ESCAPE") >= 0) {
                        this.lexer.nextToken();
                        escape = this.bitOrExpression(null, null);
                    }
                    fst = new LikeExpression(false, fst, temp, escape).setCacheEvalRst(this.cacheEvalRst);
                    continue block33;
                }
                case KW_IN: {
                    int index;
                    if (this.lexer.nextToken() == MySQLToken.QUESTION_MARK) {
                        index = this.lexer.paramIndex();
                        this.lexer.nextToken();
                        fst = this.createParam(index);
                        continue block33;
                    }
                    if (this.lexer.token() != MySQLToken.PUNC_LEFT_PAREN) {
                        this.lexer.addCacheToke(MySQLToken.KW_IN);
                        return fst;
                    }
                    temp = this.rightOprandOfIn();
                    fst = new InExpression(false, fst, temp).setCacheEvalRst(this.cacheEvalRst);
                    continue block33;
                }
                case KW_IS: {
                    switch (this.lexer.nextToken()) {
                        case KW_NOT: {
                            switch (this.lexer.nextToken()) {
                                case LITERAL_NULL: {
                                    this.lexer.nextToken();
                                    fst = new ComparisionIsExpression(fst, 5).setCacheEvalRst(this.cacheEvalRst);
                                    continue block33;
                                }
                                case LITERAL_BOOL_FALSE: {
                                    this.lexer.nextToken();
                                    fst = new ComparisionIsExpression(fst, 7).setCacheEvalRst(this.cacheEvalRst);
                                    continue block33;
                                }
                                case LITERAL_BOOL_TRUE: {
                                    this.lexer.nextToken();
                                    fst = new ComparisionIsExpression(fst, 6).setCacheEvalRst(this.cacheEvalRst);
                                    continue block33;
                                }
                            }
                            this.matchIdentifier("UNKNOWN");
                            fst = new ComparisionIsExpression(fst, 8).setCacheEvalRst(this.cacheEvalRst);
                            continue block33;
                        }
                        case LITERAL_NULL: {
                            this.lexer.nextToken();
                            fst = new ComparisionIsExpression(fst, 1).setCacheEvalRst(this.cacheEvalRst);
                            continue block33;
                        }
                        case LITERAL_BOOL_FALSE: {
                            this.lexer.nextToken();
                            fst = new ComparisionIsExpression(fst, 3).setCacheEvalRst(this.cacheEvalRst);
                            continue block33;
                        }
                        case LITERAL_BOOL_TRUE: {
                            this.lexer.nextToken();
                            fst = new ComparisionIsExpression(fst, 2).setCacheEvalRst(this.cacheEvalRst);
                            continue block33;
                        }
                    }
                    this.matchIdentifier("UNKNOWN");
                    fst = new ComparisionIsExpression(fst, 4).setCacheEvalRst(this.cacheEvalRst);
                    continue block33;
                }
                case OP_EQUALS: {
                    this.lexer.nextToken();
                    temp = this.anyAllExpression();
                    fst = new ComparisionEqualsExpression(fst, temp).setCacheEvalRst(this.cacheEvalRst);
                    continue block33;
                }
                case OP_NULL_SAFE_EQUALS: {
                    this.lexer.nextToken();
                    temp = this.bitOrExpression(null, null);
                    fst = new ComparisionNullSafeEqualsExpression(fst, temp).setCacheEvalRst(this.cacheEvalRst);
                    continue block33;
                }
                case OP_GREATER_OR_EQUALS: {
                    this.lexer.nextToken();
                    temp = this.anyAllExpression();
                    fst = new ComparisionGreaterThanOrEqualsExpression(fst, temp).setCacheEvalRst(this.cacheEvalRst);
                    continue block33;
                }
                case OP_GREATER_THAN: {
                    this.lexer.nextToken();
                    temp = this.anyAllExpression();
                    fst = new ComparisionGreaterThanExpression(fst, temp).setCacheEvalRst(this.cacheEvalRst);
                    continue block33;
                }
                case OP_LESS_OR_EQUALS: {
                    this.lexer.nextToken();
                    temp = this.anyAllExpression();
                    fst = new ComparisionLessThanOrEqualsExpression(fst, temp).setCacheEvalRst(this.cacheEvalRst);
                    continue block33;
                }
                case OP_LESS_THAN: {
                    this.lexer.nextToken();
                    temp = this.anyAllExpression();
                    fst = new ComparisionLessThanExpression(fst, temp).setCacheEvalRst(this.cacheEvalRst);
                    continue block33;
                }
                case OP_LESS_OR_GREATER: {
                    this.lexer.nextToken();
                    temp = this.anyAllExpression();
                    fst = new ComparisionLessOrGreaterThanExpression(fst, temp).setCacheEvalRst(this.cacheEvalRst);
                    continue block33;
                }
                case OP_NOT_EQUALS: {
                    this.lexer.nextToken();
                    temp = this.anyAllExpression();
                    fst = new ComparisionNotEqualsExpression(fst, temp).setCacheEvalRst(this.cacheEvalRst);
                    continue block33;
                }
            }
            if (this.equalsIdentifier("SOUNDS") < 0) break;
            this.lexer.nextToken();
            this.match(MySQLToken.KW_LIKE);
            temp = this.bitOrExpression(null, null);
            fst = new SoundsLikeExpression(fst, temp).setCacheEvalRst(this.cacheEvalRst);
        }
        return fst;
    }

    private Expression rightOprandOfIn() throws SQLSyntaxErrorException {
        this.match(MySQLToken.PUNC_LEFT_PAREN);
        if (MySQLToken.KW_SELECT == this.lexer.token()) {
            QueryExpression subq = this.subQuery();
            this.match(MySQLToken.PUNC_RIGHT_PAREN);
            return subq;
        }
        return new InExpressionList(this.expressionList(new LinkedList<Expression>())).setCacheEvalRst(this.cacheEvalRst);
    }

    private Expression anyAllExpression() throws SQLSyntaxErrorException {
        QueryExpression subquery = null;
        switch (this.lexer.token()) {
            case KW_ALL: {
                this.lexer.nextToken();
                this.match(MySQLToken.PUNC_LEFT_PAREN);
                subquery = this.subQuery();
                this.match(MySQLToken.PUNC_RIGHT_PAREN);
                return new SubqueryAllExpression(subquery).setCacheEvalRst(this.cacheEvalRst);
            }
        }
        int matchIndex = this.equalsIdentifier("SOME", "ANY");
        if (matchIndex < 0) {
            return this.bitOrExpression(null, null);
        }
        String consumed = this.lexer.stringValue();
        String consumedUp = this.lexer.stringValueUppercase();
        if (this.lexer.nextToken() == MySQLToken.PUNC_LEFT_PAREN) {
            this.lexer.nextToken();
            subquery = this.subQuery();
            this.match(MySQLToken.PUNC_RIGHT_PAREN);
            return new SubqueryAnyExpression(subquery).setCacheEvalRst(this.cacheEvalRst);
        }
        return this.bitOrExpression(consumed, consumedUp);
    }

    private Expression bitOrExpression(String consumed, String consumedUp) throws SQLSyntaxErrorException {
        Expression expr = this.bitAndExpression(consumed, consumedUp);
        block3: while (true) {
            switch (this.lexer.token()) {
                case OP_VERTICAL_BAR: {
                    this.lexer.nextToken();
                    Expression newExpr = this.bitAndExpression(null, null);
                    expr = new BitOrExpression(expr, newExpr).setCacheEvalRst(this.cacheEvalRst);
                    continue block3;
                }
            }
            break;
        }
        return expr;
    }

    private Expression bitAndExpression(String consumed, String consumedUp) throws SQLSyntaxErrorException {
        Expression expr = this.bitShiftExpression(consumed, consumedUp);
        block3: while (true) {
            switch (this.lexer.token()) {
                case OP_AMPERSAND: {
                    this.lexer.nextToken();
                    Expression newExpr = this.bitShiftExpression(null, null);
                    expr = new BitAndExpression(expr, newExpr).setCacheEvalRst(this.cacheEvalRst);
                    continue block3;
                }
            }
            break;
        }
        return expr;
    }

    private Expression bitShiftExpression(String consumed, String consumedUp) throws SQLSyntaxErrorException {
        Expression expr = this.arithmeticTermOperatorExpression(consumed, consumedUp);
        block4: while (true) {
            switch (this.lexer.token()) {
                case OP_LEFT_SHIFT: {
                    this.lexer.nextToken();
                    Expression temp = this.arithmeticTermOperatorExpression(null, null);
                    expr = new BitShiftExpression(false, expr, temp).setCacheEvalRst(this.cacheEvalRst);
                    continue block4;
                }
                case OP_RIGHT_SHIFT: {
                    this.lexer.nextToken();
                    Expression temp = this.arithmeticTermOperatorExpression(null, null);
                    expr = new BitShiftExpression(true, expr, temp).setCacheEvalRst(this.cacheEvalRst);
                    continue block4;
                }
            }
            break;
        }
        return expr;
    }

    private Expression arithmeticTermOperatorExpression(String consumed, String consumedUp) throws SQLSyntaxErrorException {
        Expression expr = this.arithmeticFactorOperatorExpression(consumed, consumedUp);
        block4: while (true) {
            switch (this.lexer.token()) {
                case OP_PLUS: {
                    this.lexer.nextToken();
                    Expression temp = this.arithmeticFactorOperatorExpression(null, null);
                    expr = new ArithmeticAddExpression(expr, temp).setCacheEvalRst(this.cacheEvalRst);
                    continue block4;
                }
                case OP_MINUS: {
                    this.lexer.nextToken();
                    Expression temp = this.arithmeticFactorOperatorExpression(null, null);
                    expr = new ArithmeticSubtractExpression(expr, temp).setCacheEvalRst(this.cacheEvalRst);
                    continue block4;
                }
            }
            break;
        }
        return expr;
    }

    private Expression arithmeticFactorOperatorExpression(String consumed, String consumedUp) throws SQLSyntaxErrorException {
        Expression expr = this.bitXORExpression(consumed, consumedUp);
        block6: while (true) {
            switch (this.lexer.token()) {
                case OP_ASTERISK: {
                    this.lexer.nextToken();
                    Expression temp = this.bitXORExpression(null, null);
                    expr = new ArithmeticMultiplyExpression(expr, temp).setCacheEvalRst(this.cacheEvalRst);
                    continue block6;
                }
                case OP_SLASH: {
                    this.lexer.nextToken();
                    Expression temp = this.bitXORExpression(null, null);
                    expr = new ArithmeticDivideExpression(expr, temp).setCacheEvalRst(this.cacheEvalRst);
                    continue block6;
                }
                case KW_DIV: {
                    this.lexer.nextToken();
                    Expression temp = this.bitXORExpression(null, null);
                    expr = new ArithmeticIntegerDivideExpression(expr, temp).setCacheEvalRst(this.cacheEvalRst);
                    continue block6;
                }
                case OP_PERCENT: 
                case KW_MOD: {
                    this.lexer.nextToken();
                    Expression temp = this.bitXORExpression(null, null);
                    expr = new ArithmeticModExpression(expr, temp).setCacheEvalRst(this.cacheEvalRst);
                    continue block6;
                }
            }
            break;
        }
        return expr;
    }

    private Expression bitXORExpression(String consumed, String consumedUp) throws SQLSyntaxErrorException {
        Expression expr = this.unaryOpExpression(consumed, consumedUp);
        block3: while (true) {
            switch (this.lexer.token()) {
                case OP_CARET: {
                    this.lexer.nextToken();
                    Expression temp = this.unaryOpExpression(null, null);
                    expr = new BitXORExpression(expr, temp).setCacheEvalRst(this.cacheEvalRst);
                    continue block3;
                }
            }
            break;
        }
        return expr;
    }

    private Expression unaryOpExpression(String consumed, String consumedUp) throws SQLSyntaxErrorException {
        if (consumed == null) {
            switch (this.lexer.token()) {
                case OP_EXCLAMATION: {
                    this.lexer.nextToken();
                    Expression expr = this.unaryOpExpression(null, null);
                    return new NegativeValueExpression(expr).setCacheEvalRst(this.cacheEvalRst);
                }
                case OP_PLUS: {
                    this.lexer.nextToken();
                    return this.unaryOpExpression(null, null);
                }
                case OP_MINUS: {
                    this.lexer.nextToken();
                    Expression expr = this.unaryOpExpression(null, null);
                    return new MinusExpression(expr).setCacheEvalRst(this.cacheEvalRst);
                }
                case OP_TILDE: {
                    this.lexer.nextToken();
                    Expression expr = this.unaryOpExpression(null, null);
                    return new BitInvertExpression(expr).setCacheEvalRst(this.cacheEvalRst);
                }
                case KW_BINARY: {
                    this.lexer.nextToken();
                    Expression expr = this.unaryOpExpression(null, null);
                    return new CastBinaryExpression(expr).setCacheEvalRst(this.cacheEvalRst);
                }
            }
        }
        return this.collateExpression(consumed, consumedUp);
    }

    private Expression collateExpression(String consumed, String consumedUp) throws SQLSyntaxErrorException {
        Expression expr = this.userExpression(consumed, consumedUp);
        while (this.lexer.token() == MySQLToken.KW_COLLATE) {
            this.lexer.nextToken();
            String collateName = this.lexer.stringValue();
            this.match(MySQLToken.IDENTIFIER);
            expr = new CollateExpression(expr, collateName).setCacheEvalRst(this.cacheEvalRst);
        }
        return expr;
    }

    private Expression userExpression(String consumed, String consumedUp) throws SQLSyntaxErrorException {
        Expression first = this.primaryExpression(consumed, consumedUp);
        if (this.lexer.token() == MySQLToken.USR_VAR) {
            if (first instanceof LiteralString) {
                StringBuilder str = new StringBuilder().append('\'').append(((LiteralString)first).getString()).append('\'').append(this.lexer.stringValue());
                this.lexer.nextToken();
                return new UserExpression(str.toString()).setCacheEvalRst(this.cacheEvalRst);
            }
            if (first instanceof Identifier) {
                StringBuilder str = new StringBuilder().append(((Identifier)first).getIdText()).append(this.lexer.stringValue());
                this.lexer.nextToken();
                return new UserExpression(str.toString()).setCacheEvalRst(this.cacheEvalRst);
            }
        }
        return first;
    }

    public Expression valueExpression() throws SQLSyntaxErrorException {
        return this.bitOrExpression(null, null);
    }

    private Expression primaryExpression(String consumed, String consumedUp) throws SQLSyntaxErrorException {
        if (consumed != null) {
            return this.startedFromIdentifier(consumed, consumedUp, this.lexer.getLastTokenIndex());
        }
        switch (this.lexer.token()) {
            case PLACE_HOLDER: {
                String tempStr = this.lexer.stringValue();
                String tempStrUp = this.lexer.stringValueUppercase();
                this.lexer.nextToken();
                return this.createPlaceHolder(tempStr, tempStrUp);
            }
            case LITERAL_BIT: {
                String tempStr = this.lexer.stringValue();
                this.lexer.nextToken();
                return new LiteralBitField(null, tempStr).setCacheEvalRst(this.cacheEvalRst);
            }
            case LITERAL_HEX: {
                LiteralHexadecimal hex = new LiteralHexadecimal(null, this.lexer.getSQL(), this.lexer.getOffsetCache(), this.lexer.getSizeCache(), this.charset);
                this.lexer.nextToken();
                return hex.setCacheEvalRst(this.cacheEvalRst);
            }
            case LITERAL_BOOL_FALSE: {
                this.lexer.nextToken();
                return new LiteralBoolean(false).setCacheEvalRst(this.cacheEvalRst);
            }
            case LITERAL_BOOL_TRUE: {
                this.lexer.nextToken();
                return new LiteralBoolean(true).setCacheEvalRst(this.cacheEvalRst);
            }
            case LITERAL_NULL: {
                this.lexer.nextToken();
                return new LiteralNull().setCacheEvalRst(this.cacheEvalRst);
            }
            case LITERAL_NCHARS: {
                StringBuilder tempSb = new StringBuilder();
                do {
                    this.lexer.appendStringContent(tempSb);
                } while (this.lexer.nextToken() == MySQLToken.LITERAL_CHARS);
                return new LiteralString(null, tempSb.toString(), true).setCacheEvalRst(this.cacheEvalRst);
            }
            case LITERAL_CHARS: {
                StringBuilder tempSb = new StringBuilder();
                do {
                    this.lexer.appendStringContent(tempSb);
                } while (this.lexer.nextToken() == MySQLToken.LITERAL_CHARS);
                return new LiteralString(null, tempSb.toString(), false).setCacheEvalRst(this.cacheEvalRst);
            }
            case LITERAL_NUM_PURE_DIGIT: {
                Number tempNum = this.lexer.integerValue();
                this.lexer.nextToken();
                return new LiteralNumber(tempNum).setCacheEvalRst(this.cacheEvalRst);
            }
            case LITERAL_NUM_MIX_DIGIT: {
                BigDecimal tempNum = this.lexer.decimalValue();
                this.lexer.nextToken();
                return new LiteralNumber(tempNum).setCacheEvalRst(this.cacheEvalRst);
            }
            case QUESTION_MARK: {
                int index = this.lexer.paramIndex();
                this.lexer.nextToken();
                return this.createParam(index);
            }
            case KW_CASE: {
                this.lexer.nextToken();
                return this.caseWhenExpression();
            }
            case KW_INTERVAL: {
                this.lexer.nextToken();
                return this.intervalExpression();
            }
            case KW_EXISTS: {
                this.lexer.nextToken();
                this.match(MySQLToken.PUNC_LEFT_PAREN);
                QueryExpression tempExpr = this.subQuery();
                this.match(MySQLToken.PUNC_RIGHT_PAREN);
                return new ExistsPrimary(tempExpr).setCacheEvalRst(this.cacheEvalRst);
            }
            case USR_VAR: {
                String tempStr = this.lexer.stringValue();
                Expression tempExpr = new UsrDefVarPrimary(tempStr).setCacheEvalRst(this.cacheEvalRst);
                if (this.lexer.nextToken() == MySQLToken.OP_ASSIGN) {
                    this.lexer.nextToken();
                    Expression tempExpr2 = this.expression();
                    return new AssignmentExpression(tempExpr, tempExpr2);
                }
                return tempExpr;
            }
            case SYS_VAR: {
                return this.systemVariale();
            }
            case KW_MATCH: {
                this.lexer.nextToken();
                return this.matchExpression();
            }
            case PUNC_LEFT_PAREN: {
                this.lexer.nextToken();
                if (this.lexer.token() == MySQLToken.KW_SELECT) {
                    QueryExpression tempExpr = this.subQuery();
                    this.match(MySQLToken.PUNC_RIGHT_PAREN);
                    return tempExpr;
                }
                Expression tempExpr = this.expression();
                switch (this.lexer.token()) {
                    case PUNC_RIGHT_PAREN: {
                        this.lexer.nextToken();
                        return tempExpr;
                    }
                    case PUNC_COMMA: {
                        this.lexer.nextToken();
                        List<Expression> tempExprList = new LinkedList<Expression>();
                        tempExprList.add(tempExpr);
                        tempExprList = this.expressionList(tempExprList);
                        return new RowExpression(tempExprList).setCacheEvalRst(this.cacheEvalRst);
                    }
                }
                throw this.err("unexpected token: " + (Object)((Object)this.lexer.token()));
            }
            case KW_UTC_DATE: {
                this.lexer.nextToken();
                if (this.lexer.token() == MySQLToken.PUNC_LEFT_PAREN) {
                    this.lexer.nextToken();
                    this.match(MySQLToken.PUNC_RIGHT_PAREN);
                }
                return new UtcDate(null).setCacheEvalRst(this.cacheEvalRst);
            }
            case KW_UTC_TIME: {
                this.lexer.nextToken();
                if (this.lexer.token() == MySQLToken.PUNC_LEFT_PAREN) {
                    this.lexer.nextToken();
                    this.match(MySQLToken.PUNC_RIGHT_PAREN);
                }
                return new UtcTime(null).setCacheEvalRst(this.cacheEvalRst);
            }
            case KW_UTC_TIMESTAMP: {
                this.lexer.nextToken();
                if (this.lexer.token() == MySQLToken.PUNC_LEFT_PAREN) {
                    this.lexer.nextToken();
                    this.match(MySQLToken.PUNC_RIGHT_PAREN);
                }
                return new UtcTimestamp(null).setCacheEvalRst(this.cacheEvalRst);
            }
            case KW_CURRENT_DATE: {
                this.lexer.nextToken();
                if (this.lexer.token() == MySQLToken.PUNC_LEFT_PAREN) {
                    this.lexer.nextToken();
                    this.match(MySQLToken.PUNC_RIGHT_PAREN);
                }
                return new Curdate().setCacheEvalRst(this.cacheEvalRst);
            }
            case KW_CURRENT_TIME: {
                this.lexer.nextToken();
                if (this.lexer.token() == MySQLToken.PUNC_LEFT_PAREN) {
                    this.lexer.nextToken();
                    this.match(MySQLToken.PUNC_RIGHT_PAREN);
                }
                return new Curtime().setCacheEvalRst(this.cacheEvalRst);
            }
            case KW_CURRENT_TIMESTAMP: 
            case KW_LOCALTIME: 
            case KW_LOCALTIMESTAMP: {
                this.lexer.nextToken();
                if (this.lexer.token() == MySQLToken.PUNC_LEFT_PAREN) {
                    this.lexer.nextToken();
                    this.match(MySQLToken.PUNC_RIGHT_PAREN);
                }
                return new Now(null).setCacheEvalRst(this.cacheEvalRst);
            }
            case KW_CURRENT_USER: {
                this.lexer.nextToken();
                if (this.lexer.token() == MySQLToken.PUNC_LEFT_PAREN) {
                    this.lexer.nextToken();
                    this.match(MySQLToken.PUNC_RIGHT_PAREN);
                }
                return new CurrentUser().setCacheEvalRst(this.cacheEvalRst);
            }
            case KW_DEFAULT: {
                int functionNameIndexToken = this.lexer.getLastTokenIndex();
                if (this.lexer.nextToken() == MySQLToken.PUNC_LEFT_PAREN) {
                    return this.ordinaryFunction(this.lexer.stringValue(), this.lexer.stringValueUppercase(), functionNameIndexToken);
                }
                return new DefaultValue().setCacheEvalRst(this.cacheEvalRst);
            }
            case KW_DATABASE: 
            case KW_IF: 
            case KW_INSERT: 
            case KW_LEFT: 
            case KW_REPEAT: 
            case KW_REPLACE: 
            case KW_RIGHT: 
            case KW_SCHEMA: 
            case KW_VALUES: {
                String tempStr = this.lexer.stringValue();
                String tempStrUp = this.lexer.stringValueUppercase();
                String tempStrUp2 = MySQLToken.keyWordToString(this.lexer.token());
                if (!tempStrUp2.equals(tempStrUp)) {
                    tempStrUp = tempStr = tempStrUp2;
                }
                int begin = this.lexer.getLastTokenIndex();
                if (this.lexer.nextToken() == MySQLToken.PUNC_LEFT_PAREN) {
                    return this.ordinaryFunction(tempStr, tempStrUp, begin);
                }
                throw this.err("keyword not followed by '(' is not expression: " + tempStr);
            }
            case KW_MOD: {
                this.lexer.nextToken();
                this.match(MySQLToken.PUNC_LEFT_PAREN);
                Expression tempExpr = this.expression();
                this.match(MySQLToken.PUNC_COMMA);
                Expression tempExpr2 = this.expression();
                this.match(MySQLToken.PUNC_RIGHT_PAREN);
                return new ArithmeticModExpression(tempExpr, tempExpr2).setCacheEvalRst(this.cacheEvalRst);
            }
            case KW_CHAR: {
                this.lexer.nextToken();
                this.match(MySQLToken.PUNC_LEFT_PAREN);
                return this.functionChar();
            }
            case KW_CONVERT: {
                this.lexer.nextToken();
                this.match(MySQLToken.PUNC_LEFT_PAREN);
                return this.functionConvert();
            }
            case KW_MAXVALUE: 
            case IDENTIFIER: {
                String tempStr = this.lexer.stringValue();
                String tempStrUp = this.lexer.stringValueUppercase();
                int begin = this.lexer.getLastTokenIndex();
                this.lexer.nextToken();
                return this.startedFromIdentifier(tempStr, tempStrUp, begin);
            }
            case OP_ASTERISK: {
                this.lexer.nextToken();
                return new Wildcard(null).setCacheEvalRst(this.cacheEvalRst);
            }
        }
        throw this.err("unrecognized token as first token of primary: " + (Object)((Object)this.lexer.token()));
    }

    private Timestampdiff timestampdiff() throws SQLSyntaxErrorException {
        IntervalPrimary.Unit unit = this.intervalPrimaryUnit();
        this.match(MySQLToken.PUNC_COMMA);
        Expression interval = this.expression();
        this.match(MySQLToken.PUNC_COMMA);
        Expression expr = this.expression();
        this.match(MySQLToken.PUNC_RIGHT_PAREN);
        ArrayList<Expression> argument = new ArrayList<Expression>(2);
        argument.add(interval);
        argument.add(expr);
        Timestampdiff func = new Timestampdiff(unit, argument);
        func.setCacheEvalRst(this.cacheEvalRst);
        return func;
    }

    private Timestampadd timestampadd() throws SQLSyntaxErrorException {
        IntervalPrimary.Unit unit = this.intervalPrimaryUnit();
        this.match(MySQLToken.PUNC_COMMA);
        Expression interval = this.expression();
        this.match(MySQLToken.PUNC_COMMA);
        Expression expr = this.expression();
        this.match(MySQLToken.PUNC_RIGHT_PAREN);
        ArrayList<Expression> argument = new ArrayList<Expression>(2);
        argument.add(interval);
        argument.add(expr);
        Timestampadd func = new Timestampadd(unit, argument);
        func.setCacheEvalRst(this.cacheEvalRst);
        return func;
    }

    private Extract extract() throws SQLSyntaxErrorException {
        IntervalPrimary.Unit unit = this.intervalPrimaryUnit();
        this.match(MySQLToken.KW_FROM);
        Expression date = this.expression();
        this.match(MySQLToken.PUNC_RIGHT_PAREN);
        Extract extract = new Extract(unit, date);
        extract.setCacheEvalRst(this.cacheEvalRst);
        return extract;
    }

    private Convert functionConvert() throws SQLSyntaxErrorException {
        Expression expr = this.expression();
        Convert cvt = null;
        switch (this.lexer.token()) {
            case PUNC_COMMA: {
                this.lexer.nextToken();
                Pair<String, Pair<Expression, Expression>> type = this.type4specialFunc();
                this.match(MySQLToken.PUNC_RIGHT_PAREN);
                Pair<Expression, Expression> info = type.getValue();
                cvt = info != null ? new Convert(expr, null, type.getKey(), info.getKey(), info.getValue()) : new Convert(expr, null, type.getKey(), null, null);
                cvt.setCacheEvalRst(this.cacheEvalRst);
                return cvt;
            }
            case KW_USING: {
                this.lexer.nextToken();
                String tempStr = this.getStringValue();
                this.match(MySQLToken.PUNC_RIGHT_PAREN);
                cvt = new Convert(expr, tempStr, null, null, null);
                cvt.setCacheEvalRst(this.cacheEvalRst);
                return cvt;
            }
        }
        throw this.err("expect ',' or 'USING' but is " + (Object)((Object)this.lexer.token()));
    }

    private Char functionChar() throws SQLSyntaxErrorException {
        LinkedList<Expression> tempExprList = new LinkedList<Expression>();
        block5: while (true) {
            Expression tempExpr = this.expression();
            tempExprList.add(tempExpr);
            switch (this.lexer.token()) {
                case PUNC_COMMA: {
                    this.lexer.nextToken();
                    continue block5;
                }
                case PUNC_RIGHT_PAREN: {
                    this.lexer.nextToken();
                    Char chr = new Char(tempExprList, null);
                    chr.setCacheEvalRst(this.cacheEvalRst);
                    return chr;
                }
                case KW_USING: {
                    this.lexer.nextToken();
                    String tempStr = this.lexer.stringValue();
                    this.match(MySQLToken.IDENTIFIER);
                    this.match(MySQLToken.PUNC_RIGHT_PAREN);
                    Char chr = new Char(tempExprList, tempStr);
                    chr.setCacheEvalRst(this.cacheEvalRst);
                    return chr;
                }
            }
            break;
        }
        throw this.err("expect ',' or 'USING' or ')' but is " + (Object)((Object)this.lexer.token()));
    }

    private Expression startedFromIdentifier(String consumed, String consumedUp, int begin) throws SQLSyntaxErrorException {
        switch (this.lexer.token()) {
            case PUNC_DOT: {
                Expression tempExpr = new Identifier(null, consumed, consumedUp).setCacheEvalRst(this.cacheEvalRst);
                block49: while (this.lexer.token() == MySQLToken.PUNC_DOT) {
                    switch (this.lexer.nextToken()) {
                        case IDENTIFIER: {
                            tempExpr = new Identifier((Identifier)tempExpr, this.lexer.stringValue(), this.lexer.stringValueUppercase()).setCacheEvalRst(this.cacheEvalRst);
                            this.lexer.nextToken();
                            continue block49;
                        }
                        case OP_ASTERISK: {
                            this.lexer.nextToken();
                            return new Wildcard((Identifier)tempExpr).setCacheEvalRst(this.cacheEvalRst);
                        }
                    }
                    tempExpr = new Identifier((Identifier)tempExpr, this.lexer.stringValue(), this.lexer.stringValueUppercase()).setCacheEvalRst(this.cacheEvalRst);
                    this.lexer.nextToken();
                }
                return tempExpr;
            }
            case LITERAL_BIT: {
                if (consumed.charAt(0) != '_') {
                    return new Identifier(null, consumed, consumedUp).setCacheEvalRst(this.cacheEvalRst);
                }
                String tempStr = this.lexer.stringValue();
                this.lexer.nextToken();
                return new LiteralBitField(consumed, tempStr).setCacheEvalRst(this.cacheEvalRst);
            }
            case LITERAL_HEX: {
                if (consumed.charAt(0) != '_') {
                    return new Identifier(null, consumed, consumedUp).setCacheEvalRst(this.cacheEvalRst);
                }
                LiteralHexadecimal hex = new LiteralHexadecimal(consumed, this.lexer.getSQL(), this.lexer.getOffsetCache(), this.lexer.getSizeCache(), this.charset);
                this.lexer.nextToken();
                return hex.setCacheEvalRst(this.cacheEvalRst);
            }
            case LITERAL_CHARS: {
                if (consumed.charAt(0) != '_') {
                    return new Identifier(null, consumed, consumedUp).setCacheEvalRst(this.cacheEvalRst);
                }
                StringBuilder tempSb = new StringBuilder();
                do {
                    this.lexer.appendStringContent(tempSb);
                } while (this.lexer.nextToken() == MySQLToken.LITERAL_CHARS);
                return new LiteralString(consumed, tempSb.toString(), false).setCacheEvalRst(this.cacheEvalRst);
            }
            case PUNC_LEFT_PAREN: {
                consumedUp = Identifier.unescapeName(consumedUp);
                switch (this.functionManager.getParsingStrategy(consumedUp)) {
                    case GET_FORMAT: {
                        this.lexer.nextToken();
                        int gfi = this.matchIdentifier("DATE", "TIME", "DATETIME", "TIMESTAMP");
                        this.match(MySQLToken.PUNC_COMMA);
                        Expression getFormatArg = this.expression();
                        this.match(MySQLToken.PUNC_RIGHT_PAREN);
                        switch (gfi) {
                            case 0: {
                                return new GetFormat(GetFormat.FormatType.DATE, getFormatArg);
                            }
                            case 1: {
                                return new GetFormat(GetFormat.FormatType.TIME, getFormatArg);
                            }
                            case 2: 
                            case 3: {
                                return new GetFormat(GetFormat.FormatType.DATETIME, getFormatArg);
                            }
                        }
                        throw this.err("unexpected format type for GET_FORMAT()");
                    }
                    case CAST: {
                        this.lexer.nextToken();
                        Expression tempExpr = this.expression();
                        this.match(MySQLToken.KW_AS);
                        Pair<String, Pair<Expression, Expression>> type = this.type4specialFunc();
                        this.match(MySQLToken.PUNC_RIGHT_PAREN);
                        Pair<Expression, Expression> info = type.getValue();
                        if (info != null) {
                            return new Cast(tempExpr, type.getKey(), info.getKey(), info.getValue()).setCacheEvalRst(this.cacheEvalRst);
                        }
                        return new Cast(tempExpr, type.getKey(), null, null).setCacheEvalRst(this.cacheEvalRst);
                    }
                    case POSITION: {
                        this.lexer.nextToken();
                        ArrayList<Expression> tempExprList = new ArrayList<Expression>(2);
                        tempExprList.add(this.expression());
                        this.match(MySQLToken.KW_IN);
                        tempExprList.add(this.expression());
                        this.match(MySQLToken.PUNC_RIGHT_PAREN);
                        return new Locate(tempExprList).setCacheEvalRst(this.cacheEvalRst);
                    }
                    case SUBSTRING: {
                        this.lexer.nextToken();
                        ArrayList<Expression> tempExprList = new ArrayList<Expression>(3);
                        tempExprList.add(this.expression());
                        this.match(MySQLToken.PUNC_COMMA, MySQLToken.KW_FROM);
                        tempExprList.add(this.expression());
                        switch (this.lexer.token()) {
                            case PUNC_COMMA: 
                            case KW_FOR: {
                                this.lexer.nextToken();
                                tempExprList.add(this.expression());
                            }
                        }
                        this.match(MySQLToken.PUNC_RIGHT_PAREN);
                        return new Substring(tempExprList).setCacheEvalRst(this.cacheEvalRst);
                    }
                    case ROW: {
                        this.lexer.nextToken();
                        List<Expression> tempExprList = this.expressionList(new LinkedList<Expression>());
                        return new RowExpression(tempExprList).setCacheEvalRst(this.cacheEvalRst);
                    }
                    case TRIM: {
                        Trim.Direction direction;
                        switch (this.lexer.nextToken()) {
                            case KW_BOTH: {
                                this.lexer.nextToken();
                                direction = Trim.Direction.BOTH;
                                break;
                            }
                            case KW_LEADING: {
                                this.lexer.nextToken();
                                direction = Trim.Direction.LEADING;
                                break;
                            }
                            case KW_TRAILING: {
                                this.lexer.nextToken();
                                direction = Trim.Direction.TRAILING;
                                break;
                            }
                            default: {
                                direction = Trim.Direction.DEFAULT;
                            }
                        }
                        if (direction == Trim.Direction.DEFAULT) {
                            Expression tempExpr = this.expression();
                            if (this.lexer.token() == MySQLToken.KW_FROM) {
                                this.lexer.nextToken();
                                Expression tempExpr2 = this.expression();
                                this.match(MySQLToken.PUNC_RIGHT_PAREN);
                                return new Trim(direction, tempExpr, tempExpr2).setCacheEvalRst(this.cacheEvalRst);
                            }
                            this.match(MySQLToken.PUNC_RIGHT_PAREN);
                            return new Trim(direction, null, tempExpr).setCacheEvalRst(this.cacheEvalRst);
                        }
                        if (this.lexer.token() == MySQLToken.KW_FROM) {
                            this.lexer.nextToken();
                            Expression tempExpr = this.expression();
                            this.match(MySQLToken.PUNC_RIGHT_PAREN);
                            return new Trim(direction, null, tempExpr).setCacheEvalRst(this.cacheEvalRst);
                        }
                        Expression tempExpr = this.expression();
                        this.match(MySQLToken.KW_FROM);
                        Expression tempExpr2 = this.expression();
                        this.match(MySQLToken.PUNC_RIGHT_PAREN);
                        return new Trim(direction, tempExpr, tempExpr2).setCacheEvalRst(this.cacheEvalRst);
                    }
                    case AVG: {
                        boolean tempGroupDistinct;
                        if (this.lexer.nextToken() == MySQLToken.KW_DISTINCT) {
                            tempGroupDistinct = true;
                            this.lexer.nextToken();
                        } else {
                            tempGroupDistinct = false;
                        }
                        Expression tempExpr = this.expression();
                        this.match(MySQLToken.PUNC_RIGHT_PAREN);
                        int end = this.lexer.getLastTokenIndex();
                        String originStr = String.valueOf(this.lexer.getSQL(), begin, end - begin).trim();
                        return new Avg(tempExpr, tempGroupDistinct).setCacheEvalRst(this.cacheEvalRst).setOriginStr(originStr);
                    }
                    case MAX: {
                        boolean tempGroupDistinct;
                        if (this.lexer.nextToken() == MySQLToken.KW_DISTINCT) {
                            tempGroupDistinct = true;
                            this.lexer.nextToken();
                        } else {
                            tempGroupDistinct = false;
                        }
                        Expression tempExpr = this.expression();
                        this.match(MySQLToken.PUNC_RIGHT_PAREN);
                        int end = this.lexer.getLastTokenIndex();
                        String originStr = String.valueOf(this.lexer.getSQL(), begin, end - begin).trim();
                        return new Max(tempExpr, tempGroupDistinct).setCacheEvalRst(this.cacheEvalRst).setOriginStr(originStr);
                    }
                    case MIN: {
                        boolean tempGroupDistinct;
                        if (this.lexer.nextToken() == MySQLToken.KW_DISTINCT) {
                            tempGroupDistinct = true;
                            this.lexer.nextToken();
                        } else {
                            tempGroupDistinct = false;
                        }
                        Expression tempExpr = this.expression();
                        this.match(MySQLToken.PUNC_RIGHT_PAREN);
                        int end = this.lexer.getLastTokenIndex();
                        String originStr = String.valueOf(this.lexer.getSQL(), begin, end - begin).trim();
                        return new Min(tempExpr, tempGroupDistinct).setCacheEvalRst(this.cacheEvalRst).setOriginStr(originStr);
                    }
                    case SUM: {
                        boolean tempGroupDistinct;
                        if (this.lexer.nextToken() == MySQLToken.KW_DISTINCT) {
                            tempGroupDistinct = true;
                            this.lexer.nextToken();
                        } else {
                            tempGroupDistinct = false;
                        }
                        Expression tempExpr = this.expression();
                        this.match(MySQLToken.PUNC_RIGHT_PAREN);
                        int end = this.lexer.getLastTokenIndex();
                        String originStr = String.valueOf(this.lexer.getSQL(), begin, end - begin).trim();
                        return new Sum(tempExpr, tempGroupDistinct).setCacheEvalRst(this.cacheEvalRst).setOriginStr(originStr);
                    }
                    case COUNT: {
                        if (this.lexer.nextToken() == MySQLToken.KW_DISTINCT) {
                            this.lexer.nextToken();
                            List<Expression> tempExprList = this.expressionList(new LinkedList<Expression>());
                            int end = this.lexer.getLastTokenIndex();
                            String originStr = String.valueOf(this.lexer.getSQL(), begin, end - begin).trim();
                            return new Count(tempExprList).setCacheEvalRst(this.cacheEvalRst).setOriginStr(originStr);
                        }
                        Expression tempExpr = this.expression();
                        this.match(MySQLToken.PUNC_RIGHT_PAREN);
                        int end = this.lexer.getLastTokenIndex();
                        String originStr = String.valueOf(this.lexer.getSQL(), begin, end - begin).trim();
                        Count c = new Count(tempExpr);
                        c.setCacheEvalRst(this.cacheEvalRst);
                        c.setOriginStr(originStr);
                        return c;
                    }
                    case GROUP_CONCAT: {
                        Expression tempExpr;
                        boolean tempGroupDistinct;
                        if (this.lexer.nextToken() == MySQLToken.KW_DISTINCT) {
                            this.lexer.nextToken();
                            tempGroupDistinct = true;
                        } else {
                            tempGroupDistinct = false;
                        }
                        LinkedList<Expression> tempExprList = new LinkedList<Expression>();
                        while (true) {
                            tempExpr = this.expression();
                            tempExprList.add(tempExpr);
                            if (this.lexer.token() != MySQLToken.PUNC_COMMA) break;
                            this.lexer.nextToken();
                        }
                        LinkedList<Pair<Expression, SortOrder>> orderBys = null;
                        String tempStr = null;
                        switch (this.lexer.token()) {
                            case KW_ORDER: {
                                this.lexer.nextToken();
                                this.match(MySQLToken.KW_BY);
                                do {
                                    if (orderBys == null) {
                                        orderBys = new LinkedList<Pair<Expression, SortOrder>>();
                                    }
                                    boolean tempIsDesc = false;
                                    tempExpr = this.expression();
                                    if (this.lexer.token() == MySQLToken.KW_ASC) {
                                        this.lexer.nextToken();
                                    } else if (this.lexer.token() == MySQLToken.KW_DESC) {
                                        tempIsDesc = true;
                                        this.lexer.nextToken();
                                    }
                                    orderBys.add(new Pair<Expression, SortOrder>(tempExpr, tempIsDesc ? SortOrder.DESC : SortOrder.ASC));
                                } while (this.lexer.token() == MySQLToken.PUNC_COMMA && this.lexer.nextToken() != MySQLToken.EOF);
                                if (this.lexer.token() != MySQLToken.KW_SEPARATOR) break;
                            }
                            case KW_SEPARATOR: {
                                this.lexer.nextToken();
                                StringBuilder tempSb = new StringBuilder();
                                this.lexer.appendStringContent(tempSb);
                                tempStr = LiteralString.getUnescapedString(tempSb.toString());
                                this.match(MySQLToken.LITERAL_CHARS);
                                break;
                            }
                        }
                        this.match(MySQLToken.PUNC_RIGHT_PAREN);
                        return new GroupConcat(tempGroupDistinct, tempExprList, orderBys, tempStr == null ? null : new LiteralString(null, tempStr, false)).setCacheEvalRst(this.cacheEvalRst);
                    }
                    case CHAR: {
                        this.lexer.nextToken();
                        return this.functionChar();
                    }
                    case CONVERT: {
                        this.lexer.nextToken();
                        return this.functionConvert();
                    }
                    case EXTRACT: {
                        this.lexer.nextToken();
                        return this.extract();
                    }
                    case TIMESTAMPDIFF: {
                        this.lexer.nextToken();
                        return this.timestampdiff();
                    }
                    case TIMESTAMPADD: {
                        this.lexer.nextToken();
                        return this.timestampadd();
                    }
                    case _ORDINARY: {
                        return this.ordinaryFunction(consumed, consumedUp, begin);
                    }
                    case _USER_DEF: {
                        return this.ordinaryFunction(consumed, consumedUp, begin);
                    }
                }
                throw this.err("unexpected function parsing strategy for id of " + consumed);
            }
        }
        return new Identifier(null, consumed, consumedUp).setCacheEvalRst(this.cacheEvalRst);
    }

    private Pair<String, Pair<Expression, Expression>> type4specialFunc() throws SQLSyntaxErrorException {
        Expression exp1 = null;
        Expression exp2 = null;
        switch (this.lexer.token()) {
            case KW_BINARY: 
            case KW_CHAR: {
                String typeName = MySQLToken.keyWordToString(this.lexer.token());
                if (this.lexer.nextToken() == MySQLToken.PUNC_LEFT_PAREN) {
                    this.lexer.nextToken();
                    exp1 = this.expression();
                    this.match(MySQLToken.PUNC_RIGHT_PAREN);
                }
                return MySQLExprParser.constructTypePair(typeName, exp1, exp2);
            }
            case KW_DECIMAL: {
                String typeName = MySQLToken.keyWordToString(this.lexer.token());
                if (this.lexer.nextToken() == MySQLToken.PUNC_LEFT_PAREN) {
                    this.lexer.nextToken();
                    exp1 = this.expression();
                    if (this.lexer.token() == MySQLToken.PUNC_COMMA) {
                        this.lexer.nextToken();
                        exp2 = this.expression();
                    }
                    this.match(MySQLToken.PUNC_RIGHT_PAREN);
                }
                return MySQLExprParser.constructTypePair(typeName, exp1, exp2);
            }
            case KW_UNSIGNED: {
                String typeName = MySQLToken.keyWordToString(this.lexer.token());
                this.lexer.nextToken();
                if (this.lexer.token() == MySQLToken.KW_INTEGER || this.lexer.token() == MySQLToken.KW_INT) {
                    this.lexer.nextToken();
                }
                return MySQLExprParser.constructTypePair(typeName, null, null);
            }
            case IDENTIFIER: {
                String typeName = this.lexer.stringValueUppercase();
                this.lexer.nextToken();
                if ("SIGNED".equals(typeName)) {
                    if (this.lexer.token() == MySQLToken.KW_INTEGER || this.lexer.token() == MySQLToken.KW_INT) {
                        this.lexer.nextToken();
                    }
                } else if (!("DATE".equals(typeName) || "DATETIME".equals(typeName) || "TIME".equals(typeName))) {
                    throw this.err("invalide type name: " + typeName);
                }
                return MySQLExprParser.constructTypePair(typeName, null, null);
            }
        }
        throw this.err("invalide type name: " + this.lexer.stringValueUppercase());
    }

    private static Pair<String, Pair<Expression, Expression>> constructTypePair(String typeName, Expression exp1, Expression exp2) {
        return new Pair<String, Pair<Expression, Expression>>(typeName, new Pair<Expression, Expression>(exp1, exp2));
    }

    private FunctionExpression ordinaryFunction(String id, String idUpper, int begin) throws SQLSyntaxErrorException {
        FunctionExpression funcExpr;
        idUpper = Identifier.unescapeName(idUpper);
        this.match(MySQLToken.PUNC_LEFT_PAREN);
        if (this.lexer.token() == MySQLToken.PUNC_RIGHT_PAREN) {
            this.lexer.nextToken();
            funcExpr = this.functionManager.createFunctionExpression(idUpper, null);
        } else {
            List<Expression> args = this.expressionList(new LinkedList<Expression>());
            funcExpr = this.functionManager.createFunctionExpression(idUpper, args);
        }
        int end = this.lexer.getLastTokenIndex();
        if (funcExpr == null) {
            throw new SQLSyntaxErrorException(id + "() is not a function");
        }
        String originSql = String.valueOf(this.lexer.getSQL(), begin, end - begin).trim();
        funcExpr.setOriginStr(originSql);
        funcExpr.setCacheEvalRst(this.cacheEvalRst);
        return funcExpr;
    }

    private Expression matchExpression() throws SQLSyntaxErrorException {
        this.match(MySQLToken.PUNC_LEFT_PAREN);
        List<Expression> colList = this.expressionList(new LinkedList<Expression>());
        this.matchIdentifier("AGAINST");
        this.match(MySQLToken.PUNC_LEFT_PAREN);
        Expression pattern = this.expression();
        MatchExpression.Modifier modifier = MatchExpression.Modifier._DEFAULT;
        block0 : switch (this.lexer.token()) {
            case KW_WITH: {
                this.lexer.nextToken();
                this.match(MySQLToken.IDENTIFIER);
                this.match(MySQLToken.IDENTIFIER);
                modifier = MatchExpression.Modifier.WITH_QUERY_EXPANSION;
                break;
            }
            case KW_IN: {
                switch (this.lexer.nextToken()) {
                    case KW_NATURAL: {
                        this.lexer.nextToken();
                        this.matchIdentifier("LANGUAGE");
                        this.matchIdentifier("MODE");
                        if (this.lexer.token() == MySQLToken.KW_WITH) {
                            this.lexer.nextToken();
                            this.lexer.nextToken();
                            this.lexer.nextToken();
                            modifier = MatchExpression.Modifier.IN_NATURAL_LANGUAGE_MODE_WITH_QUERY_EXPANSION;
                            break block0;
                        }
                        modifier = MatchExpression.Modifier.IN_NATURAL_LANGUAGE_MODE;
                        break block0;
                    }
                }
                this.matchIdentifier("BOOLEAN");
                this.matchIdentifier("MODE");
                modifier = MatchExpression.Modifier.IN_BOOLEAN_MODE;
            }
        }
        this.match(MySQLToken.PUNC_RIGHT_PAREN);
        return new MatchExpression(colList, pattern, modifier).setCacheEvalRst(this.cacheEvalRst);
    }

    private Expression intervalExpression() throws SQLSyntaxErrorException {
        Expression fstExpr;
        List<Expression> argList = null;
        if (this.lexer.token() == MySQLToken.PUNC_LEFT_PAREN) {
            if (this.lexer.nextToken() == MySQLToken.KW_SELECT) {
                fstExpr = this.subQuery();
                this.match(MySQLToken.PUNC_RIGHT_PAREN);
            } else {
                fstExpr = this.expression();
                if (this.lexer.token() == MySQLToken.PUNC_COMMA) {
                    this.lexer.nextToken();
                    argList = new LinkedList<Expression>();
                    argList.add(fstExpr);
                    argList = this.expressionList(argList);
                } else {
                    this.match(MySQLToken.PUNC_RIGHT_PAREN);
                }
            }
        } else {
            fstExpr = this.expression();
        }
        if (argList != null) {
            return new Interval(argList).setCacheEvalRst(this.cacheEvalRst);
        }
        return new IntervalPrimary(fstExpr, this.intervalPrimaryUnit()).setCacheEvalRst(this.cacheEvalRst);
    }

    private IntervalPrimary.Unit intervalPrimaryUnit() throws SQLSyntaxErrorException {
        switch (this.lexer.token()) {
            case KW_SECOND_MICROSECOND: {
                this.lexer.nextToken();
                return IntervalPrimary.Unit.SECOND_MICROSECOND;
            }
            case KW_MINUTE_MICROSECOND: {
                this.lexer.nextToken();
                return IntervalPrimary.Unit.MINUTE_MICROSECOND;
            }
            case KW_MINUTE_SECOND: {
                this.lexer.nextToken();
                return IntervalPrimary.Unit.MINUTE_SECOND;
            }
            case KW_HOUR_MICROSECOND: {
                this.lexer.nextToken();
                return IntervalPrimary.Unit.HOUR_MICROSECOND;
            }
            case KW_HOUR_SECOND: {
                this.lexer.nextToken();
                return IntervalPrimary.Unit.HOUR_SECOND;
            }
            case KW_HOUR_MINUTE: {
                this.lexer.nextToken();
                return IntervalPrimary.Unit.HOUR_MINUTE;
            }
            case KW_DAY_MICROSECOND: {
                this.lexer.nextToken();
                return IntervalPrimary.Unit.DAY_MICROSECOND;
            }
            case KW_DAY_SECOND: {
                this.lexer.nextToken();
                return IntervalPrimary.Unit.DAY_SECOND;
            }
            case KW_DAY_MINUTE: {
                this.lexer.nextToken();
                return IntervalPrimary.Unit.DAY_MINUTE;
            }
            case KW_DAY_HOUR: {
                this.lexer.nextToken();
                return IntervalPrimary.Unit.DAY_HOUR;
            }
            case KW_YEAR_MONTH: {
                this.lexer.nextToken();
                return IntervalPrimary.Unit.YEAR_MONTH;
            }
            case IDENTIFIER: {
                String unitText = this.lexer.stringValueUppercase();
                IntervalPrimary.Unit unit = IntervalPrimary.getIntervalUnit(unitText);
                if (unit == null) break;
                this.lexer.nextToken();
                return unit;
            }
        }
        throw this.err("literal INTERVAL should end with an UNIT");
    }

    private Expression caseWhenExpression() throws SQLSyntaxErrorException {
        Expression comparee = null;
        if (this.lexer.token() != MySQLToken.KW_WHEN) {
            comparee = this.expression();
        }
        LinkedList<Pair<Expression, Expression>> list = new LinkedList<Pair<Expression, Expression>>();
        while (this.lexer.token() == MySQLToken.KW_WHEN) {
            this.lexer.nextToken();
            Expression when = this.expression();
            this.match(MySQLToken.KW_THEN);
            Expression then = this.expression();
            if (when == null || then == null) {
                throw this.err("when or then is null in CASE WHEN expression");
            }
            list.add(new Pair<Expression, Expression>(when, then));
        }
        if (list.isEmpty()) {
            throw this.err("at least one WHEN ... THEN branch for CASE ... WHEN syntax");
        }
        Expression elseValue = null;
        switch (this.lexer.token()) {
            case KW_ELSE: {
                this.lexer.nextToken();
                elseValue = this.expression();
            }
        }
        this.matchIdentifier("END");
        return new CaseWhenOperatorExpression(comparee, list, elseValue).setCacheEvalRst(this.cacheEvalRst);
    }

    public List<Expression> expressionList(List<Expression> exprList) throws SQLSyntaxErrorException {
        block4: while (true) {
            Expression expr = this.expression();
            exprList.add(expr);
            switch (this.lexer.token()) {
                case PUNC_COMMA: {
                    this.lexer.nextToken();
                    continue block4;
                }
                case PUNC_RIGHT_PAREN: {
                    this.lexer.nextToken();
                    return exprList;
                }
            }
            break;
        }
        throw this.err("unexpected token: " + (Object)((Object)this.lexer.token()));
    }

    private QueryExpression subQuery() throws SQLSyntaxErrorException {
        if (this.selectParser == null) {
            this.selectParser = new MySQLDMLSelectParser(this.lexer, this);
        }
        return this.selectParser.selectUnion();
    }

    public Expression freeText() throws SQLSyntaxErrorException {
        boolean inbracket = true;
        if (this.lexer.token() != MySQLToken.PUNC_LEFT_PAREN) {
            inbracket = false;
        }
        int nestylevel = 0;
        StringBuffer freeText = new StringBuffer();
        if (!inbracket) {
            freeText.append(this.lexer.stringValue());
        }
        boolean loopend = false;
        block7: while (!loopend) {
            MySQLToken token = this.lexer.nextToken();
            if (nestylevel < 0) {
                throw new SQLSyntaxErrorException("expression level is illegal!");
            }
            switch (token) {
                case PUNC_LEFT_PAREN: {
                    if (!inbracket) {
                        loopend = true;
                        continue block7;
                    }
                    ++nestylevel;
                    freeText.append("(");
                    continue block7;
                }
                case PUNC_RIGHT_PAREN: {
                    if (nestylevel == 0) {
                        loopend = true;
                        if (!inbracket) continue block7;
                        this.match(MySQLToken.PUNC_RIGHT_PAREN);
                        continue block7;
                    }
                    --nestylevel;
                    freeText.append(")");
                    continue block7;
                }
                case PUNC_LEFT_BRACE: {
                    freeText.append('{');
                    continue block7;
                }
                case PUNC_RIGHT_BRACE: {
                    freeText.append('}');
                    continue block7;
                }
                case LITERAL_NUM_PURE_DIGIT: {
                    freeText.append(this.lexer.integerValue());
                    continue block7;
                }
            }
            freeText.append(this.lexer.stringValue());
        }
        return new LiteralString(null, freeText.toString(), false);
    }

    public String getCharset() {
        return this.charset;
    }

    private String getStringValue() throws SQLSyntaxErrorException {
        switch (this.lexer.token()) {
            case IDENTIFIER: {
                String name = Identifier.unescapeName(this.lexer.stringValue());
                this.lexer.nextToken();
                return name;
            }
            case LITERAL_CHARS: {
                String name = this.lexer.stringValue();
                name = LiteralString.getUnescapedString(name.substring(1, name.length() - 1));
                this.lexer.nextToken();
                return name;
            }
        }
        throw this.err("unexpected token: " + (Object)((Object)this.lexer.token()));
    }
}

