/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.txc.parser.recognizer.mysql.syntax;

import com.alibaba.txc.parser.ast.expression.primary.Identifier;
import com.alibaba.txc.parser.ast.stmt.SQLStatement;
import com.alibaba.txc.parser.ast.stmt.dal.ReleaseDbLock;
import com.alibaba.txc.parser.ast.stmt.mts.MTSReleaseStatement;
import com.alibaba.txc.parser.ast.stmt.mts.MTSRollbackStatement;
import com.alibaba.txc.parser.ast.stmt.mts.MTSSavepointStatement;
import com.alibaba.txc.parser.recognizer.mysql.MySQLToken;
import com.alibaba.txc.parser.recognizer.mysql.lexer.MySQLLexer;
import com.alibaba.txc.parser.recognizer.mysql.syntax.MySQLParser;
import java.sql.SQLSyntaxErrorException;
import java.util.HashMap;
import java.util.Map;

public class MySQLMTSParser
extends MySQLParser {
    private static final Map<String, SpecialIdentifier> specialIdentifiers = new HashMap<String, SpecialIdentifier>();

    public MySQLMTSParser(MySQLLexer lexer) {
        super(lexer);
    }

    public MTSSavepointStatement savepoint() throws SQLSyntaxErrorException {
        this.lexer.nextToken();
        Identifier id = this.identifier();
        this.match(MySQLToken.EOF);
        return new MTSSavepointStatement(id);
    }

    public SQLStatement release() throws SQLSyntaxErrorException {
        this.match(MySQLToken.KW_RELEASE);
        if (this.lexer.stringValue().equalsIgnoreCase("dblock")) {
            this.matchIdentifier("DBLOCK");
            this.match(MySQLToken.EOF);
            return new ReleaseDbLock();
        }
        this.matchIdentifier("SAVEPOINT");
        Identifier id = this.identifier();
        this.match(MySQLToken.EOF);
        return new MTSReleaseStatement(id);
    }

    public MTSRollbackStatement rollback() throws SQLSyntaxErrorException {
        this.lexer.nextToken();
        SpecialIdentifier siTemp = specialIdentifiers.get(this.lexer.stringValueUppercase());
        if (siTemp == SpecialIdentifier.WORK) {
            this.lexer.nextToken();
        }
        switch (this.lexer.token()) {
            case EOF: {
                return new MTSRollbackStatement(MTSRollbackStatement.CompleteType.UN_DEF);
            }
            case KW_TO: {
                this.lexer.nextToken();
                String str = this.lexer.stringValueUppercase();
                if (specialIdentifiers.get(str) == SpecialIdentifier.SAVEPOINT) {
                    this.lexer.nextToken();
                }
                Identifier savepoint = this.identifier();
                this.match(MySQLToken.EOF);
                return new MTSRollbackStatement(savepoint);
            }
            case KW_AND: {
                this.lexer.nextToken();
                siTemp = specialIdentifiers.get(this.lexer.stringValueUppercase());
                if (siTemp == SpecialIdentifier.NO) {
                    this.lexer.nextToken();
                    this.matchIdentifier("CHAIN");
                    this.match(MySQLToken.EOF);
                    return new MTSRollbackStatement(MTSRollbackStatement.CompleteType.NO_CHAIN);
                }
                this.matchIdentifier("CHAIN");
                this.match(MySQLToken.EOF);
                return new MTSRollbackStatement(MTSRollbackStatement.CompleteType.CHAIN);
            }
            case KW_RELEASE: {
                this.lexer.nextToken();
                this.match(MySQLToken.EOF);
                return new MTSRollbackStatement(MTSRollbackStatement.CompleteType.RELEASE);
            }
            case IDENTIFIER: {
                siTemp = specialIdentifiers.get(this.lexer.stringValueUppercase());
                if (siTemp != SpecialIdentifier.NO) break;
                this.lexer.nextToken();
                this.match(MySQLToken.KW_RELEASE);
                this.match(MySQLToken.EOF);
                return new MTSRollbackStatement(MTSRollbackStatement.CompleteType.NO_RELEASE);
            }
        }
        throw this.err("unrecognized complete type: " + (Object)((Object)this.lexer.token()));
    }

    static {
        specialIdentifiers.put("SAVEPOINT", SpecialIdentifier.SAVEPOINT);
        specialIdentifiers.put("WORK", SpecialIdentifier.WORK);
        specialIdentifiers.put("CHAIN", SpecialIdentifier.CHAIN);
        specialIdentifiers.put("RELEASE", SpecialIdentifier.RELEASE);
        specialIdentifiers.put("NO", SpecialIdentifier.NO);
        specialIdentifiers.put("DBLOCK", SpecialIdentifier.DBLOCK);
    }

    private static enum SpecialIdentifier {
        CHAIN,
        NO,
        RELEASE,
        SAVEPOINT,
        WORK,
        DBLOCK;

    }
}

