/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.txc.parser.recognizer.mysql.syntax;

import com.alibaba.txc.parser.ast.ASTNode;
import com.alibaba.txc.parser.ast.expression.BinaryOperatorExpression;
import com.alibaba.txc.parser.ast.expression.Expression;
import com.alibaba.txc.parser.ast.expression.PolyadicOperatorExpression;
import com.alibaba.txc.parser.ast.expression.TernaryOperatorExpression;
import com.alibaba.txc.parser.ast.expression.UnaryOperatorExpression;
import com.alibaba.txc.parser.ast.expression.comparison.BetweenAndExpression;
import com.alibaba.txc.parser.ast.expression.comparison.ComparisionEqualsExpression;
import com.alibaba.txc.parser.ast.expression.comparison.ComparisionIsExpression;
import com.alibaba.txc.parser.ast.expression.comparison.ComparisionNullSafeEqualsExpression;
import com.alibaba.txc.parser.ast.expression.comparison.InExpression;
import com.alibaba.txc.parser.ast.expression.logical.LogicalAndExpression;
import com.alibaba.txc.parser.ast.expression.logical.LogicalOrExpression;
import com.alibaba.txc.parser.ast.expression.misc.InExpressionList;
import com.alibaba.txc.parser.ast.expression.misc.QueryExpression;
import com.alibaba.txc.parser.ast.expression.misc.UserExpression;
import com.alibaba.txc.parser.ast.expression.primary.CaseWhenOperatorExpression;
import com.alibaba.txc.parser.ast.expression.primary.DefaultValue;
import com.alibaba.txc.parser.ast.expression.primary.ExistsPrimary;
import com.alibaba.txc.parser.ast.expression.primary.Identifier;
import com.alibaba.txc.parser.ast.expression.primary.MatchExpression;
import com.alibaba.txc.parser.ast.expression.primary.ParamMarker;
import com.alibaba.txc.parser.ast.expression.primary.PlaceHolder;
import com.alibaba.txc.parser.ast.expression.primary.RowExpression;
import com.alibaba.txc.parser.ast.expression.primary.SysVarPrimary;
import com.alibaba.txc.parser.ast.expression.primary.UsrDefVarPrimary;
import com.alibaba.txc.parser.ast.expression.primary.VariableExpression;
import com.alibaba.txc.parser.ast.expression.primary.ddl.AddColumn;
import com.alibaba.txc.parser.ast.expression.primary.ddl.AddColumns;
import com.alibaba.txc.parser.ast.expression.primary.ddl.AddForeignKey;
import com.alibaba.txc.parser.ast.expression.primary.ddl.AddFullTextIndex;
import com.alibaba.txc.parser.ast.expression.primary.ddl.AddIndex;
import com.alibaba.txc.parser.ast.expression.primary.ddl.AddPartitition;
import com.alibaba.txc.parser.ast.expression.primary.ddl.AddPrimaryKey;
import com.alibaba.txc.parser.ast.expression.primary.ddl.AddSpatialIndex;
import com.alibaba.txc.parser.ast.expression.primary.ddl.AddUniqueKey;
import com.alibaba.txc.parser.ast.expression.primary.ddl.Algorithm;
import com.alibaba.txc.parser.ast.expression.primary.ddl.AlterColumnDefaultVal;
import com.alibaba.txc.parser.ast.expression.primary.ddl.AlterSpecification;
import com.alibaba.txc.parser.ast.expression.primary.ddl.AnalyzePartition;
import com.alibaba.txc.parser.ast.expression.primary.ddl.ChangeColumn;
import com.alibaba.txc.parser.ast.expression.primary.ddl.CharacterSet;
import com.alibaba.txc.parser.ast.expression.primary.ddl.CheckPartition;
import com.alibaba.txc.parser.ast.expression.primary.ddl.CoalescePartition;
import com.alibaba.txc.parser.ast.expression.primary.ddl.ConvertCharset;
import com.alibaba.txc.parser.ast.expression.primary.ddl.DBPartitionBy;
import com.alibaba.txc.parser.ast.expression.primary.ddl.DBPartitionOptions;
import com.alibaba.txc.parser.ast.expression.primary.ddl.DropColumn;
import com.alibaba.txc.parser.ast.expression.primary.ddl.DropForeignKey;
import com.alibaba.txc.parser.ast.expression.primary.ddl.DropIndex;
import com.alibaba.txc.parser.ast.expression.primary.ddl.DropPartitition;
import com.alibaba.txc.parser.ast.expression.primary.ddl.DropPrimaryKey;
import com.alibaba.txc.parser.ast.expression.primary.ddl.EnableKeys;
import com.alibaba.txc.parser.ast.expression.primary.ddl.ExchangePartition;
import com.alibaba.txc.parser.ast.expression.primary.ddl.ForceOperation;
import com.alibaba.txc.parser.ast.expression.primary.ddl.ImportTablespace;
import com.alibaba.txc.parser.ast.expression.primary.ddl.LockOperation;
import com.alibaba.txc.parser.ast.expression.primary.ddl.ModifyColumn;
import com.alibaba.txc.parser.ast.expression.primary.ddl.OptimizePartition;
import com.alibaba.txc.parser.ast.expression.primary.ddl.Orderby;
import com.alibaba.txc.parser.ast.expression.primary.ddl.PartitionBy;
import com.alibaba.txc.parser.ast.expression.primary.ddl.PartitionByType;
import com.alibaba.txc.parser.ast.expression.primary.ddl.PartitionDefinition;
import com.alibaba.txc.parser.ast.expression.primary.ddl.PartitionOptions;
import com.alibaba.txc.parser.ast.expression.primary.ddl.RebuildPartition;
import com.alibaba.txc.parser.ast.expression.primary.ddl.RemovePartitioning;
import com.alibaba.txc.parser.ast.expression.primary.ddl.RenameOperation;
import com.alibaba.txc.parser.ast.expression.primary.ddl.ReorganizePartition;
import com.alibaba.txc.parser.ast.expression.primary.ddl.RepairPartition;
import com.alibaba.txc.parser.ast.expression.primary.ddl.SubPartitionBy;
import com.alibaba.txc.parser.ast.expression.primary.ddl.SubpartitionDefinition;
import com.alibaba.txc.parser.ast.expression.primary.ddl.TBPartitionBy;
import com.alibaba.txc.parser.ast.expression.primary.ddl.TruncatePartitition;
import com.alibaba.txc.parser.ast.expression.primary.function.FunctionExpression;
import com.alibaba.txc.parser.ast.expression.primary.function.cast.Cast;
import com.alibaba.txc.parser.ast.expression.primary.function.cast.Convert;
import com.alibaba.txc.parser.ast.expression.primary.function.datetime.Extract;
import com.alibaba.txc.parser.ast.expression.primary.function.datetime.GetFormat;
import com.alibaba.txc.parser.ast.expression.primary.function.datetime.Timestampadd;
import com.alibaba.txc.parser.ast.expression.primary.function.datetime.Timestampdiff;
import com.alibaba.txc.parser.ast.expression.primary.function.groupby.Avg;
import com.alibaba.txc.parser.ast.expression.primary.function.groupby.Count;
import com.alibaba.txc.parser.ast.expression.primary.function.groupby.GroupConcat;
import com.alibaba.txc.parser.ast.expression.primary.function.groupby.Max;
import com.alibaba.txc.parser.ast.expression.primary.function.groupby.Min;
import com.alibaba.txc.parser.ast.expression.primary.function.groupby.Sum;
import com.alibaba.txc.parser.ast.expression.primary.function.string.Char;
import com.alibaba.txc.parser.ast.expression.primary.function.string.Trim;
import com.alibaba.txc.parser.ast.expression.primary.literal.IntervalPrimary;
import com.alibaba.txc.parser.ast.expression.primary.literal.LiteralBitField;
import com.alibaba.txc.parser.ast.expression.primary.literal.LiteralBoolean;
import com.alibaba.txc.parser.ast.expression.primary.literal.LiteralHexadecimal;
import com.alibaba.txc.parser.ast.expression.primary.literal.LiteralNull;
import com.alibaba.txc.parser.ast.expression.primary.literal.LiteralNumber;
import com.alibaba.txc.parser.ast.expression.primary.literal.LiteralString;
import com.alibaba.txc.parser.ast.expression.string.LikeExpression;
import com.alibaba.txc.parser.ast.expression.type.CollateExpression;
import com.alibaba.txc.parser.ast.fragment.GroupBy;
import com.alibaba.txc.parser.ast.fragment.Limit;
import com.alibaba.txc.parser.ast.fragment.LockReference;
import com.alibaba.txc.parser.ast.fragment.OrderBy;
import com.alibaba.txc.parser.ast.fragment.SortOrder;
import com.alibaba.txc.parser.ast.fragment.VariableScope;
import com.alibaba.txc.parser.ast.fragment.ddl.ColumnDefinition;
import com.alibaba.txc.parser.ast.fragment.ddl.TableOptions;
import com.alibaba.txc.parser.ast.fragment.ddl.datatype.DataType;
import com.alibaba.txc.parser.ast.fragment.ddl.index.IndexColumnName;
import com.alibaba.txc.parser.ast.fragment.ddl.index.IndexDefinition;
import com.alibaba.txc.parser.ast.fragment.ddl.index.IndexOption;
import com.alibaba.txc.parser.ast.fragment.ddl.index.ReferenceDefinition;
import com.alibaba.txc.parser.ast.fragment.ddl.index.ReferenceOption;
import com.alibaba.txc.parser.ast.fragment.tableref.Dual;
import com.alibaba.txc.parser.ast.fragment.tableref.IndexHint;
import com.alibaba.txc.parser.ast.fragment.tableref.InnerJoin;
import com.alibaba.txc.parser.ast.fragment.tableref.NaturalJoin;
import com.alibaba.txc.parser.ast.fragment.tableref.OuterJoin;
import com.alibaba.txc.parser.ast.fragment.tableref.StraightJoin;
import com.alibaba.txc.parser.ast.fragment.tableref.SubqueryFactor;
import com.alibaba.txc.parser.ast.fragment.tableref.TableRefFactor;
import com.alibaba.txc.parser.ast.fragment.tableref.TableReference;
import com.alibaba.txc.parser.ast.fragment.tableref.TableReferences;
import com.alibaba.txc.parser.ast.stmt.dal.CheckTableStatement;
import com.alibaba.txc.parser.ast.stmt.dal.DALDeallocateStatement;
import com.alibaba.txc.parser.ast.stmt.dal.DALExecuteStatement;
import com.alibaba.txc.parser.ast.stmt.dal.DALPrepareStatement;
import com.alibaba.txc.parser.ast.stmt.dal.DALSetCharacterSetStatement;
import com.alibaba.txc.parser.ast.stmt.dal.DALSetNamesStatement;
import com.alibaba.txc.parser.ast.stmt.dal.DALSetSimpleStatement;
import com.alibaba.txc.parser.ast.stmt.dal.DALSetStatement;
import com.alibaba.txc.parser.ast.stmt.dal.Kill;
import com.alibaba.txc.parser.ast.stmt.dal.ReleaseDbLock;
import com.alibaba.txc.parser.ast.stmt.dal.ShowAuthors;
import com.alibaba.txc.parser.ast.stmt.dal.ShowBinLogEvent;
import com.alibaba.txc.parser.ast.stmt.dal.ShowBinaryLog;
import com.alibaba.txc.parser.ast.stmt.dal.ShowBroadcasts;
import com.alibaba.txc.parser.ast.stmt.dal.ShowCharaterSet;
import com.alibaba.txc.parser.ast.stmt.dal.ShowCollation;
import com.alibaba.txc.parser.ast.stmt.dal.ShowColumns;
import com.alibaba.txc.parser.ast.stmt.dal.ShowContributors;
import com.alibaba.txc.parser.ast.stmt.dal.ShowCreate;
import com.alibaba.txc.parser.ast.stmt.dal.ShowDataSources;
import com.alibaba.txc.parser.ast.stmt.dal.ShowDatabases;
import com.alibaba.txc.parser.ast.stmt.dal.ShowDbLock;
import com.alibaba.txc.parser.ast.stmt.dal.ShowEngine;
import com.alibaba.txc.parser.ast.stmt.dal.ShowEngines;
import com.alibaba.txc.parser.ast.stmt.dal.ShowErrors;
import com.alibaba.txc.parser.ast.stmt.dal.ShowEvents;
import com.alibaba.txc.parser.ast.stmt.dal.ShowFunctionCode;
import com.alibaba.txc.parser.ast.stmt.dal.ShowFunctionStatus;
import com.alibaba.txc.parser.ast.stmt.dal.ShowGrants;
import com.alibaba.txc.parser.ast.stmt.dal.ShowIndex;
import com.alibaba.txc.parser.ast.stmt.dal.ShowMasterStatus;
import com.alibaba.txc.parser.ast.stmt.dal.ShowOpenTables;
import com.alibaba.txc.parser.ast.stmt.dal.ShowPartitions;
import com.alibaba.txc.parser.ast.stmt.dal.ShowPlugins;
import com.alibaba.txc.parser.ast.stmt.dal.ShowPrivileges;
import com.alibaba.txc.parser.ast.stmt.dal.ShowProcedureCode;
import com.alibaba.txc.parser.ast.stmt.dal.ShowProcedureStatus;
import com.alibaba.txc.parser.ast.stmt.dal.ShowProcesslist;
import com.alibaba.txc.parser.ast.stmt.dal.ShowProfile;
import com.alibaba.txc.parser.ast.stmt.dal.ShowProfiles;
import com.alibaba.txc.parser.ast.stmt.dal.ShowRule;
import com.alibaba.txc.parser.ast.stmt.dal.ShowSequences;
import com.alibaba.txc.parser.ast.stmt.dal.ShowSlaveHosts;
import com.alibaba.txc.parser.ast.stmt.dal.ShowSlaveStatus;
import com.alibaba.txc.parser.ast.stmt.dal.ShowSlow;
import com.alibaba.txc.parser.ast.stmt.dal.ShowStats;
import com.alibaba.txc.parser.ast.stmt.dal.ShowStatus;
import com.alibaba.txc.parser.ast.stmt.dal.ShowTableStatus;
import com.alibaba.txc.parser.ast.stmt.dal.ShowTables;
import com.alibaba.txc.parser.ast.stmt.dal.ShowTopology;
import com.alibaba.txc.parser.ast.stmt.dal.ShowTrace;
import com.alibaba.txc.parser.ast.stmt.dal.ShowTriggers;
import com.alibaba.txc.parser.ast.stmt.dal.ShowVariables;
import com.alibaba.txc.parser.ast.stmt.dal.ShowWarnings;
import com.alibaba.txc.parser.ast.stmt.ddl.AlterSequence;
import com.alibaba.txc.parser.ast.stmt.ddl.CreateSequence;
import com.alibaba.txc.parser.ast.stmt.ddl.DDLAlterTableStatement;
import com.alibaba.txc.parser.ast.stmt.ddl.DDLCreateIndexStatement;
import com.alibaba.txc.parser.ast.stmt.ddl.DDLCreateTableStatement;
import com.alibaba.txc.parser.ast.stmt.ddl.DDLDropIndexStatement;
import com.alibaba.txc.parser.ast.stmt.ddl.DDLDropTableStatement;
import com.alibaba.txc.parser.ast.stmt.ddl.DDLRenameTableStatement;
import com.alibaba.txc.parser.ast.stmt.ddl.DDLTruncateStatement;
import com.alibaba.txc.parser.ast.stmt.ddl.DescTableStatement;
import com.alibaba.txc.parser.ast.stmt.ddl.DropSequence;
import com.alibaba.txc.parser.ast.stmt.ddl.LockTablesStatement;
import com.alibaba.txc.parser.ast.stmt.ddl.UnLockTablesStatement;
import com.alibaba.txc.parser.ast.stmt.dml.DMLCallStatement;
import com.alibaba.txc.parser.ast.stmt.dml.DMLDeleteStatement;
import com.alibaba.txc.parser.ast.stmt.dml.DMLInsertStatement;
import com.alibaba.txc.parser.ast.stmt.dml.DMLLoadStatement;
import com.alibaba.txc.parser.ast.stmt.dml.DMLReplaceStatement;
import com.alibaba.txc.parser.ast.stmt.dml.DMLSelectFromUpdateStatement;
import com.alibaba.txc.parser.ast.stmt.dml.DMLSelectStatement;
import com.alibaba.txc.parser.ast.stmt.dml.DMLSelectUnionStatement;
import com.alibaba.txc.parser.ast.stmt.dml.DMLUpdateStatement;
import com.alibaba.txc.parser.ast.stmt.extension.ExtDDLCreatePolicy;
import com.alibaba.txc.parser.ast.stmt.extension.ExtDDLDropPolicy;
import com.alibaba.txc.parser.ast.stmt.mts.MTSReleaseStatement;
import com.alibaba.txc.parser.ast.stmt.mts.MTSRollbackStatement;
import com.alibaba.txc.parser.ast.stmt.mts.MTSSavepointStatement;
import com.alibaba.txc.parser.ast.stmt.mts.MTSSetTransactionStatement;
import com.alibaba.txc.parser.ast.stmt.reload.ReloadDataSources;
import com.alibaba.txc.parser.ast.stmt.reload.ReloadSchema;
import com.alibaba.txc.parser.ast.stmt.reload.ReloadUsers;
import com.alibaba.txc.parser.recognizer.mysql.lexer.MySQLKeywords;
import com.alibaba.txc.parser.util.Pair;
import com.taobao.txc.common.util.string.CommerSpliter;
import com.taobao.txc.common.util.string.ConfigDataMode;
import com.taobao.txc.common.util.string.TStringUtil;
import com.taobao.txc.parser.visitor.api.SQLASTVisitor;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class MySQLOutputASTVisitor
implements SQLASTVisitor {
    protected static final Object[] EMPTY_OBJ_ARRAY = new Object[0];
    protected static final int[] EMPTY_INT_ARRAY = new int[0];
    protected final StringBuilder appendable;
    protected final Object[] args;
    protected int[] argsIndex;
    protected Map<PlaceHolder, Object> placeHolderToString;
    protected boolean upperCase = false;
    protected int index = -1;

    public MySQLOutputASTVisitor(StringBuilder appendable) {
        this(appendable, false);
    }

    public MySQLOutputASTVisitor(StringBuilder appendable, boolean upperCase) {
        this(appendable, null, upperCase);
    }

    public MySQLOutputASTVisitor(StringBuilder appendable, Object[] args, boolean upperCase) {
        this.appendable = appendable;
        this.args = args == null ? EMPTY_OBJ_ARRAY : args;
        this.argsIndex = args == null ? EMPTY_INT_ARRAY : new int[args.length];
        this.upperCase = upperCase;
    }

    public void setPlaceHolderToString(Map<PlaceHolder, Object> map) {
        this.placeHolderToString = map;
    }

    public Object[] getArguments() {
        int argsIndexSize = this.argsIndex.length;
        if (argsIndexSize <= 0) {
            return EMPTY_OBJ_ARRAY;
        }
        boolean noChange = true;
        for (int i = 0; i < argsIndexSize; ++i) {
            if (i == this.argsIndex[i]) continue;
            noChange = false;
            break;
        }
        if (noChange) {
            return this.args;
        }
        Object[] rst = new Object[argsIndexSize];
        for (int i = 0; i < argsIndexSize; ++i) {
            rst[i] = this.args[this.argsIndex[i]];
        }
        return rst;
    }

    protected void printList(List<? extends ASTNode> list) {
        this.printList(list, ", ");
    }

    protected void printList(List<? extends ASTNode> list, String sep) {
        boolean isFst = true;
        for (ASTNode aSTNode : list) {
            if (isFst) {
                isFst = false;
            } else {
                this.appendable.append(sep);
            }
            aSTNode.accept(this);
        }
    }

    @Override
    public void visit(BetweenAndExpression node) {
        boolean paren;
        Expression comparee = node.getFirst();
        boolean bl = paren = comparee.getPrecedence() <= node.getPrecedence();
        if (paren) {
            this.appendable.append('(');
        }
        comparee.accept(this);
        if (paren) {
            this.appendable.append(')');
        }
        if (node.isNot()) {
            this.appendable.append(" NOT BETWEEN ");
        } else {
            this.appendable.append(" BETWEEN ");
        }
        Expression start = node.getSecond();
        boolean bl2 = paren = start.getPrecedence() < node.getPrecedence();
        if (paren) {
            this.appendable.append('(');
        }
        start.accept(this);
        if (paren) {
            this.appendable.append(')');
        }
        this.appendable.append(" AND ");
        Expression end = node.getThird();
        boolean bl3 = paren = end.getPrecedence() < node.getPrecedence();
        if (paren) {
            this.appendable.append('(');
        }
        end.accept(this);
        if (paren) {
            this.appendable.append(')');
        }
    }

    @Override
    public void visit(ComparisionIsExpression node) {
        boolean paren;
        Expression comparee = node.getOperand();
        boolean bl = paren = comparee.getPrecedence() < node.getPrecedence();
        if (paren) {
            this.appendable.append('(');
        }
        comparee.accept(this);
        if (paren) {
            this.appendable.append(')');
        }
        switch (node.getMode()) {
            case 1: {
                this.appendable.append(" IS NULL");
                break;
            }
            case 2: {
                this.appendable.append(" IS TRUE");
                break;
            }
            case 3: {
                this.appendable.append(" IS FALSE");
                break;
            }
            case 4: {
                this.appendable.append(" IS UNKNOWN");
                break;
            }
            case 5: {
                this.appendable.append(" IS NOT NULL");
                break;
            }
            case 6: {
                this.appendable.append(" IS NOT TRUE");
                break;
            }
            case 7: {
                this.appendable.append(" IS NOT FALSE");
                break;
            }
            case 8: {
                this.appendable.append(" IS NOT UNKNOWN");
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown mode for IS expression: " + node.getMode());
            }
        }
    }

    @Override
    public void visit(InExpressionList node) {
        this.appendable.append('(');
        this.printList(node.getList());
        this.appendable.append(')');
    }

    @Override
    public void visit(LikeExpression node) {
        Expression escape;
        boolean paren;
        Expression comparee = node.getFirst();
        boolean bl = paren = comparee.getPrecedence() < node.getPrecedence();
        if (paren) {
            this.appendable.append('(');
        }
        comparee.accept(this);
        if (paren) {
            this.appendable.append(')');
        }
        if (node.isNot()) {
            this.appendable.append(" NOT LIKE ");
        } else {
            this.appendable.append(" LIKE ");
        }
        Expression pattern = node.getSecond();
        boolean bl2 = paren = pattern.getPrecedence() <= node.getPrecedence();
        if (paren) {
            this.appendable.append('(');
        }
        pattern.accept(this);
        if (paren) {
            this.appendable.append(')');
        }
        if ((escape = node.getThird()) != null) {
            this.appendable.append(" ESCAPE ");
            boolean bl3 = paren = escape.getPrecedence() <= node.getPrecedence();
            if (paren) {
                this.appendable.append('(');
            }
            escape.accept(this);
            if (paren) {
                this.appendable.append(')');
            }
        }
    }

    @Override
    public void visit(CollateExpression node) {
        boolean paren;
        Expression string = node.getString();
        boolean bl = paren = string.getPrecedence() < node.getPrecedence();
        if (paren) {
            this.appendable.append('(');
        }
        string.accept(this);
        if (paren) {
            this.appendable.append(')');
        }
        this.appendable.append(" COLLATE ").append(node.getCollateName());
    }

    @Override
    public void visit(UserExpression node) {
        this.appendable.append(node.getUserAtHost());
    }

    @Override
    public void visit(UnaryOperatorExpression node) {
        boolean paren;
        this.appendable.append(node.getOperator()).append(' ');
        boolean bl = paren = node.getOperand().getPrecedence() < node.getPrecedence();
        if (paren) {
            this.appendable.append('(');
        }
        node.getOperand().accept(this);
        if (paren) {
            this.appendable.append(')');
        }
    }

    @Override
    public void visit(BinaryOperatorExpression node) {
        boolean paren;
        Expression left = node.getLeftOprand();
        boolean bl = node.isLeftCombine() ? left.getPrecedence() < node.getPrecedence() : (paren = left.getPrecedence() <= node.getPrecedence());
        if (paren) {
            this.appendable.append('(');
        }
        left.accept(this);
        if (paren) {
            this.appendable.append(')');
        }
        this.appendable.append(' ').append(node.getOperator()).append(' ');
        Expression right = node.getRightOprand();
        boolean bl2 = node.isLeftCombine() ? right.getPrecedence() <= node.getPrecedence() : (paren = right.getPrecedence() < node.getPrecedence());
        if (paren) {
            this.appendable.append('(');
        }
        right.accept(this);
        if (paren) {
            this.appendable.append(')');
        }
    }

    @Override
    public void visit(PolyadicOperatorExpression node) {
        int len = node.getArity();
        for (int i = 0; i < len; ++i) {
            Expression operand;
            boolean paren;
            if (i > 0) {
                this.appendable.append(' ').append(node.getOperator()).append(' ');
            }
            boolean bl = paren = (operand = node.getOperand(i)).getPrecedence() < node.getPrecedence();
            if (paren) {
                this.appendable.append('(');
            }
            operand.accept(this);
            if (!paren) continue;
            this.appendable.append(')');
        }
    }

    @Override
    public void visit(LogicalAndExpression node) {
        this.visit((PolyadicOperatorExpression)node);
    }

    @Override
    public void visit(LogicalOrExpression node) {
        this.visit((PolyadicOperatorExpression)node);
    }

    @Override
    public void visit(ComparisionEqualsExpression node) {
        this.visit((BinaryOperatorExpression)node);
    }

    @Override
    public void visit(ComparisionNullSafeEqualsExpression node) {
        this.visit((BinaryOperatorExpression)node);
    }

    @Override
    public void visit(InExpression node) {
        this.visit((BinaryOperatorExpression)node);
    }

    @Override
    public void visit(FunctionExpression node) {
        String functionName = node.getFunctionName();
        this.appendable.append(functionName).append('(');
        this.printList(node.getArguments());
        this.appendable.append(')');
    }

    @Override
    public void visit(Char node) {
        String functionName = node.getFunctionName();
        this.appendable.append(functionName).append('(');
        this.printList(node.getArguments());
        String charset = node.getCharset();
        if (charset != null) {
            this.appendable.append(" USING ").append(charset);
        }
        this.appendable.append(')');
    }

    @Override
    public void visit(Convert node) {
        String functionName = node.getFunctionName();
        this.appendable.append(functionName).append('(');
        this.printList(node.getArguments());
        String transcodeName = node.getTranscodeName();
        if (transcodeName != null) {
            this.appendable.append(" USING ").append(transcodeName);
        } else {
            this.appendable.append(", ");
            String typeName = node.getTypeName();
            this.appendable.append(typeName);
            Expression info1 = node.getTypeInfo1();
            if (info1 != null) {
                this.appendable.append('(');
                info1.accept(this);
                Expression info2 = node.getTypeInfo2();
                if (info2 != null) {
                    this.appendable.append(", ");
                    info2.accept(this);
                }
                this.appendable.append(')');
            }
        }
        this.appendable.append(')');
    }

    @Override
    public void visit(Trim node) {
        String functionName = node.getFunctionName();
        this.appendable.append(functionName).append('(');
        Expression remStr = node.getRemainString();
        switch (node.getDirection()) {
            case DEFAULT: {
                if (remStr == null) break;
                remStr.accept(this);
                this.appendable.append(" FROM ");
                break;
            }
            case BOTH: {
                this.appendable.append("BOTH ");
                if (remStr != null) {
                    remStr.accept(this);
                }
                this.appendable.append(" FROM ");
                break;
            }
            case LEADING: {
                this.appendable.append("LEADING ");
                if (remStr != null) {
                    remStr.accept(this);
                }
                this.appendable.append(" FROM ");
                break;
            }
            case TRAILING: {
                this.appendable.append("TRAILING ");
                if (remStr != null) {
                    remStr.accept(this);
                }
                this.appendable.append(" FROM ");
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown trim direction: " + (Object)((Object)node.getDirection()));
            }
        }
        Expression str = node.getString();
        str.accept(this);
        this.appendable.append(')');
    }

    @Override
    public void visit(Cast node) {
        String functionName = node.getFunctionName();
        this.appendable.append(functionName).append('(');
        node.getExpr().accept(this);
        this.appendable.append(" AS ");
        String typeName = node.getTypeName();
        this.appendable.append(typeName);
        Expression info1 = node.getTypeInfo1();
        if (info1 != null) {
            this.appendable.append('(');
            info1.accept(this);
            Expression info2 = node.getTypeInfo2();
            if (info2 != null) {
                this.appendable.append(", ");
                info2.accept(this);
            }
            this.appendable.append(')');
        }
        this.appendable.append(')');
    }

    @Override
    public void visit(Avg node) {
        String functionName = node.getFunctionName();
        this.appendable.append(functionName).append('(');
        if (node.isDistinct()) {
            this.appendable.append("DISTINCT ");
        }
        this.printList(node.getArguments());
        this.appendable.append(')');
    }

    @Override
    public void visit(Max node) {
        String functionName = node.getFunctionName();
        this.appendable.append(functionName).append('(');
        if (node.isDistinct()) {
            this.appendable.append("DISTINCT ");
        }
        this.printList(node.getArguments());
        this.appendable.append(')');
    }

    @Override
    public void visit(Min node) {
        String functionName = node.getFunctionName();
        this.appendable.append(functionName).append('(');
        if (node.isDistinct()) {
            this.appendable.append("DISTINCT ");
        }
        this.printList(node.getArguments());
        this.appendable.append(')');
    }

    @Override
    public void visit(Sum node) {
        String functionName = node.getFunctionName();
        this.appendable.append(functionName).append('(');
        if (node.isDistinct()) {
            this.appendable.append("DISTINCT ");
        }
        this.printList(node.getArguments());
        this.appendable.append(')');
    }

    @Override
    public void visit(Count node) {
        String functionName = node.getFunctionName();
        this.appendable.append(functionName).append('(');
        if (node.isDistinct()) {
            this.appendable.append("DISTINCT ");
        }
        this.printList(node.getArguments());
        this.appendable.append(')');
    }

    @Override
    public void visit(GroupConcat node) {
        LiteralString sep;
        String functionName = node.getFunctionName();
        this.appendable.append(functionName).append('(');
        if (node.isDistinct()) {
            this.appendable.append("DISTINCT ");
        }
        this.printList(node.getArguments());
        List<Pair<Expression, SortOrder>> orderBy = node.getOrderBy();
        if (orderBy != null && !orderBy.isEmpty()) {
            Iterator<Pair<Expression, SortOrder>> orderByIterator = orderBy.iterator();
            this.appendable.append(" ORDER BY ");
            boolean first = true;
            while (orderByIterator.hasNext()) {
                if (!first) {
                    this.appendable.append(",");
                }
                first = false;
                Pair<Expression, SortOrder> o = orderByIterator.next();
                o.getKey().accept(this);
                if (o.getValue().equals((Object)SortOrder.DESC)) {
                    this.appendable.append(" DESC");
                    continue;
                }
                this.appendable.append(" ASC");
            }
        }
        if ((sep = node.getSeparator()) != null) {
            this.appendable.append(" SEPARATOR ");
            sep.accept(this);
        }
        this.appendable.append(')');
    }

    @Override
    public void visit(Extract node) {
        this.appendable.append("EXTRACT(").append(node.getUnit().name()).append(" FROM ");
        this.printList(node.getArguments());
        this.appendable.append(')');
    }

    @Override
    public void visit(Timestampdiff node) {
        this.appendable.append("TIMESTAMPDIFF(").append(node.getUnit().name()).append(", ");
        this.printList(node.getArguments());
        this.appendable.append(')');
    }

    @Override
    public void visit(Timestampadd node) {
        this.appendable.append("TIMESTAMPADD(").append(node.getUnit().name()).append(", ");
        this.printList(node.getArguments());
        this.appendable.append(')');
    }

    @Override
    public void visit(GetFormat node) {
        this.appendable.append("GET_FORMAT(");
        GetFormat.FormatType type = node.getFormatType();
        this.appendable.append(type.name()).append(", ");
        this.printList(node.getArguments());
        this.appendable.append(')');
    }

    @Override
    public void visit(PlaceHolder node) {
        if (this.placeHolderToString == null) {
            this.appendable.append("${").append(node.getName()).append('}');
            return;
        }
        Object toStringer = this.placeHolderToString.get(node);
        if (toStringer == null) {
            this.appendable.append("${").append(node.getName()).append('}');
        } else {
            this.appendable.append(toStringer.toString());
        }
    }

    @Override
    public void visit(IntervalPrimary node) {
        boolean paren;
        this.appendable.append("INTERVAL ");
        Expression quantity = node.getQuantity();
        boolean bl = paren = quantity.getPrecedence() < node.getPrecedence();
        if (paren) {
            this.appendable.append('(');
        }
        quantity.accept(this);
        if (paren) {
            this.appendable.append(')');
        }
        IntervalPrimary.Unit unit = node.getUnit();
        this.appendable.append(' ').append(unit.name());
    }

    @Override
    public void visit(LiteralBitField node) {
        String introducer = node.getIntroducer();
        if (introducer != null) {
            this.appendable.append(introducer).append(' ');
        }
        this.appendable.append("b'").append(node.getText()).append('\'');
    }

    @Override
    public void visit(LiteralBoolean node) {
        if (node.isTrue()) {
            this.appendable.append("TRUE");
        } else {
            this.appendable.append("FALSE");
        }
    }

    @Override
    public void visit(LiteralHexadecimal node) {
        String introducer = node.getIntroducer();
        if (introducer != null) {
            this.appendable.append(introducer).append(' ');
        }
        this.appendable.append("x'");
        node.appendTo(this.appendable);
        this.appendable.append('\'');
    }

    @Override
    public void visit(LiteralNull node) {
        this.appendable.append("NULL");
    }

    @Override
    public void visit(LiteralNumber node) {
        this.appendable.append(String.valueOf(node.getNumber()));
    }

    @Override
    public void visit(LiteralString node) {
        String introducer = node.getIntroducer();
        if (introducer != null) {
            this.appendable.append(introducer);
        } else if (node.isNchars()) {
            this.appendable.append('N');
        }
        this.appendable.append('\'').append(node.getString()).append('\'');
    }

    @Override
    public void visit(CaseWhenOperatorExpression node) {
        this.appendable.append("CASE");
        Expression comparee = node.getComparee();
        if (comparee != null) {
            this.appendable.append(' ');
            comparee.accept(this);
        }
        List<Pair<Expression, Expression>> whenList = node.getWhenList();
        for (Pair<Expression, Expression> whenthen : whenList) {
            this.appendable.append(" WHEN ");
            Expression when = whenthen.getKey();
            when.accept(this);
            this.appendable.append(" THEN ");
            Expression then = whenthen.getValue();
            then.accept(this);
        }
        Expression elseRst = node.getElseResult();
        if (elseRst != null) {
            this.appendable.append(" ELSE ");
            elseRst.accept(this);
        }
        this.appendable.append(" END");
    }

    @Override
    public void visit(DefaultValue node) {
        this.appendable.append("DEFAULT");
    }

    @Override
    public void visit(ExistsPrimary node) {
        this.appendable.append("EXISTS (");
        node.getSubquery().accept(this);
        this.appendable.append(')');
    }

    @Override
    public void visit(Identifier node) {
        Identifier parent = node.getParent();
        if (parent != null) {
            parent.accept(this);
            this.appendable.append('.');
        }
        this.appendable.append(MySQLOutputASTVisitor.convertKeywords(node.getIdText()));
    }

    protected static boolean containsCompIn(Expression pat) {
        if (pat.getPrecedence() > 7) {
            return false;
        }
        if (pat instanceof BinaryOperatorExpression) {
            if (pat instanceof InExpression) {
                return true;
            }
            BinaryOperatorExpression bp = (BinaryOperatorExpression)pat;
            if (bp.isLeftCombine()) {
                return MySQLOutputASTVisitor.containsCompIn(bp.getLeftOprand());
            }
            return MySQLOutputASTVisitor.containsCompIn(bp.getLeftOprand());
        }
        if (pat instanceof ComparisionIsExpression) {
            ComparisionIsExpression is = (ComparisionIsExpression)pat;
            return MySQLOutputASTVisitor.containsCompIn(is.getOperand());
        }
        if (pat instanceof TernaryOperatorExpression) {
            TernaryOperatorExpression tp = (TernaryOperatorExpression)pat;
            return MySQLOutputASTVisitor.containsCompIn(tp.getFirst()) || MySQLOutputASTVisitor.containsCompIn(tp.getSecond()) || MySQLOutputASTVisitor.containsCompIn(tp.getThird());
        }
        if (pat instanceof UnaryOperatorExpression) {
            UnaryOperatorExpression up = (UnaryOperatorExpression)pat;
            return MySQLOutputASTVisitor.containsCompIn(up.getOperand());
        }
        return false;
    }

    @Override
    public void visit(MatchExpression node) {
        this.appendable.append("MATCH (");
        this.printList(node.getColumns());
        this.appendable.append(") AGAINST (");
        Expression pattern = node.getPattern();
        boolean inparen = MySQLOutputASTVisitor.containsCompIn(pattern);
        if (inparen) {
            this.appendable.append('(');
        }
        pattern.accept(this);
        if (inparen) {
            this.appendable.append(')');
        }
        switch (node.getModifier()) {
            case IN_BOOLEAN_MODE: {
                this.appendable.append(" IN BOOLEAN MODE");
                break;
            }
            case IN_NATURAL_LANGUAGE_MODE: {
                this.appendable.append(" IN NATURAL LANGUAGE MODE");
                break;
            }
            case IN_NATURAL_LANGUAGE_MODE_WITH_QUERY_EXPANSION: {
                this.appendable.append(" IN NATURAL LANGUAGE MODE WITH QUERY EXPANSION");
                break;
            }
            case WITH_QUERY_EXPANSION: {
                this.appendable.append(" WITH QUERY EXPANSION");
                break;
            }
            case _DEFAULT: {
                break;
            }
            default: {
                throw new IllegalArgumentException("unkown modifier for match expression: " + (Object)((Object)node.getModifier()));
            }
        }
        this.appendable.append(')');
    }

    protected void appendArgsIndex(int value) {
        int i;
        if (this.argsIndex.length <= (i = ++this.index)) {
            int[] a = new int[i + 1];
            if (i > 0) {
                System.arraycopy(this.argsIndex, 0, a, 0, i);
            }
            this.argsIndex = a;
        }
        this.argsIndex[i] = value;
    }

    @Override
    public void visit(ParamMarker node) {
        this.appendable.append('?');
        this.appendArgsIndex(node.getParamIndex() - 1);
    }

    @Override
    public void visit(RowExpression node) {
        this.appendable.append("ROW(");
        this.printList(node.getRowExprList());
        this.appendable.append(')');
    }

    @Override
    public void visit(SysVarPrimary node) {
        VariableScope scope = node.getScope();
        switch (scope) {
            case GLOBAL: {
                this.appendable.append("@@global.");
                break;
            }
            case SESSION: {
                this.appendable.append("@@");
                break;
            }
            default: {
                throw new IllegalArgumentException("unkown scope for sysVar primary: " + (Object)((Object)scope));
            }
        }
        this.appendable.append(node.getVarText());
    }

    @Override
    public void visit(UsrDefVarPrimary node) {
        this.appendable.append(node.getVarText());
    }

    @Override
    public void visit(IndexHint node) {
        IndexHint.IndexAction action = node.getAction();
        switch (action) {
            case FORCE: {
                this.appendable.append("FORCE ");
                break;
            }
            case IGNORE: {
                this.appendable.append("IGNORE ");
                break;
            }
            case USE: {
                this.appendable.append("USE ");
                break;
            }
            default: {
                throw new IllegalArgumentException("unkown index action for index hint: " + (Object)((Object)action));
            }
        }
        IndexHint.IndexType type = node.getType();
        switch (type) {
            case INDEX: {
                this.appendable.append("INDEX ");
                break;
            }
            case KEY: {
                this.appendable.append("KEY ");
                break;
            }
            default: {
                throw new IllegalArgumentException("unkown index type for index hint: " + (Object)((Object)type));
            }
        }
        IndexHint.IndexScope scope = node.getScope();
        switch (scope) {
            case GROUP_BY: {
                this.appendable.append("FOR GROUP BY ");
                break;
            }
            case ORDER_BY: {
                this.appendable.append("FOR ORDER BY ");
                break;
            }
            case JOIN: {
                this.appendable.append("FOR JOIN ");
                break;
            }
            case ALL: {
                break;
            }
            default: {
                throw new IllegalArgumentException("unkown index scope for index hint: " + (Object)((Object)scope));
            }
        }
        this.appendable.append('(');
        List<String> indexList = node.getIndexList();
        boolean isFst = true;
        for (String indexName : indexList) {
            if (isFst) {
                isFst = false;
            } else {
                this.appendable.append(", ");
            }
            this.appendable.append(MySQLOutputASTVisitor.convertKeywords(indexName));
        }
        this.appendable.append(')');
    }

    @Override
    public void visit(TableReferences node) {
        this.printList(node.getTableReferenceList());
    }

    @Override
    public void visit(InnerJoin node) {
        boolean paren;
        TableReference left = node.getLeftTableRef();
        boolean bl = paren = left.getPrecedence() < node.getPrecedence();
        if (paren) {
            this.appendable.append('(');
        }
        left.accept(this);
        if (paren) {
            this.appendable.append(')');
        }
        this.appendable.append(" INNER JOIN ");
        TableReference right = node.getRightTableRef();
        boolean bl2 = paren = right.getPrecedence() <= node.getPrecedence();
        if (paren) {
            this.appendable.append('(');
        }
        right.accept(this);
        if (paren) {
            this.appendable.append(')');
        }
        Expression on = node.getOnCond();
        List<String> using = node.getUsing();
        if (on != null) {
            this.appendable.append(" ON ");
            on.accept(this);
        } else if (using != null) {
            this.appendable.append(" USING (");
            boolean isFst = true;
            for (String col : using) {
                if (isFst) {
                    isFst = false;
                } else {
                    this.appendable.append(", ");
                }
                this.appendable.append(MySQLOutputASTVisitor.convertKeywords(col));
            }
            this.appendable.append(")");
        }
    }

    @Override
    public void visit(NaturalJoin node) {
        boolean paren;
        TableReference left = node.getLeftTableRef();
        boolean bl = paren = left.getPrecedence() < node.getPrecedence();
        if (paren) {
            this.appendable.append('(');
        }
        left.accept(this);
        if (paren) {
            this.appendable.append(')');
        }
        this.appendable.append(" NATURAL ");
        if (node.isOuter()) {
            if (node.isLeft()) {
                this.appendable.append("LEFT ");
            } else {
                this.appendable.append("RIGHT ");
            }
        }
        this.appendable.append("JOIN ");
        TableReference right = node.getRightTableRef();
        boolean bl2 = paren = right.getPrecedence() <= node.getPrecedence();
        if (paren) {
            this.appendable.append('(');
        }
        right.accept(this);
        if (paren) {
            this.appendable.append(')');
        }
    }

    @Override
    public void visit(StraightJoin node) {
        Expression on;
        boolean paren;
        TableReference left = node.getLeftTableRef();
        boolean bl = paren = left.getPrecedence() < node.getPrecedence();
        if (paren) {
            this.appendable.append('(');
        }
        left.accept(this);
        if (paren) {
            this.appendable.append(')');
        }
        this.appendable.append(" STRAIGHT_JOIN ");
        TableReference right = node.getRightTableRef();
        boolean bl2 = paren = right.getPrecedence() <= node.getPrecedence();
        if (paren) {
            this.appendable.append('(');
        }
        right.accept(this);
        if (paren) {
            this.appendable.append(')');
        }
        if ((on = node.getOnCond()) != null) {
            this.appendable.append(" ON ");
            on.accept(this);
        }
    }

    @Override
    public void visit(OuterJoin node) {
        boolean paren;
        TableReference left = node.getLeftTableRef();
        boolean bl = paren = left.getPrecedence() < node.getPrecedence();
        if (paren) {
            this.appendable.append('(');
        }
        left.accept(this);
        if (paren) {
            this.appendable.append(')');
        }
        if (node.isLeftJoin()) {
            this.appendable.append(" LEFT JOIN ");
        } else {
            this.appendable.append(" RIGHT JOIN ");
        }
        TableReference right = node.getRightTableRef();
        boolean bl2 = paren = right.getPrecedence() <= node.getPrecedence();
        if (paren) {
            this.appendable.append('(');
        }
        right.accept(this);
        if (paren) {
            this.appendable.append(')');
        }
        Expression on = node.getOnCond();
        List<String> using = node.getUsing();
        if (on != null) {
            this.appendable.append(" ON ");
            on.accept(this);
        } else if (using != null) {
            this.appendable.append(" USING (");
            boolean isFst = true;
            for (String col : using) {
                if (isFst) {
                    isFst = false;
                } else {
                    this.appendable.append(", ");
                }
                this.appendable.append(MySQLOutputASTVisitor.convertKeywords(col));
            }
            this.appendable.append(")");
        } else {
            throw new IllegalArgumentException("either ON or USING must be included for OUTER JOIN");
        }
    }

    @Override
    public void visit(SubqueryFactor node) {
        this.appendable.append('(');
        QueryExpression query = node.getSubquery();
        query.accept(this);
        this.appendable.append(") AS ").append(MySQLOutputASTVisitor.convertKeywords(node.getAlias()));
    }

    @Override
    public void visit(TableRefFactor node) {
        List<IndexHint> list;
        this.processTableName(node.getTable());
        String alias = node.getAlias();
        if (alias != null) {
            this.appendable.append(" AS ");
            this.appendable.append(MySQLOutputASTVisitor.convertKeywords(alias));
        }
        if ((list = node.getHintList()) != null && !list.isEmpty()) {
            this.appendable.append(' ');
            this.printList(list, " ");
        }
    }

    @Override
    public void visit(Dual dual) {
        this.appendable.append("DUAL");
    }

    @Override
    public void visit(GroupBy node) {
        this.appendable.append("GROUP BY ");
        boolean isFst = true;
        for (Pair<Expression, SortOrder> p : node.getOrderByList()) {
            if (isFst) {
                isFst = false;
            } else {
                this.appendable.append(", ");
            }
            Expression col = p.getKey();
            col.accept(this);
            switch (p.getValue()) {
                case DESC: {
                    this.appendable.append(" DESC");
                    break;
                }
            }
        }
        if (node.isWithRollup()) {
            this.appendable.append(" WITH ROLLUP");
        }
    }

    @Override
    public void visit(OrderBy node) {
        this.appendable.append("ORDER BY ");
        boolean isFst = true;
        for (Pair<Expression, SortOrder> p : node.getOrderByList()) {
            if (isFst) {
                isFst = false;
            } else {
                this.appendable.append(", ");
            }
            Expression col = p.getKey();
            col.accept(this);
            switch (p.getValue()) {
                case DESC: {
                    this.appendable.append(" DESC");
                    break;
                }
            }
        }
    }

    @Override
    public void visit(Limit node) {
        this.appendable.append("LIMIT ");
        Object offset = node.getOffset();
        if (offset instanceof ParamMarker) {
            ((ParamMarker)offset).accept(this);
        } else {
            this.appendable.append(String.valueOf(offset));
        }
        this.appendable.append(", ");
        Object size = node.getSize();
        if (size instanceof ParamMarker) {
            ((ParamMarker)size).accept(this);
        } else {
            this.appendable.append(String.valueOf(size));
        }
    }

    @Override
    public void visit(IndexOption node) {
        if (node.getKeyBlockSize() != null) {
            this.appendable.append("KEY_BLOCK_SIZE = ");
            node.getKeyBlockSize().accept(this);
        } else if (node.getIndexType() != null) {
            this.appendable.append("USING ");
            switch (node.getIndexType()) {
                case BTREE: {
                    this.appendable.append("BTREE");
                    break;
                }
                case HASH: {
                    this.appendable.append("HASH");
                }
            }
        } else if (node.getParserName() != null) {
            this.appendable.append("WITH PARSER ");
            node.getParserName().accept(this);
            this.appendable.append(" ");
        } else if (node.getComment() != null) {
            this.appendable.append("COMMENT ");
            node.getComment().accept(this);
            this.appendable.append(" ");
        }
    }

    @Override
    public void visit(TableOptions node) {
        CommerSpliter spliter = new CommerSpliter(this.appendable);
        spliter.reset();
        if (node.getEngine() != null) {
            spliter.split();
            this.appendable.append("ENGINE = ");
            node.getEngine().accept(this);
        }
        if (node.getAutoIncrement() != null) {
            spliter.split();
            this.appendable.append("AUTO_INCREMENT = ");
            ((LiteralNumber)node.getAutoIncrement()).accept(this);
        }
        if (node.getAvgRowLength() != null) {
            spliter.split();
            this.appendable.append("AVG_ROW_LENGTH = ");
            ((LiteralNumber)node.getAvgRowLength()).accept(this);
        }
        if (node.getCharSet() != null) {
            spliter.split();
            if (node.isDefaultCharset()) {
                this.appendable.append("DEFAULT ");
            }
            this.appendable.append("CHARACTER SET = ");
            node.getCharSet().accept(this);
            if (node.getCollateWithCharset() != null) {
                if (node.isDefaultCollateWithCharset()) {
                    this.appendable.append(" DEFAULT");
                }
                this.appendable.append(" COLLATE = ");
                node.getCollateWithCharset().accept(this);
            }
        }
        if (node.getCheckSum() != null) {
            spliter.split();
            this.appendable.append("CHECKSUM = ");
            this.appendable.append(node.getCheckSum() != false ? 1 : 0);
        }
        if (node.getCollation() != null) {
            spliter.split();
            if (node.isDefaultCollate()) {
                this.appendable.append("DEFAULT ");
            }
            this.appendable.append("COLLATE = ");
            node.getCollation().accept(this);
        }
        if (node.getComment() != null) {
            spliter.split();
            this.appendable.append("COMMENT = ");
            node.getComment().accept(this);
        }
        if (node.getConnection() != null) {
            spliter.split();
            this.appendable.append("CONNECTION = ");
            node.getConnection().accept(this);
        }
        if (node.getDataDir() != null) {
            spliter.split();
            this.appendable.append("DATA DIRECTORY = ");
            node.getDataDir().accept(this);
        }
        if (node.getDelayKeyWrite() != null) {
            spliter.split();
            this.appendable.append("DELAY_KEY_WRITE = ");
            this.appendable.append(node.getDelayKeyWrite() != false ? 1 : 0);
        }
        if (node.getIndexDir() != null) {
            spliter.split();
            this.appendable.append("INDEX DIRECTORY = ");
            node.getIndexDir().accept(this);
        }
        if (node.getInsertMethod() != null) {
            spliter.split();
            this.appendable.append("INSERT_METHOD = ");
            this.appendable.append(node.getInsertMethod().name());
        }
        if (node.getKeyBlockSize() != null) {
            spliter.split();
            this.appendable.append("KEY_BLOCK_SIZE = ");
            ((LiteralNumber)node.getKeyBlockSize()).accept(this);
        }
        if (node.getMaxRows() != null) {
            spliter.split();
            this.appendable.append("MAX_ROWS = ");
            ((LiteralNumber)node.getMaxRows()).accept(this);
        }
        if (node.getMinRows() != null) {
            spliter.split();
            this.appendable.append("MIN_ROWS = ");
            ((LiteralNumber)node.getMinRows()).accept(this);
        }
        if (node.getPackKeys() != null) {
            spliter.split();
            this.appendable.append("PACK_KEYS = ");
            switch (node.getPackKeys()) {
                case TRUE: {
                    this.appendable.append(1);
                    break;
                }
                case FALSE: {
                    this.appendable.append(0);
                    break;
                }
                case DEFAULT: {
                    this.appendable.append("DEFAULT");
                }
            }
        }
        if (node.getPassword() != null) {
            spliter.split();
            this.appendable.append("PASSWORD = ");
            node.getPassword().accept(this);
        }
        if (node.getRowFormat() != null) {
            spliter.split();
            this.appendable.append("ROW_FORMAT = ");
            this.appendable.append(node.getRowFormat().name());
        }
        if (node.getStatsAutoRecalc() != null) {
            spliter.split();
            this.appendable.append("STATS_AUTO_RECALC = ");
            switch (node.getStatsAutoRecalc()) {
                case FALSE: {
                    this.appendable.append(0);
                    break;
                }
                case TRUE: {
                    this.appendable.append(1);
                    break;
                }
                case DEFAULT: {
                    this.appendable.append("DEFAULT");
                }
            }
        }
        if (node.getStatsPersistent() != null) {
            spliter.split();
            this.appendable.append("STATS_PERSISTENT = ");
            switch (node.getStatsPersistent()) {
                case FALSE: {
                    this.appendable.append(0);
                    break;
                }
                case TRUE: {
                    this.appendable.append(1);
                    break;
                }
                case DEFAULT: {
                    this.appendable.append("DEFAULT");
                }
            }
        }
        if (node.getStatsSamplePages() != null) {
            spliter.split();
            this.appendable.append("STATS_SAMPLE_PAGES = ");
            node.getStatsSamplePages().accept(this);
        }
        if (node.getTablespaceName() != null) {
            spliter.split();
            this.appendable.append("TABLESPACE ");
            node.getTablespaceName().accept(this);
            if (node.getTableSpaceStorage() != null) {
                this.appendable.append(" STORAGE ");
                switch (node.getTableSpaceStorage()) {
                    case DISK: {
                        this.appendable.append("DISK");
                        break;
                    }
                    case MEMORY: {
                        this.appendable.append("MEMORY");
                        break;
                    }
                    case DEFAULT: {
                        this.appendable.append("DEFAULT");
                    }
                }
            }
        }
        if (node.getUnion() != null) {
            spliter.split();
            this.appendable.append("UNION = (");
            CommerSpliter unspliter = new CommerSpliter(this.appendable);
            for (Identifier tbl_name : node.getUnion()) {
                unspliter.split();
                tbl_name.accept(this);
            }
            this.appendable.append(")");
        }
    }

    @Override
    public void visit(DataType node) {
        throw new UnsupportedOperationException("subclass have not implement visit");
    }

    @Override
    public void visit(ShowDbLock showDbLock) {
        this.appendable.append("SHOW ").append("DBLOCK");
    }

    protected void printSimpleShowStmt(String attName) {
        this.appendable.append("SHOW ").append(attName);
    }

    @Override
    public void visit(ShowAuthors node) {
        this.printSimpleShowStmt("AUTHORS");
    }

    @Override
    public void visit(ShowBinaryLog node) {
        this.printSimpleShowStmt("BINARY LOGS");
    }

    @Override
    public void visit(ShowBinLogEvent node) {
        Limit limit;
        Expression pos;
        this.appendable.append("SHOW BINLOG EVENTS");
        String logName = node.getLogName();
        if (logName != null) {
            this.appendable.append(" IN ").append(logName);
        }
        if ((pos = node.getPos()) != null) {
            this.appendable.append(" FROM ");
            pos.accept(this);
        }
        if ((limit = node.getLimit()) != null) {
            this.appendable.append(' ');
            limit.accept(this);
        }
    }

    protected void printLikeOrWhere(String like, Expression where) {
        if (like != null) {
            this.appendable.append(" LIKE ").append(like);
        } else if (where != null) {
            this.appendable.append(" WHERE ");
            where.accept(this);
        }
    }

    @Override
    public void visit(ShowCharaterSet node) {
        this.appendable.append("SHOW CHARACTER SET");
        this.printLikeOrWhere(node.getPattern(), node.getWhere());
    }

    @Override
    public void visit(ShowCollation node) {
        this.appendable.append("SHOW COLLATION");
        this.printLikeOrWhere(node.getPattern(), node.getWhere());
    }

    @Override
    public void visit(ShowColumns node) {
        this.appendable.append("SHOW ");
        if (node.isFull()) {
            this.appendable.append("FULL ");
        }
        this.appendable.append("COLUMNS FROM ");
        this.processTableName(node.getTable());
        this.printLikeOrWhere(node.getPattern(), node.getWhere());
    }

    @Override
    public void visit(ShowContributors node) {
        this.printSimpleShowStmt("CONTRIBUTORS");
    }

    @Override
    public void visit(ShowCreate node) {
        this.appendable.append("SHOW CREATE ").append(node.getType().name()).append(' ');
        this.processTableName(node.getId());
    }

    @Override
    public void visit(ShowDatabases node) {
        this.appendable.append("SHOW DATABASES");
        this.printLikeOrWhere(node.getPattern(), node.getWhere());
    }

    @Override
    public void visit(ShowEngine node) {
        this.appendable.append("SHOW ENGINE ");
        switch (node.getType()) {
            case INNODB_MUTEX: {
                this.appendable.append("INNODB MUTEX");
                break;
            }
            case INNODB_STATUS: {
                this.appendable.append("INNODB STATUS");
                break;
            }
            case PERFORMANCE_SCHEMA_STATUS: {
                this.appendable.append("PERFORMANCE SCHEMA STATUS");
                break;
            }
            default: {
                throw new IllegalArgumentException("unrecognized type for SHOW ENGINE: " + (Object)((Object)node.getType()));
            }
        }
    }

    @Override
    public void visit(ShowEngines node) {
        this.printSimpleShowStmt("ENGINES");
    }

    @Override
    public void visit(ShowErrors node) {
        this.appendable.append("SHOW ");
        if (node.isCount()) {
            this.appendable.append("COUNT(*) ERRORS");
        } else {
            this.appendable.append("ERRORS");
            Limit limit = node.getLimit();
            if (node.getLimit() != null) {
                this.appendable.append(' ');
                limit.accept(this);
            }
        }
    }

    @Override
    public void visit(ShowEvents node) {
        this.appendable.append("SHOW EVENTS");
        Identifier schema = node.getSchema();
        if (schema != null) {
            this.appendable.append(" FROM ");
            schema.accept(this);
        }
        this.printLikeOrWhere(node.getPattern(), node.getWhere());
    }

    @Override
    public void visit(ShowFunctionCode node) {
        this.appendable.append("SHOW FUNCTION CODE ");
        node.getFunctionName().accept(this);
    }

    @Override
    public void visit(ShowFunctionStatus node) {
        this.appendable.append("SHOW FUNCTION STATUS");
        this.printLikeOrWhere(node.getPattern(), node.getWhere());
    }

    @Override
    public void visit(ShowGrants node) {
        this.appendable.append("SHOW GRANTS");
        Expression user = node.getUser();
        if (user != null) {
            this.appendable.append(" FOR ");
            user.accept(this);
        }
    }

    @Override
    public void visit(ShowIndex node) {
        this.appendable.append("SHOW ");
        switch (node.getType()) {
            case INDEX: {
                this.appendable.append("INDEX ");
                break;
            }
            case INDEXES: {
                this.appendable.append("INDEXES ");
                break;
            }
            case KEYS: {
                this.appendable.append("KEYS ");
                break;
            }
            default: {
                throw new IllegalArgumentException("unrecognized type for SHOW INDEX: " + (Object)((Object)node.getType()));
            }
        }
        this.appendable.append("IN ");
        this.processTableName(node.getTable());
    }

    @Override
    public void visit(ShowMasterStatus node) {
        this.printSimpleShowStmt("MASTER STATUS");
    }

    @Override
    public void visit(ShowOpenTables node) {
        this.appendable.append("SHOW OPEN TABLES");
        Identifier db = node.getSchema();
        if (db != null) {
            this.appendable.append(" FROM ");
            db.accept(this);
        }
        this.printLikeOrWhere(node.getPattern(), node.getWhere());
    }

    @Override
    public void visit(ShowPlugins node) {
        this.printSimpleShowStmt("PLUGINS");
    }

    @Override
    public void visit(ShowPrivileges node) {
        this.printSimpleShowStmt("PRIVILEGES");
    }

    @Override
    public void visit(ShowProcedureCode node) {
        this.appendable.append("SHOW PROCEDURE CODE ");
        node.getProcedureName().accept(this);
    }

    @Override
    public void visit(ShowProcedureStatus node) {
        this.appendable.append("SHOW PROCEDURE STATUS");
        this.printLikeOrWhere(node.getPattern(), node.getWhere());
    }

    @Override
    public void visit(ShowProcesslist node) {
        this.appendable.append("SHOW ");
        if (node.isFull()) {
            this.appendable.append("FULL ");
        }
        this.appendable.append("PROCESSLIST");
    }

    @Override
    public void visit(ShowProfile node) {
        Limit limit;
        this.appendable.append("SHOW PROFILE");
        List<ShowProfile.Type> types = node.getTypes();
        boolean isFst = true;
        for (ShowProfile.Type type : types) {
            if (isFst) {
                isFst = false;
                this.appendable.append(' ');
            } else {
                this.appendable.append(", ");
            }
            this.appendable.append(type.name().replace('_', ' '));
        }
        Expression query = node.getForQuery();
        if (query != null) {
            this.appendable.append(" FOR QUERY ");
            query.accept(this);
        }
        if ((limit = node.getLimit()) != null) {
            this.appendable.append(' ');
            limit.accept(this);
        }
    }

    @Override
    public void visit(ShowProfiles node) {
        this.printSimpleShowStmt("PROFILES");
    }

    @Override
    public void visit(ShowSlaveHosts node) {
        this.printSimpleShowStmt("SLAVE HOSTS");
    }

    @Override
    public void visit(ShowSlaveStatus node) {
        this.printSimpleShowStmt("SLAVE STATUS");
    }

    @Override
    public void visit(ShowStatus node) {
        this.appendable.append("SHOW ").append(node.getScope().name().replace('_', ' ')).append(" STATUS");
        this.printLikeOrWhere(node.getPattern(), node.getWhere());
    }

    @Override
    public void visit(ShowTables node) {
        this.appendable.append("SHOW");
        if (node.isFull()) {
            this.appendable.append(" FULL");
        }
        this.appendable.append(" TABLES");
        Identifier schema = node.getSchema();
        if (schema != null) {
            this.appendable.append(" FROM ");
            schema.accept(this);
        }
        this.printLikeOrWhere(node.getPattern(), node.getWhere());
    }

    @Override
    public void visit(ShowTableStatus node) {
        this.appendable.append("SHOW TABLE STATUS");
        Identifier schema = node.getDatabase();
        if (schema != null) {
            this.appendable.append(" FROM ");
            schema.accept(this);
        }
        this.printLikeOrWhere(node.getPattern(), node.getWhere());
    }

    @Override
    public void visit(ShowTriggers node) {
        this.appendable.append("SHOW TRIGGERS");
        Identifier schema = node.getSchema();
        if (schema != null) {
            this.appendable.append(" FROM ");
            schema.accept(this);
        }
        this.printLikeOrWhere(node.getPattern(), node.getWhere());
    }

    @Override
    public void visit(ShowVariables node) {
        this.appendable.append("SHOW ").append(node.getScope().name().replace('_', ' ')).append(" VARIABLES");
        this.printLikeOrWhere(node.getPattern(), node.getWhere());
    }

    @Override
    public void visit(ShowWarnings node) {
        this.appendable.append("SHOW ");
        if (node.isCount()) {
            this.appendable.append("COUNT(*) WARNINGS");
        } else {
            this.appendable.append("WARNINGS");
            Limit limit = node.getLimit();
            if (limit != null) {
                this.appendable.append(' ');
                limit.accept(this);
            }
        }
    }

    @Override
    public void visit(DescTableStatement node) {
        this.appendable.append("DESC ");
        this.processTableName(node.getTable());
    }

    @Override
    public void visit(DALSetStatement node) {
        this.appendable.append("SET ");
        boolean isFst = true;
        for (Pair<VariableExpression, Expression> p : node.getAssignmentList()) {
            if (isFst) {
                isFst = false;
            } else {
                this.appendable.append(", ");
            }
            p.getKey().accept(this);
            this.appendable.append(" = ");
            p.getValue().accept(this);
        }
    }

    @Override
    public void visit(DALSetSimpleStatement node) {
        this.appendable.append("SET ");
        boolean isFst = true;
        for (Pair<String, String> p : node.getVals()) {
            if (isFst) {
                isFst = false;
            } else {
                this.appendable.append(", ");
            }
            this.appendable.append(p.getKey());
            this.appendable.append(" = ");
            this.appendable.append(p.getValue());
        }
    }

    @Override
    public void visit(DALSetNamesStatement node) {
        this.appendable.append("SET NAMES ");
        if (node.isDefault()) {
            this.appendable.append("DEFAULT");
        } else {
            this.appendable.append(node.getCharsetName());
            String collate = node.getCollationName();
            if (collate != null) {
                this.appendable.append(" COLLATE ");
                this.appendable.append(collate);
            }
        }
    }

    @Override
    public void visit(DALSetCharacterSetStatement node) {
        this.appendable.append("SET CHARACTER SET ");
        if (node.isDefault()) {
            this.appendable.append("DEFAULT");
        } else {
            this.appendable.append(node.getCharset());
        }
    }

    @Override
    public void visit(MTSSetTransactionStatement node) {
        this.appendable.append("SET ");
        VariableScope scope = node.getScope();
        if (scope != null) {
            switch (scope) {
                case SESSION: {
                    this.appendable.append("SESSION ");
                    break;
                }
                case GLOBAL: {
                    this.appendable.append("GLOBAL ");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown scope for SET TRANSACTION ISOLATION LEVEL: " + (Object)((Object)scope));
                }
            }
        }
        this.appendable.append("TRANSACTION ISOLATION LEVEL ");
        switch (node.getLevel()) {
            case READ_COMMITTED: {
                this.appendable.append("READ COMMITTED");
                break;
            }
            case READ_UNCOMMITTED: {
                this.appendable.append("READ UNCOMMITTED");
                break;
            }
            case REPEATABLE_READ: {
                this.appendable.append("REPEATABLE READ");
                break;
            }
            case SERIALIZABLE: {
                this.appendable.append("SERIALIZABLE");
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown level for SET TRANSACTION ISOLATION LEVEL: " + (Object)((Object)node.getLevel()));
            }
        }
    }

    @Override
    public void visit(MTSSavepointStatement node) {
        this.appendable.append("SAVEPOINT ");
        node.getSavepoint().accept(this);
    }

    @Override
    public void visit(MTSReleaseStatement node) {
        this.appendable.append("RELEASE SAVEPOINT ");
        node.getSavepoint().accept(this);
    }

    @Override
    public void visit(MTSRollbackStatement node) {
        this.appendable.append("ROLLBACK");
        Identifier savepoint = node.getSavepoint();
        if (savepoint == null) {
            MTSRollbackStatement.CompleteType type = node.getCompleteType();
            switch (type) {
                case CHAIN: {
                    this.appendable.append(" AND CHAIN");
                    break;
                }
                case NO_CHAIN: {
                    this.appendable.append(" AND NO CHAIN");
                    break;
                }
                case NO_RELEASE: {
                    this.appendable.append(" NO RELEASE");
                    break;
                }
                case RELEASE: {
                    this.appendable.append(" RELEASE");
                    break;
                }
                case UN_DEF: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unrecgnized complete type: " + (Object)((Object)type));
                }
            }
        } else {
            this.appendable.append(" TO SAVEPOINT ");
            savepoint.accept(this);
        }
    }

    @Override
    public void visit(DMLCallStatement node) {
        this.appendable.append("CALL ");
        node.getProcedure().accept(this);
        this.appendable.append('(');
        this.printList(node.getArguments());
        this.appendable.append(')');
    }

    @Override
    public void visit(DMLDeleteStatement node) {
        Limit limit;
        OrderBy orderBy;
        TableReferences tableRefs;
        this.appendable.append("DELETE ");
        if (node.isLowPriority()) {
            this.appendable.append("LOW_PRIORITY ");
        }
        if (node.isQuick()) {
            this.appendable.append("QUICK ");
        }
        if (node.isIgnore()) {
            this.appendable.append("IGNORE ");
        }
        if ((tableRefs = node.getTableRefs()) == null) {
            this.appendable.append("FROM ");
            this.processTableName(node.getTableNames().get(0));
        } else {
            this.printList(node.getTableNames());
            this.appendable.append(" FROM ");
            node.getTableRefs().accept(this);
        }
        Expression where = node.getWhereCondition();
        if (where != null) {
            this.appendable.append(" WHERE ");
            where.accept(this);
        }
        if ((orderBy = node.getOrderBy()) != null) {
            this.appendable.append(' ');
            orderBy.accept(this);
        }
        if ((limit = node.getLimit()) != null) {
            this.appendable.append(" LIMIT ");
            Object size = limit.getSize();
            if (size instanceof ParamMarker) {
                ((ParamMarker)size).accept(this);
            } else {
                this.appendable.append(String.valueOf(size));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void visit(DMLInsertStatement node) {
        boolean isFst;
        QueryExpression select;
        this.appendable.append("INSERT ");
        switch (node.getMode()) {
            case DELAY: {
                this.appendable.append("DELAYED ");
                break;
            }
            case HIGH: {
                this.appendable.append("HIGH_PRIORITY ");
                break;
            }
            case LOW: {
                this.appendable.append("LOW_PRIORITY ");
                break;
            }
            case UNDEF: {
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown mode for INSERT: " + (Object)((Object)node.getMode()));
            }
        }
        if (node.isCommitOnSuccess()) {
            this.appendable.append("COMMIT_ON_SUCCESS ");
        }
        if (node.isRollbackOnFail()) {
            this.appendable.append("ROLLBACK_ON_FAIL ");
        }
        if (node.isQueueOnPk()) {
            this.appendable.append("QUEUE_ON_PK ");
            if (node.getQueueOnPkNumP() != null) {
                node.getQueueOnPkNumP().accept(this);
            } else {
                this.appendable.append(String.valueOf(node.getQueueOnPkNum()));
            }
            this.appendable.append(" ");
        }
        if (node.isTargetAffectRow()) {
            this.appendable.append("TARGET_AFFECT_ROW ");
            if (node.getNumP() != null) {
                node.getNumP().accept(this);
            } else {
                this.appendable.append(String.valueOf(node.getNum()));
            }
            this.appendable.append(" ");
        }
        if (node.isIgnore()) {
            this.appendable.append("IGNORE ");
        }
        this.appendable.append("INTO ");
        this.processTableName(node.getTable());
        this.appendable.append(' ');
        List<Identifier> cols = node.getColumnNameList();
        if (cols != null && !cols.isEmpty()) {
            this.appendable.append('(');
            this.printList(cols);
            this.appendable.append(") ");
        }
        if ((select = node.getSelect()) == null) {
            this.appendable.append("VALUES ");
            List<RowExpression> rows = node.getRowList();
            if (rows == null || rows.isEmpty()) throw new IllegalArgumentException("at least one row for INSERT");
            isFst = true;
            for (RowExpression rowExpression : rows) {
                if (rowExpression == null || rowExpression.getRowExprList().isEmpty()) continue;
                if (isFst) {
                    isFst = false;
                } else {
                    this.appendable.append(", ");
                }
                this.appendable.append('(');
                this.printList(rowExpression.getRowExprList());
                this.appendable.append(')');
            }
        } else {
            select.accept(this);
        }
        List<Pair<Identifier, Expression>> dup = node.getDuplicateUpdate();
        if (dup == null || dup.isEmpty()) return;
        this.appendable.append(" ON DUPLICATE KEY UPDATE ");
        isFst = true;
        for (Pair pair : dup) {
            if (isFst) {
                isFst = false;
            } else {
                this.appendable.append(", ");
            }
            ((Identifier)pair.getKey()).accept(this);
            this.appendable.append(" = ");
            ((Expression)pair.getValue()).accept(this);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void visit(DMLReplaceStatement node) {
        QueryExpression select;
        this.appendable.append("REPLACE ");
        switch (node.getMode()) {
            case DELAY: {
                this.appendable.append("DELAYED ");
                break;
            }
            case LOW: {
                this.appendable.append("LOW_PRIORITY ");
                break;
            }
            case UNDEF: {
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown mode for INSERT: " + (Object)((Object)node.getMode()));
            }
        }
        this.appendable.append("INTO ");
        this.processTableName(node.getTable());
        this.appendable.append(' ');
        List<Identifier> cols = node.getColumnNameList();
        if (cols != null && !cols.isEmpty()) {
            this.appendable.append('(');
            this.printList(cols);
            this.appendable.append(") ");
        }
        if ((select = node.getSelect()) == null) {
            this.appendable.append("VALUES ");
            List<RowExpression> rows = node.getRowList();
            if (rows == null || rows.isEmpty()) throw new IllegalArgumentException("at least one row for REPLACE");
            boolean isFst = true;
            for (RowExpression row : rows) {
                if (row == null || row.getRowExprList().isEmpty()) continue;
                if (isFst) {
                    isFst = false;
                } else {
                    this.appendable.append(", ");
                }
                this.appendable.append('(');
                this.printList(row.getRowExprList());
                this.appendable.append(')');
            }
            return;
        } else {
            select.accept(this);
        }
    }

    @Override
    public void visit(DMLSelectFromUpdateStatement node) {
        Limit limit;
        OrderBy orderBy;
        if (node.isExplain()) {
            this.appendable.append("EXPLAIN ");
        }
        this.appendable.append("SELECT ");
        DMLSelectFromUpdateStatement.SelectFromUpdateOption option = node.getSelectFromUpdateOption();
        boolean isFst = true;
        List<Pair<Expression, String>> exprList = node.getSelectExprList();
        for (Pair<Expression, String> pair : exprList) {
            String alias;
            if (isFst) {
                isFst = false;
            } else {
                this.appendable.append(", ");
            }
            if (pair.getKey() instanceof DMLSelectStatement) {
                this.appendable.append("(");
            }
            if (!this.upperCase) {
                this.appendable.append(pair.getKey().getOriginStr());
            } else {
                pair.getKey().accept(this);
            }
            if (pair.getKey() instanceof DMLSelectStatement) {
                this.appendable.append(")");
            }
            if ((alias = pair.getValue()) == null) continue;
            this.appendable.append(" AS ").append(MySQLOutputASTVisitor.convertKeywords(alias));
        }
        this.appendable.append(" FROM UPDATE ");
        if (option.lowPriority) {
            this.appendable.append("LOW_PRIORITY ");
        }
        if (option.ignore) {
            this.appendable.append("IGNORE ");
        }
        if (option.commitOnSuccess) {
            this.appendable.append("COMMIT_ON_SUCCESS ");
        }
        if (option.rollbackOnFail) {
            this.appendable.append("ROLLBACK_ON_FAIL ");
        }
        if (option.queueOnPk) {
            this.appendable.append("QUEUE_ON_PK ");
            if (option.queueOnPkNumP != null) {
                option.queueOnPkNumP.accept(this);
            } else {
                this.appendable.append(String.valueOf(option.queueOnPkNum));
            }
            this.appendable.append(" ");
        }
        if (option.targetAffectRow) {
            this.appendable.append("TARGET_AFFECT_ROW ");
            if (option.numP != null) {
                option.numP.accept(this);
            } else {
                this.appendable.append(String.valueOf(option.num));
            }
            this.appendable.append(" ");
        }
        this.processTableName(node.getTable());
        this.appendable.append(" SET ");
        isFst = true;
        for (Pair<Expression, Object> pair : node.getValues()) {
            boolean paren;
            if (isFst) {
                isFst = false;
            } else {
                this.appendable.append(", ");
            }
            ((Identifier)pair.getKey()).accept(this);
            this.appendable.append(" = ");
            Expression value = (Expression)pair.getValue();
            boolean bl = paren = value.getPrecedence() <= 7;
            if (paren) {
                this.appendable.append('(');
            }
            value.accept(this);
            if (!paren) continue;
            this.appendable.append(')');
        }
        Expression where = node.getWhere();
        if (where != null) {
            this.appendable.append(" WHERE ");
            where.accept(this);
        }
        if ((orderBy = node.getOrder()) != null) {
            this.appendable.append(' ');
            orderBy.accept(this);
        }
        if ((limit = node.getLimit()) != null) {
            this.appendable.append(" LIMIT ");
            Object size = limit.getSize();
            if (size instanceof ParamMarker) {
                ((ParamMarker)size).accept(this);
            } else {
                this.appendable.append(String.valueOf(size));
            }
        }
    }

    @Override
    public void visit(DMLSelectStatement node) {
        Limit limit;
        OrderBy order;
        Expression having;
        GroupBy group;
        Expression where;
        if (node.isExplain()) {
            this.appendable.append("EXPLAIN ");
        }
        this.appendable.append("SELECT ");
        DMLSelectStatement.SelectOption option = node.getOption();
        switch (option.resultDup) {
            case ALL: {
                break;
            }
            case DISTINCT: {
                this.appendable.append("DISTINCT ");
                break;
            }
            case DISTINCTROW: {
                this.appendable.append("DISTINCTROW ");
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown option for SELECT: " + option);
            }
        }
        if (option.highPriority) {
            this.appendable.append("HIGH_PRIORITY ");
        }
        if (option.straightJoin) {
            this.appendable.append("STRAIGHT_JOIN ");
        }
        switch (option.resultSize) {
            case SQL_BIG_RESULT: {
                this.appendable.append("SQL_BIG_RESULT ");
                break;
            }
            case SQL_SMALL_RESULT: {
                this.appendable.append("SQL_SMALL_RESULT ");
                break;
            }
            case UNDEF: {
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown option for SELECT: " + option);
            }
        }
        if (option.sqlBufferResult) {
            this.appendable.append("SQL_BUFFER_RESULT ");
        }
        switch (option.queryCache) {
            case SQL_CACHE: {
                this.appendable.append("SQL_CACHE ");
                break;
            }
            case SQL_NO_CACHE: {
                this.appendable.append("SQL_NO_CACHE ");
                break;
            }
            case UNDEF: {
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown option for SELECT: " + option);
            }
        }
        if (option.sqlCalcFoundRows) {
            this.appendable.append("SQL_CALC_FOUND_ROWS ");
        }
        boolean isFst = true;
        List<Pair<Expression, String>> exprList = node.getSelectExprList();
        for (Pair<Expression, String> p : exprList) {
            String alias;
            if (isFst) {
                isFst = false;
            } else {
                this.appendable.append(", ");
            }
            if (p.getKey() instanceof DMLSelectStatement) {
                this.appendable.append("(");
            }
            if (!this.upperCase) {
                if (p.getKey() instanceof DMLSelectStatement && p.getValue() != null) {
                    p.getKey().accept(this);
                } else {
                    this.appendable.append(p.getKey().getOriginStr());
                }
            } else {
                p.getKey().accept(this);
            }
            if (p.getKey() instanceof DMLSelectStatement) {
                this.appendable.append(")");
            }
            if ((alias = p.getValue()) == null) continue;
            this.appendable.append(" AS ").append(MySQLOutputASTVisitor.convertKeywords(alias));
        }
        TableReferences from = node.getTables();
        if (from != null) {
            this.appendable.append(" FROM ");
            from.accept(this);
        }
        if ((where = node.getWhere()) != null) {
            this.appendable.append(" WHERE ");
            where.accept(this);
        }
        if ((group = node.getGroup()) != null) {
            this.appendable.append(' ');
            group.accept(this);
        }
        if ((having = node.getHaving()) != null) {
            this.appendable.append(" HAVING ");
            having.accept(this);
        }
        if ((order = node.getOrder()) != null) {
            this.appendable.append(' ');
            order.accept(this);
        }
        if ((limit = node.getLimit()) != null) {
            this.appendable.append(' ');
            limit.accept(this);
        }
        switch (option.lockMode) {
            case FOR_UPDATE: {
                this.appendable.append(" FOR UPDATE");
                break;
            }
            case LOCK_IN_SHARE_MODE: {
                this.appendable.append(" LOCK IN SHARE MODE");
                break;
            }
            case UNDEF: {
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown option for SELECT: " + option);
            }
        }
    }

    @Override
    public void visit(DMLSelectUnionStatement node) {
        Limit limit;
        List<DMLSelectStatement> list;
        if (node.isExplain()) {
            this.appendable.append("EXPLAIN ");
        }
        if ((list = node.getSelectStmtList()) == null || list.isEmpty()) {
            throw new IllegalArgumentException("SELECT UNION must have at least one SELECT");
        }
        int fstDist = node.getFirstDistinctIndex();
        int i = 0;
        for (DMLSelectStatement select : list) {
            if (i > 0) {
                this.appendable.append(" UNION ");
                if (i > fstDist) {
                    this.appendable.append("ALL ");
                }
            }
            this.appendable.append('(');
            select.accept(this);
            this.appendable.append(')');
            ++i;
        }
        OrderBy order = node.getOrderBy();
        if (order != null) {
            this.appendable.append(' ');
            order.accept(this);
        }
        if ((limit = node.getLimit()) != null) {
            this.appendable.append(' ');
            limit.accept(this);
        }
    }

    @Override
    public void visit(DMLUpdateStatement node) {
        Limit limit;
        OrderBy order;
        this.appendable.append("UPDATE ");
        if (node.isLowPriority()) {
            this.appendable.append("LOW_PRIORITY ");
        }
        if (node.isCommitOnSuccess()) {
            this.appendable.append("COMMIT_ON_SUCCESS ");
        }
        if (node.isRollbackOnFail()) {
            this.appendable.append("ROLLBACK_ON_FAIL ");
        }
        if (node.isQueueOnPk()) {
            this.appendable.append("QUEUE_ON_PK ");
            if (node.getQueueOnPkNumP() != null) {
                node.getQueueOnPkNumP().accept(this);
            } else {
                this.appendable.append(String.valueOf(node.getQueueOnPkNum()));
            }
            this.appendable.append(" ");
        }
        if (node.isTargetAffectRow()) {
            this.appendable.append("TARGET_AFFECT_ROW ");
            if (node.getNumP() != null) {
                node.getNumP().accept(this);
            } else {
                this.appendable.append(String.valueOf(node.getNum()));
            }
            this.appendable.append(" ");
        }
        if (node.isIgnore()) {
            this.appendable.append("IGNORE ");
        }
        node.getTableRefs().accept(this);
        this.appendable.append(" SET ");
        boolean isFst = true;
        for (Pair<Identifier, Expression> p : node.getValues()) {
            boolean paren;
            if (isFst) {
                isFst = false;
            } else {
                this.appendable.append(", ");
            }
            p.getKey().accept(this);
            this.appendable.append(" = ");
            Expression value = p.getValue();
            boolean bl = paren = value.getPrecedence() <= 7;
            if (paren) {
                this.appendable.append('(');
            }
            value.accept(this);
            if (!paren) continue;
            this.appendable.append(')');
        }
        Expression where = node.getWhere();
        if (where != null) {
            this.appendable.append(" WHERE ");
            where.accept(this);
        }
        if ((order = node.getOrderBy()) != null) {
            this.appendable.append(' ');
            order.accept(this);
        }
        if ((limit = node.getLimit()) != null) {
            this.appendable.append(" LIMIT ");
            Object size = limit.getSize();
            if (size instanceof ParamMarker) {
                ((ParamMarker)size).accept(this);
            } else {
                this.appendable.append(String.valueOf(size));
            }
        }
    }

    @Override
    public void visit(DDLTruncateStatement node) {
        this.appendable.append("TRUNCATE TABLE ");
        this.processTableName(node.getTable());
    }

    @Override
    public void visit(AddColumn addColumn) {
        this.appendable.append("ADD COLUMN ");
        addColumn.getColumnName().accept(this);
        this.appendable.append(" ");
        addColumn.getColumnDefine().accept(this);
        if (addColumn.isFirst()) {
            this.appendable.append(" FIRST");
        } else if (addColumn.getAfterColumn() != null) {
            this.appendable.append(" AFTER ");
            addColumn.getAfterColumn().accept(this);
        }
    }

    @Override
    public void visit(AddColumns addColumns) {
        this.appendable.append("ADD COLUMN ");
        boolean isFst = true;
        for (Pair<Identifier, ColumnDefinition> columnDefinitionPair : addColumns.getColumns()) {
            if (isFst) {
                isFst = false;
            } else {
                this.appendable.append(", ");
            }
            columnDefinitionPair.getKey().accept(this);
            this.appendable.append(" ");
            columnDefinitionPair.getValue().accept(this);
        }
    }

    @Override
    public void visit(AddIndex addIndex) {
        this.appendable.append("ADD INDEX ");
        if (addIndex.getIndexName() != null) {
            addIndex.getIndexName().accept(this);
        }
        this.appendable.append(" ");
        addIndex.getIndexDef().accept(this);
    }

    @Override
    public void visit(IndexDefinition indexDefinition) {
        if (indexDefinition.getIndexType() != null) {
            this.visit(indexDefinition.getIndexType());
        }
        this.appendable.append(" (");
        boolean isFst = true;
        for (IndexColumnName indexColumnName : indexDefinition.getColumns()) {
            if (isFst) {
                isFst = false;
            } else {
                this.appendable.append(", ");
            }
            indexColumnName.accept(this);
        }
        this.appendable.append(") ");
        isFst = true;
        for (IndexOption indexOption : indexDefinition.getOptions()) {
            if (isFst) {
                isFst = false;
            } else {
                this.appendable.append(" ");
            }
            indexOption.accept(this);
        }
    }

    @Override
    public void visit(IndexColumnName node) {
        node.getColumnName().accept(this);
        if (node.getLength() != null) {
            this.appendable.append("(");
            this.visit((LiteralNumber)node.getLength());
            this.appendable.append(") ");
        }
        if (node.isAsc() != null) {
            if (node.isAsc().booleanValue()) {
                this.appendable.append(" ASC ");
            } else {
                this.appendable.append(" DESC ");
            }
        }
    }

    @Override
    public void visit(AddFullTextIndex addFullTextIndex) {
        this.appendable.append("ADD FULLTEXT ");
        if (addFullTextIndex.isHasIndexType()) {
            this.appendable.append("INDEX ");
        }
        if (addFullTextIndex.getIndexName() != null) {
            addFullTextIndex.getIndexName().accept(this);
        }
        this.appendable.append(" ");
        addFullTextIndex.getIndexDef().accept(this);
    }

    @Override
    public void visit(AddPrimaryKey addPrimaryKey) {
        this.appendable.append("ADD ");
        if (addPrimaryKey.getConstraint() != null) {
            this.appendable.append("CONSTRAINT ");
            if (!addPrimaryKey.getConstraint().getIdTextUnescape().equals("")) {
                addPrimaryKey.getConstraint().accept(this);
            }
            this.appendable.append(" ");
        }
        this.appendable.append("PRIMARY KEY ");
        addPrimaryKey.getIndexDef().accept(this);
    }

    @Override
    public void visit(AddForeignKey addForeignKey) {
        this.appendable.append("ADD ");
        if (addForeignKey.getConstraint() != null) {
            this.appendable.append("CONSTRAINT ");
            if (!addForeignKey.getConstraint().getIdTextUnescape().equals("")) {
                addForeignKey.getConstraint().accept(this);
            }
            this.appendable.append(" ");
        }
        this.appendable.append("FOREIGN KEY ");
        if (addForeignKey.getIndexName() != null) {
            addForeignKey.getIndexName().accept(this);
            this.appendable.append(" ");
        }
        addForeignKey.getIndexDef().accept(this);
        addForeignKey.getReferenceDefinition().accept(this);
    }

    @Override
    public void visit(AddSpatialIndex addSpatialIndex) {
        this.appendable.append("ADD SPATIAL ");
        if (addSpatialIndex.isHasIndexType()) {
            this.appendable.append("INDEX ");
        }
        if (addSpatialIndex.getIndexName() != null) {
            addSpatialIndex.getIndexName().accept(this);
        }
        this.appendable.append(" ");
        addSpatialIndex.getIndexDef().accept(this);
    }

    @Override
    public void visit(AddUniqueKey addUniqueKey) {
        this.appendable.append("ADD ");
        if (addUniqueKey.getConstraint() != null) {
            this.appendable.append("CONSTRAINT ");
            if (!addUniqueKey.getConstraint().getIdTextUnescape().equals("")) {
                addUniqueKey.getConstraint().accept(this);
            }
            this.appendable.append(" ");
        }
        this.appendable.append("UNIQUE ");
        if (addUniqueKey.isHasIndexType()) {
            this.appendable.append("INDEX ");
        }
        if (addUniqueKey.getIndexName() != null) {
            addUniqueKey.getIndexName().accept(this);
        }
        this.appendable.append(" ");
        addUniqueKey.getIndexDef().accept(this);
    }

    @Override
    public void visit(AlterColumnDefaultVal alterColumnDefaultVal) {
        this.appendable.append(" ALTER COLUMN ");
        alterColumnDefaultVal.getColumnName().accept(this);
        this.appendable.append(" ");
        if (alterColumnDefaultVal.isDropDefault()) {
            this.appendable.append("DROP DEFAULT");
        } else {
            this.appendable.append("SET DEFAULT ");
            alterColumnDefaultVal.getDefaultValue().accept(this);
        }
    }

    @Override
    public void visit(ChangeColumn changeColumn) {
        this.appendable.append(" CHANGE COLUMN ");
        changeColumn.getOldName().accept(this);
        this.appendable.append(" ");
        changeColumn.getNewName().accept(this);
        this.appendable.append(" ");
        changeColumn.getColDef().accept(this);
        if (changeColumn.isFirst() && changeColumn.getNewName() != null) {
            this.appendable.append(" FIRST ");
        } else if (changeColumn.getAfterColumn() != null) {
            this.appendable.append(" AFTER ");
            changeColumn.getAfterColumn().accept(this);
        }
    }

    @Override
    public void visit(ModifyColumn modifyColumn) {
        this.appendable.append("MODIFY COLUMN ");
        modifyColumn.getColName().accept(this);
        this.appendable.append(" ");
        modifyColumn.getColDef().accept(this);
        if (modifyColumn.isFirst()) {
            this.appendable.append(" FIRST");
        } else if (modifyColumn.getAfterColumn() != null) {
            this.appendable.append(" AFTER ");
            modifyColumn.getAfterColumn().accept(this);
        }
    }

    @Override
    public void visit(DropColumn dropColumn) {
        this.appendable.append(" DROP COLUMN ");
        dropColumn.getColName().accept(this);
    }

    @Override
    public void visit(DropIndex dropIndex) {
        this.appendable.append(" DROP INDEX ");
        dropIndex.getIndexName().accept(this);
    }

    @Override
    public void visit(DropPrimaryKey dropPrimaryKey) {
        this.appendable.append("DROP PRIMARY KEY");
    }

    @Override
    public void visit(DropForeignKey foreignKey) {
        this.appendable.append("DROP FOREIGN KEY ");
        foreignKey.getFk_symbol().accept(this);
    }

    @Override
    public void visit(AlterSpecification node) {
        node.accept(this);
    }

    @Override
    public void visit(DDLAlterTableStatement node) {
        this.appendable.append("ALTER ");
        if (node.isIgnore()) {
            this.appendable.append("IGNORE ");
        }
        this.appendable.append("TABLE ");
        this.processTableName(node.getTable());
        this.appendable.append(" ");
        CommerSpliter spSpliter = new CommerSpliter(this.appendable);
        for (AlterSpecification alterSpecification : node.getAlters()) {
            spSpliter.split();
            alterSpecification.accept(this);
        }
        if (node.getTableOptions() != null) {
            StringBuilder stringBuilder = new StringBuilder();
            MySQLOutputASTVisitor tableOptionVisitor = new MySQLOutputASTVisitor(stringBuilder);
            node.getTableOptions().accept(tableOptionVisitor);
            if (!stringBuilder.toString().isEmpty()) {
                spSpliter.split();
                this.appendable.append(stringBuilder.toString());
            }
        }
    }

    @Override
    public void visit(DDLCreateIndexStatement node) {
        this.appendable.append("CREATE ");
        if (node.getConstraintType() != null) {
            this.appendable.append(node.getConstraintType().name());
        }
        this.appendable.append(" INDEX ");
        node.getIndexName().accept(this);
        this.appendable.append(" ");
        if (node.getIndexType() != null) {
            this.visit(node.getIndexType());
        }
        this.appendable.append(" ON ");
        this.processTableName(node.getTable());
        this.appendable.append(" ( ");
        boolean isFst = true;
        for (IndexColumnName indexColumnName : node.getColumns()) {
            if (isFst) {
                isFst = false;
            } else {
                this.appendable.append(", ");
            }
            indexColumnName.accept(this);
        }
        this.appendable.append(") ");
        if (node.getOptions() != null) {
            for (IndexOption indexOption : node.getOptions()) {
                this.appendable.append(" ");
                indexOption.accept(this);
            }
        }
        if (node.getAlgorithm() != null) {
            this.appendable.append(" ");
            node.getAlgorithm().accept(this);
        }
        if (node.getLock() != null) {
            this.appendable.append(" ");
            node.getLock().accept(this);
        }
    }

    @Override
    public void visit(ColumnDefinition columnDefinition) {
        DataType.DataTypeName dataTypeName = columnDefinition.getDataType().getTypeName();
        this.appendable.append(dataTypeName.name());
        if (DataType.DataTypeName.ENUM.equals((Object)dataTypeName) || DataType.DataTypeName.SET.equals((Object)dataTypeName)) {
            if (columnDefinition.getDataType().getCollectionVals().size() > 0) {
                this.appendable.append("(");
                int collectionCount = columnDefinition.getDataType().getCollectionVals().size();
                for (int i = 0; i < collectionCount; ++i) {
                    if (i > 0) {
                        this.appendable.append(",");
                    }
                    Expression collExpression = columnDefinition.getDataType().getCollectionVals().get(i);
                    collExpression.accept(this);
                }
                this.appendable.append(")");
                if (columnDefinition.getDataType().getCharSet() != null) {
                    this.appendable.append(" CHARACTER SET ");
                    columnDefinition.getDataType().getCharSet().accept(this);
                    this.appendable.append(' ');
                }
                if (columnDefinition.getDataType().getCollation() != null) {
                    this.appendable.append(" COLLATE ");
                    columnDefinition.getDataType().getCollation().accept(this);
                    this.appendable.append(' ');
                }
            }
        } else {
            if (columnDefinition.getDataType().getLength() != null) {
                LiteralNumber decimals;
                this.appendable.append("(");
                LiteralNumber number = (LiteralNumber)columnDefinition.getDataType().getLength();
                if (number != null) {
                    this.appendable.append(number.getNumber());
                }
                if ((decimals = (LiteralNumber)columnDefinition.getDataType().getDecimals()) != null) {
                    this.appendable.append(',');
                    this.appendable.append(decimals.getNumber());
                }
                this.appendable.append(")");
            }
            if (columnDefinition.getDataType().isBinary()) {
                this.appendable.append(" BINARY ");
            }
            if (columnDefinition.getDataType().isUnsigned()) {
                this.appendable.append(" UNSIGNED ");
            }
            if (columnDefinition.getDataType().isZerofill()) {
                this.appendable.append(" ZEROFILL ");
            }
            if (columnDefinition.getDataType().getCharSet() != null) {
                this.appendable.append(" CHARACTER SET ");
                columnDefinition.getDataType().getCharSet().accept(this);
                this.appendable.append(' ');
            }
            if (columnDefinition.getDataType().getCollation() != null) {
                this.appendable.append(" COLLATE ");
                columnDefinition.getDataType().getCollation().accept(this);
                this.appendable.append(' ');
            }
            if (columnDefinition.getDataType().getFsp() != null) {
                this.appendable.append("(");
                columnDefinition.getDataType().getFsp().accept(this);
                this.appendable.append(")");
            }
        }
        this.appendable.append(" ");
        if (columnDefinition.getNotNull() != null) {
            if (columnDefinition.getNotNull() == ColumnDefinition.ColumnNull.NULL) {
                this.appendable.append("NULL ");
            } else {
                this.appendable.append("NOT NULL ");
            }
        }
        if (columnDefinition.getDefaultVal() != null) {
            this.appendable.append("DEFAULT ");
            columnDefinition.getDefaultVal().accept(this);
            this.appendable.append(" ");
        }
        if (columnDefinition.isOnUpdateCurrentTimestamp()) {
            this.appendable.append("ON UPDATE CURRENT_TIMESTAMP ");
        }
        if (columnDefinition.isAutoIncrement()) {
            this.appendable.append("AUTO_INCREMENT ");
        }
        if (columnDefinition.getSpecialIndex() != null) {
            if (columnDefinition.getSpecialIndex() == ColumnDefinition.SpecialIndex.PRIMARY) {
                this.appendable.append("PRIMARY KEY ");
            } else if (columnDefinition.getSpecialIndex() == ColumnDefinition.SpecialIndex.UNIQUE) {
                this.appendable.append("UNIQUE ");
            }
        }
        if (columnDefinition.getComment() != null) {
            this.appendable.append(" COMMENT ");
            columnDefinition.getComment().accept(this);
            this.appendable.append(' ');
        }
        if (columnDefinition.getColumnFormat() != null) {
            this.appendable.append("COLUMN_FORMAT ");
            if (columnDefinition.getColumnFormat() == ColumnDefinition.ColumnFormat.FIXED) {
                this.appendable.append("FIXED ");
            } else if (columnDefinition.getColumnFormat() == ColumnDefinition.ColumnFormat.DYNAMIC) {
                this.appendable.append("DYNAMIC ");
            } else if (columnDefinition.getColumnFormat() == ColumnDefinition.ColumnFormat.DEFAULT) {
                this.appendable.append("DEFAULT ");
            }
        }
        if (columnDefinition.getStorage() != null) {
            this.appendable.append("STORAGE ");
            if (columnDefinition.getStorage() == ColumnDefinition.Storage.DISK) {
                this.appendable.append("DISK ");
            } else if (columnDefinition.getStorage() == ColumnDefinition.Storage.MEMORY) {
                this.appendable.append("MEMORY ");
            } else if (columnDefinition.getStorage() == ColumnDefinition.Storage.DEFAULT) {
                this.appendable.append("DEFAULT ");
            }
        }
        if (columnDefinition.getReferenceDefinition() != null) {
            columnDefinition.getReferenceDefinition().accept(this);
        }
    }

    @Override
    public void visit(DBPartitionBy DBPartitionBy2) {
        this.appendable.append(" DBPARTITION BY ");
        if (DBPartitionBy2.getType() == PartitionByType.HASH) {
            this.appendable.append("HASH(");
            if (DBPartitionBy2.getColExpr() != null) {
                DBPartitionBy2.getColExpr().accept(this);
            }
            this.appendable.append(")");
        }
    }

    @Override
    public void visit(TBPartitionBy TBPartitionBy2) {
        this.appendable.append(" TBPARTITION BY ");
        if (TBPartitionBy2.getType() == PartitionByType.HASH) {
            this.appendable.append("HASH(");
            if (TBPartitionBy2.getColExpr() != null) {
                TBPartitionBy2.getColExpr().accept(this);
            }
            this.appendable.append(")");
        }
    }

    @Override
    public void visit(SubpartitionDefinition subpartitionDefinition) {
        this.appendable.append(" SUBPARTITION ");
        if (subpartitionDefinition.getLogicalName() != null) {
            subpartitionDefinition.getLogicalName().accept(this);
            this.appendable.append(' ');
        }
        if (subpartitionDefinition.getEngineName() != null) {
            if (subpartitionDefinition.isStorage()) {
                this.appendable.append("STORAGE ");
            }
            subpartitionDefinition.getEngineName().accept(this);
        }
        if (subpartitionDefinition.getCommentText() != null) {
            this.appendable.append("COMMENT = ");
            subpartitionDefinition.getCommentText().accept(this);
            this.appendable.append(" ");
        }
        if (subpartitionDefinition.getDataDir() != null) {
            this.appendable.append("DATA DIRECTORY = ");
            subpartitionDefinition.getDataDir().accept(this);
            this.appendable.append(" ");
        }
        if (subpartitionDefinition.getIndexDir() != null) {
            this.appendable.append("INDEX DIRECTORY = ");
            subpartitionDefinition.getIndexDir().accept(this);
            this.appendable.append(" ");
        }
        if (subpartitionDefinition.getMaxNumberOfRows() != null) {
            this.appendable.append("MAX_ROWS = ");
            subpartitionDefinition.getMaxNumberOfRows().accept(this);
            this.appendable.append(" ");
        }
        if (subpartitionDefinition.getMinNumberOfRows() != null) {
            this.appendable.append("MIN_ROWS = ");
            subpartitionDefinition.getMinNumberOfRows().accept(this);
            this.appendable.append(" ");
        }
        if (subpartitionDefinition.getTablespaceName() != null) {
            this.appendable.append("TABLESPACE = ");
            subpartitionDefinition.getTablespaceName().accept(this);
            this.appendable.append(" ");
        }
        if (subpartitionDefinition.getNodeGroupId() != null) {
            this.appendable.append("NODEGROUP = ");
            subpartitionDefinition.getNodeGroupId().accept(this);
        }
    }

    @Override
    public void visit(PartitionDefinition partitionDefinition) {
        this.appendable.append(" PARTITION ");
        if (partitionDefinition.getPartitionName() != null) {
            partitionDefinition.getPartitionName().accept(this);
            this.appendable.append(' ');
        }
        if (partitionDefinition.isHasValues()) {
            this.appendable.append(" VALUES ");
            switch (partitionDefinition.getPartitionDefinitionValuesType()) {
                case LESSTHAN_EXPR: {
                    this.appendable.append("LESS THAN (");
                    if (partitionDefinition.getValuesLessThanExpr() != null) {
                        if (partitionDefinition.getValuesLessThanExpr() instanceof Identifier && ((Identifier)partitionDefinition.getValuesLessThanExpr()).getIdTextUpUnescape().equals("MAXVALUE")) {
                            this.appendable.append("MAXVALUE");
                        } else {
                            partitionDefinition.getValuesLessThanExpr().accept(this);
                        }
                    }
                    this.appendable.append(") ");
                    break;
                }
                case LESSTHAN_VALUELIST: {
                    CommerSpliter valueListSpliter;
                    this.appendable.append("LESS THAN (");
                    if (partitionDefinition.getValueLessThanValueList() != null) {
                        valueListSpliter = new CommerSpliter(this.appendable);
                        for (Expression value : partitionDefinition.getValueLessThanValueList()) {
                            valueListSpliter.split();
                            if (value instanceof Identifier && ((Identifier)value).getIdTextUpUnescape().equals("MAXVALUE")) {
                                this.appendable.append("MAXVALUE");
                                continue;
                            }
                            value.accept(this);
                        }
                    }
                    this.appendable.append(") ");
                    break;
                }
                case LESSTHAN_MAXVALUE: {
                    this.appendable.append("LESS THAN (MAXVALUE) ");
                    break;
                }
                case IN: {
                    CommerSpliter valueListSpliter;
                    this.appendable.append("IN (");
                    if (partitionDefinition.getValuesInValueList() != null) {
                        valueListSpliter = new CommerSpliter(this.appendable);
                        for (Expression value : partitionDefinition.getValuesInValueList()) {
                            valueListSpliter.split();
                            value.accept(this);
                        }
                    }
                    this.appendable.append(")");
                }
            }
        }
        if (partitionDefinition.getEngineName() != null) {
            if (partitionDefinition.isHasStorage()) {
                this.appendable.append("STORAGE ");
            }
            partitionDefinition.getEngineName().accept(this);
        }
        if (partitionDefinition.getCommentText() != null) {
            this.appendable.append("COMMENT = ");
            partitionDefinition.getCommentText().accept(this);
            this.appendable.append(" ");
        }
        if (partitionDefinition.getDataDir() != null) {
            this.appendable.append("DATA DIRECTORY = ");
            partitionDefinition.getDataDir().accept(this);
            this.appendable.append(" ");
        }
        if (partitionDefinition.getIndexDir() != null) {
            this.appendable.append("INDEX DIRECTORY = ");
            partitionDefinition.getIndexDir().accept(this);
            this.appendable.append(" ");
        }
        if (partitionDefinition.getMaxNumberOfRows() != null) {
            this.appendable.append("MAX_ROWS = ");
            partitionDefinition.getMaxNumberOfRows().accept(this);
            this.appendable.append(" ");
        }
        if (partitionDefinition.getMinNumberOfRows() != null) {
            this.appendable.append("MIN_ROWS = ");
            partitionDefinition.getMinNumberOfRows().accept(this);
            this.appendable.append(" ");
        }
        if (partitionDefinition.getTablespaceName() != null) {
            this.appendable.append("TABLESPACE = ");
            partitionDefinition.getTablespaceName().accept(this);
            this.appendable.append(" ");
        }
        if (partitionDefinition.getNodeGroupId() != null) {
            this.appendable.append("NODEGROUP = ");
            partitionDefinition.getNodeGroupId().accept(this);
            this.appendable.append(" ");
        }
        if (partitionDefinition.getSubpartitionDefinitionList() != null) {
            CommerSpliter subpartitionSpliter = new CommerSpliter(this.appendable);
            this.appendable.append(" (");
            for (SubpartitionDefinition subpartitionDefinition : partitionDefinition.getSubpartitionDefinitionList()) {
                subpartitionSpliter.split();
                subpartitionDefinition.accept(this);
            }
            this.appendable.append(") ");
        }
    }

    @Override
    public void visit(PartitionOptions partitionOptions) {
        if (partitionOptions.getPartitionBy() != null) {
            partitionOptions.getPartitionBy().accept(this);
            this.appendable.append(' ');
        }
        if (partitionOptions.getNum() != null) {
            this.appendable.append("PARTITIONS ");
            partitionOptions.getNum().accept(this);
            this.appendable.append(' ');
        }
        if (partitionOptions.getSubPartitionBy() != null) {
            partitionOptions.getSubPartitionBy().accept(this);
            this.appendable.append(' ');
        }
        if (partitionOptions.getPartitionDefinitionList() != null) {
            CommerSpliter partitionDefinitionSpliter = new CommerSpliter(this.appendable);
            this.appendable.append(" (");
            for (PartitionDefinition partitionDefinition : partitionOptions.getPartitionDefinitionList()) {
                partitionDefinitionSpliter.split();
                partitionDefinition.accept(this);
            }
            this.appendable.append(") ");
        }
    }

    @Override
    public void visit(SubPartitionBy subPartitionBy) {
        this.appendable.append(" SUBPARTITION BY ");
        if (subPartitionBy.isLiner()) {
            this.appendable.append("LINEAR ");
        }
        if (subPartitionBy.getSubPartitionByType() != null) {
            switch (subPartitionBy.getSubPartitionByType()) {
                case HASH: {
                    this.appendable.append("HASH (");
                    if (subPartitionBy.getHashExpr() != null) {
                        subPartitionBy.getHashExpr().accept(this);
                    }
                    this.appendable.append(") ");
                    break;
                }
                case KEY: {
                    this.appendable.append("KEY ");
                    if (subPartitionBy.getAlgorithm() != null) {
                        this.appendable.append(" ALGORITHM=");
                        subPartitionBy.getAlgorithm().accept(this);
                    }
                    this.appendable.append(" (");
                    if (subPartitionBy.getColumnList() != null) {
                        CommerSpliter columnSpliter = new CommerSpliter(this.appendable);
                        for (Identifier column : subPartitionBy.getColumnList()) {
                            columnSpliter.split();
                            column.accept(this);
                        }
                    }
                    this.appendable.append(") ");
                }
            }
        }
        if (subPartitionBy.getNum() != null) {
            this.appendable.append("SUBPARTITIONS ");
            subPartitionBy.getNum().accept(this);
        }
    }

    @Override
    public void visit(PartitionBy partitionBy) {
        this.appendable.append(" PARTITION BY ");
        if (partitionBy.getPartitionByType() != null) {
            switch (partitionBy.getPartitionByType()) {
                case HASH: {
                    if (partitionBy.isLiner()) {
                        this.appendable.append("LINEAR ");
                    }
                    this.appendable.append("HASH (");
                    if (partitionBy.getHashExpr() != null) {
                        partitionBy.getHashExpr().accept(this);
                    }
                    this.appendable.append(") ");
                    break;
                }
                case KEY: {
                    if (partitionBy.isLiner()) {
                        this.appendable.append("LINEAR ");
                    }
                    this.appendable.append("KEY ");
                    if (partitionBy.getAlgorithm() != null) {
                        this.appendable.append("ALGORITHM= ");
                        partitionBy.getAlgorithm().accept(this);
                        this.appendable.append(' ');
                    }
                    if (partitionBy.getKeyColumnList() == null) break;
                    this.appendable.append(" (");
                    CommerSpliter columnSpliter = new CommerSpliter(this.appendable);
                    for (Identifier column : partitionBy.getKeyColumnList()) {
                        columnSpliter.split();
                        column.accept(this);
                    }
                    this.appendable.append(") ");
                    break;
                }
                case RANGE: {
                    this.appendable.append("RANGE ");
                    if (partitionBy.getRangeExpr() != null) {
                        this.appendable.append(" (");
                        partitionBy.getRangeExpr().accept(this);
                        this.appendable.append(") ");
                        break;
                    }
                    if (partitionBy.getRangeColumnList() == null) break;
                    this.appendable.append(" COLUMNS(");
                    CommerSpliter columnSpliter = new CommerSpliter(this.appendable);
                    for (Identifier column : partitionBy.getRangeColumnList()) {
                        columnSpliter.split();
                        column.accept(this);
                    }
                    this.appendable.append(") ");
                    break;
                }
                case LIST: {
                    this.appendable.append("LIST ");
                    if (partitionBy.getListExpr() != null) {
                        this.appendable.append(" (");
                        partitionBy.getListExpr().accept(this);
                        this.appendable.append(") ");
                        break;
                    }
                    if (partitionBy.getListColumnList() == null) break;
                    this.appendable.append(" COLUMNS(");
                    CommerSpliter columnSpliter = new CommerSpliter(this.appendable);
                    for (Identifier column : partitionBy.getListColumnList()) {
                        columnSpliter.split();
                        column.accept(this);
                    }
                    this.appendable.append(") ");
                }
            }
        }
    }

    @Override
    public void visit(DBPartitionOptions DBPartitionOptions2) {
        if (DBPartitionOptions2.getDbpartitionBy() != null) {
            DBPartitionOptions2.getDbpartitionBy().accept(this);
        }
        if (DBPartitionOptions2.getDbpartitions() > 0) {
            this.appendable.append(" DBPARTITIONS ");
            this.appendable.append(DBPartitionOptions2.getDbpartitions()).append(" ");
        }
        if (DBPartitionOptions2.getTbpartitionBy() != null) {
            DBPartitionOptions2.getTbpartitionBy().accept(this);
        }
        if (DBPartitionOptions2.getTbpartitions() > 0) {
            this.appendable.append(" TBPARTITIONS ");
            this.appendable.append(DBPartitionOptions2.getTbpartitions()).append(" ");
        }
    }

    @Override
    public void visit(DDLCreateTableStatement node) {
        this.appendable.append("CREATE ");
        if (node.isTemporary()) {
            this.appendable.append("TEMPORARY ");
        }
        this.appendable.append("TABLE ");
        if (node.isIfNotExists()) {
            this.appendable.append("IF NOT EXISTS ");
        }
        this.processTableName(node.getTable());
        List<Pair<Identifier, ColumnDefinition>> colDefs = node.getColDefs();
        if (colDefs.size() > 0) {
            this.appendable.append('(');
        }
        CommerSpliter cdSpliter = new CommerSpliter(this.appendable);
        for (Pair<Identifier, ColumnDefinition> pair : colDefs) {
            cdSpliter.split();
            pair.getKey().accept(this);
            this.appendable.append(' ');
            pair.getValue().accept(this);
        }
        if (node.getPrimaryKey() != null) {
            cdSpliter.split();
            if (node.isHasPrimaryKeyConstraint()) {
                this.appendable.append("CONSTRAINT ");
            }
            if (node.getPrimaryKeyConstraint() != null) {
                if (!node.getPrimaryKeyConstraint().getIdTextUnescape().equals("")) {
                    node.getPrimaryKeyConstraint().accept(this);
                }
                this.appendable.append(' ');
            }
            this.appendable.append("PRIMARY KEY ");
            if (node.getPrimaryKey().getIndexType() != null) {
                this.visit(node.getPrimaryKey().getIndexType());
            }
            this.appendable.append("(");
            CommerSpliter pkSpliter = new CommerSpliter(this.appendable);
            if (node.getPrimaryKey().getColumns() != null && node.getPrimaryKey().getColumns().size() > 0) {
                for (IndexColumnName columnName : node.getPrimaryKey().getColumns()) {
                    pkSpliter.split();
                    columnName.accept(this);
                }
            }
            this.appendable.append(")");
            if (node.getPrimaryKey().getOptions() != null && node.getPrimaryKey().getOptions().size() > 0) {
                for (IndexOption indexOption : node.getPrimaryKey().getOptions()) {
                    this.appendable.append(" ");
                    indexOption.accept(this);
                }
            }
        }
        if (node.getKeys() != null) {
            for (Pair<Identifier, ASTNode> pair : node.getKeys()) {
                cdSpliter.split();
                this.appendable.append("INDEX ");
                if (pair.getKey() != null) {
                    pair.getKey().accept(this);
                    this.appendable.append(' ');
                }
                if (((IndexDefinition)pair.getValue()).getIndexType() != null) {
                    this.visit(((IndexDefinition)pair.getValue()).getIndexType());
                }
                this.appendable.append("(");
                CommerSpliter idxSpliter = new CommerSpliter(this.appendable);
                if (pair.getValue() != null && ((IndexDefinition)pair.getValue()).getColumns() != null) {
                    for (IndexColumnName columnName : ((IndexDefinition)pair.getValue()).getColumns()) {
                        idxSpliter.split();
                        columnName.accept(this);
                    }
                }
                this.appendable.append(")");
                if (pair.getValue() == null || ((IndexDefinition)pair.getValue()).getOptions() == null) continue;
                for (IndexOption indexOption : ((IndexDefinition)pair.getValue()).getOptions()) {
                    this.appendable.append(" ");
                    indexOption.accept(this);
                }
            }
        }
        if (node.getUniqueKeys() != null) {
            for (Pair<Identifier, ASTNode> pair : node.getUniqueKeys()) {
                cdSpliter.split();
                if (((IndexDefinition)pair.getValue()).isHasConstraint()) {
                    this.appendable.append("CONSTRAINT ");
                }
                if (((IndexDefinition)pair.getValue()).getUniqueConstraint() != null) {
                    if (!((IndexDefinition)pair.getValue()).getUniqueConstraint().getIdTextUnescape().equals("")) {
                        ((IndexDefinition)pair.getValue()).getUniqueConstraint().accept(this);
                    }
                    this.appendable.append(' ');
                }
                this.appendable.append("UNIQUE INDEX ");
                if (pair.getKey() != null) {
                    pair.getKey().accept(this);
                    this.appendable.append(' ');
                }
                if (((IndexDefinition)pair.getValue()).getIndexType() != null) {
                    this.visit(((IndexDefinition)pair.getValue()).getIndexType());
                }
                this.appendable.append("(");
                CommerSpliter ukSpliter = new CommerSpliter(this.appendable);
                if (pair.getValue() != null && ((IndexDefinition)pair.getValue()).getColumns() != null) {
                    for (IndexColumnName columnName : ((IndexDefinition)pair.getValue()).getColumns()) {
                        ukSpliter.split();
                        columnName.accept(this);
                    }
                }
                this.appendable.append(")");
                if (pair.getValue() == null || ((IndexDefinition)pair.getValue()).getOptions() == null) continue;
                for (IndexOption indexOption : ((IndexDefinition)pair.getValue()).getOptions()) {
                    this.appendable.append(" ");
                    indexOption.accept(this);
                }
            }
        }
        if (node.getFullTextKeys() != null) {
            for (Pair<Identifier, ASTNode> pair : node.getFullTextKeys()) {
                cdSpliter.split();
                this.appendable.append("FULLTEXT INDEX ");
                if (pair.getKey() != null) {
                    this.visit(pair.getKey());
                    this.appendable.append(' ');
                }
                this.appendable.append("(");
                CommerSpliter ftSpliter = new CommerSpliter(this.appendable);
                for (IndexColumnName columnName : ((IndexDefinition)pair.getValue()).getColumns()) {
                    ftSpliter.split();
                    columnName.accept(this);
                }
                this.appendable.append(")");
                if (pair.getValue() == null || ((IndexDefinition)pair.getValue()).getOptions() == null) continue;
                for (IndexOption indexOption : ((IndexDefinition)pair.getValue()).getOptions()) {
                    this.appendable.append(" ");
                    indexOption.accept(this);
                }
            }
        }
        if (node.getSpatialKeys() != null) {
            for (Pair<Identifier, ASTNode> pair : node.getSpatialKeys()) {
                cdSpliter.split();
                this.appendable.append("SPATIAL INDEX ");
                if (pair.getKey() != null) {
                    this.visit(pair.getKey());
                    this.appendable.append(' ');
                }
                this.appendable.append("(");
                CommerSpliter spSpliter = new CommerSpliter(this.appendable);
                for (IndexColumnName columnName : ((IndexDefinition)pair.getValue()).getColumns()) {
                    spSpliter.split();
                    columnName.accept(this);
                }
                this.appendable.append(")");
                if (pair.getValue() == null || ((IndexDefinition)pair.getValue()).getOptions() == null) continue;
                for (IndexOption indexOption : ((IndexDefinition)pair.getValue()).getOptions()) {
                    this.appendable.append(" ");
                    indexOption.accept(this);
                }
            }
        }
        if (node.getForeignKeys() != null) {
            for (Pair<Identifier, ASTNode> pair : node.getForeignKeys()) {
                cdSpliter.split();
                if (((IndexDefinition)pair.getValue()).isHasConstraint()) {
                    this.appendable.append("CONSTRAINT ");
                }
                if (((IndexDefinition)pair.getValue()).getForeignKeyConstraint() != null) {
                    if (!((IndexDefinition)pair.getValue()).getForeignKeyConstraint().getIdTextUnescape().equals("")) {
                        ((IndexDefinition)pair.getValue()).getForeignKeyConstraint().accept(this);
                    }
                    this.appendable.append(' ');
                }
                this.appendable.append("FOREIGN KEY ");
                if (pair.getKey() != null) {
                    this.visit(pair.getKey());
                    this.appendable.append(' ');
                }
                this.appendable.append("(");
                CommerSpliter fkSpliter = new CommerSpliter(this.appendable);
                for (IndexColumnName columnName : ((IndexDefinition)pair.getValue()).getColumns()) {
                    fkSpliter.split();
                    columnName.accept(this);
                }
                this.appendable.append(")");
                if (pair.getValue() != null && ((IndexDefinition)pair.getValue()).getOptions() != null) {
                    for (IndexOption indexOption : ((IndexDefinition)pair.getValue()).getOptions()) {
                        this.appendable.append(" ");
                        indexOption.accept(this);
                    }
                }
                if (((IndexDefinition)pair.getValue()).getForeignKeyReferenceDefinition() == null) continue;
                ((IndexDefinition)pair.getValue()).getForeignKeyReferenceDefinition().accept(this);
            }
        }
        if (colDefs.size() > 0) {
            this.appendable.append(')');
        }
        if (node.getTableOptions() != null) {
            node.getTableOptions().accept(this);
        }
        if (node.getOldTblName() != null) {
            this.appendable.append(" LIKE ");
            node.getOldTblName().accept(this);
        }
        if (node.getPartitionOptions() != null) {
            this.appendable.append(' ');
            node.getPartitionOptions().accept(this);
        }
        if (node.getSelect() != null) {
            this.appendable.append(' ');
            if (node.getSelect().getKey() != null) {
                switch (node.getSelect().getKey()) {
                    case IGNORED: {
                        this.appendable.append("IGNORE ");
                        break;
                    }
                    case REPLACE: {
                        this.appendable.append("REPLACE ");
                    }
                }
            }
            if (node.getSelect().getValue() != null) {
                node.getSelect().getValue().accept(this);
            }
        }
    }

    @Override
    public void visit(DDLRenameTableStatement node) {
        this.appendable.append("RENAME TABLE ");
        boolean isFst = true;
        for (Pair<Identifier, Identifier> p : node.getList()) {
            if (isFst) {
                isFst = false;
            } else {
                this.appendable.append(", ");
            }
            this.processTableName(p.getKey());
            this.appendable.append(" TO ");
            this.processTableName(p.getValue());
        }
    }

    @Override
    public void visit(DDLDropIndexStatement node) {
        this.appendable.append("DROP INDEX ");
        node.getIndexName().accept(this);
        this.appendable.append(" ON ");
        this.processTableName(node.getTable());
        if (node.getAlgorithm() != null) {
            this.appendable.append(" ");
            node.getAlgorithm().accept(this);
        }
        if (node.getLock() != null) {
            this.appendable.append(" ");
            node.getLock().accept(this);
        }
    }

    @Override
    public void visit(DDLDropTableStatement node) {
        this.appendable.append("DROP ");
        if (node.isTemp()) {
            this.appendable.append("TEMPORARY ");
        }
        this.appendable.append("TABLE ");
        if (node.isIfExists()) {
            this.appendable.append("IF EXISTS ");
        }
        boolean isFst = true;
        for (Identifier arg : node.getTableNames()) {
            if (isFst) {
                isFst = false;
            } else {
                this.appendable.append(',');
            }
            this.processTableName(arg);
        }
        switch (node.getMode()) {
            case CASCADE: {
                this.appendable.append(" CASCADE");
                break;
            }
            case RESTRICT: {
                this.appendable.append(" RESTRICT");
                break;
            }
            case UNDEF: {
                break;
            }
            default: {
                throw new IllegalArgumentException("unsupported mode for DROP TABLE: " + (Object)((Object)node.getMode()));
            }
        }
    }

    @Override
    public void visit(ExtDDLCreatePolicy node) {
        this.appendable.append("CREATE POLICY ");
        node.getName().accept(this);
        this.appendable.append(" (");
        boolean first = true;
        for (Pair<Integer, Expression> p : node.getProportion()) {
            if (first) {
                first = false;
            } else {
                this.appendable.append(", ");
            }
            this.appendable.append(p.getKey()).append(' ');
            p.getValue().accept(this);
        }
        this.appendable.append(')');
    }

    @Override
    public void visit(ExtDDLDropPolicy node) {
        this.appendable.append("DROP POLICY ");
        node.getPolicyName().accept(this);
    }

    @Override
    public void visit(ShowSequences showSequences) {
        this.appendable.append("SHOW SEQUENCES");
    }

    @Override
    public void visit(ShowTopology node) {
        this.appendable.append("SHOW TOPOLOGY ");
        node.getName().accept(this);
    }

    @Override
    public void visit(DMLLoadStatement node) {
        List<Identifier> cols;
        this.appendable.append("LOAD DATA ");
        switch (node.getMode()) {
            case CONCURRENT: {
                this.appendable.append("CONCURRENT ");
                break;
            }
            case LOW: {
                this.appendable.append("LOW_PRIORITY ");
                break;
            }
            case UNDEF: {
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown mode for LOAD DATA: " + (Object)((Object)node.getMode()));
            }
        }
        if (node.isLocal()) {
            this.appendable.append("LOCAL ");
        }
        this.appendable.append("INFILE ");
        node.getFileName().accept(this);
        this.appendable.append(" ");
        switch (node.getDuplicateMode()) {
            case IGNORE: {
                this.appendable.append("IGNORE ");
                break;
            }
            case REPLACE: {
                this.appendable.append("REPLACE ");
                break;
            }
            case UNDEF: {
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown mode for LOAD DATA: " + (Object)((Object)node.getDuplicateMode()));
            }
        }
        this.appendable.append("INTO TABLE ");
        this.processTableName(node.getTable());
        this.appendable.append(" ");
        if (node.getCharSet() != null) {
            this.appendable.append("CHARACTER SET ");
            this.appendable.append(node.getCharSet()).append(" ");
        }
        if (node.getFieldsEnclosedBy() != null || node.getFieldsEscapedBy() != null || node.getFiledsTerminatedBy() != null) {
            this.appendable.append("COLUMNS ");
            if (node.getFiledsTerminatedBy() != null) {
                this.appendable.append("TERMINATED BY ");
                node.getFiledsTerminatedBy().accept(this);
                this.appendable.append(" ");
            }
            if (node.getFieldsEnclosedBy() != null) {
                if (node.isOptionally()) {
                    this.appendable.append("OPTIONALLY ENCLOSED BY ");
                } else {
                    this.appendable.append("ENCLOSED BY ");
                }
                node.getFieldsEnclosedBy().accept(this);
                this.appendable.append(" ");
            }
            if (node.getFieldsEscapedBy() != null) {
                this.appendable.append("ESCAPED BY ");
                node.getFieldsEscapedBy().accept(this);
                this.appendable.append(" ");
            }
        }
        if (node.getLinesStartingBy() != null || node.getLinesTerminatedBy() != null) {
            this.appendable.append("LINES");
            if (node.getLinesStartingBy() != null) {
                this.appendable.append("STARTING BY ");
                node.getLinesStartingBy().accept(this);
                this.appendable.append(" ");
            }
            if (node.getLinesTerminatedBy() != null) {
                this.appendable.append("TERMINATED BY ");
                node.getLinesTerminatedBy().accept(this);
                this.appendable.append(" ");
            }
        }
        if (node.getIgnoreLines() != null) {
            this.appendable.append("IGNORE ");
            this.appendable.append(node.getIgnoreLines());
            this.appendable.append(" LINES ");
        }
        if ((cols = node.getColumnNameList()) != null && !cols.isEmpty()) {
            this.appendable.append('(');
            this.printList(cols);
            this.appendable.append(") ");
        }
        if (node.getValues() != null) {
            this.appendable.append("SET ");
            boolean isFst = true;
            for (Pair<Identifier, Expression> p : node.getValues()) {
                boolean paren;
                if (isFst) {
                    isFst = false;
                } else {
                    this.appendable.append(", ");
                }
                p.getKey().accept(this);
                this.appendable.append(" = ");
                Expression value = p.getValue();
                boolean bl = paren = value.getPrecedence() <= 7;
                if (paren) {
                    this.appendable.append('(');
                }
                value.accept(this);
                if (!paren) continue;
                this.appendable.append(')');
            }
        }
    }

    @Override
    public void visit(ShowPartitions node) {
        this.appendable.append("SHOW DBPARTITIONS ");
        node.getName().accept(this);
    }

    @Override
    public void visit(ShowBroadcasts showBroadcasts) {
        this.appendable.append("SHOW BROADCASTS");
    }

    @Override
    public void visit(ShowRule showRule) {
        this.appendable.append("SHOW RULE");
    }

    @Override
    public void visit(ReloadSchema reloadSchema) {
        this.appendable.append("RELOAD SCHEMA");
    }

    @Override
    public void visit(ReloadUsers reloadUsers) {
        this.appendable.append("RELOAD USERS");
    }

    @Override
    public void visit(DALPrepareStatement node) {
        this.appendable.append("PREPARE ");
        this.appendable.append(node.getStmt_id());
    }

    @Override
    public void visit(DALExecuteStatement node) {
        this.appendable.append("EXECUTE ");
        this.appendable.append(node.getStmt_id());
    }

    @Override
    public void visit(DALDeallocateStatement node) {
        this.appendable.append("DEALLOCATE PREPARE ");
        this.appendable.append(node.getStmt_id());
    }

    @Override
    public void visit(ShowTrace showTrace) {
        this.appendable.append("SHOW TRACE");
    }

    @Override
    public void visit(ShowDataSources showDatasources) {
        this.appendable.append("SHOW DATASOURCES");
    }

    @Override
    public void visit(ReloadDataSources clearDataSources) {
        this.appendable.append("CLEAR DATASOURCES");
    }

    @Override
    public void visit(CreateSequence node) {
        this.appendable.append("CREATE SEQUENCE ");
        node.getName().accept(this);
        if (node.getStart() != null) {
            this.appendable.append(" START ");
            this.appendable.append(node.getStart());
        }
    }

    @Override
    public void visit(AlterSequence node) {
        this.appendable.append("ALTER SEQUENCE ");
        node.getName().accept(this);
        if (node.getStart() != null) {
            this.appendable.append(" START ");
            this.appendable.append(node.getStart());
        }
    }

    @Override
    public void visit(DropSequence node) {
        this.appendable.append("DROP SEQUENCE ");
        node.getName().accept(this);
    }

    @Override
    public void visit(ReferenceDefinition referenceDefinition) {
        this.appendable.append(" REFERENCES ");
        this.processTableName(referenceDefinition.getTblName());
        this.appendable.append(" (");
        boolean isFst = true;
        for (IndexColumnName indexColumnName : referenceDefinition.getColumns()) {
            if (isFst) {
                isFst = false;
            } else {
                this.appendable.append(", ");
            }
            indexColumnName.accept(this);
        }
        this.appendable.append(") ");
        if (referenceDefinition.getMatchType() != null) {
            switch (referenceDefinition.getMatchType()) {
                case MATCH_FULL: {
                    this.appendable.append("MATCH FULL ");
                    break;
                }
                case MATCH_PARTIAL: {
                    this.appendable.append("MATCH PARTIAL ");
                    break;
                }
                case MATCH_SIMPLE: {
                    this.appendable.append("MATCH SIMPLE ");
                }
            }
        }
        if (referenceDefinition.getReferenceOptions() != null) {
            for (ReferenceOption referenceOption : referenceDefinition.getReferenceOptions()) {
                this.appendable.append(" ");
                referenceOption.accept(this);
            }
        }
    }

    @Override
    public void visit(ReferenceOption referenceOption) {
        if (referenceOption.getOnType() != null) {
            switch (referenceOption.getOnType()) {
                case ON_DELETE: {
                    this.appendable.append("ON DELETE ");
                    break;
                }
                case ON_UPDATE: {
                    this.appendable.append("ON UPDATE ");
                }
            }
            switch (referenceOption.getReferenceOptionType()) {
                case RESTRICT: {
                    this.appendable.append("RESTRICT");
                    break;
                }
                case CASCADE: {
                    this.appendable.append("CASCADE");
                    break;
                }
                case SET_NULL: {
                    this.appendable.append("SET NULL");
                    break;
                }
                case NO_ACTION: {
                    this.appendable.append("NO ACTION");
                }
            }
        }
    }

    public void visit(IndexDefinition.IndexType indexType) {
        this.appendable.append("USING ");
        if (indexType == IndexDefinition.IndexType.BTREE) {
            this.appendable.append("BTREE ");
        } else if (indexType == IndexDefinition.IndexType.HASH) {
            this.appendable.append("HASH ");
        }
    }

    @Override
    public void visit(Algorithm algorithm) {
        this.appendable.append("ALGORITHM = ");
        switch (algorithm.getAlgorithmType()) {
            case DEFAULT: {
                this.appendable.append("DEFAULT ");
                break;
            }
            case INPLACE: {
                this.appendable.append("INPLACE ");
                break;
            }
            case COPY: {
                this.appendable.append("COPY ");
            }
        }
    }

    @Override
    public void visit(LockOperation lockOperation) {
        this.appendable.append("LOCK = ");
        switch (lockOperation.getLockType()) {
            case DEFAULT: {
                this.appendable.append("DEFAULT ");
                break;
            }
            case NONE: {
                this.appendable.append("NONE ");
                break;
            }
            case SHARED: {
                this.appendable.append("SHARED ");
                break;
            }
            case EXCLUSIVE: {
                this.appendable.append("EXCLUSIVE ");
            }
        }
    }

    @Override
    public void visit(EnableKeys enableKeys) {
        switch (enableKeys.getEnableType()) {
            case ENABLE: {
                this.appendable.append("ENABLE KEYS ");
                break;
            }
            case DISABLE: {
                this.appendable.append("DISABLE KEYS ");
            }
        }
    }

    @Override
    public void visit(ImportTablespace importTablespace) {
        switch (importTablespace.getImportTSType()) {
            case IMPORT: {
                this.appendable.append("IMPORT TABLESPACE ");
                break;
            }
            case DISCARD: {
                this.appendable.append("DISCARD TABLESPACE ");
            }
        }
    }

    @Override
    public void visit(ForceOperation foreceOperation) {
        this.appendable.append("FORCE ");
    }

    @Override
    public void visit(RenameOperation renameOperation) {
        this.appendable.append("RENAME ");
        if (renameOperation.getRenameType() != null) {
            switch (renameOperation.getRenameType()) {
                case AS: {
                    this.appendable.append("AS ");
                    break;
                }
                case TO: {
                    this.appendable.append("TO ");
                }
            }
        }
        if (renameOperation.getNewTblName() != null) {
            renameOperation.getNewTblName().accept(this);
        }
    }

    @Override
    public void visit(ConvertCharset convertCharset) {
        this.appendable.append("CONVERT TO CHARACTER SET ");
        if (convertCharset.getCharsetdef() != null && convertCharset.getCharsetdef().getKey() != null) {
            convertCharset.getCharsetdef().getKey().accept(this);
            this.appendable.append(" ");
            if (convertCharset.getCharsetdef().getValue() != null) {
                this.appendable.append("COLLATE ");
                convertCharset.getCharsetdef().getValue().accept(this);
            }
        }
    }

    @Override
    public void visit(CharacterSet characterSet) {
        if (characterSet.isIsdefault()) {
            this.appendable.append("DEFAULT ");
        }
        this.appendable.append("CHARACTER SET = ");
        if (characterSet.getCharsetdef() != null && characterSet.getCharsetdef().getKey() != null) {
            characterSet.getCharsetdef().getKey().accept(this);
            this.appendable.append(" ");
            if (characterSet.getCharsetdef().getValue() != null) {
                this.appendable.append("COLLATE = ");
                characterSet.getCharsetdef().getValue().accept(this);
            }
        }
    }

    private void visit(List<Identifier> ids) {
        CommerSpliter commerSpliter = new CommerSpliter(this.appendable);
        for (Identifier id : ids) {
            commerSpliter.split();
            id.accept(this);
        }
    }

    @Override
    public void visit(Orderby orderby) {
        this.appendable.append("ORDER BY ");
        CommerSpliter spliter = new CommerSpliter(this.appendable);
        for (Identifier colName : orderby.getColNames()) {
            spliter.split();
            this.appendable.append(' ');
            colName.accept(this);
        }
    }

    @Override
    public void visit(AddPartitition addPartitition) {
        this.appendable.append("ADD PARTITION (");
        if (addPartitition.getPartitionDefinition() != null) {
            addPartitition.getPartitionDefinition().accept(this);
        }
        this.appendable.append(") ");
    }

    @Override
    public void visit(DropPartitition dropPartitition) {
        this.appendable.append("DROP PARTITION ");
        this.visit(dropPartitition.getPartition_names());
        this.appendable.append(" ");
    }

    @Override
    public void visit(TruncatePartitition truncatePartitition) {
        this.appendable.append("TRUNCATE PARTITION ");
        if (truncatePartitition.getTruncatePartitionType() != null) {
            switch (truncatePartitition.getTruncatePartitionType()) {
                case ALL: {
                    this.appendable.append("ALL");
                    break;
                }
                case PARTITION_NAMES: {
                    this.visit(truncatePartitition.getPartition_names());
                }
            }
        }
        this.appendable.append(" ");
    }

    @Override
    public void visit(CoalescePartition coalescePartition) {
        this.appendable.append("COALESCE PARTITION ");
        if (coalescePartition.getNumber() != null) {
            coalescePartition.getNumber().accept(this);
        }
        this.appendable.append(" ");
    }

    @Override
    public void visit(ReorganizePartition reorganizePartition) {
        this.appendable.append("REORGANIZE PARTITION ");
        if (reorganizePartition.getPartition_names() != null) {
            this.visit(reorganizePartition.getPartition_names());
            this.appendable.append(" ");
        }
        this.appendable.append(" INTO (");
        if (reorganizePartition.getPartitionDefinitionList() != null) {
            CommerSpliter pdSpliter = new CommerSpliter(this.appendable);
            for (PartitionDefinition pd : reorganizePartition.getPartitionDefinitionList()) {
                pdSpliter.split();
                pd.accept(this);
            }
        }
        this.appendable.append(") ");
    }

    @Override
    public void visit(ExchangePartition exchangePartition) {
        this.appendable.append("EXCHANGE PARTITION ");
        if (exchangePartition.getPartition_name() != null) {
            exchangePartition.getPartition_name().accept(this);
            this.appendable.append(' ');
        }
        this.appendable.append("WITH TABLE ");
        if (exchangePartition.getTbl_name() != null) {
            exchangePartition.getTbl_name().accept(this);
        }
        this.appendable.append(" ");
    }

    @Override
    public void visit(AnalyzePartition analyzePartition) {
        this.appendable.append("ANALYZE PARTITION ");
        if (analyzePartition.getAnalyzePartitionType() != null) {
            switch (analyzePartition.getAnalyzePartitionType()) {
                case ALL: {
                    this.appendable.append("ALL");
                    break;
                }
                case PARTITION_NAMES: {
                    this.visit(analyzePartition.getPartition_names());
                }
            }
        }
        this.appendable.append(' ');
    }

    @Override
    public void visit(CheckPartition checkPartition) {
        this.appendable.append("CHECK PARTITION ");
        if (checkPartition.getCheckPartitionType() != null) {
            switch (checkPartition.getCheckPartitionType()) {
                case ALL: {
                    this.appendable.append("ALL");
                    break;
                }
                case PARTITION_NAMES: {
                    this.visit(checkPartition.getPartition_names());
                }
            }
        }
        this.appendable.append(' ');
    }

    @Override
    public void visit(OptimizePartition optimizePartition) {
        this.appendable.append("OPTIMIZE PARTITION ");
        if (optimizePartition.getOptimizePartitionType() != null) {
            switch (optimizePartition.getOptimizePartitionType()) {
                case ALL: {
                    this.appendable.append("ALL");
                    break;
                }
                case PARTITION_NAMES: {
                    this.visit(optimizePartition.getPartition_names());
                }
            }
        }
        this.appendable.append(' ');
    }

    @Override
    public void visit(RebuildPartition rebuildPartition) {
        this.appendable.append("REBUILD PARTITION ");
        if (rebuildPartition.getRebuildPartitionType() != null) {
            switch (rebuildPartition.getRebuildPartitionType()) {
                case ALL: {
                    this.appendable.append("ALL");
                    break;
                }
                case PARTITION_NAMES: {
                    this.visit(rebuildPartition.getPartition_names());
                }
            }
        }
        this.appendable.append(' ');
    }

    @Override
    public void visit(RepairPartition repairPartition) {
        this.appendable.append("REPAIR PARTITION ");
        if (repairPartition.getRepairPartitionType() != null) {
            switch (repairPartition.getRepairPartitionType()) {
                case ALL: {
                    this.appendable.append("ALL");
                    break;
                }
                case PARTITION_NAMES: {
                    this.visit(repairPartition.getPartition_names());
                }
            }
        }
        this.appendable.append(' ');
    }

    @Override
    public void visit(RemovePartitioning removePartitioning) {
        this.appendable.append("REMOVE PARTITIONING ");
    }

    protected void processTableName(Identifier identifier) {
        identifier.accept(this);
    }

    public static String convertKeywords(String name) {
        if (name == null) {
            return null;
        }
        if (ConfigDataMode.isQuotaEscape()) {
            if (TStringUtil.equals((String)"*", (String)name)) {
                return name;
            }
            if (TStringUtil.startsWith((String)name, (String)"`")) {
                return name;
            }
            if (TStringUtil.startsWith((String)name, (String)"'") || TStringUtil.startsWith((String)name, (String)"\"")) {
                return name;
            }
            name = TStringUtil.replace((String)name, (String)"`", (String)"``");
            StringBuilder sb = new StringBuilder(2 + name.length());
            sb.append("`");
            sb.append(name);
            sb.append("`");
            return sb.toString();
        }
        if (MySQLKeywords.DEFAULT_KEYWORDS.isKeyword(name)) {
            StringBuilder sb = new StringBuilder(2 + name.length());
            sb.append("`");
            sb.append(name);
            sb.append("`");
            return sb.toString();
        }
        return name;
    }

    @Override
    public void visit(Kill kill) {
        this.appendable.append("KILL '" + kill.getProcessId() + "'");
    }

    @Override
    public void visit(ReleaseDbLock releaseDbLock) {
        this.appendable.append("RELEASE ").append("DBLOCK");
    }

    @Override
    public void visit(LockTablesStatement lockTablesStatement) {
        this.appendable.append("LOCK TABLES ");
        boolean first = true;
        for (LockReference lock : lockTablesStatement.getLocks()) {
            if (first) {
                first = false;
            } else {
                this.appendable.append(", ");
            }
            lock.getTable().accept(this);
            this.appendable.append(" ");
            if (lock.getAlias() != null) {
                this.appendable.append("AS ");
                lock.getAlias().accept(this);
                this.appendable.append(" ");
            }
            switch (lock.getLockType()) {
                case READ: {
                    this.appendable.append("READ");
                    break;
                }
                case READ_LOCAL: {
                    this.appendable.append("READ LOCAL");
                    break;
                }
                case LOW_PRIORITY_WRITE: {
                    this.appendable.append("LOW_PRIORITY WRITE");
                    break;
                }
                case WRITE: {
                    this.appendable.append("WRITE");
                }
            }
        }
    }

    @Override
    public void visit(UnLockTablesStatement unLockTablesStatement) {
        this.appendable.append("UNLOCK TABLES");
    }

    @Override
    public void visit(CheckTableStatement node) {
    }

    @Override
    public void visit(ShowSlow node) {
        Limit limit;
        this.appendable.append("SHOW ");
        if (node.isPhysical()) {
            this.appendable.append("PHYSICAL_SLOW");
        } else {
            this.appendable.append("SLOW");
        }
        Expression where = node.getWhere();
        if (where != null) {
            this.appendable.append(' ');
            where.accept(this);
        }
        if ((limit = node.getLimit()) != null) {
            this.appendable.append(' ');
            limit.accept(this);
        }
    }

    @Override
    public void visit(ShowStats node) {
        this.appendable.append("SHOW ");
        if (node.isFull()) {
            this.appendable.append("FULL ");
        }
        this.appendable.append("STATS");
    }
}

