/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.txc.parser.recognizer.mysql.syntax;

import com.alibaba.txc.parser.ast.expression.primary.Identifier;
import com.alibaba.txc.parser.ast.expression.primary.ParamMarker;
import com.alibaba.txc.parser.ast.expression.primary.PlaceHolder;
import com.alibaba.txc.parser.ast.expression.primary.SysVarPrimary;
import com.alibaba.txc.parser.ast.expression.primary.Wildcard;
import com.alibaba.txc.parser.ast.fragment.Limit;
import com.alibaba.txc.parser.ast.fragment.VariableScope;
import com.alibaba.txc.parser.recognizer.mysql.MySQLToken;
import com.alibaba.txc.parser.recognizer.mysql.lexer.MySQLKeywords;
import com.alibaba.txc.parser.recognizer.mysql.lexer.MySQLLexer;
import java.sql.SQLSyntaxErrorException;
import java.util.HashMap;
import java.util.Map;

public abstract class MySQLParser {
    public static final String DEFAULT_CHARSET = "utf-8";
    protected final MySQLLexer lexer;
    private static final Map<String, SpecialIdentifier> specialIdentifiers = new HashMap<String, SpecialIdentifier>();
    protected final boolean cacheEvalRst;

    public MySQLParser(MySQLLexer lexer) {
        this(lexer, true);
    }

    public MySQLParser(MySQLLexer lexer, boolean cacheEvalRst) {
        this.lexer = lexer;
        this.cacheEvalRst = cacheEvalRst;
    }

    public Identifier identifier() throws SQLSyntaxErrorException {
        Identifier id;
        if (this.lexer.token() == null) {
            this.lexer.nextToken();
        }
        switch (this.lexer.token()) {
            case OP_ASTERISK: {
                this.lexer.nextToken();
                Wildcard wc = new Wildcard(null);
                wc.setCacheEvalRst(this.cacheEvalRst);
                return wc;
            }
            case IDENTIFIER: {
                id = new Identifier(null, this.lexer.stringValue(), this.lexer.stringValueUppercase());
                id.setCacheEvalRst(this.cacheEvalRst);
                this.lexer.nextToken();
                break;
            }
            case LITERAL_CHARS: {
                String tempstr = this.lexer.stringValue().substring(1, this.lexer.stringValue().length() - 1);
                id = new Identifier(null, tempstr, tempstr.toUpperCase());
                this.lexer.nextToken();
                break;
            }
            default: {
                throw this.err("expect id or * after '.'");
            }
        }
        block9: while (this.lexer.token() == MySQLToken.PUNC_DOT) {
            MySQLKeywords keywods;
            this.lexer.nextToken();
            switch (this.lexer.token()) {
                case OP_ASTERISK: {
                    this.lexer.nextToken();
                    Wildcard wc = new Wildcard(id);
                    wc.setCacheEvalRst(this.cacheEvalRst);
                    return wc;
                }
                case IDENTIFIER: {
                    id = new Identifier(id, this.lexer.stringValue(), this.lexer.stringValueUppercase());
                    id.setCacheEvalRst(this.cacheEvalRst);
                    this.lexer.nextToken();
                    continue block9;
                }
            }
            if (id != null && (keywods = MySQLKeywords.DEFAULT_KEYWORDS).isKeyword(MySQLToken.keyWordToString(this.lexer.token()))) {
                id = new Identifier(id, this.lexer.stringValue(), this.lexer.stringValueUppercase());
                id.setCacheEvalRst(this.cacheEvalRst);
                this.lexer.nextToken();
                continue;
            }
            throw this.err("expect id or * after '.'");
        }
        return id;
    }

    public SysVarPrimary systemVariale() throws SQLSyntaxErrorException {
        VariableScope scope = VariableScope.SESSION;
        String str = this.lexer.stringValue();
        String strUp = this.lexer.stringValueUppercase();
        this.match(MySQLToken.SYS_VAR);
        SpecialIdentifier si = specialIdentifiers.get(strUp);
        if (si != null) {
            switch (si) {
                case GLOBAL: {
                    scope = VariableScope.GLOBAL;
                }
                case SESSION: 
                case LOCAL: {
                    this.match(MySQLToken.PUNC_DOT);
                    str = this.lexer.stringValue();
                    strUp = this.lexer.stringValueUppercase();
                    this.match(MySQLToken.IDENTIFIER);
                    SysVarPrimary sys = new SysVarPrimary(scope, str, strUp);
                    sys.setCacheEvalRst(this.cacheEvalRst);
                    return sys;
                }
            }
        }
        SysVarPrimary sys = new SysVarPrimary(scope, str, strUp);
        sys.setCacheEvalRst(this.cacheEvalRst);
        return sys;
    }

    protected ParamMarker createParam(int index) {
        ParamMarker param = new ParamMarker(index);
        param.setCacheEvalRst(this.cacheEvalRst);
        return param;
    }

    protected PlaceHolder createPlaceHolder(String str, String strUp) {
        PlaceHolder ph = new PlaceHolder(str, strUp);
        ph.setCacheEvalRst(this.cacheEvalRst);
        return ph;
    }

    protected Limit limit() throws SQLSyntaxErrorException {
        if (this.lexer.token() != MySQLToken.KW_LIMIT) {
            return null;
        }
        switch (this.lexer.nextToken()) {
            case LITERAL_NUM_PURE_DIGIT: {
                Number num1 = this.lexer.integerValue();
                switch (this.lexer.nextToken()) {
                    case PUNC_COMMA: {
                        switch (this.lexer.nextToken()) {
                            case LITERAL_NUM_PURE_DIGIT: {
                                Number num2 = this.lexer.integerValue();
                                this.lexer.nextToken();
                                return new Limit(num1, num2);
                            }
                            case QUESTION_MARK: {
                                int paramIndex1 = this.lexer.paramIndex();
                                this.lexer.nextToken();
                                return new Limit(num1, this.createParam(paramIndex1));
                            }
                        }
                        throw this.err("expect digit or ? after , for limit");
                    }
                    case IDENTIFIER: {
                        if (!"OFFSET".equals(this.lexer.stringValueUppercase())) break;
                        switch (this.lexer.nextToken()) {
                            case LITERAL_NUM_PURE_DIGIT: {
                                Number num2 = this.lexer.integerValue();
                                this.lexer.nextToken();
                                return new Limit(num2, num1);
                            }
                            case QUESTION_MARK: {
                                int paramIndex1 = this.lexer.paramIndex();
                                this.lexer.nextToken();
                                return new Limit(this.createParam(paramIndex1), num1);
                            }
                        }
                        throw this.err("expect digit or ? after , for limit");
                    }
                }
                return new Limit((Number)new Integer(0), num1);
            }
            case QUESTION_MARK: {
                int paramIndex1 = this.lexer.paramIndex();
                switch (this.lexer.nextToken()) {
                    case PUNC_COMMA: {
                        switch (this.lexer.nextToken()) {
                            case LITERAL_NUM_PURE_DIGIT: {
                                Number num1 = this.lexer.integerValue();
                                this.lexer.nextToken();
                                return new Limit(this.createParam(paramIndex1), num1);
                            }
                            case QUESTION_MARK: {
                                int paramIndex2 = this.lexer.paramIndex();
                                this.lexer.nextToken();
                                return new Limit(this.createParam(paramIndex1), this.createParam(paramIndex2));
                            }
                        }
                        throw this.err("expect digit or ? after , for limit");
                    }
                    case IDENTIFIER: {
                        if (!"OFFSET".equals(this.lexer.stringValueUppercase())) break;
                        switch (this.lexer.nextToken()) {
                            case LITERAL_NUM_PURE_DIGIT: {
                                Number num1 = this.lexer.integerValue();
                                this.lexer.nextToken();
                                return new Limit(num1, this.createParam(paramIndex1));
                            }
                            case QUESTION_MARK: {
                                int paramIndex2 = this.lexer.paramIndex();
                                this.lexer.nextToken();
                                return new Limit(this.createParam(paramIndex2), this.createParam(paramIndex1));
                            }
                        }
                        throw this.err("expect digit or ? after , for limit");
                    }
                }
                return new Limit((Number)new Integer(0), this.createParam(paramIndex1));
            }
        }
        throw this.err("expect digit or ? after limit");
    }

    protected Limit dmlLimit() throws SQLSyntaxErrorException {
        if (this.lexer.token() != MySQLToken.KW_LIMIT) {
            return null;
        }
        switch (this.lexer.nextToken()) {
            case LITERAL_NUM_PURE_DIGIT: {
                Number num1 = this.lexer.integerValue();
                this.lexer.nextToken();
                return new Limit((Number)new Integer(0), num1);
            }
            case QUESTION_MARK: {
                int paramIndex1 = this.lexer.paramIndex();
                this.lexer.nextToken();
                return new Limit((Number)new Integer(0), this.createParam(paramIndex1));
            }
        }
        throw this.err("expect digit or ? after limit");
    }

    protected int equalsIdentifier(String ... expectTextUppercases) throws SQLSyntaxErrorException {
        if (this.lexer.token() == MySQLToken.IDENTIFIER) {
            String id = this.lexer.stringValueUppercase();
            for (int i = 0; i < expectTextUppercases.length; ++i) {
                if (!expectTextUppercases[i].equals(id)) continue;
                return i;
            }
        }
        return -1;
    }

    protected int matchIdentifier(String ... expectTextUppercase) throws SQLSyntaxErrorException {
        if (expectTextUppercase == null || expectTextUppercase.length <= 0) {
            throw new IllegalArgumentException("at least one expect token");
        }
        if (this.lexer.token() != MySQLToken.IDENTIFIER) {
            throw this.err("expect an id");
        }
        String id = this.lexer.stringValueUppercase();
        for (int i = 0; i < expectTextUppercase.length; ++i) {
            if (!(id == null ? expectTextUppercase[i] == null : id.equals(expectTextUppercase[i]))) continue;
            this.lexer.nextToken();
            return i;
        }
        throw this.err("expect " + expectTextUppercase);
    }

    protected int match(MySQLToken ... expectToken) throws SQLSyntaxErrorException {
        if (expectToken == null || expectToken.length <= 0) {
            throw new IllegalArgumentException("at least one expect token");
        }
        MySQLToken token = this.lexer.token();
        for (int i = 0; i < expectToken.length; ++i) {
            if (token != expectToken[i]) continue;
            if (token != MySQLToken.EOF || i < expectToken.length - 1) {
                this.lexer.nextToken();
            }
            return i;
        }
        throw this.err("expect " + expectToken);
    }

    protected SQLSyntaxErrorException err(String msg) throws SQLSyntaxErrorException {
        StringBuilder errmsg = new StringBuilder();
        errmsg.append(msg).append(". lexer state: ").append(String.valueOf(this.lexer));
        throw new SQLSyntaxErrorException(errmsg.toString());
    }

    static {
        specialIdentifiers.put("GLOBAL", SpecialIdentifier.GLOBAL);
        specialIdentifiers.put("SESSION", SpecialIdentifier.SESSION);
        specialIdentifiers.put("LOCAL", SpecialIdentifier.LOCAL);
    }

    private static enum SpecialIdentifier {
        GLOBAL,
        LOCAL,
        SESSION;

    }
}

