/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.txc.parser.util;

import com.alibaba.txc.parser.ast.expression.Expression;
import com.alibaba.txc.parser.ast.expression.primary.literal.LiteralBoolean;
import com.alibaba.txc.parser.recognizer.mysql.lexer.MySQLLexer;
import com.alibaba.txc.parser.util.BinaryOperandCalculator;
import com.alibaba.txc.parser.util.Pair;
import com.alibaba.txc.parser.util.UnaryOperandCalculator;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.SQLSyntaxErrorException;
import java.util.HashMap;
import java.util.Map;

public class ExprEvalUtils {
    private static final int CLASS_MAP_DOUBLE = 1;
    private static final int CLASS_MAP_FLOAT = 2;
    private static final int CLASS_MAP_BIG_ING = 3;
    private static final int CLASS_MAP_BIG_DECIMAL = 4;
    private static final int CLASS_MAP_LONG = 5;
    private static final Map<Class<? extends Number>, Integer> classMap = new HashMap<Class<? extends Number>, Integer>(5);
    private static final int NUM_INT = 1;
    private static final int NUM_LONG = 2;
    private static final int NUM_BIG_INTEGER = 3;
    private static final int NUM_BIG_DECIMAL = 4;

    public static boolean obj2bool(Object obj) {
        if (obj == LiteralBoolean.TRUE) {
            return true;
        }
        if (obj == LiteralBoolean.FALSE) {
            return false;
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        Number num = obj instanceof String ? (Number)ExprEvalUtils.string2Number((String)obj) : (Number)((Number)obj);
        Integer classType = classMap.get(num.getClass());
        if (classType == null) {
            return num.intValue() != 0;
        }
        switch (classType) {
            case 4: {
                return BigDecimal.ZERO.compareTo((BigDecimal)num) != 0;
            }
            case 3: {
                return BigInteger.ZERO.compareTo((BigInteger)num) != 0;
            }
            case 1: {
                return (Double)num != 0.0;
            }
            case 2: {
                return ((Float)num).floatValue() != 0.0f;
            }
            case 5: {
                return (Long)num != 0L;
            }
        }
        throw new IllegalArgumentException("unsupported number type: " + num.getClass());
    }

    public static Object calculate(UnaryOperandCalculator cal, Number num) {
        try {
            if (num == null) {
                return null;
            }
            if (num instanceof Integer) {
                return cal.calculate((Integer)num);
            }
            if (num instanceof Long) {
                return cal.calculate((Long)num);
            }
            if (num instanceof BigDecimal) {
                return cal.calculate((BigDecimal)num);
            }
            if (num instanceof BigInteger) {
                return cal.calculate((BigInteger)num);
            }
        }
        finally {
            return Expression.UNEVALUATABLE;
        }
        {
        }
    }

    public static Object calculate(BinaryOperandCalculator cal, Number n1, Number n2) {
        try {
            if (n1 == null || n2 == null) {
                return null;
            }
            if (n1 instanceof Integer) {
                return cal.calculate((Integer)n1, (Integer)n2);
            }
            if (n1 instanceof Long) {
                return cal.calculate((Long)n1, (Long)n2);
            }
            if (n1 instanceof BigDecimal) {
                return cal.calculate((BigDecimal)n1, (BigDecimal)n2);
            }
            if (n1 instanceof BigInteger) {
                return cal.calculate((BigInteger)n1, (BigInteger)n2);
            }
        }
        finally {
            return Expression.UNEVALUATABLE;
        }
        {
        }
    }

    public static Pair<Number, Number> convertNum2SameLevel(Object obj1, Object obj2) {
        int l2;
        Number n1 = obj1 instanceof String ? (Number)ExprEvalUtils.string2Number((String)obj1) : (Number)((Number)obj1);
        Number n2 = obj2 instanceof String ? (Number)ExprEvalUtils.string2Number((String)obj2) : (Number)((Number)obj2);
        if (n1 == null || n2 == null) {
            return new Pair<Number, Number>(n1, n2);
        }
        int l1 = ExprEvalUtils.getNumberLevel(n1.getClass());
        if (l1 > (l2 = ExprEvalUtils.getNumberLevel(n2.getClass()))) {
            n2 = ExprEvalUtils.upTolevel(n2, l1);
        } else if (l1 < l2) {
            n1 = ExprEvalUtils.upTolevel(n1, l2);
        }
        return new Pair<Number, Number>(n1, n2);
    }

    private static Number upTolevel(Number num, int level) {
        switch (level) {
            case 1: {
                if (num instanceof Integer) {
                    return num;
                }
                return num.intValue();
            }
            case 2: {
                if (num instanceof Long) {
                    return num;
                }
                return num.longValue();
            }
            case 3: {
                if (num instanceof BigInteger) {
                    return num;
                }
                return new BigInteger(num.toString());
            }
            case 4: {
                if (num instanceof BigDecimal) {
                    return num;
                }
                return new BigDecimal(num.toString());
            }
        }
        throw new IllegalArgumentException("unsupported number level: " + level);
    }

    private static int getNumberLevel(Class<?> clz) {
        if (Integer.class.isAssignableFrom(clz)) {
            return 1;
        }
        if (Long.class.isAssignableFrom(clz)) {
            return 2;
        }
        if (BigInteger.class.isAssignableFrom(clz)) {
            return 3;
        }
        if (BigDecimal.class.isAssignableFrom(clz)) {
            return 4;
        }
        throw new IllegalArgumentException("unsupported number class: " + clz);
    }

    public static Number string2Number(String str) {
        if (str == null) {
            return null;
        }
        try {
            return new Integer(str);
        }
        catch (Exception exception) {
            try {
                return new Long(str);
            }
            catch (Exception exception2) {
                try {
                    MySQLLexer lexer = new MySQLLexer(str);
                    switch (lexer.token()) {
                        case LITERAL_NUM_PURE_DIGIT: {
                            return lexer.integerValue();
                        }
                        case LITERAL_NUM_MIX_DIGIT: {
                            return lexer.decimalValue();
                        }
                    }
                    throw new IllegalArgumentException("unrecognized number: " + str);
                }
                catch (SQLSyntaxErrorException e) {
                    throw new IllegalArgumentException(e);
                }
            }
        }
    }

    static {
        classMap.put(Double.class, 1);
        classMap.put(Float.class, 2);
        classMap.put(BigInteger.class, 3);
        classMap.put(BigDecimal.class, 4);
        classMap.put(Long.class, 5);
    }
}

