/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.txc.parser.util;

public final class ParseString {
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];

    public static byte[] hexString2Bytes(String hexString) {
        if (hexString == null) {
            return null;
        }
        int offset = 0;
        int length = hexString.length();
        if (length == 0) {
            return EMPTY_BYTE_ARRAY;
        }
        boolean odd = length << 31 == Integer.MIN_VALUE;
        byte[] bs = new byte[odd ? length + 1 >> 1 : length >> 1];
        int limit = offset + length;
        for (int i = offset; i < limit; ++i) {
            int b;
            char low;
            int high;
            if (i == offset && odd) {
                high = 48;
                low = hexString.charAt(i);
            } else {
                high = hexString.charAt(i);
                low = hexString.charAt(++i);
            }
            switch (high) {
                case 48: {
                    b = 0;
                    break;
                }
                case 49: {
                    b = 16;
                    break;
                }
                case 50: {
                    b = 32;
                    break;
                }
                case 51: {
                    b = 48;
                    break;
                }
                case 52: {
                    b = 64;
                    break;
                }
                case 53: {
                    b = 80;
                    break;
                }
                case 54: {
                    b = 96;
                    break;
                }
                case 55: {
                    b = 112;
                    break;
                }
                case 56: {
                    b = 128;
                    break;
                }
                case 57: {
                    b = 144;
                    break;
                }
                case 65: 
                case 97: {
                    b = 160;
                    break;
                }
                case 66: 
                case 98: {
                    b = 176;
                    break;
                }
                case 67: 
                case 99: {
                    b = 192;
                    break;
                }
                case 68: 
                case 100: {
                    b = 208;
                    break;
                }
                case 69: 
                case 101: {
                    b = 224;
                    break;
                }
                case 70: 
                case 102: {
                    b = 240;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("illegal hex-string: " + hexString);
                }
            }
            switch (low) {
                case '0': {
                    break;
                }
                case '1': {
                    ++b;
                    break;
                }
                case '2': {
                    b += 2;
                    break;
                }
                case '3': {
                    b += 3;
                    break;
                }
                case '4': {
                    b += 4;
                    break;
                }
                case '5': {
                    b += 5;
                    break;
                }
                case '6': {
                    b += 6;
                    break;
                }
                case '7': {
                    b += 7;
                    break;
                }
                case '8': {
                    b += 8;
                    break;
                }
                case '9': {
                    b += 9;
                    break;
                }
                case 'A': 
                case 'a': {
                    b += 10;
                    break;
                }
                case 'B': 
                case 'b': {
                    b += 11;
                    break;
                }
                case 'C': 
                case 'c': {
                    b += 12;
                    break;
                }
                case 'D': 
                case 'd': {
                    b += 13;
                    break;
                }
                case 'E': 
                case 'e': {
                    b += 14;
                    break;
                }
                case 'F': 
                case 'f': {
                    b += 15;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("illegal hex-string: " + hexString);
                }
            }
            bs[i - offset >> 1] = (byte)b;
        }
        return bs;
    }

    public static byte[] hexString2Bytes(char[] hexString, int offset, int length) {
        if (hexString == null) {
            return null;
        }
        if (length == 0) {
            return EMPTY_BYTE_ARRAY;
        }
        boolean odd = length << 31 == Integer.MIN_VALUE;
        byte[] bs = new byte[odd ? length + 1 >> 1 : length >> 1];
        int limit = offset + length;
        for (int i = offset; i < limit; ++i) {
            int b;
            char low;
            int high;
            if (i == offset && odd) {
                high = 48;
                low = hexString[i];
            } else {
                high = hexString[i];
                low = hexString[++i];
            }
            switch (high) {
                case 48: {
                    b = 0;
                    break;
                }
                case 49: {
                    b = 16;
                    break;
                }
                case 50: {
                    b = 32;
                    break;
                }
                case 51: {
                    b = 48;
                    break;
                }
                case 52: {
                    b = 64;
                    break;
                }
                case 53: {
                    b = 80;
                    break;
                }
                case 54: {
                    b = 96;
                    break;
                }
                case 55: {
                    b = 112;
                    break;
                }
                case 56: {
                    b = 128;
                    break;
                }
                case 57: {
                    b = 144;
                    break;
                }
                case 65: 
                case 97: {
                    b = 160;
                    break;
                }
                case 66: 
                case 98: {
                    b = 176;
                    break;
                }
                case 67: 
                case 99: {
                    b = 192;
                    break;
                }
                case 68: 
                case 100: {
                    b = 208;
                    break;
                }
                case 69: 
                case 101: {
                    b = 224;
                    break;
                }
                case 70: 
                case 102: {
                    b = 240;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("illegal hex-string: " + new String(hexString, offset, length));
                }
            }
            switch (low) {
                case '0': {
                    break;
                }
                case '1': {
                    ++b;
                    break;
                }
                case '2': {
                    b += 2;
                    break;
                }
                case '3': {
                    b += 3;
                    break;
                }
                case '4': {
                    b += 4;
                    break;
                }
                case '5': {
                    b += 5;
                    break;
                }
                case '6': {
                    b += 6;
                    break;
                }
                case '7': {
                    b += 7;
                    break;
                }
                case '8': {
                    b += 8;
                    break;
                }
                case '9': {
                    b += 9;
                    break;
                }
                case 'A': 
                case 'a': {
                    b += 10;
                    break;
                }
                case 'B': 
                case 'b': {
                    b += 11;
                    break;
                }
                case 'C': 
                case 'c': {
                    b += 12;
                    break;
                }
                case 'D': 
                case 'd': {
                    b += 13;
                    break;
                }
                case 'E': 
                case 'e': {
                    b += 14;
                    break;
                }
                case 'F': 
                case 'f': {
                    b += 15;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("illegal hex-string: " + new String(hexString, offset, length));
                }
            }
            bs[i - offset >> 1] = (byte)b;
        }
        return bs;
    }
}

