/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.txc.parser.util;

import com.alibaba.txc.parser.util.CharTypes;

public final class ParseUtil {
    private static final String JSON = "json";
    private static final String EQ = "=";

    public static boolean isEOF(char c) {
        return c == ' ' || c == '\t' || c == '\n' || c == '\r' || c == ';';
    }

    public static long getSQLId(String stmt) {
        int offset = stmt.indexOf(61);
        if (offset != -1 && stmt.length() > ++offset) {
            String id = stmt.substring(offset).trim();
            try {
                return Long.parseLong(id);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0L;
    }

    private static String parseString(String stmt, int offset) {
        StringBuilder sb = new StringBuilder();
        ++offset;
        while (offset < stmt.length()) {
            char c = stmt.charAt(offset);
            if (c == '\\') {
                c = stmt.charAt(++offset);
                switch (c) {
                    case '0': {
                        sb.append('\u0000');
                        break;
                    }
                    case 'b': {
                        sb.append('\b');
                        break;
                    }
                    case 'n': {
                        sb.append('\n');
                        break;
                    }
                    case 'r': {
                        sb.append('\r');
                        break;
                    }
                    case 't': {
                        sb.append('\t');
                        break;
                    }
                    case 'Z': {
                        sb.append('\u001a');
                        break;
                    }
                    default: {
                        sb.append(c);
                        break;
                    }
                }
            } else if (c == '\'') {
                if (offset + 1 >= stmt.length() || stmt.charAt(offset + 1) != '\'') break;
                ++offset;
                sb.append('\'');
            } else {
                sb.append(c);
            }
            ++offset;
        }
        return sb.toString();
    }

    private static String parseString2(String stmt, int offset) {
        StringBuilder sb = new StringBuilder();
        ++offset;
        while (offset < stmt.length()) {
            char c = stmt.charAt(offset);
            if (c == '\\') {
                c = stmt.charAt(++offset);
                switch (c) {
                    case '0': {
                        sb.append('\u0000');
                        break;
                    }
                    case 'b': {
                        sb.append('\b');
                        break;
                    }
                    case 'n': {
                        sb.append('\n');
                        break;
                    }
                    case 'r': {
                        sb.append('\r');
                        break;
                    }
                    case 't': {
                        sb.append('\t');
                        break;
                    }
                    case 'Z': {
                        sb.append('\u001a');
                        break;
                    }
                    default: {
                        sb.append(c);
                        break;
                    }
                }
            } else if (c == '\"') {
                if (offset + 1 >= stmt.length() || stmt.charAt(offset + 1) != '\"') break;
                ++offset;
                sb.append('\"');
            } else {
                sb.append(c);
            }
            ++offset;
        }
        return sb.toString();
    }

    private static String parseIdentifierEscape(String stmt, int offset) {
        StringBuilder sb = new StringBuilder();
        ++offset;
        while (offset < stmt.length()) {
            char c = stmt.charAt(offset);
            if (c == '`') {
                if (offset + 1 >= stmt.length() || stmt.charAt(offset + 1) != '`') break;
                ++offset;
                sb.append('`');
            } else {
                sb.append(c);
            }
            ++offset;
        }
        return sb.toString();
    }

    public static String parseAlias(String stmt, int aliasIndex) {
        int offset;
        if (aliasIndex < 0 || aliasIndex >= stmt.length()) {
            return null;
        }
        switch (stmt.charAt(aliasIndex)) {
            case '\'': {
                return ParseUtil.parseString(stmt, aliasIndex);
            }
            case '\"': {
                return ParseUtil.parseString2(stmt, aliasIndex);
            }
            case '`': {
                return ParseUtil.parseIdentifierEscape(stmt, aliasIndex);
            }
        }
        for (offset = aliasIndex; offset < stmt.length() && CharTypes.isIdentifierChar(stmt.charAt(offset)); ++offset) {
        }
        return stmt.substring(aliasIndex, offset);
    }

    public static int comment(String stmt, int offset) {
        int len = stmt.length();
        int n = offset;
        switch (stmt.charAt(n)) {
            case '/': {
                if (len <= ++n || stmt.charAt(n++) != '*' || len <= n + 1 || stmt.charAt(n) == '!') break;
                for (int i = n; i < len; ++i) {
                    int m;
                    if (stmt.charAt(i) != '*' || len <= (m = i + 1) || stmt.charAt(m) != '/') continue;
                    return m;
                }
                break;
            }
            case '#': {
                for (int i = n + 1; i < len; ++i) {
                    if (stmt.charAt(i) != '\n') continue;
                    return i;
                }
                break;
            }
        }
        return offset;
    }

    public static boolean currentCharIsSep(String stmt, int offset) {
        if (stmt.length() > offset) {
            switch (stmt.charAt(offset)) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    public static boolean nextCharIsSep(String stmt, int offset) {
        return ParseUtil.currentCharIsSep(stmt, ++offset);
    }

    public static int nextStringIsExpectedWithIgnoreSepChar(String stmt, int offset, String nextExpectedString, boolean checkSepChar) {
        int i;
        if (nextExpectedString == null || nextExpectedString.length() < 1) {
            return offset;
        }
        int index = 0;
        for (i = offset; i < stmt.length() && index < nextExpectedString.length(); ++i) {
            char expectedChar;
            char actualChar;
            boolean isSep;
            if (index == 0 && (isSep = ParseUtil.currentCharIsSep(stmt, i)) || (actualChar = stmt.charAt(i)) == (expectedChar = nextExpectedString.charAt(index++))) continue;
            return offset;
        }
        if (index == nextExpectedString.length()) {
            boolean ok = true;
            if (checkSepChar) {
                ok = ParseUtil.nextCharIsSep(stmt, i);
            }
            if (ok) {
                return i;
            }
        }
        return offset;
    }

    public static int nextStringIsJsonEq(String stmt, int offset) {
        int i = offset;
        if (!ParseUtil.currentCharIsSep(stmt, ++i)) {
            return offset;
        }
        int k = ParseUtil.nextStringIsExpectedWithIgnoreSepChar(stmt, i, JSON, false);
        if (k <= i) {
            return offset;
        }
        i = k;
        if ((k = ParseUtil.nextStringIsExpectedWithIgnoreSepChar(stmt, i, EQ, false)) <= i) {
            return offset;
        }
        return i;
    }

    public static int move(String stmt, int offset, int length) {
        int i;
        block4: for (i = offset; i < stmt.length(); ++i) {
            switch (stmt.charAt(i)) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block4;
                }
                case '#': 
                case '/': {
                    i = ParseUtil.comment(stmt, i);
                    continue block4;
                }
                default: {
                    return i + length;
                }
            }
        }
        return i;
    }

    public static boolean compare(String s, int offset, char[] keyword) {
        if (s.length() >= offset + keyword.length) {
            int i = 0;
            while (i < keyword.length) {
                if (Character.toUpperCase(s.charAt(offset)) != keyword[i]) {
                    return false;
                }
                ++i;
                ++offset;
            }
            return true;
        }
        return false;
    }
}

