/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.txc.client;

import com.taobao.txc.client.TxcClientContext;
import com.taobao.txc.client.api.TxcApplicationContext;
import com.taobao.txc.client.api.TxcTransactionManager;
import com.taobao.txc.client.event.TxcTransactionBeginCheckSuccessEvent;
import com.taobao.txc.client.event.support.AutoDegradeHandler;
import com.taobao.txc.client.event.support.ClusterSwitch;
import com.taobao.txc.common.LoggerInit;
import com.taobao.txc.common.LoggerWrap;
import com.taobao.txc.common.config.IConfigCallback;
import com.taobao.txc.common.config.TxcConfigHolder;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class TxcApplicationContextImpl
implements Runnable,
TxcApplicationContext {
    private static final LoggerWrap LOGGER = LoggerInit.logger;
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    private boolean txcDegraded = false;
    private boolean txcAutoDegradeUpgradeEnabled = false;
    private boolean txcClusterSwitchEnabled = false;
    private TxcTransactionManager txcTransactionManager;
    private final ExecutorService executorService = Executors.newSingleThreadExecutor();
    private AtomicInteger continuousTxcServerAvailableCount = new AtomicInteger(0);

    TxcApplicationContextImpl(TxcTransactionManager txcTransactionManager) {
        this.txcTransactionManager = txcTransactionManager;
    }

    @Override
    public TxcTransactionManager getTxcTransactionManager() {
        return this.txcTransactionManager;
    }

    @Override
    public boolean isTxcDegraded() {
        return this.txcDegraded;
    }

    @Override
    public void setTxcDegraded(boolean txcDegraded) {
        LOGGER.info("TXC Degrade Switch is set from " + this.txcDegraded + " to " + txcDegraded);
        this.txcDegraded = txcDegraded;
        if (!TxcClientContext.isTxcDisabled() && TxcClientContext.anyTxcClientEventListener()) {
            this.executorService.submit(this);
            LOGGER.info("TXC Transaction Checking Thread is Triggered.");
        } else {
            LOGGER.info("TXC Transaction Checking Thread is NOT Triggered since No TxcClientEventListener is Listening.");
        }
    }

    @Override
    public boolean isTxcAutoDegradeUpgradeEnabled() {
        return this.txcAutoDegradeUpgradeEnabled;
    }

    public void init() {
        if (this.initialized.compareAndSet(false, true)) {
            TxcConfigHolder.getInstance().getEnableDegrade(new IConfigCallback(){

                @Override
                public void callback(String content) {
                    try {
                        TxcApplicationContextImpl.this.txcAutoDegradeUpgradeEnabled = Boolean.parseBoolean(content);
                        LOGGER.info("Auto Degrade is " + (TxcApplicationContextImpl.this.txcAutoDegradeUpgradeEnabled ? "enabled" : "disabled"));
                        if (TxcApplicationContextImpl.this.txcAutoDegradeUpgradeEnabled) {
                            TxcClientContext.addSystemTxcClientEventListener(AutoDegradeHandler.get());
                        } else {
                            TxcClientContext.removeSystemTxcClientEventListener(AutoDegradeHandler.get());
                        }
                    }
                    catch (Exception e) {
                        LOGGER.warn("Failed to parse txc.degrade.enable=" + content);
                    }
                }
            });
            TxcConfigHolder.getInstance().getEnableClusterSwitch(new IConfigCallback(){

                @Override
                public void callback(String content) {
                    try {
                        TxcApplicationContextImpl.this.txcClusterSwitchEnabled = Boolean.parseBoolean(content);
                        LOGGER.info("Cluster Switch is " + (TxcApplicationContextImpl.this.txcClusterSwitchEnabled ? "enabled" : "disabled"));
                        if (TxcApplicationContextImpl.this.txcClusterSwitchEnabled) {
                            TxcClientContext.addSystemTxcClientEventListener(ClusterSwitch.get());
                        } else {
                            TxcClientContext.removeSystemTxcClientEventListener(ClusterSwitch.get());
                        }
                    }
                    catch (Exception e) {
                        LOGGER.warn("Failed to parse txc.cluster.switch.enable=" + content);
                    }
                }
            });
            LOGGER.info("TxcApplicationContext inited.");
        } else {
            LOGGER.warn("TxcApplicationContext was ALREADY inited.");
        }
    }

    @Override
    public void run() {
        while (this.isTxcDegraded()) {
            LOGGER.info("TXC Transaction Checking ...");
            try {
                this.txcTransactionManager.begin(5000L, "TXC-SDK", "txcTransactionCheck");
                this.txcTransactionManager.commit();
                TxcClientContext.publishEvent(new TxcTransactionBeginCheckSuccessEvent(this, this.continuousTxcServerAvailableCount.incrementAndGet()));
                LOGGER.info("TXC Transaction Checking Success ... ");
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    LOGGER.warn("TXC Transaction Checking Sleep is interrupted ... " + e.getMessage());
                }
            }
            catch (Throwable ex) {
                LOGGER.info("TXC Transaction Checking Fail ... " + ex.getMessage());
                this.continuousTxcServerAvailableCount.set(0);
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    LOGGER.warn("TXC Transaction Checking Sleep is interrupted ... " + e.getMessage());
                }
            }
        }
        LOGGER.info("TXC Transaction Checking End");
    }
}

