/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.txc.client;

import com.taobao.txc.client.TxcApplicationContextImpl;
import com.taobao.txc.client.TxcClientContext;
import com.taobao.txc.client.api.TxcTransactionManager;
import com.taobao.txc.client.api.impl.TxcTransactionManagerImpl;
import com.taobao.txc.common.LoggerInit;
import com.taobao.txc.common.LoggerWrap;
import com.taobao.txc.common.TxcConstants;
import com.taobao.txc.common.TxcRole;
import com.taobao.txc.common.config.DiamondUtil;
import com.taobao.txc.common.config.IConfigCallback;
import com.taobao.txc.common.config.TxcConfigHolder;
import com.taobao.txc.resourcemanager.RmRpcClient;
import com.taobao.txc.resourcemanager.TxcRMMessageListener;
import com.taobao.txc.resourcemanager.TxcResourceManagerImpl;
import com.taobao.txc.resourcemanager.executor.TxcLogManager;
import com.taobao.txc.resourcemanager.mt.MtResourceManager;
import com.taobao.txc.resourcemanager.mt.MtRmRpcClient;
import com.taobao.txc.rpc.impl.RpcClient;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class TxcClient {
    private static final LoggerWrap logger = LoggerInit.logger;
    public static final int AT_MODE = 1;
    public static final int MT_MODE = 2;
    public static final int SERVICE_MODE = 4;
    private static TxcClient txcClient = null;
    private String accessKey;
    private String secretKey;
    private TxcTransactionManager txcTransactionManager = null;
    private RpcClient rpcClient;
    public final ThreadPoolExecutor txcCommonThreadPoolExecutor = new ThreadPoolExecutor(32, 200, 500L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(20000), new ThreadPoolExecutor.CallerRunsPolicy());

    public static TxcClient getInstance(String txcAppName, String txcServerGroup, int mode) {
        return TxcClient.getInstance(txcAppName, txcServerGroup, mode, new HashSet<String>(), null, null, 0);
    }

    public static TxcClient getInstance(String txcAppName, String txcServerGroup, int mode, int clientType) {
        return TxcClient.getInstance(txcAppName, txcServerGroup, mode, new HashSet<String>(), null, null, clientType);
    }

    public static TxcClient getInstance(String txcAppName, String txcServerGroup, int mode, String ak, String sk) {
        return TxcClient.getInstance(txcAppName, txcServerGroup, mode, new HashSet<String>(), ak, sk, 0);
    }

    public static TxcClient getInstance(String txcAppName, String txcServerGroup, int mode, String ak, String sk, int clientType) {
        return TxcClient.getInstance(txcAppName, txcServerGroup, mode, new HashSet<String>(), ak, sk, clientType);
    }

    public static TxcClient createInstance(String txcAppName, String txcServerGroup, int mode, Set<String> txcInsts, String ak, String sk, int clientType) {
        return new TxcClient(txcAppName, txcServerGroup, mode, txcInsts, ak, sk, clientType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TxcClient getInstance(String txcAppName, String txcServerGroup, int mode, Set<String> txcInsts, String ak, String sk, int clientType) {
        if (txcClient != null) return txcClient;
        Class<TxcClient> clazz = TxcClient.class;
        synchronized (TxcClient.class) {
            if (txcClient != null) return txcClient;
            txcClient = new TxcClient(txcAppName, txcServerGroup, mode, txcInsts, ak, sk, clientType);
            // ** MonitorExit[var7_7] (shouldn't be in output)
            return txcClient;
        }
    }

    private TxcClient(String txcAppName, String txcServerGroup, int mode, Set<String> txcInsts, String accessKey, String secretKey, int clientType) {
        if (System.getProperty("txc.appname") != null) {
            txcAppName = System.getProperty("txc.appname");
        }
        if (System.getProperty("txc.servergroup") != null) {
            txcServerGroup = System.getProperty("txc.servergroup");
        }
        if (System.getProperty("txc.mode") != null) {
            mode = Integer.parseInt(System.getProperty("txc.mode"));
        }
        this.accessKey = accessKey;
        this.secretKey = secretKey;
        this.doInit(txcAppName, txcServerGroup, mode, txcInsts, clientType);
    }

    public void doInit(String txcAppName, String txcServerGroup, int mode, Set<String> txcInsts, int clientType) {
        System.out.println("client mode:" + mode + " [0:None (only be client) 1:Default Mode 2:Manual Mode 3:Default Mode & Manual Mode 5:Default Mode & Service Mode 6:Manual Mode & Service Mode 7:Default Mode & Manual Mode &Service Mode]");
        System.out.println("txcAppName:" + txcAppName);
        System.out.println("txcServerGroup:" + txcServerGroup);
        if (DiamondUtil.DEFAULT == null) {
            if (clientType == 0) {
                TxcConfigHolder.setConsoleConfig(true);
            } else {
                DiamondUtil.current();
            }
        }
        TxcConfigHolder.setGroup(txcServerGroup);
        if ((4 & mode) == 0) {
            TxcConstants.role = TxcRole.CLIENT;
            this.rpcClient = RpcClient.getInstance(this.txcCommonThreadPoolExecutor);
            this.rpcClient.setGroup(txcServerGroup);
            this.rpcClient.setClientAppName(txcAppName);
            this.rpcClient.setClientType(clientType);
            this.rpcClient.setTxcInsts(txcInsts);
            this.rpcClient.setAccessKey(this.readAccessKey());
            this.rpcClient.setSecretKey(this.readSecretKey());
            this.rpcClient.init();
            logger.info("RpcClient inited. client mode:" + mode + " txcAppName:" + txcAppName + " txcServerGroup:" + txcServerGroup);
            TxcTransactionManagerImpl txcTransactionManagerImpl = TxcTransactionManagerImpl.getInstance();
            txcTransactionManagerImpl.setClientMessageSender(this.rpcClient);
            txcTransactionManagerImpl.init();
            this.txcTransactionManager = txcTransactionManagerImpl;
            TxcApplicationContextImpl txcApplicationContext = new TxcApplicationContextImpl(txcTransactionManagerImpl);
            txcApplicationContext.init();
            TxcClientContext.setTxcApplicationContext(txcApplicationContext);
            logger.info("TxcTransactionManager inited");
            TxcConfigHolder.getInstance().getRuleDynamic("txc.dummy", txcAppName, new IConfigCallback(){

                @Override
                public void callback(String content) {
                    logger.info(String.format("TxcClient dummy rule notified: %s", content));
                }
            });
        } else {
            TxcConstants.role = TxcRole.PARTICIPANT;
        }
        logger.info("txc role is:" + (Object)((Object)TxcConstants.role));
        TxcRMMessageListener txcRmMessageListener = null;
        if ((1 & mode) > 0) {
            RmRpcClient rmRpcClient = RmRpcClient.getInstance(this.txcCommonThreadPoolExecutor);
            rmRpcClient.setAppName(txcAppName);
            rmRpcClient.init();
            logger.info("RmRpcClient inited");
            TxcResourceManagerImpl txcResourceManager = TxcResourceManagerImpl.getTxcResourceManager();
            txcResourceManager.setClientMessageSender(rmRpcClient);
            txcResourceManager.setTxcSqlLogManager(new TxcLogManager());
            txcResourceManager.init();
            logger.info("TxcResourceManager inited");
            txcRmMessageListener = new TxcRMMessageListener();
            txcRmMessageListener.setRmRpcClient(rmRpcClient);
            txcRmMessageListener.setResourceManager(txcResourceManager);
            txcRmMessageListener.init();
            logger.info("AT TxcRMMessageListener inited");
        }
        if ((2 & mode) > 0) {
            MtRmRpcClient mtRmRpcClient = MtRmRpcClient.getInstance(this.txcCommonThreadPoolExecutor);
            mtRmRpcClient.setAppName(txcAppName);
            mtRmRpcClient.init();
            logger.info("MtRmRpcClient inited");
            MtResourceManager mtResourceManager = MtResourceManager.getTxcResourceManager();
            mtResourceManager.setClientMessageSender(mtRmRpcClient);
            mtResourceManager.init();
            logger.info("MtResourceManager inited");
            if (txcRmMessageListener == null) {
                txcRmMessageListener = new TxcRMMessageListener();
            }
            txcRmMessageListener.setMtRmRpcClient(mtRmRpcClient);
            txcRmMessageListener.setMtResourceManager(mtResourceManager);
            txcRmMessageListener.init();
            logger.info("MT TxcRMMessageListener inited");
        }
    }

    public TxcTransactionManager getTxcTransactionManager() {
        return this.txcTransactionManager;
    }

    public String readAccessKey() {
        if (this.accessKey == null || this.accessKey.isEmpty()) {
            this.accessKey = System.getProperty("txc.accesskey");
        }
        return this.accessKey;
    }

    public String readSecretKey() {
        if (this.secretKey == null || this.secretKey.isEmpty()) {
            this.secretKey = System.getProperty("txc.secretkey");
        }
        return this.secretKey;
    }

    public RpcClient getRpcClient() {
        return this.rpcClient;
    }
}

