/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.txc.client;

import com.taobao.txc.client.api.TxcApplicationContext;
import com.taobao.txc.client.event.TxcClientEvent;
import com.taobao.txc.client.event.TxcClientEventListener;
import com.taobao.txc.common.LoggerInit;
import com.taobao.txc.common.LoggerWrap;
import java.util.ArrayList;

public class TxcClientContext {
    private static final LoggerWrap LOGGER = LoggerInit.logger;
    private static TxcApplicationContext APPLICATION_TXC_TRANSACTION_CONTEXT;
    private static ArrayList<TxcClientEventListener> SYSTEM_LISTENERS;
    private static ArrayList<TxcClientEventListener> USER_LISTENERS;
    private static boolean TXC_DISABLED;
    private static boolean USER_DISABLE_TXC;

    public static void setTxcDisabled(boolean disabled) {
        TXC_DISABLED = disabled;
    }

    public static void setUserDisableTxc(boolean userDisableTxc) {
        USER_DISABLE_TXC = userDisableTxc;
    }

    public static boolean isTxcDisabled() {
        return TXC_DISABLED || USER_DISABLE_TXC;
    }

    public static TxcApplicationContext getTxcApplicationContext() {
        if (APPLICATION_TXC_TRANSACTION_CONTEXT == null) {
            throw new RuntimeException("TxcApplicationContext is NOT ready.");
        }
        return APPLICATION_TXC_TRANSACTION_CONTEXT;
    }

    public static void setTxcApplicationContext(TxcApplicationContext applicationTxcTransactionContext) {
        APPLICATION_TXC_TRANSACTION_CONTEXT = applicationTxcTransactionContext;
    }

    public static boolean anyTxcClientEventListener() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("SYSTEM_LISTENERS: " + SYSTEM_LISTENERS);
            LOGGER.debug("USER_LISTENERS: " + USER_LISTENERS);
        }
        return !SYSTEM_LISTENERS.isEmpty() || !USER_LISTENERS.isEmpty();
    }

    public static void addSystemTxcClientEventListener(TxcClientEventListener listener) {
        if (SYSTEM_LISTENERS.contains(listener)) {
            return;
        }
        SYSTEM_LISTENERS.add(listener);
    }

    public static void removeSystemTxcClientEventListener(TxcClientEventListener listener) {
        if (!SYSTEM_LISTENERS.contains(listener)) {
            return;
        }
        SYSTEM_LISTENERS.remove(listener);
    }

    public static void addUserTxcClientEventListener(TxcClientEventListener listener) {
        if (USER_LISTENERS.contains(listener)) {
            return;
        }
        USER_LISTENERS.add(listener);
    }

    public static void removeUserTxcClientEventListener(TxcClientEventListener listener) {
        if (!USER_LISTENERS.contains(listener)) {
            return;
        }
        USER_LISTENERS.remove(listener);
    }

    public static void publishEvent(TxcClientEvent event) {
        for (TxcClientEventListener listener : SYSTEM_LISTENERS) {
            listener.onEvent(event);
        }
        for (TxcClientEventListener listener : USER_LISTENERS) {
            listener.onEvent(event);
        }
    }

    static {
        SYSTEM_LISTENERS = new ArrayList();
        USER_LISTENERS = new ArrayList();
        TXC_DISABLED = false;
        USER_DISABLE_TXC = false;
    }
}

