/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.txc.client;

import com.taobao.txc.client.TxcClient;
import com.taobao.txc.common.exception.TxcException;
import com.taobao.txc.common.spring.CommonClient;
import java.util.HashSet;
import org.apache.commons.lang.StringUtils;

public class TxcTransaction
extends CommonClient {
    private TxcClient txcClient = null;
    private String txcVgroup = null;
    private static TxcTransaction _instance;

    public static TxcTransaction createInstance(String txcAppName, String txcVgroup, int mode, String accessKey, String secretKey) {
        if (StringUtils.isEmpty((String)txcVgroup) || StringUtils.isEmpty((String)accessKey) || StringUtils.isEmpty((String)secretKey)) {
            throw new RuntimeException("input parameter for create TxcTransaction is invalid!");
        }
        TxcClient txcClient = TxcClient.getInstance(txcAppName, txcVgroup, mode, null, accessKey, secretKey, 0);
        TxcTransaction txcTransaction = new TxcTransaction();
        txcTransaction.txcClient = txcClient;
        txcTransaction.txcVgroup = txcVgroup;
        return txcTransaction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TxcTransaction getInstance(String txcAppName, String txcVgroup, int mode, String accessKey, String secretKey) {
        if (StringUtils.isEmpty((String)txcVgroup) || StringUtils.isEmpty((String)accessKey) || StringUtils.isEmpty((String)secretKey)) {
            throw new RuntimeException("input parameter for create TxcTransaction is invalid!");
        }
        if (_instance != null) return _instance;
        Class<TxcTransaction> clazz = TxcTransaction.class;
        synchronized (TxcTransaction.class) {
            if (_instance != null) return _instance;
            TxcClient txcClient = TxcClient.getInstance(txcAppName, txcVgroup, mode, null, accessKey, secretKey, 0);
            _instance = new TxcTransaction();
            TxcTransaction._instance.txcClient = txcClient;
            TxcTransaction._instance.txcVgroup = txcVgroup;
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return _instance;
        }
    }

    public static TxcTransaction getInstance(String txcAppName, String txcVgroup, String accessKey, String secretKey) {
        return TxcTransaction.getInstance(txcAppName, txcVgroup, 1, accessKey, secretKey);
    }

    public static TxcTransaction getInstance(String txcVgroup, String accessKey, String secretKey) {
        return TxcTransaction.getInstance(txcVgroup, txcVgroup, accessKey, secretKey);
    }

    public static TxcTransaction createInstance(String txcAppName, String txcServerGroup) {
        if (StringUtils.isEmpty((String)txcAppName) || StringUtils.isEmpty((String)txcServerGroup)) {
            throw new RuntimeException("input parameter for create TxcTransaction is invalid!");
        }
        TxcClient txcClient = TxcClient.createInstance(txcAppName, txcServerGroup, 1, new HashSet<String>(), null, null, 0);
        TxcTransaction txcTransaction = new TxcTransaction();
        txcTransaction.txcClient = txcClient;
        txcTransaction.txcVgroup = txcAppName;
        return txcTransaction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TxcTransaction getInstance(String txcAppName, String txcServerGroup) {
        if (StringUtils.isEmpty((String)txcAppName) || StringUtils.isEmpty((String)txcServerGroup)) {
            throw new RuntimeException("input parameter for create TxcTransaction is invalid!");
        }
        if (_instance != null) return _instance;
        Class<TxcTransaction> clazz = TxcTransaction.class;
        synchronized (TxcTransaction.class) {
            if (_instance != null) return _instance;
            TxcClient txcClient = TxcClient.getInstance(txcAppName, txcServerGroup, 1);
            _instance = new TxcTransaction();
            TxcTransaction._instance.txcClient = txcClient;
            TxcTransaction._instance.txcVgroup = txcAppName;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return _instance;
        }
    }

    public void begin(long timeout) throws TxcException {
        String txcInst = this.getMethodFullName();
        this.txcClient.getTxcTransactionManager().begin(timeout, this.txcVgroup, txcInst);
    }

    public void commit() throws TxcException {
        this.txcClient.getTxcTransactionManager().commit();
    }

    public void rollback() throws TxcException {
        this.txcClient.getTxcTransactionManager().rollback();
    }

    private String getMethodFullName() {
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        if (stackTraceElements.length < 4) {
            throw new RuntimeException("caller stack is incomplete!");
        }
        StackTraceElement e = stackTraceElements[3];
        return e.getClassName() + "." + e.getMethodName();
    }
}

