/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.txc.client.aop;

import com.taobao.txc.client.utils.ApplicationUtils;
import com.taobao.txc.common.LoggerInit;
import com.taobao.txc.common.LoggerWrap;
import com.taobao.txc.common.exception.TxcErrCode;
import com.taobao.txc.common.exception.TxcException;
import com.taobao.txc.resourcemanager.mt.MtResourceManager;
import java.util.HashMap;
import org.apache.commons.lang.ClassUtils;
import org.springframework.aop.framework.autoproxy.BeanNameAutoProxyCreator;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;

public class MTRelationShipManager
extends BeanNameAutoProxyCreator
implements ApplicationListener {
    private static final LoggerWrap logger = LoggerInit.logger;
    private static final long serialVersionUID = -3000433421888634191L;
    private HashMap<String, Object> mtServiceMap = new HashMap();
    private MtResourceManager mtResourceManager = null;
    private String[] beanNames = new String[0];
    private Object bean;

    public MTRelationShipManager() {
        this.setOrder(1);
        logger.info("MTRelationShipManager construct init order=1");
    }

    public void setBeanNames(String[] beanNames) {
        this.beanNames = beanNames;
        super.setBeanNames(beanNames);
    }

    protected synchronized Object wrapIfNecessary(Object bean, String beanName, Object cacheKey) {
        if (bean instanceof MtResourceManager) {
            this.mtResourceManager = (MtResourceManager)bean;
            return bean;
        }
        this.bean = bean;
        return super.wrapIfNecessary(bean, beanName, cacheKey);
    }

    protected boolean isMatch(String beanName, String mappedName) {
        boolean matchResult = false;
        try {
            Class interfaceClass = ClassUtils.getClass((String)mappedName);
            if (interfaceClass.isInstance(this.bean)) {
                this.mtServiceMap.put(mappedName, this.bean);
                matchResult = true;
            } else {
                matchResult = false;
            }
        }
        catch (ClassNotFoundException e) {
            matchResult = false;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("test beanName:" + beanName + " mappedName:" + mappedName + " result:" + matchResult);
        }
        return matchResult;
    }

    public void onApplicationEvent(ApplicationEvent event) {
        logger.info("Received ApplicationEvent " + event);
        if (ApplicationUtils.isSuitEvent(event)) {
            logger.info(event + " MTRelationShipManager onApplicationEvent init finished!");
            if (this.mtResourceManager == null) {
                this.mtResourceManager = MtResourceManager.getTxcResourceManager();
            }
            if (this.mtResourceManager != null && this.mtServiceMap.size() == this.beanNames.length) {
                this.mtResourceManager.setMtServices(this.mtServiceMap);
                try {
                    this.mtResourceManager.init();
                }
                catch (Throwable e) {
                    throw TxcException.nestedException(new TxcException(e, "unexpected error", TxcErrCode.MTResourceManagerInitError));
                }
            } else {
                if (this.mtResourceManager == null) {
                    throw TxcException.nestedException(new TxcException("MtResourceManager not be found!", TxcErrCode.MTResourceManagerNotDefined));
                }
                for (String bn : this.beanNames) {
                    if (this.mtServiceMap.containsKey(bn)) continue;
                    throw TxcException.nestedException(new TxcException(String.format("The instance of %s not be found!", bn), TxcErrCode.InstanceNotFoundInSpringContext));
                }
            }
        }
    }
}

