/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.txc.client.aop;

import com.taobao.txc.client.TxcClientContext;
import com.taobao.txc.client.aop.MethodDesc;
import com.taobao.txc.client.aop.annotation.Propagation;
import com.taobao.txc.client.aop.annotation.TxcModel;
import com.taobao.txc.client.aop.annotation.TxcTransaction;
import com.taobao.txc.client.template.TxcCallback;
import com.taobao.txc.client.template.TxcTransactionTemplate;
import com.taobao.txc.common.LoggerInit;
import com.taobao.txc.common.LoggerWrap;
import com.taobao.txc.common.util.string.TxcString;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

public class TransactionTxcInterceptor
implements MethodInterceptor {
    private static final LoggerWrap logger = LoggerInit.logger;
    private final TxcTransactionTemplate template = new TxcTransactionTemplate();
    private volatile HashMap<Object, TxcTransaction> methodMap = new HashMap();
    protected static final TxcTransaction NULL = new TxcTransaction(){

        @Override
        public Class<? extends Annotation> annotationType() {
            return null;
        }

        @Override
        public int timeout() {
            return 0;
        }

        @Override
        public TxcModel type() {
            return null;
        }

        @Override
        public int effectiveTime() {
            return 0;
        }

        @Override
        public String appName() {
            return null;
        }

        @Override
        public Propagation propagation() {
            return null;
        }
    };

    public TransactionTxcInterceptor(List<MethodDesc> list) {
        for (MethodDesc md : list) {
            logger.info("add:" + md.getM());
            this.methodMap.put(TransactionTxcInterceptor.formatMethod(md.getM()), md.getTrasactionAnnotation());
        }
    }

    public Object invoke(final MethodInvocation arg0) throws Throwable {
        TxcTransaction txc = this.getTxcTransaction(arg0);
        if (txc != NULL) {
            if (txc.type() == TxcModel.RT) {
                return this.template.runRT(new TxcCallback(){

                    @Override
                    public Object callback() throws Throwable {
                        return arg0.proceed();
                    }
                }, txc.effectiveTime());
            }
            if (!TxcClientContext.isTxcDisabled() && !TxcClientContext.getTxcApplicationContext().isTxcDegraded() && txc.type() == TxcModel.ATMT) {
                return this.template.runATMT(new TxcCallback(){

                    @Override
                    public Object callback() throws Throwable {
                        return arg0.proceed();
                    }
                }, txc.timeout(), TxcString.limitAppName(txc.appName()), TxcString.makeTxcAnnoMethodStr(arg0.getMethod()), txc.propagation());
            }
        }
        return arg0.proceed();
    }

    private static String formatMethod(Method method) {
        StringBuilder sb = new StringBuilder();
        String mehodName = method.getName();
        Class<?>[] params = method.getParameterTypes();
        sb.append(mehodName);
        sb.append("(");
        int paramPos = 0;
        for (Class<?> claz : params) {
            sb.append(claz.getName());
            if (++paramPos >= params.length) continue;
            sb.append(",");
        }
        sb.append(")");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TxcTransaction getTxcTransaction(MethodInvocation arg0) {
        TxcTransaction txc = this.methodMap.get(arg0.getMethod());
        if (txc == null) {
            TransactionTxcInterceptor transactionTxcInterceptor = this;
            synchronized (transactionTxcInterceptor) {
                txc = this.methodMap.get(arg0.getMethod());
                if (txc == null) {
                    String methodStringDesc = TransactionTxcInterceptor.formatMethod(arg0.getMethod());
                    txc = this.methodMap.get(methodStringDesc);
                    if (txc == null) {
                        txc = NULL;
                    }
                    HashMap<Object, TxcTransaction> newMap = new HashMap<Object, TxcTransaction>();
                    newMap.putAll(this.methodMap);
                    newMap.remove(methodStringDesc);
                    newMap.put(arg0.getMethod(), txc);
                    this.methodMap = newMap;
                }
            }
        }
        if (logger.isDebugEnabled()) {
            if (txc != NULL) {
                logger.debug("Y:" + arg0.getMethod());
            } else {
                logger.debug("N:" + arg0.getMethod());
            }
        }
        return txc;
    }
}

