/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.txc.client.aop;

import com.taobao.txc.client.TxcClient;
import com.taobao.txc.client.TxcClientContext;
import com.taobao.txc.client.aop.MethodDesc;
import com.taobao.txc.client.aop.TransactionTxcInterceptor;
import com.taobao.txc.client.aop.TxcClientInitDoneEvent;
import com.taobao.txc.client.aop.annotation.TxcTransaction;
import com.taobao.txc.client.degrade.TxcDegradeChecker;
import com.taobao.txc.client.degrade.TxcUserDegrade;
import com.taobao.txc.client.event.TxcClientEventListener;
import com.taobao.txc.client.utils.ApplicationUtils;
import com.taobao.txc.common.LoggerInit;
import com.taobao.txc.common.LoggerWrap;
import com.taobao.txc.common.config.DiamondUtil;
import com.taobao.txc.common.config.TxcConfigHolder;
import com.taobao.txc.common.exception.TxcErrCode;
import com.taobao.txc.common.exception.TxcException;
import com.taobao.txc.common.spring.CommonScanner;
import com.taobao.txc.common.util.string.TxcString;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.springframework.aop.Advisor;
import org.springframework.aop.TargetSource;
import org.springframework.aop.framework.AdvisedSupport;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;

public class TxcTransactionScaner
extends CommonScanner
implements InitializingBean,
ApplicationContextAware {
    private static final LoggerWrap logger = LoggerInit.logger;
    private static final long serialVersionUID = -8650586520064930251L;
    private static final Set<String> proxyedSet = new HashSet<String>();
    private TransactionTxcInterceptor interceptor;
    private String txcAppName = null;
    private String txcServerGroup = null;
    private int mode = -1;
    private String accessKey;
    private String secretKey;
    private static final Set<String> txcAnnoMethods = new HashSet<String>();
    private boolean txcClientInitDone = false;
    private boolean txcClientInitDoneEventPublished = false;
    private boolean initAfterContextComplete = false;
    private TxcUserDegrade userDegrade;
    private TxcDegradeChecker txcDegradeChecker;
    private ApplicationContext applicationContext;

    public void setInitAfterContextComplete(boolean initAfterContextComplete) {
        this.initAfterContextComplete = initAfterContextComplete;
    }

    public TxcTransactionScaner() {
        this.setOrder(2);
        this.setProxyTargetClass(true);
        try {
            if (DiamondUtil.DEFAULT == null) {
                TxcConfigHolder.setConsoleConfig(true);
            }
        }
        catch (Exception e) {
            logger.warn("something wrong with scanner init ... " + e.getMessage());
        }
        logger.info("txc trasaction scaner initing.... use default client");
    }

    private boolean shouldInitAfterContextComplete() {
        if ((2 & this.mode) > 0) {
            return true;
        }
        return this.initAfterContextComplete;
    }

    public TxcTransactionScaner(String vgroup) {
        this(vgroup, 1);
    }

    public TxcTransactionScaner(String vgroup, int mode) {
        this(vgroup, vgroup, mode);
    }

    public TxcTransactionScaner(String txcAppName, String vgroup) {
        this(txcAppName, vgroup, 1);
    }

    public TxcTransactionScaner(String txcAppName, String vgroup, int mode) {
        this(txcAppName, vgroup, mode, null);
    }

    public TxcTransactionScaner(String txcAppName, String vgroup, int mode, String url) {
        this.setOrder(2);
        this.setProxyTargetClass(true);
        try {
            if (!StringUtils.isEmpty((String)url)) {
                TxcConfigHolder.setConsoleConfig(true, url);
            } else if (DiamondUtil.DEFAULT == null) {
                TxcConfigHolder.setConsoleConfig(true);
            }
        }
        catch (Exception e) {
            logger.warn("something wrong with scanner init ... " + e.getMessage());
        }
        this.txcAppName = txcAppName;
        this.txcServerGroup = vgroup;
        this.mode = mode;
        logger.info("txc trasaction scaner initing...." + String.format("txcAppName:%s,txcServerGroup:%s,mode:%d", txcAppName, this.txcServerGroup, mode));
    }

    public TxcTransactionScaner(String txcAppName, String txcServerGroup, int mode, int isolation) {
        this(txcAppName, txcServerGroup, mode);
    }

    private void InitTxcClient() {
        if (StringUtils.isEmpty((String)this.txcAppName) || StringUtils.isEmpty((String)this.txcServerGroup)) {
            throw new TxcException("txcAppName or txcServerGroup is null", TxcErrCode.InitTxcClientError);
        }
        TxcClient.getInstance(this.txcAppName, this.txcServerGroup, this.mode, txcAnnoMethods, this.accessKey, this.secretKey, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object wrapIfNecessary(Object bean, String beanName, Object cacheKey) {
        if (TxcClientContext.isTxcDisabled()) {
            return bean;
        }
        try {
            if (bean instanceof TxcClientEventListener) {
                TxcClientContext.addUserTxcClientEventListener((TxcClientEventListener)bean);
                logger.info("Add TxcClientEventListener " + beanName + " " + bean);
            }
            Set<String> set = proxyedSet;
            synchronized (set) {
                if (proxyedSet.contains(beanName)) {
                    return bean;
                }
                proxyedSet.add(beanName);
                Class<?> serviceInterface = this.findTargetClass(bean);
                Method[] methods = serviceInterface.getMethods();
                LinkedList<MethodDesc> methodDescList = new LinkedList<MethodDesc>();
                for (Method method : methods) {
                    TxcTransaction anno = this.resolveTxcTransaction(method);
                    if (anno == null) continue;
                    methodDescList.add(this.makeMethodDesc(anno, method));
                    txcAnnoMethods.add(TxcString.makeTxcAnnoMethodStr(method));
                }
                if (methodDescList.size() == 0) {
                    return bean;
                }
                this.interceptor = new TransactionTxcInterceptor(methodDescList);
                if (!AopUtils.isAopProxy((Object)bean)) {
                    bean = super.wrapIfNecessary(bean, beanName, cacheKey);
                } else {
                    Advisor[] advisor;
                    AdvisedSupport advised = this.getAdvisedSupport(bean);
                    for (Advisor avr : advisor = this.buildAdvisors(beanName, this.getAdvicesAndAdvisorsForBean(null, null, null))) {
                        advised.addAdvisor(0, avr);
                    }
                }
                return bean;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected TxcTransaction resolveTxcTransaction(Method method) {
        return method.getAnnotation(TxcTransaction.class);
    }

    private MethodDesc makeMethodDesc(Object bean, Method m) {
        TxcTransaction anno = this.resolveTxcTransaction(m);
        return new MethodDesc(anno, m);
    }

    private Class<?> findTargetClass(Object proxy) throws Exception {
        if (AopUtils.isAopProxy((Object)proxy)) {
            AdvisedSupport advised = this.getAdvisedSupport(proxy);
            if (advised.getTargetSource() == null || advised.getTargetSource().getTarget() == null) {
                return proxy.getClass();
            }
            Object target = advised.getTargetSource().getTarget();
            return this.findTargetClass(target);
        }
        return proxy.getClass();
    }

    private AdvisedSupport getAdvisedSupport(Object proxy) throws Exception {
        Field h = AopUtils.isJdkDynamicProxy((Object)proxy) ? proxy.getClass().getSuperclass().getDeclaredField("h") : proxy.getClass().getDeclaredField("CGLIB$CALLBACK_0");
        h.setAccessible(true);
        Object dynamicAdvisedInterceptor = h.get(proxy);
        Field advised = dynamicAdvisedInterceptor.getClass().getDeclaredField("advised");
        advised.setAccessible(true);
        return (AdvisedSupport)advised.get(dynamicAdvisedInterceptor);
    }

    protected Object[] getAdvicesAndAdvisorsForBean(Class beanClass, String beanName, TargetSource customTargetSource) throws BeansException {
        return new Object[]{this.interceptor};
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof TxcClientInitDoneEvent) {
            return;
        }
        if (!this.shouldInitAfterContextComplete()) {
            if (!this.txcClientInitDoneEventPublished) {
                this.applicationContext.publishEvent((ApplicationEvent)new TxcClientInitDoneEvent(this.applicationContext));
                logger.info("TxcClientInitDoneEvent is published after PropertiesSet. Triggered By " + event);
                this.txcClientInitDoneEventPublished = true;
            }
            return;
        }
        logger.info("Received ApplicationEvent " + event);
        if (ApplicationUtils.isSuitEvent(event)) {
            logger.info(event + " TxcTransactionScaner onApplicationEvent init finished");
            if (!TxcClientContext.isTxcDisabled()) {
                this.InitTxcClient();
                this.txcClientInitDone = true;
                if (!this.txcClientInitDoneEventPublished) {
                    if (this.applicationContext != null) {
                        this.applicationContext.publishEvent((ApplicationEvent)new TxcClientInitDoneEvent(this.applicationContext));
                        logger.info("TxcClientInitDoneEvent is published after " + event + ".");
                    }
                    this.txcClientInitDoneEventPublished = true;
                }
            }
        }
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public void afterPropertiesSet() throws Exception {
        this.txcDegradeChecker = new TxcDegradeChecker(this.txcServerGroup, this.userDegrade);
        this.txcDegradeChecker.init();
        if (this.shouldInitAfterContextComplete()) {
            return;
        }
        if (!TxcClientContext.isTxcDisabled()) {
            this.InitTxcClient();
            this.txcClientInitDone = true;
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setUserDegrade(TxcUserDegrade userDegrade) {
        this.userDegrade = userDegrade;
    }
}

