/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.txc.client.api.impl;

import com.taobao.txc.client.api.TxcTransactionManager;
import com.taobao.txc.common.LoggerInit;
import com.taobao.txc.common.LoggerWrap;
import com.taobao.txc.common.TxcContext;
import com.taobao.txc.common.TxcXID;
import com.taobao.txc.common.analyze.AnalyzeLogger;
import com.taobao.txc.common.config.TxcConfigHolder;
import com.taobao.txc.common.exception.RollbackOnlyException;
import com.taobao.txc.common.exception.TxcErrCode;
import com.taobao.txc.common.exception.TxcException;
import com.taobao.txc.common.message.AbstractResultMessage;
import com.taobao.txc.common.message.BeginMessage;
import com.taobao.txc.common.message.BeginResultMessage;
import com.taobao.txc.common.message.GlobalCommitMessage;
import com.taobao.txc.common.message.GlobalCommitResultMessage;
import com.taobao.txc.common.message.GlobalRollbackMessage;
import com.taobao.txc.common.message.GlobalRollbackResultMessage;
import com.taobao.txc.common.message.ResultCode;
import com.taobao.txc.common.task.TaskParameter;
import com.taobao.txc.resourcemanager.limit.ClientLimitationHelper;
import com.taobao.txc.resourcemanager.mt.service.MtServiceTask;
import com.taobao.txc.resourcemanager.mt.service.MtServiceTaskImpl;
import com.taobao.txc.rpc.api.TxcClientMessageSender;
import com.taobao.txc.rpc.impl.RpcClient;
import java.net.ConnectException;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

public class TxcTransactionManagerImpl
implements TxcTransactionManager {
    private static final LoggerWrap logger = LoggerInit.logger;
    private TxcClientMessageSender clientMessageSender;
    private MtServiceTask mtServiceTask;
    public static BlockingQueue<String> begunTranIds = new LinkedBlockingQueue<String>();
    public static BlockingQueue<Long> committedTranIds = new LinkedBlockingQueue<Long>();
    private static Set<String> decreasedWeightServerSet = Collections.synchronizedSet(new HashSet());
    private static TxcTransactionManagerImpl instance = null;

    private TxcTransactionManagerImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TxcTransactionManagerImpl getInstance() {
        if (instance != null) return instance;
        Class<TxcTransactionManagerImpl> clazz = TxcTransactionManagerImpl.class;
        synchronized (TxcTransactionManagerImpl.class) {
            if (instance != null) return instance;
            instance = new TxcTransactionManagerImpl();
            new Thread(new Runnable(){

                @Override
                public void run() {
                    while (true) {
                        if (begunTranIds.size() > 0 || committedTranIds.size() > 0) {
                            StringBuilder builder = new StringBuilder();
                            while (!begunTranIds.isEmpty()) {
                                builder.append((String)begunTranIds.poll()).append(" ");
                            }
                            int len = builder.length();
                            if (len > 0) {
                                builder.append("begin. \t");
                            }
                            len = builder.length();
                            while (!committedTranIds.isEmpty()) {
                                builder.append(committedTranIds.poll()).append(" ");
                            }
                            if (builder.length() > len) {
                                builder.append("commit finished.");
                            }
                            logger.info(builder.toString());
                        }
                        try {
                            Thread.sleep(10L);
                            continue;
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                            continue;
                        }
                        break;
                    }
                }
            }).start();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public TxcClientMessageSender getClientMessageSender() {
        return this.clientMessageSender;
    }

    public void setClientMessageSender(TxcClientMessageSender clientMessageSender) {
        this.clientMessageSender = clientMessageSender;
    }

    public MtServiceTask getMtServiceTask() {
        return this.mtServiceTask;
    }

    public void setMtServiceTask(MtServiceTask mtServiceTask) {
        this.mtServiceTask = mtServiceTask;
    }

    @Override
    public void commit() throws TxcException {
        this.commit(5);
    }

    @Override
    public void rollback() throws TxcException {
        this.rollback(0);
    }

    @Override
    public void begin(long timeout) throws TxcException {
        this.begin(timeout, null, null);
    }

    @Override
    public void begin(long timeout, String appname, String txcInst) throws TxcException {
        if (TxcContext.inRetryContext()) {
            throw new TxcException("This transaction has been RT model!", TxcErrCode.TxcTransactionModeError);
        }
        int beginCount = TxcContext.getBeginCount();
        if (logger.isDebugEnabled()) {
            logger.debug("beginCount:" + beginCount + ", commitCount:" + TxcContext.getCommitCount() + ", inTxcTransaction:" + TxcContext.inTxcTransaction());
        }
        if (beginCount > 0 && !TxcContext.inTxcTransaction()) {
            logger.warn("beginCount:" + beginCount + ",commitCount:" + TxcContext.getCommitCount() + " not in transaction.");
            TxcContext.clearReenterCounter();
            if (TxcContext.isRollbackOnly()) {
                TxcContext.setRollbackOnly(false);
            }
            beginCount = 0;
        }
        TxcContext.setBegin(++beginCount);
        if (beginCount == 1) {
            if (TxcContext.isRollbackOnly()) {
                TxcContext.setRollbackOnly(false);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Trying to begin a new GlobalTransaction");
            }
            this._begin(timeout, appname, txcInst);
            if (logger.isDebugEnabled()) {
                logger.debug("New GlobalTransaction XID: " + TxcContext.getCurrentXid());
            }
        } else {
            logger.info("nesting transaction, level:" + beginCount + ",xid:" + TxcContext.getCurrentXid());
        }
    }

    @Override
    public void commit(int retry) throws TxcException {
        if (TxcContext.isRollbackOnly()) {
            TxcContext.clearReenterCounter();
            logger.info("Should NOT commit a transaction(" + TxcContext.getCurrentXid() + ") which has been marked as rollbackOnly.");
            throw new RollbackOnlyException();
        }
        int commitCount = TxcContext.getCommitCount();
        int beginCount = TxcContext.getBeginCount();
        TxcContext.setCommitCount(++commitCount);
        if (commitCount >= beginCount) {
            TxcContext.clearReenterCounter();
            if (TxcContext.inTxcTransaction()) {
                this._commit(retry);
            }
        }
    }

    @Override
    public void rollback(int retry) throws TxcException {
        TxcContext.clearReenterCounter();
        if (TxcContext.inTxcTransaction()) {
            this._rollback(retry);
        }
    }

    private void _begin(long timeout, String appname, String txcInst) {
        BeginMessage beginMessage = new BeginMessage();
        beginMessage.setTimeout(timeout);
        beginMessage.setAppname(appname);
        beginMessage.setTxcInst(txcInst);
        ClientLimitationHelper.getInstance().handleMessage(beginMessage);
        try {
            this._begin(beginMessage);
        }
        catch (Throwable th) {
            TxcContext.clearReenterCounter();
            ClientLimitationHelper.getInstance().handleException(beginMessage, th);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _begin(BeginMessage beginMessage) {
        block30: {
            BeginResultMessage resultMessage;
            block29: {
                long start = 0L;
                if (logger.isDebugEnabled()) {
                    start = System.currentTimeMillis();
                }
                resultMessage = null;
                try {
                    resultMessage = (BeginResultMessage)this.clientMessageSender.invoke(beginMessage, 30000L);
                    if (resultMessage.getResult() != ResultCode.OK.getValue()) {
                        throw new TxcException(resultMessage.getResult(), resultMessage.getMsg());
                    }
                    String nextSvrAddr = resultMessage.getNextSvrAddr();
                    int idx = nextSvrAddr.lastIndexOf(":") + 1;
                    int port = Integer.parseInt(nextSvrAddr.substring(idx)) - 1000;
                    TxcContext.bind(resultMessage.getXid(), nextSvrAddr.substring(0, idx) + port);
                    if (RpcClient.weightRule != null && decreasedWeightServerSet.size() > 0 && decreasedWeightServerSet.contains(TxcContext.getCurrentServer())) {
                        List<RpcClient.TxcWeight> list = RpcClient.getWeightList();
                        synchronized (list) {
                            boolean b = decreasedWeightServerSet.remove(TxcContext.getCurrentServer());
                            if (b) {
                                String addr = TxcContext.getCurrentServer();
                                for (RpcClient.TxcWeight weight : RpcClient.getWeightList()) {
                                    if (!addr.equals(weight.getAddr())) continue;
                                    weight.setLogicValue(weight.getValue());
                                    RpcClient.resetRandomVauleToAddrMap();
                                    break;
                                }
                            }
                        }
                    }
                    if (!logger.isDebugEnabled()) break block29;
                }
                catch (Throwable th) {
                    try {
                        int idx;
                        String msg;
                        if (RpcClient.weightRule != null && th instanceof ConnectException) {
                            int idx2;
                            String msg2 = th.getMessage();
                            if (msg2 != null && (idx2 = msg2.lastIndexOf("/")) > 0) {
                                String addr = msg2.substring(idx2 + 1);
                                String vipAddress = TxcConfigHolder.getInstance().lookupVIP(addr);
                                if (vipAddress != null) {
                                    RpcClient.getInstance().releaseChannel(null, vipAddress);
                                }
                                RpcClient.getInstance().releaseChannel(null, addr);
                                List<RpcClient.TxcWeight> list = RpcClient.getWeightList();
                                synchronized (list) {
                                    for (RpcClient.TxcWeight weight : RpcClient.getWeightList()) {
                                        if (!addr.equals(weight.getAddr())) continue;
                                        if (weight.getLogicValue() <= 3) break;
                                        int logicWeight = weight.getLogicValue() / 10;
                                        if (logicWeight < 3) {
                                            logicWeight = 3;
                                        }
                                        weight.setLogicValue(logicWeight);
                                        RpcClient.resetRandomVauleToAddrMap();
                                        decreasedWeightServerSet.add(addr);
                                        break;
                                    }
                                }
                            }
                        } else if (th instanceof RuntimeException && null != th.getMessage() && th.getMessage().indexOf("java.util.concurrent.TimeoutException") != -1 && (msg = th.getMessage()) != null && (idx = msg.lastIndexOf("ip:")) > 0) {
                            String addr = msg.substring(idx + 1);
                            String vipAddress = TxcConfigHolder.getInstance().lookupVIP(addr);
                            if (vipAddress != null) {
                                RpcClient.getInstance().releaseChannel(null, vipAddress);
                            }
                            RpcClient.getInstance().releaseChannel(null, addr);
                        }
                        throw TxcException.nestedException(th);
                    }
                    catch (Throwable throwable) {
                        if (logger.isDebugEnabled()) {
                            long end = System.currentTimeMillis();
                            logger.debug(resultMessage + " cost " + (end - start) + " ms.");
                        } else if (resultMessage != null && resultMessage.getXid() != null) {
                            String xid = resultMessage.getXid();
                            begunTranIds.offer(xid);
                            if (logger.isAnalyzeEnabled()) {
                                AnalyzeLogger.getInstance().begin(xid);
                                logger.analyze("tran.begin", xid);
                            }
                        }
                        throw throwable;
                    }
                }
                long end = System.currentTimeMillis();
                logger.debug(resultMessage + " cost " + (end - start) + " ms.");
                break block30;
            }
            if (resultMessage != null && resultMessage.getXid() != null) {
                String xid = resultMessage.getXid();
                begunTranIds.offer(xid);
                if (logger.isAnalyzeEnabled()) {
                    AnalyzeLogger.getInstance().begin(xid);
                    logger.analyze("tran.begin", xid);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _commit(int retry) {
        GlobalCommitMessage commitMessage = new GlobalCommitMessage();
        if (TxcContext.getCurrentXid() == null) {
            throw new TxcException(ResultCode.SYSTEMERROR.getValue(), "the thread is not in transaction when invoke commit.");
        }
        commitMessage.setTranId(TxcXID.getTransactionId(TxcContext.getCurrentXid()));
        long start = 0L;
        if (logger.isDebugEnabled()) {
            start = System.currentTimeMillis();
        }
        try {
            GlobalCommitResultMessage resultMessage = null;
            Exception ex = null;
            do {
                block21: {
                    resultMessage = (GlobalCommitResultMessage)this.clientMessageSender.invoke(commitMessage, 30000L);
                    if (resultMessage.getResult() != ResultCode.OK.getValue()) break block21;
                    if (logger.isAnalyzeEnabled()) {
                        logger.analyze("tran.end", TxcContext.getCurrentXid(), "commit", resultMessage.getResult(), "");
                    }
                    committedTranIds.offer(commitMessage.getTranId());
                    return;
                }
                try {
                    String globalCommitResultMsg = resultMessage.getMsg();
                    if (globalCommitResultMsg != null && globalCommitResultMsg.contains("doesn't exist")) {
                        throw new TxcException(resultMessage.getResult(), "Transaction " + TxcContext.getCurrentXid() + " Global commit failed since " + globalCommitResultMsg + ". It might already been rolled back.");
                    }
                    logger.info("Transaction " + TxcContext.getCurrentXid() + " Global commit will be retried since " + globalCommitResultMsg);
                    Thread.sleep(3000L);
                }
                catch (Exception e) {
                    if (resultMessage != null) {
                        logger.error("GlobalCommit error", resultMessage.getMsg(), (Throwable)e);
                    } else {
                        logger.error("GlobalCommit error", e.getMessage());
                    }
                    ex = e;
                    try {
                        Thread.sleep(3000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            } while (--retry > 0);
            if (resultMessage != null && resultMessage.getResult() != ResultCode.OK.getValue()) {
                if (logger.isAnalyzeEnabled()) {
                    logger.analyze("tran.end", TxcContext.getCurrentXid(), "commit", resultMessage.getResult(), resultMessage.getMsg());
                }
                throw new TxcException(resultMessage.getResult(), "transaction " + TxcContext.getCurrentXid() + " Global commit failed. Msg:" + resultMessage.getMsg());
            }
            if (ex != null) {
                if (logger.isAnalyzeEnabled()) {
                    logger.analyze("tran.end", TxcContext.getCurrentXid(), "commit", resultMessage.getResult(), ex.getMessage());
                }
                throw new TxcException(ex, "transaction " + TxcContext.getCurrentXid() + " Global commit failed.");
            }
            committedTranIds.offer(commitMessage.getTranId());
        }
        finally {
            TxcContext.unbind();
            if (logger.isDebugEnabled()) {
                long end = System.currentTimeMillis();
                logger.debug("invoke global commit message:" + commitMessage + " cost " + (end - start) + " ms.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _rollback(int retry) {
        GlobalRollbackMessage rollbackMessage = new GlobalRollbackMessage();
        rollbackMessage.setTranId(TxcXID.getTransactionId(TxcContext.getCurrentXid()));
        long start = 0L;
        if (logger.isDebugEnabled()) {
            start = System.currentTimeMillis();
        }
        AbstractResultMessage resultMessage = null;
        try {
            Exception ex = null;
            do {
                block21: {
                    Long rollbackTimeout = TxcConfigHolder.getInstance().getRollbackTimeoutInMillisecond();
                    resultMessage = (GlobalRollbackResultMessage)this.clientMessageSender.invoke(rollbackMessage, rollbackTimeout);
                    if (resultMessage.getResult() != ResultCode.OK.getValue()) break block21;
                    if (logger.isAnalyzeEnabled()) {
                        logger.analyze("tran.end", TxcContext.getCurrentXid(), "rollback", resultMessage.getResult(), "");
                    }
                    return;
                }
                try {
                    Thread.sleep(3000L);
                }
                catch (Exception e) {
                    if (resultMessage != null) {
                        logger.error("GlobalRollback error", resultMessage.getMsg(), (Throwable)e);
                    } else {
                        logger.error("GlobalRollback error", e.getMessage());
                    }
                    ex = e;
                    try {
                        Thread.sleep(3000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            } while (--retry > 0);
            if (resultMessage != null && resultMessage.getResult() != ResultCode.OK.getValue()) {
                if (logger.isAnalyzeEnabled()) {
                    logger.analyze("tran.end", TxcContext.getCurrentXid(), "rollback", resultMessage.getResult(), resultMessage.getMsg());
                }
                throw new TxcException(resultMessage.getResult(), resultMessage.getMsg());
            }
            if (ex != null) {
                if (logger.isAnalyzeEnabled()) {
                    logger.analyze("tran.end", TxcContext.getCurrentXid(), "rollback", resultMessage.getResult(), ex.getMessage());
                }
                throw new TxcException(ex);
            }
        }
        finally {
            if (logger.isDebugEnabled()) {
                long end = System.currentTimeMillis();
                logger.debug("invoke global rollback message:" + rollbackMessage + " cost " + (end - start) + " ms.");
            } else {
                StringBuilder builder = new StringBuilder("invoke global rollback message:");
                builder.append(rollbackMessage);
                if (resultMessage != null) {
                    builder.append(",result:").append(resultMessage.getResult()).append(",msg:").append(resultMessage.getMsg());
                }
                logger.info(builder.toString());
            }
            TxcContext.unbind();
        }
    }

    @Override
    public void begin(String usr, long timeout) throws TxcException {
        this.begin(timeout);
    }

    @Override
    public void begin(TaskParameter para) throws TxcException {
        this.begin(para.getEndTimeTimeout());
        if (this.mtServiceTask == null) {
            this.mtServiceTask = MtServiceTaskImpl.getInstance();
        }
        this.mtServiceTask.task(null, 0L, para.getUdata(), para.getTaskHandlerName());
        MtServiceTaskImpl.getThreadlocaltaskpara().set(para);
    }

    @Override
    public void commit(boolean sync) throws TxcException {
        String fullXid = MtServiceTaskImpl.getThreadlocalfullxid().get();
        TaskParameter para = MtServiceTaskImpl.getThreadlocaltaskpara().get();
        int idx = fullXid.lastIndexOf(":");
        String xid = fullXid.substring(0, idx);
        long branchId = Long.parseLong(fullXid.substring(idx + 1));
        if (this.mtServiceTask == null) {
            this.mtServiceTask = MtServiceTaskImpl.getInstance();
        }
        if (sync) {
            try {
                if (this.mtServiceTask.runTask(para.getTaskHandlerName(), para.getUdata(), xid, branchId)) {
                    this.commit();
                    return;
                }
            }
            catch (Exception e) {
                logger.info("exec task fail.");
            }
        }
        this.mtServiceTask.getResourceManager().reportUdata(xid, branchId, "task", new Long(Calendar.getInstance().getTimeInMillis() + para.getStartTimeTimeout()).toString(), false);
        this.commit();
    }

    public void init() {
    }
}

