/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.txc.client.degrade;

import com.taobao.txc.client.TxcClientContext;
import com.taobao.txc.client.degrade.TxcUserDegrade;
import com.taobao.txc.common.LoggerInit;
import com.taobao.txc.common.LoggerWrap;
import com.taobao.txc.common.config.IConfigCallback;
import com.taobao.txc.common.config.TxcConfigHolder;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang.StringUtils;

public class TxcDegradeChecker
implements Runnable,
IConfigCallback {
    private static final LoggerWrap logger = LoggerInit.logger;
    private static AtomicBoolean currStatus = new AtomicBoolean(false);
    private final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
    private static final long PERIOD_MILLS = 1000L;
    private String vgroup;
    private TxcUserDegrade userDegrade;
    private final AtomicBoolean initialized = new AtomicBoolean(false);

    public TxcDegradeChecker(String vgroup, TxcUserDegrade userDegrade) {
        if (vgroup == null) {
            throw new IllegalArgumentException("vgroup of TxcDegradeChecker should not be null");
        }
        this.vgroup = vgroup;
        this.userDegrade = userDegrade;
    }

    public void init() {
        if (this.initialized.compareAndSet(false, true)) {
            try {
                this.checkTxcDisabled(this.vgroup);
                logger.info("txc.disable check init done ... ");
            }
            catch (Exception ex) {
                logger.error("Unknown", "Failed to init txc.disable check on " + this.vgroup, (Throwable)ex);
            }
            if (this.userDegrade == null) {
                logger.info("No User TXC degrade provided ... ");
            } else {
                this.executor.scheduleAtFixedRate(this, 0L, 1000L, TimeUnit.MILLISECONDS);
                logger.info("User TXC degrade check init done ... ");
            }
        }
    }

    @Override
    public void run() {
        try {
            boolean thisSwitch = this.userDegrade.shouldDegrade();
            boolean currentStatus = currStatus.get();
            if (currentStatus != thisSwitch && currStatus.compareAndSet(currentStatus, thisSwitch)) {
                TxcClientContext.setUserDisableTxc(thisSwitch);
                logger.warn("TxcUserDegrade changed [currentStatus=" + currentStatus + ", thisSwitch=" + thisSwitch + "]");
            }
        }
        catch (Throwable exx) {
            logger.error("Unknown", "Failed to run User TXC degrade check on " + this.vgroup, exx);
        }
    }

    private void checkTxcDisabled(String vgroup) {
        vgroup = System.getProperty("txc.servergroup") == null ? vgroup : System.getProperty("txc.servergroup");
        boolean txcDisabled = TxcConfigHolder.getInstance().isTxcDisable(vgroup);
        TxcClientContext.setTxcDisabled(txcDisabled);
        TxcConfigHolder.getInstance().checkTxcDisable(vgroup, this);
        logger.info((TxcClientContext.isTxcDisabled() ? "disable" : "enable") + " txc.");
    }

    @Override
    public void callback(String content) {
        boolean txcDisabled = StringUtils.isNotEmpty((String)content) && content.equalsIgnoreCase("true");
        TxcClientContext.setTxcDisabled(txcDisabled);
        logger.info("TXC is configured to be " + (TxcClientContext.isTxcDisabled() ? "disabled" : "enabled"));
    }
}

