/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.txc.client.dubbo;

import com.taobao.txc.common.LoggerInit;
import com.taobao.txc.common.LoggerWrap;
import com.taobao.txc.common.TxcContext;
import com.taobao.txc.common.context.TxcContextOperateHelper;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.rpc.Filter;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.RpcException;

@Activate(group={"provider", "consumer"}, order=100)
public class TransactionPropagationFilter
implements Filter {
    private static final LoggerWrap LOGGER = LoggerInit.logger;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        String xid = TxcContext.getCurrentXid();
        String rpcXid = RpcContext.getContext().getAttachment("TXC_XID");
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("xid in RootContext[" + xid + "] xid in RpcContext[" + rpcXid + "]");
        }
        boolean bind = false;
        if (xid != null) {
            RpcContext.getContext().setAttachment("TXC_XID", xid);
            RpcContext.getContext().setAttachment("BEGIN_COUNT", TxcContextOperateHelper.getUserData("BEGIN_COUNT"));
            RpcContext.getContext().setAttachment("COMMIT_COUNT", TxcContextOperateHelper.getUserData("COMMIT_COUNT"));
        } else if (rpcXid != null) {
            TxcContext.bind(rpcXid, null);
            TxcContextOperateHelper.putUserData("BEGIN_COUNT", RpcContext.getContext().getAttachment("BEGIN_COUNT"));
            TxcContextOperateHelper.putUserData("COMMIT_COUNT", RpcContext.getContext().getAttachment("COMMIT_COUNT"));
            bind = true;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("bind[" + rpcXid + "] to RootContext: " + TxcContext.getBeginCount() + "/" + TxcContext.getCommitCount());
            }
        }
        try {
            Result result = invoker.invoke(invocation);
            return result;
        }
        finally {
            if (bind) {
                String unbindXid = TxcContext.suspendTxcTransaction();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("unbind[" + unbindXid + "] from RootContext");
                }
                if (!rpcXid.equalsIgnoreCase(unbindXid)) {
                    LOGGER.warn("xid in change during RPC from " + rpcXid + " to " + unbindXid);
                    if (unbindXid != null) {
                        TxcContext.resumeTxcTransaction(unbindXid);
                        LOGGER.warn("bind [" + unbindXid + "] back to RootContext");
                    }
                } else {
                    TxcContext.clearReenterCounter();
                }
            }
        }
    }
}

