/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.txc.client.event.support;

import com.taobao.txc.client.event.TxcClientEvent;
import com.taobao.txc.client.event.TxcClientEventListener;
import com.taobao.txc.client.event.TxcClientExceptionContext;
import com.taobao.txc.client.event.TxcTransactionBeginCheckSuccessEvent;
import com.taobao.txc.client.event.TxcTransactionBeginFailureEvent;
import com.taobao.txc.common.LoggerInit;
import com.taobao.txc.common.LoggerWrap;
import com.taobao.txc.common.config.IConfigCallback;
import com.taobao.txc.common.config.TxcConfigHolder;
import com.taobao.txc.rpc.impl.RpcClient;

public class AutoDegradeHandler
implements TxcClientEventListener {
    private static final LoggerWrap LOGGER = LoggerInit.logger;
    private int degradeTxcByFailureThreshold = 30;
    private int upgradeTxcBySuccessThreshold = 30;

    AutoDegradeHandler() {
    }

    public int getDegradeTxcByFailureThreshold() {
        return this.degradeTxcByFailureThreshold;
    }

    void setDegradeTxcByFailureThreshold(int degradeTxcByFailureThreshold) {
        this.degradeTxcByFailureThreshold = degradeTxcByFailureThreshold;
    }

    public int getUpgradeTxcBySuccessThreshold() {
        return this.upgradeTxcBySuccessThreshold;
    }

    void setUpgradeTxcBySuccessThreshold(int upgradeTxcBySuccessThreshold) {
        this.upgradeTxcBySuccessThreshold = upgradeTxcBySuccessThreshold;
    }

    @Override
    public void onEvent(TxcClientEvent event) {
        if (event instanceof TxcTransactionBeginFailureEvent) {
            LOGGER.info("Receive Event: " + event);
            TxcTransactionBeginFailureEvent exceptionEvent = (TxcTransactionBeginFailureEvent)event;
            TxcClientExceptionContext exceptionContext = exceptionEvent.getExceptionContext();
            int count = exceptionContext.getContinuousCount();
            LOGGER.warn("TXC Transaction Begin Failure Since " + (Object)((Object)exceptionContext.getErrCode()));
            if (count > this.degradeTxcByFailureThreshold) {
                exceptionEvent.getTxcApplicationContext().setTxcDegraded(true);
                LOGGER.info("TXC is degraded ... ");
            }
        }
        if (event instanceof TxcTransactionBeginCheckSuccessEvent) {
            LOGGER.info("Receive Event: " + event);
            TxcTransactionBeginCheckSuccessEvent txcServerBackToWorkEvent = (TxcTransactionBeginCheckSuccessEvent)event;
            int count = txcServerBackToWorkEvent.getContinuousCount();
            LOGGER.info("TXC Transaction Check Success " + count + " times");
            if (count > this.upgradeTxcBySuccessThreshold) {
                txcServerBackToWorkEvent.getTxcApplicationContext().setTxcDegraded(false);
                LOGGER.info("TXC is upgraded ... ");
            }
        }
    }

    public static AutoDegradeHandler get() {
        return SingletonMaker.INSTANCE.getAutoDegradeHandler();
    }

    public String toString() {
        return "AutoDegradeHandler{degradeTxcByFailureThreshold=" + this.degradeTxcByFailureThreshold + ", upgradeTxcBySuccessThreshold=" + this.upgradeTxcBySuccessThreshold + '}';
    }

    private static enum SingletonMaker {
        INSTANCE;

        private AutoDegradeHandler autoDegradeHandler = new AutoDegradeHandler();

        public AutoDegradeHandler getAutoDegradeHandler() {
            return this.autoDegradeHandler;
        }

        private SingletonMaker() {
            TxcConfigHolder.getInstance().checkTxcDegradeCount(RpcClient.getVgroup(), new IConfigCallback(){

                @Override
                public void callback(String content) {
                    if (content != null) {
                        try {
                            SingletonMaker.this.autoDegradeHandler.setDegradeTxcByFailureThreshold(Integer.parseInt(content));
                        }
                        catch (Throwable throwable) {
                            LoggerInit.logger.warn("Failed to parse txc.degrade.count=" + content);
                        }
                    }
                }
            });
            TxcConfigHolder.getInstance().checkTxcUpgradeCount(RpcClient.getVgroup(), new IConfigCallback(){

                @Override
                public void callback(String content) {
                    if (content != null) {
                        try {
                            SingletonMaker.this.autoDegradeHandler.setUpgradeTxcBySuccessThreshold(Integer.parseInt(content));
                        }
                        catch (Throwable throwable) {
                            LoggerInit.logger.warn("Failed to parse txc.upgrade.count=" + content);
                        }
                    }
                }
            });
            LoggerInit.logger.info("autoDegradeHandler is inited [" + this.autoDegradeHandler + "]");
        }
    }
}

