/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.txc.client.event.support;

import com.taobao.txc.client.event.TxcClientEvent;
import com.taobao.txc.client.event.TxcClientEventListener;
import com.taobao.txc.client.event.TxcClientExceptionContext;
import com.taobao.txc.client.event.TxcTransactionBeginFailureEvent;
import com.taobao.txc.common.LoggerInit;
import com.taobao.txc.common.LoggerWrap;
import com.taobao.txc.common.config.IConfigCallback;
import com.taobao.txc.common.config.ITxcManagerListener;
import com.taobao.txc.common.config.TxcConfigHolder;
import com.taobao.txc.common.exception.TxcErrCode;
import com.taobao.txc.rpc.impl.RpcClient;
import java.util.LinkedList;
import java.util.concurrent.Executor;

public class ClusterSwitch
implements TxcClientEventListener {
    private static final LoggerWrap LOGGER = LoggerInit.logger;
    private int clusterSwitchThreshold = 15;
    private int clusterSwitchAlarmAfterMillSecondsThreshold = 5000;
    private String backupCluster = null;
    private long timestampOfClusterSwitched = 0L;

    @Override
    public void onEvent(TxcClientEvent event) {
        if (event instanceof TxcTransactionBeginFailureEvent) {
            LOGGER.info("Receive Event: " + event);
            if (this.backupCluster == null) {
                LOGGER.info("No backup Cluster is configured. Nothing to do ...");
                return;
            }
            String currentCluster = this.getCurrentCluster();
            if (currentCluster == null) {
                LOGGER.info("Unknown current Cluster. Nothing to do ...");
                return;
            }
            if (this.backupCluster.equals(currentCluster)) {
                LOGGER.info("Already working on backup Cluster. Nothing to do ...");
                if (this.timestampOfClusterSwitched > 0L && System.currentTimeMillis() - this.timestampOfClusterSwitched > (long)this.clusterSwitchAlarmAfterMillSecondsThreshold) {
                    LOGGER.monitor(TxcErrCode.UnknownAppError.errCode, "TXC is still NOT available after cluster switch on [" + this.timestampOfClusterSwitched + "]");
                }
                return;
            }
            if (this.timestampOfClusterSwitched > 0L) {
                LOGGER.info("TXC cluster was changed since [" + this.timestampOfClusterSwitched + "]. Let's wait ... ");
                return;
            }
            this.timestampOfClusterSwitched = 0L;
            TxcTransactionBeginFailureEvent exceptionEvent = (TxcTransactionBeginFailureEvent)event;
            TxcClientExceptionContext exceptionContext = exceptionEvent.getExceptionContext();
            int count = exceptionContext.getContinuousCount();
            LOGGER.warn("TXC Transaction Begin Failure Since " + (Object)((Object)exceptionContext.getErrCode()));
            if (count > this.clusterSwitchThreshold) {
                String vgroupMappingDataId = "vgroup_mapping_" + RpcClient.getVgroup();
                try {
                    TxcConfigHolder.getInstance().putSingle(vgroupMappingDataId, "TXC_GROUP", this.backupCluster);
                    this.timestampOfClusterSwitched = System.currentTimeMillis();
                }
                catch (Exception e) {
                    LOGGER.warn("Failed to publish " + vgroupMappingDataId + "=" + this.backupCluster);
                    return;
                }
                LOGGER.monitor(TxcErrCode.UnknownAppError.errCode, RpcClient.getVgroup() + " TXC Service is changed from " + currentCluster + " into backup cluster " + this.backupCluster);
            }
        }
    }

    private String getCurrentCluster() {
        LinkedList<String> rGroups = RpcClient.getInstance().rGroupList;
        LOGGER.info("RGroup List " + rGroups);
        if (rGroups == null || rGroups.size() == 0) {
            LOGGER.warn("No RGroup there, should NEVER happen ... ");
            return null;
        }
        return rGroups.get(0);
    }

    public static ClusterSwitch get() {
        return SingletonMaker.INSTANCE.clusterSwitch;
    }

    public String toString() {
        return "ClusterSwitch{clusterSwitchThreshold=" + this.clusterSwitchThreshold + ", backupCluster='" + this.backupCluster + '\'' + '}';
    }

    private static enum SingletonMaker {
        INSTANCE;

        private ClusterSwitch clusterSwitch = new ClusterSwitch();

        private SingletonMaker() {
            TxcConfigHolder.getInstance().checkTxcClusterSwitchThreshold(RpcClient.getVgroup(), new IConfigCallback(){

                @Override
                public void callback(String content) {
                    if (content != null) {
                        try {
                            int threshold = Integer.parseInt(content);
                            SingletonMaker.this.clusterSwitch.clusterSwitchThreshold = threshold;
                        }
                        catch (Throwable throwable) {
                            LOGGER.warn("Failed to parse txc.cluster.switch.threshold=" + content);
                        }
                    }
                }
            });
            String backupClusterDataId = "vgroup_backup_mapping_" + RpcClient.getVgroup();
            this.clusterSwitch.backupCluster = TxcConfigHolder.getInstance().getConfig(backupClusterDataId, "TXC_GROUP");
            TxcConfigHolder.getInstance().addListener("vgroup_backup_mapping_" + RpcClient.getVgroup(), "TXC_GROUP", new ITxcManagerListener(){

                @Override
                public Executor getExecutor() {
                    return null;
                }

                @Override
                public void receiveConfigInfo(String rGroup) {
                    if ("".equals(rGroup)) {
                        rGroup = null;
                    }
                    LOGGER.info("Backup Cluster is changed from " + SingletonMaker.this.clusterSwitch.backupCluster + " to " + rGroup);
                    SingletonMaker.this.clusterSwitch.backupCluster = rGroup;
                }
            });
            LOGGER.info("ClusterSwitch is inited [" + this.clusterSwitch + "]");
        }
    }
}

