/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.txc.client.rt;

import com.taobao.txc.common.LoggerInit;
import com.taobao.txc.common.LoggerWrap;
import com.taobao.txc.common.TxcContext;
import com.taobao.txc.common.exception.TxcErrCode;
import com.taobao.txc.common.exception.TxcException;

public class RTManager {
    private static final LoggerWrap logger = LoggerInit.logger;

    public static void beginRT(long effectiveTime) {
        if (TxcContext.inTxcTransaction()) {
            throw new TxcException("This transaction has been AT or MT model!", TxcErrCode.TxcTransactionModeError2);
        }
        int beginCount = TxcContext.getBeginCount();
        if (++beginCount == 1) {
            RTManager._beginRT(effectiveTime);
        }
        TxcContext.setBegin(beginCount);
    }

    public static void endRT() {
        int commitCount = TxcContext.getCommitCount();
        int beginCount = TxcContext.getBeginCount();
        TxcContext.setCommitCount(++commitCount);
        if (commitCount == beginCount) {
            TxcContext.clearReenterCounter();
            if (TxcContext.inRetryContext()) {
                RTManager._endRT();
            }
        }
    }

    private static void _beginRT(long effectiveTime) {
        TxcContext.startRetryBranch(effectiveTime);
        logger.info("begin RT");
    }

    private static void _endRT() {
        TxcContext.endRetryBranch();
        logger.info("end RT");
    }
}

