/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.txc.client.template;

import com.taobao.txc.client.TxcClientContext;
import com.taobao.txc.client.aop.annotation.Propagation;
import com.taobao.txc.client.api.TxcTransactionManager;
import com.taobao.txc.client.api.impl.TxcTransactionManagerImpl;
import com.taobao.txc.client.event.TxcClientExceptionContext;
import com.taobao.txc.client.event.TxcTransactionBeginFailureEvent;
import com.taobao.txc.client.template.TxcCallback;
import com.taobao.txc.common.LoggerInit;
import com.taobao.txc.common.LoggerWrap;
import com.taobao.txc.common.TxcContext;
import com.taobao.txc.common.exception.RollbackTxcException;
import com.taobao.txc.common.exception.TxcErrCode;
import com.taobao.txc.common.exception.TxcException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang.StringUtils;

public class TxcTransactionTemplate {
    private static final LoggerWrap logger = LoggerInit.logger;
    private TxcTransactionManager tm = TxcTransactionManagerImpl.getInstance();
    private static AtomicInteger continuousBeginFailTimes = new AtomicInteger(0);

    public Object runATMT(TxcCallback callback, long timeout, String appname, String txcInst) throws Throwable {
        return this.runATMT(callback, timeout, appname, txcInst, Propagation.REQUIRED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object runATMT(TxcCallback callback, long timeout, String appname, String txcInst, Propagation propagation) throws Throwable {
        String progatedXid = null;
        String progatedNextSvrAddr = null;
        int progatedBeginCount = -1;
        int progatedCommitCount = -1;
        switch (propagation) {
            case REQUIRED: {
                break;
            }
            case REQUIRES_NEW: {
                if (!TxcContext.inTxcTransaction()) break;
                progatedXid = TxcContext.getCurrentXid();
                progatedNextSvrAddr = TxcContext.getTxcNextSvrAddr();
                progatedBeginCount = TxcContext.getBeginCount();
                progatedCommitCount = TxcContext.getCommitCount();
                TxcContext.unbind();
                TxcContext.clearReenterCounter();
                logger.info("SUSPEND_OLD FOR REQUIRES_NEW:" + progatedXid + " " + progatedNextSvrAddr + " " + progatedBeginCount + " " + progatedCommitCount);
                break;
            }
            default: {
                throw new TxcException("Not Support Yet on Propagation[" + (Object)((Object)propagation) + "]");
            }
        }
        try {
            Object object = this.doRunATMT(callback, timeout, appname, txcInst);
            return object;
        }
        finally {
            if (propagation == Propagation.REQUIRES_NEW && progatedXid != null) {
                TxcContext.bind(progatedXid, progatedNextSvrAddr);
                TxcContext.setBegin(progatedBeginCount);
                TxcContext.setCommitCount(progatedCommitCount);
                logger.info("RESUME_OLD FOR REQUIRES_NEW:" + progatedXid + " " + progatedNextSvrAddr + " " + progatedBeginCount + " " + progatedCommitCount);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object doRunATMT(TxcCallback callback, long timeout, String appname, String txcInst) throws Throwable {
        if (logger.isDebugEnabled()) {
            logger.debug("XID_TRACING: Before Begin: " + TxcContext.getCurrentXid());
        }
        try {
            if (TxcClientContext.anyTxcClientEventListener()) {
                try {
                    this.tm.begin(timeout, appname, txcInst);
                    continuousBeginFailTimes.set(0);
                }
                catch (TxcException txce) {
                    try {
                        TxcClientExceptionContext exceptionContext = new TxcClientExceptionContext();
                        exceptionContext.setContinuousCount(continuousBeginFailTimes.incrementAndGet());
                        exceptionContext.setExceptionObject(txce);
                        String exMessage = txce.getMessage();
                        if (exMessage != null && (exMessage.contains("can not connect to txc server.") || exMessage.contains("cluster is not connected"))) {
                            exceptionContext.setErrCode(TxcErrCode.NetConnect);
                        }
                        TxcTransactionBeginFailureEvent event = new TxcTransactionBeginFailureEvent(TxcClientContext.getTxcApplicationContext(), exceptionContext);
                        TxcClientContext.publishEvent(event);
                    }
                    catch (Throwable throwable) {
                        logger.warn("Failed to handle TxcException caught when trying to begin new transaction By " + throwable.getMessage());
                    }
                    finally {
                        throw txce;
                    }
                }
            } else {
                this.tm.begin(timeout, appname, txcInst);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("XID_TRACING: After Begin: " + TxcContext.getCurrentXid());
            }
            Object obj = callback.callback();
            this.tm.commit();
            return obj;
        }
        catch (Throwable rollbackOriginalException) {
            if (rollbackOriginalException instanceof TxcException) {
                logger.warn("runATMT Failed by TXC Exception " + rollbackOriginalException.getMessage());
            } else if (logger.isInfoEnabled()) {
                String xid = "null";
                if (StringUtils.isNotBlank((String)TxcContext.getCurrentXid())) {
                    xid = TxcContext.getCurrentXid();
                }
                logger.info("[runATMT:" + xid + "]", rollbackOriginalException.getMessage(), rollbackOriginalException);
            }
            ArrayList<StackTraceElement> eList = new ArrayList<StackTraceElement>();
            Collections.addAll(eList, rollbackOriginalException.getStackTrace());
            for (StackTraceElement l : eList) {
                if (!StringUtils.endsWithIgnoreCase((String)l.getClassName(), (String)RollbackTxcException.class.getName())) continue;
                throw rollbackOriginalException;
            }
            try {
                this.tm.rollback();
            }
            catch (Throwable e1) {
                String msg = e1.getMessage();
                if (msg.contains("doesn't exist")) {
                    throw rollbackOriginalException;
                }
                logger.warn(TxcContext.getCurrentXid() + " rollback failed since " + e1.getMessage());
                throw new RollbackTxcException(rollbackOriginalException, false);
            }
            eList.add(new StackTraceElement(RollbackTxcException.class.getName(), "RollbackTxcException", "RollbackTxcException.java", 0));
            rollbackOriginalException.setStackTrace(eList.toArray(new StackTraceElement[0]));
            throw rollbackOriginalException;
        }
    }

    public Object runRT(TxcCallback callback, long effectiveTime) throws TxcException {
        try {
            Object obj;
            TxcContext.startRetryBranch(effectiveTime);
            Object object = obj = callback.callback();
            return object;
        }
        catch (Throwable e) {
            throw TxcException.nestedException(e);
        }
        finally {
            TxcContext.endRetryBranch();
        }
    }
}

