/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.txc.client.utils;

import com.taobao.txc.common.LoggerInit;
import com.taobao.txc.common.LoggerWrap;
import java.lang.reflect.Method;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.event.ApplicationContextEvent;
import org.springframework.context.event.ContextRefreshedEvent;

public class ApplicationUtils {
    private static final LoggerWrap logger = LoggerInit.logger;
    private static final String SPRING_BOOT_EVENT = "org.springframework.boot.context.embedded.EmbeddedServletContainerInitializedEvent";
    private static final String SPRING_BOOT_EVENT2 = "org.springframework.boot.context.event.ApplicationReadyEvent";
    private static boolean springBootApp = false;

    public static boolean isSuitEvent(ApplicationEvent event) {
        if (null == event) {
            return false;
        }
        return springBootApp ? ApplicationUtils.isSuitSpringBootEvent(event) : event instanceof ContextRefreshedEvent;
    }

    private static boolean isSuitSpringBootEvent(ApplicationEvent event) {
        return SPRING_BOOT_EVENT.equals(event.getClass().getName()) || SPRING_BOOT_EVENT2.equals(event.getClass().getName());
    }

    public static ApplicationContext getApplicationContext(ApplicationEvent event) {
        if (event == null) {
            return null;
        }
        if (event instanceof ApplicationContextEvent) {
            return ((ApplicationContextEvent)event).getApplicationContext();
        }
        if (SPRING_BOOT_EVENT.equals(event.getClass().getName())) {
            try {
                Method m = event.getClass().getMethod("getApplicationContext", new Class[0]);
                ApplicationContext applicationContext = (ApplicationContext)m.invoke((Object)event, new Object[0]);
                return applicationContext;
            }
            catch (Throwable t) {
                logger.info("Could NOT get ApplicationContext from such event [" + event.getClass() + "]", t);
                return null;
            }
        }
        logger.info("Could NOT get ApplicationContext from such event [" + event.getClass() + "]");
        return null;
    }

    static {
        try {
            Class.forName(SPRING_BOOT_EVENT);
            springBootApp = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            Class.forName(SPRING_BOOT_EVENT2);
            springBootApp = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (springBootApp) {
            logger.info("This is a SpringBoot App.");
        }
    }
}

